/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.expr;

import java.util.Stack;
import org.apache.fop.datatypes.PercentBase;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.Property;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.expr.Function;

public class PropertyInfo {
    private Property.Maker maker;
    private PropertyList plist;
    private FObj fo;
    private Stack stkFunction;

    public PropertyInfo(Property.Maker maker, PropertyList plist, FObj fo) {
        this.maker = maker;
        this.plist = plist;
        this.fo = fo;
    }

    public boolean inheritsSpecified() {
        return this.maker.inheritsSpecified();
    }

    public PercentBase getPercentBase() {
        PercentBase pcbase = this.getFunctionPercentBase();
        return pcbase != null ? pcbase : this.maker.getPercentBase(this.fo, this.plist);
    }

    public int currentFontSize() {
        return this.plist.get("font-size").getLength().getValue();
    }

    public FObj getFO() {
        return this.fo;
    }

    public PropertyList getPropertyList() {
        return this.plist;
    }

    public void pushFunction(Function func) {
        if (this.stkFunction == null) {
            this.stkFunction = new Stack();
        }
        this.stkFunction.push(func);
    }

    public void popFunction() {
        if (this.stkFunction != null) {
            this.stkFunction.pop();
        }
    }

    private PercentBase getFunctionPercentBase() {
        Function f;
        if (this.stkFunction != null && (f = (Function)this.stkFunction.peek()) != null) {
            return f.getPercentBase();
        }
        return null;
    }
}

