/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import java.util.List;
import org.apache.fop.apps.StructureHandler;
import org.apache.fop.area.Trait;
import org.apache.fop.area.inline.FilledArea;
import org.apache.fop.area.inline.InlineArea;
import org.apache.fop.area.inline.Space;
import org.apache.fop.area.inline.Word;
import org.apache.fop.datatypes.ColorType;
import org.apache.fop.datatypes.Length;
import org.apache.fop.datatypes.PercentLength;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FObjMixed;
import org.apache.fop.layout.AccessibilityProps;
import org.apache.fop.layout.AuralProps;
import org.apache.fop.layout.BackgroundProps;
import org.apache.fop.layout.BorderAndPadding;
import org.apache.fop.layout.FontInfo;
import org.apache.fop.layout.FontState;
import org.apache.fop.layout.MarginInlineProps;
import org.apache.fop.layout.RelativePositionProps;
import org.apache.fop.layoutmgr.ContentLayoutManager;
import org.apache.fop.layoutmgr.InlineStackingLayoutManager;
import org.apache.fop.layoutmgr.LMiter;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.LeafNodeLayoutManager;
import org.apache.fop.layoutmgr.MinOptMax;
import org.apache.fop.util.CharUtilities;

public class Leader
extends FObjMixed {
    private int ruleStyle;
    private int ruleThickness;
    private int leaderPattern;
    private int patternWidth;
    protected FontInfo fontInfo = null;
    protected FontState fontState;
    protected InlineArea leaderArea = null;

    public Leader(FONode parent) {
        super(parent);
    }

    public void addLayoutManager(List list) {
        LeafNodeLayoutManager lm = new LeafNodeLayoutManager(){

            public InlineArea get(LayoutContext context) {
                return Leader.this.getInlineArea();
            }

            protected MinOptMax getAllocationIPD(int refIPD) {
                return Leader.this.getAllocIPD(refIPD);
            }
        };
        lm.setUserAgent(this.getUserAgent());
        lm.setFObj(this);
        lm.setAlignment(this.properties.get("leader-alignment").getEnum());
        list.add(lm);
    }

    protected InlineArea getInlineArea() {
        if (this.leaderArea == null) {
            this.createLeaderArea();
        }
        return this.leaderArea;
    }

    protected void createLeaderArea() {
        this.setup();
        if (this.leaderPattern == 80) {
            org.apache.fop.area.inline.Leader leader = new org.apache.fop.area.inline.Leader();
            leader.setRuleStyle(this.ruleStyle);
            leader.setRuleThickness(this.ruleThickness);
            this.leaderArea = leader;
        } else if (this.leaderPattern == 86) {
            this.leaderArea = new Space();
        } else if (this.leaderPattern == 20) {
            Word w = new Word();
            char dot = '.';
            w.setWord("" + dot);
            w.addTrait(Trait.FONT_NAME, this.fontState.getFontName());
            w.addTrait(Trait.FONT_SIZE, new Integer(this.fontState.getFontSize()));
            w.setOffset(this.fontState.getAscender());
            int width = CharUtilities.getCharWidth(dot, this.fontState);
            Space spacer = null;
            if (this.patternWidth > width) {
                spacer = new Space();
                spacer.setWidth(this.patternWidth - width);
                width = this.patternWidth;
            }
            FilledArea fa = new FilledArea();
            fa.setUnitWidth(width);
            fa.addChild(w);
            if (spacer != null) {
                fa.addChild(spacer);
            }
            fa.setHeight(this.fontState.getAscender());
            this.leaderArea = fa;
        } else if (this.leaderPattern == 101) {
            if (this.children == null) {
                this.getLogger().error("Leader use-content with no content");
                return;
            }
            InlineStackingLayoutManager lm = new InlineStackingLayoutManager();
            lm.setUserAgent(this.getUserAgent());
            lm.setFObj(this);
            lm.setLMiter(new LMiter(this.children.listIterator()));
            lm.init();
            FilledArea fa = new FilledArea();
            ContentLayoutManager clm = new ContentLayoutManager(fa);
            clm.setUserAgent(this.getUserAgent());
            lm.setParent(clm);
            clm.fillArea(lm);
            int width = clm.getStackingSize();
            Space spacer = null;
            if (this.patternWidth > width) {
                spacer = new Space();
                spacer.setWidth(this.patternWidth - width);
                width = this.patternWidth;
            }
            fa.setUnitWidth(width);
            if (spacer != null) {
                fa.addChild(spacer);
            }
            this.leaderArea = fa;
        }
    }

    public void setStructHandler(StructureHandler st) {
        super.setStructHandler(st);
        this.fontInfo = st.getFontInfo();
    }

    public void setup() {
        AccessibilityProps mAccProps = this.propMgr.getAccessibilityProps();
        AuralProps mAurProps = this.propMgr.getAuralProps();
        BorderAndPadding bap = this.propMgr.getBorderAndPadding();
        BackgroundProps bProps = this.propMgr.getBackgroundProps();
        this.fontState = this.propMgr.getFontState(this.fontInfo);
        MarginInlineProps mProps = this.propMgr.getMarginInlineProps();
        RelativePositionProps mRelProps = this.propMgr.getRelativePositionProps();
        this.setupID();
        ColorType c = this.properties.get("color").getColorType();
        float red = c.getRed();
        float green = c.getGreen();
        float blue = c.getBlue();
        this.leaderPattern = this.properties.get("leader-pattern").getEnum();
        switch (this.leaderPattern) {
            case 86: {
                break;
            }
            case 80: {
                this.ruleThickness = this.properties.get("rule-thickness").getLength().getValue();
                this.ruleStyle = this.properties.get("rule-style").getEnum();
                break;
            }
            case 20: {
                break;
            }
        }
        this.patternWidth = this.properties.get("leader-pattern-width").getLength().getValue();
    }

    protected MinOptMax getAllocIPD(int ipd) {
        int opt = this.getLength("leader-length.optimum", ipd);
        int min = this.getLength("leader-length.minimum", ipd);
        int max = this.getLength("leader-length.maximum", ipd);
        return new MinOptMax(min, opt, max);
    }

    protected int getLength(String prop, int dim) {
        Length maxlength = this.properties.get(prop).getLength();
        int length = maxlength instanceof PercentLength ? (int)(((PercentLength)maxlength).value() * (double)dim) : maxlength.getValue();
        return length;
    }
}

