/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import java.util.List;
import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.ColorType;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FObj;
import org.apache.fop.layout.AccessibilityProps;
import org.apache.fop.layout.AuralProps;
import org.apache.fop.layout.BackgroundProps;
import org.apache.fop.layout.BorderAndPadding;
import org.apache.fop.layout.RelativePositionProps;
import org.apache.fop.layoutmgr.table.Cell;
import org.xml.sax.Attributes;

public class TableCell
extends FObj {
    private ColorType backgroundColor;
    private int numColumnsSpanned;
    private int numRowsSpanned;
    private int iColNumber = -1;
    protected int startOffset;
    protected int width;
    protected int beforeOffset = 0;
    protected int startAdjust = 0;
    protected int widthAdjust = 0;
    protected int borderHeight = 0;
    protected int minCellHeight = 0;
    protected int height = 0;
    protected int top;
    protected int verticalAlign;
    protected boolean bRelativeAlign = false;
    private boolean bSepBorders = true;
    private boolean bDone = false;
    private int borderSeparation = 0;

    public TableCell(FONode parent) {
        super(parent);
    }

    public void handleAttrs(Attributes attlist) throws FOPException {
        super.handleAttrs(attlist);
        this.doSetup();
    }

    public void addLayoutManager(List list) {
        Cell clm = new Cell();
        clm.setUserAgent(this.getUserAgent());
        clm.setFObj(this);
        list.add(clm);
    }

    public void setStartOffset(int offset) {
        this.startOffset = offset;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getColumnNumber() {
        return this.iColNumber;
    }

    public int getNumColumnsSpanned() {
        return this.numColumnsSpanned;
    }

    public int getNumRowsSpanned() {
        return this.numRowsSpanned;
    }

    public void doSetup() {
        AccessibilityProps mAccProps = this.propMgr.getAccessibilityProps();
        AuralProps mAurProps = this.propMgr.getAuralProps();
        BorderAndPadding bap = this.propMgr.getBorderAndPadding();
        BackgroundProps bProps = this.propMgr.getBackgroundProps();
        RelativePositionProps mRelProps = this.propMgr.getRelativePositionProps();
        this.setupID();
        this.iColNumber = this.properties.get("column-number").getNumber().intValue();
        if (this.iColNumber < 0) {
            this.iColNumber = 0;
        }
        this.numColumnsSpanned = this.properties.get("number-columns-spanned").getNumber().intValue();
        if (this.numColumnsSpanned < 1) {
            this.numColumnsSpanned = 1;
        }
        this.numRowsSpanned = this.properties.get("number-rows-spanned").getNumber().intValue();
        if (this.numRowsSpanned < 1) {
            this.numRowsSpanned = 1;
        }
        this.backgroundColor = this.properties.get("background-color").getColorType();
        this.bSepBorders = this.properties.get("border-collapse").getEnum() == 83;
        this.calcBorders(this.propMgr.getBorderAndPadding());
        this.verticalAlign = this.properties.get("display-align").getEnum();
        if (this.verticalAlign == 8) {
            this.bRelativeAlign = true;
            this.verticalAlign = this.properties.get("relative-align").getEnum();
        } else {
            this.bRelativeAlign = false;
        }
        this.minCellHeight = this.properties.get("height").getLength().getValue();
    }

    private void calcBorders(BorderAndPadding bp) {
        if (this.bSepBorders) {
            int iSep = this.properties.get("border-separation.inline-progression-direction").getLength().getValue();
            this.startAdjust = iSep / 2 + bp.getBorderLeftWidth(false) + bp.getPaddingLeft(false);
            this.widthAdjust = this.startAdjust + iSep - iSep / 2 + bp.getBorderRightWidth(false) + bp.getPaddingRight(false);
            this.borderSeparation = this.properties.get("border-separation.block-progression-direction").getLength().getValue();
            this.beforeOffset = this.borderSeparation / 2 + bp.getBorderTopWidth(false) + bp.getPaddingTop(false);
        } else {
            int borderStart = bp.getBorderLeftWidth(false);
            int borderEnd = bp.getBorderRightWidth(false);
            int borderBefore = bp.getBorderTopWidth(false);
            int borderAfter = bp.getBorderBottomWidth(false);
            this.startAdjust = borderStart / 2 + bp.getPaddingLeft(false);
            this.widthAdjust = this.startAdjust + borderEnd / 2 + bp.getPaddingRight(false);
            this.beforeOffset = borderBefore / 2 + bp.getPaddingTop(false);
            this.borderHeight = (borderBefore + borderAfter) / 2;
        }
    }

    protected boolean containsMarkers() {
        return true;
    }
}

