/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import org.apache.fop.datatypes.ColorType;
import org.apache.fop.datatypes.Length;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.Property;
import org.apache.fop.layout.BackgroundProps;
import org.apache.fop.layout.BorderAndPadding;
import org.apache.fop.layoutmgr.LayoutManager;
import org.apache.fop.layoutmgr.table.Column;

public class TableColumn
extends FObj {
    private ColorType backgroundColor;
    private Length columnWidthPropVal;
    private int columnWidth;
    private int columnOffset;
    private int numColumnsRepeated;
    private int iColumnNumber;
    private boolean setup = false;

    public TableColumn(FONode parent) {
        super(parent);
    }

    public LayoutManager getLayoutManager() {
        this.doSetup();
        Column clm = new Column();
        clm.setUserAgent(this.getUserAgent());
        clm.setFObj(this);
        return clm;
    }

    public Length getColumnWidthAsLength() {
        return this.columnWidthPropVal;
    }

    public int getColumnWidth() {
        return this.columnWidth;
    }

    public void setColumnWidth(int columnWidth) {
        this.columnWidth = columnWidth;
    }

    public int getColumnNumber() {
        return this.iColumnNumber;
    }

    public int getNumColumnsRepeated() {
        return this.numColumnsRepeated;
    }

    public void doSetup() {
        BorderAndPadding bap = this.propMgr.getBorderAndPadding();
        BackgroundProps bProps = this.propMgr.getBackgroundProps();
        this.iColumnNumber = this.properties.get("column-number").getNumber().intValue();
        this.numColumnsRepeated = this.properties.get("number-columns-repeated").getNumber().intValue();
        this.backgroundColor = this.properties.get("background-color").getColorType();
        Property prop = this.properties.get("column-width");
        if (prop != null) {
            this.columnWidthPropVal = this.properties.get("column-width").getLength();
            this.columnWidth = this.columnWidthPropVal.getValue();
        } else {
            this.columnWidth = 300000;
        }
        this.setupID();
        this.setup = true;
    }
}

