/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.pagination;

import java.util.HashMap;
import org.apache.fop.apps.FOPException;
import org.apache.fop.area.AreaTree;
import org.apache.fop.area.PageViewport;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.Title;
import org.apache.fop.fo.flow.Flow;
import org.apache.fop.fo.flow.StaticContent;
import org.apache.fop.fo.pagination.LayoutMasterSet;
import org.apache.fop.fo.pagination.PageNumberGenerator;
import org.apache.fop.fo.pagination.PageSequenceMaster;
import org.apache.fop.fo.pagination.Region;
import org.apache.fop.fo.pagination.Root;
import org.apache.fop.fo.pagination.SimplePageMaster;
import org.apache.fop.layout.PageMaster;
import org.apache.fop.layoutmgr.PageLayoutManager;
import org.xml.sax.Attributes;

public class PageSequence
extends FObj {
    private static final int EXPLICIT = 0;
    private static final int AUTO = 1;
    private static final int AUTO_EVEN = 2;
    private static final int AUTO_ODD = 3;
    private Root root;
    private LayoutMasterSet layoutMasterSet;
    private HashMap flowMap;
    private boolean sequenceStarted = false;
    private PageViewport currentPage;
    private String ipnValue;
    private int currentPageNumber = 0;
    private int explicitFirstNumber = 0;
    private int firstPageNumber = 0;
    private PageNumberGenerator pageNumberGenerator;
    private int forcePageCount = 0;
    private int pageCount = 0;
    private boolean isForcing = false;
    private int pageNumberType;
    private boolean thisIsFirstPage;
    private SimplePageMaster currentSimplePageMaster;
    private PageSequenceMaster pageSequenceMaster;
    private Flow mainFlow = null;
    private Title titleFO;

    public PageSequence(FONode parent) {
        super(parent);
    }

    public void handleAttrs(Attributes attlist) throws FOPException {
        super.handleAttrs(attlist);
        if (!this.parent.getName().equals("fo:root")) {
            throw new FOPException("page-sequence must be child of root, not " + this.parent.getName());
        }
        this.root = (Root)this.parent;
        this.layoutMasterSet = this.root.getLayoutMasterSet();
        this.layoutMasterSet.checkRegionNames();
        this.flowMap = new HashMap();
        this.thisIsFirstPage = true;
        this.ipnValue = this.properties.get("initial-page-number").getString();
        if (this.ipnValue.equals("auto")) {
            this.pageNumberType = 1;
        } else if (this.ipnValue.equals("auto-even")) {
            this.pageNumberType = 2;
        } else if (this.ipnValue.equals("auto-odd")) {
            this.pageNumberType = 3;
        } else {
            this.pageNumberType = 0;
            try {
                int pageStart = new Integer(this.ipnValue);
                this.explicitFirstNumber = pageStart > 0 ? pageStart - 1 : 0;
            }
            catch (NumberFormatException nfe) {
                throw new FOPException("\"" + this.ipnValue + "\" is not a valid value for initial-page-number");
            }
        }
        String masterName = this.properties.get("master-reference").getString();
        this.currentSimplePageMaster = this.layoutMasterSet.getSimplePageMaster(masterName);
        if (this.currentSimplePageMaster == null) {
            this.pageSequenceMaster = this.layoutMasterSet.getPageSequenceMaster(masterName);
            if (this.pageSequenceMaster == null) {
                throw new FOPException("master-reference '" + masterName + "' for fo:page-sequence matches no" + " simple-page-master or page-sequence-master");
            }
        }
        this.pageNumberGenerator = new PageNumberGenerator(this.properties.get("format").getString(), this.properties.get("grouping-separator").getCharacter(), this.properties.get("grouping-size").getNumber().intValue(), this.properties.get("letter-value").getEnum());
        this.pageNumberGenerator.enableLogging(this.getLogger());
        this.forcePageCount = this.properties.get("force-page-count").getEnum();
        this.setupID();
    }

    public void addChild(FONode child) {
        block14: {
            try {
                String childName = child.getName();
                if (childName.equals("fo:title")) {
                    if (this.flowMap.size() > 0) {
                        this.getLogger().warn("fo:title should be first in page-sequence");
                    } else {
                        this.titleFO = (Title)child;
                    }
                    break block14;
                }
                if (childName.equals("fo:flow")) {
                    if (this.mainFlow != null) {
                        throw new FOPException("Only a single fo:flow permitted per fo:page-sequence");
                    }
                    this.mainFlow = (Flow)child;
                    String flowName = this.mainFlow.getFlowName();
                    if (this.flowMap.containsKey(flowName)) {
                        throw new FOPException("flow-name " + flowName + " is not unique within an fo:page-sequence");
                    }
                    if (!this.layoutMasterSet.regionNameExists(flowName)) {
                        this.getLogger().error("region-name '" + flowName + "' doesn't exist in the layout-master-set.");
                    }
                    if (!this.sequenceStarted) {
                        this.structHandler.startPageSequence(this, this.titleFO, this.layoutMasterSet);
                        this.sequenceStarted = true;
                    }
                    super.addChild(child);
                    break block14;
                }
                if (childName.equals("fo:static-content")) {
                    if (this.mainFlow != null) {
                        throw new FOPException(childName + " must precede fo:flow; ignoring");
                    }
                    String flowName = ((StaticContent)child).getFlowName();
                    if (this.flowMap.containsKey(flowName)) {
                        throw new FOPException("flow-name " + flowName + " is not unique within an fo:page-sequence");
                    }
                    if (!this.layoutMasterSet.regionNameExists(flowName)) {
                        this.getLogger().error("region-name '" + flowName + "' doesn't exist in the layout-master-set.");
                    }
                    this.flowMap.put(flowName, child);
                    if (this.sequenceStarted) break block14;
                    this.structHandler.startPageSequence(this, this.titleFO, this.layoutMasterSet);
                    this.sequenceStarted = true;
                    break block14;
                }
                this.getLogger().warn("FO '" + childName + "' not a legal page-sequence child.");
                return;
            }
            catch (FOPException fopex) {
                this.getLogger().error("Error in PageSequence.addChild(): " + fopex.getMessage(), (Throwable)fopex);
            }
        }
    }

    public void end() {
        try {
            this.structHandler.endPageSequence(this);
        }
        catch (FOPException fopex) {
            this.getLogger().error("Error in PageSequence.end(): " + fopex.getMessage(), (Throwable)fopex);
        }
    }

    public void format(AreaTree areaTree) throws FOPException {
        if (this.mainFlow == null) {
            return;
        }
        if (this.pageSequenceMaster != null) {
            this.pageSequenceMaster.reset();
        }
        boolean firstAvailPageNumber = false;
        this.initPageNumber();
        PageLayoutManager pageLM = new PageLayoutManager(areaTree, this);
        pageLM.setUserAgent(this.getUserAgent());
        pageLM.setFObj(this);
        pageLM.setPageCounting(this.currentPageNumber, this.pageNumberGenerator);
        pageLM.run();
        this.currentPageNumber = pageLM.getPageCount();
        this.root.setRunningPageNumberCounter(this.currentPageNumber);
    }

    private void initPageNumber() {
        this.currentPageNumber = this.root.getRunningPageNumberCounter() + 1;
        if (this.pageNumberType == 3) {
            if (this.currentPageNumber % 2 == 0) {
                ++this.currentPageNumber;
            }
        } else if (this.pageNumberType == 2) {
            if (this.currentPageNumber % 2 == 1) {
                ++this.currentPageNumber;
            }
        } else if (this.pageNumberType == 0) {
            this.currentPageNumber = this.explicitFirstNumber;
        }
        this.firstPageNumber = this.currentPageNumber;
    }

    public PageViewport createPage(int pageNumber, boolean bIsBlank, boolean firstPage, boolean bIsLast) throws FOPException {
        if (this.pageSequenceMaster != null) {
            this.currentSimplePageMaster = this.pageSequenceMaster.getNextSimplePageMaster(pageNumber % 2 == 1, firstPage, bIsBlank);
        }
        Region body = this.currentSimplePageMaster.getRegion("body");
        if (!this.mainFlow.getFlowName().equals(body.getRegionName())) {
            throw new FOPException("Flow '" + this.mainFlow.getFlowName() + "' does not map to the region-body in page-master '" + this.currentSimplePageMaster.getMasterName() + "'");
        }
        PageMaster pageMaster = this.currentSimplePageMaster.getPageMaster();
        PageViewport p = pageMaster.makePage();
        return p;
    }

    public String getIpnValue() {
        return this.ipnValue;
    }

    public int getCurrentPageNumber() {
        return this.currentPageNumber;
    }

    public SimplePageMaster getCurrentSimplePageMaster() {
        return this.currentSimplePageMaster;
    }

    public StaticContent getStaticContent(String name) {
        return (StaticContent)this.flowMap.get(name);
    }
}

