/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.pagination;

import java.util.ArrayList;
import org.apache.fop.apps.FOPException;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.pagination.ConditionalPageMasterReference;
import org.apache.fop.fo.pagination.PageSequenceMaster;
import org.apache.fop.fo.pagination.SubSequenceSpecifier;
import org.xml.sax.Attributes;

public class RepeatablePageMasterAlternatives
extends FObj
implements SubSequenceSpecifier {
    private static final int INFINITE = -1;
    private int maximumRepeats;
    private int numberConsumed = 0;
    private ArrayList conditionalPageMasterRefs;

    public RepeatablePageMasterAlternatives(FONode parent) {
        super(parent);
    }

    public void handleAttrs(Attributes attlist) throws FOPException {
        super.handleAttrs(attlist);
        this.conditionalPageMasterRefs = new ArrayList();
        if (!this.parent.getName().equals("fo:page-sequence-master")) {
            throw new FOPException("fo:repeatable-page-master-alternatives must be child of fo:page-sequence-master, not " + this.parent.getName());
        }
        PageSequenceMaster pageSequenceMaster = (PageSequenceMaster)this.parent;
        pageSequenceMaster.addSubsequenceSpecifier(this);
        String mr = this.getProperty("maximum-repeats").getString();
        if (mr.equals("no-limit")) {
            this.maximumRepeats = -1;
        } else {
            try {
                this.maximumRepeats = Integer.parseInt(mr);
                if (this.maximumRepeats < 0) {
                    this.getLogger().debug("negative maximum-repeats: " + this.maximumRepeats);
                    this.maximumRepeats = 0;
                }
            }
            catch (NumberFormatException nfe) {
                throw new FOPException("Invalid number for 'maximum-repeats' property");
            }
        }
    }

    public String getNextPageMasterName(boolean isOddPage, boolean isFirstPage, boolean isBlankPage) {
        if (this.maximumRepeats != -1) {
            if (this.numberConsumed < this.maximumRepeats) {
                ++this.numberConsumed;
            } else {
                return null;
            }
        }
        int i = 0;
        while (i < this.conditionalPageMasterRefs.size()) {
            ConditionalPageMasterReference cpmr = (ConditionalPageMasterReference)this.conditionalPageMasterRefs.get(i);
            if (cpmr.isValid(isOddPage, isFirstPage, isBlankPage)) {
                return cpmr.getMasterName();
            }
            ++i;
        }
        return null;
    }

    public void addConditionalPageMasterReference(ConditionalPageMasterReference cpmr) {
        this.conditionalPageMasterRefs.add(cpmr);
    }

    public void reset() {
        this.numberConsumed = 0;
    }
}

