/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layout;

import java.util.Collections;
import java.util.Map;
import org.apache.fop.fonts.CodePointMapping;
import org.apache.fop.fonts.Font;
import org.apache.fop.fonts.FontMetrics;

public class FontState {
    private String fontName;
    private int fontSize;
    private FontMetrics metric;

    public FontState(String key, FontMetrics met, int fontSize) {
        this.fontName = key;
        this.metric = met;
        this.fontSize = fontSize;
    }

    public int getAscender() {
        return this.metric.getAscender(this.fontSize) / 1000;
    }

    public int getCapHeight() {
        return this.metric.getCapHeight(this.fontSize) / 1000;
    }

    public int getDescender() {
        return this.metric.getDescender(this.fontSize) / 1000;
    }

    public String getFontName() {
        return this.fontName;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public int getXHeight() {
        return this.metric.getXHeight(this.fontSize) / 1000;
    }

    public Map getKerning() {
        Map ret = this.metric.getKerningInfo();
        if (ret != null) {
            return ret;
        }
        return Collections.EMPTY_MAP;
    }

    public int getWidth(int charnum) {
        return this.metric.getWidth(charnum, this.fontSize) / 1000;
    }

    public char mapChar(char c) {
        if (this.metric instanceof Font) {
            return ((Font)this.metric).mapChar(c);
        }
        char d = CodePointMapping.getMapping("WinAnsiEncoding").mapChar(c);
        c = d != '\u0000' ? d : (char)35;
        return c;
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append('(');
        sbuf.append(this.fontName);
        sbuf.append(',');
        sbuf.append(this.fontSize);
        sbuf.append(')');
        return sbuf.toString();
    }
}

