/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr;

import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import org.apache.fop.area.Area;
import org.apache.fop.area.Block;
import org.apache.fop.area.BlockViewport;
import org.apache.fop.area.CTM;
import org.apache.fop.datatypes.FODimension;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.PropertyManager;
import org.apache.fop.layout.AbsolutePositionProps;
import org.apache.fop.layoutmgr.BlockStackingLayoutManager;
import org.apache.fop.layoutmgr.BreakPoss;
import org.apache.fop.layoutmgr.BreakPossPosIter;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.LayoutProcessor;
import org.apache.fop.layoutmgr.LeafPosition;
import org.apache.fop.layoutmgr.MinOptMax;
import org.apache.fop.layoutmgr.Position;
import org.apache.fop.layoutmgr.PositionIterator;

public class BlockContainerLayoutManager
extends BlockStackingLayoutManager {
    private BlockViewport viewportBlockArea;
    private Block curBlockArea;
    private List childBreaks = new ArrayList();
    private AbsolutePositionProps abProps;
    private FODimension relDims;
    private CTM absoluteCTM;
    private boolean clip = false;
    private int overflow;
    private PropertyManager propManager;

    public void setOverflow(int of) {
        this.overflow = of;
    }

    protected void initProperties(PropertyManager pm) {
        this.propManager = pm;
        this.abProps = pm.getAbsolutePositionProps();
        if (this.abProps.absolutePosition == 1) {
            Rectangle2D.Double rect = new Rectangle2D.Double(this.abProps.left, this.abProps.top, this.abProps.right - this.abProps.left, this.abProps.bottom - this.abProps.top);
            this.relDims = new FODimension(0, 0);
            this.absoluteCTM = pm.getCTMandRelDims(rect, this.relDims);
        }
    }

    protected int getRotatedIPD() {
        PropertyList props = this.propManager.getProperties();
        int height = props.get("height").getLength().getValue();
        height = props.get("inline-progression-dimension.optimum").getLength().getValue();
        return height;
    }

    /*
     * WARNING - void declaration
     */
    public BreakPoss getNextBreakPoss(LayoutContext context) {
        LayoutProcessor curLM;
        MinOptMax stackLimit;
        boolean rotated;
        if (this.abProps.absolutePosition == 1) {
            return this.getAbsoluteBreakPoss(context);
        }
        Rectangle2D.Double rect = new Rectangle2D.Double(0.0, 0.0, context.getRefIPD(), context.getStackLimit().opt);
        this.relDims = new FODimension(0, 0);
        this.absoluteCTM = this.propManager.getCTMandRelDims(rect, this.relDims);
        double[] vals = this.absoluteCTM.toArray();
        int ipd = context.getRefIPD();
        boolean bl = rotated = vals[0] == 0.0;
        if (rotated) {
            stackLimit = new MinOptMax(1000000);
            ipd = this.getRotatedIPD();
            this.absoluteCTM = new CTM(vals[0], vals[1], vals[2], vals[3], 0.0, 0.0);
        } else {
            if (vals[0] == -1.0) {
                this.absoluteCTM = new CTM(vals[0], vals[1], vals[2], vals[3], 0.0, 0.0);
            }
            stackLimit = context.getStackLimit();
        }
        MinOptMax stackSize = new MinOptMax();
        BreakPoss lastPos = null;
        while ((curLM = this.getChildLM()) != null) {
            void var7_9;
            LayoutContext childLC = new LayoutContext(0);
            childLC.setStackLimit(MinOptMax.subtract(stackLimit, stackSize));
            childLC.setRefIPD(ipd);
            while (!var7_9.isFinished()) {
                BreakPoss bp = var7_9.getNextBreakPoss(childLC);
                if (bp == null) continue;
                stackSize.add(bp.getStackingSize());
                if (stackSize.opt > stackLimit.max) {
                    if (lastPos != null) {
                        this.reset(lastPos.getPosition());
                        break;
                    }
                    var7_9.resetPosition(null);
                    break;
                }
                lastPos = bp;
                this.childBreaks.add(bp);
                childLC.setStackLimit(MinOptMax.subtract(stackLimit, stackSize));
            }
            if (rotated) continue;
            BreakPoss breakPoss = new BreakPoss(new LeafPosition(this, this.childBreaks.size() - 1));
            breakPoss.setStackingSize(stackSize);
            return breakPoss;
        }
        this.setFinished(true);
        if (rotated) {
            BreakPoss breakPoss = new BreakPoss(new LeafPosition(this, this.childBreaks.size() - 1));
            breakPoss.setStackingSize(new MinOptMax(ipd));
            return breakPoss;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public BreakPoss getAbsoluteBreakPoss(LayoutContext context) {
        LayoutProcessor curLM;
        MinOptMax stackSize = new MinOptMax();
        int ipd = this.relDims.ipd;
        while ((curLM = this.getChildLM()) != null) {
            void var2_4;
            LayoutContext childLC = new LayoutContext(0);
            childLC.setStackLimit(new MinOptMax(1000000));
            childLC.setRefIPD(ipd);
            while (!var2_4.isFinished()) {
                BreakPoss bp = var2_4.getNextBreakPoss(childLC);
                if (bp == null) continue;
                stackSize.add(bp.getStackingSize());
                this.childBreaks.add(bp);
            }
        }
        this.setFinished(true);
        BreakPoss breakPoss = new BreakPoss(new LeafPosition(this, this.childBreaks.size() - 1));
        breakPoss.setStackingSize(new MinOptMax(0));
        if (stackSize.opt > this.relDims.bpd) {
            if (this.overflow == 36) {
                this.clip = true;
            } else if (this.overflow == 26) {
                this.getLogger().error("contents overflows block-container viewport: clipping");
                this.clip = true;
            }
        }
        return breakPoss;
    }

    /*
     * WARNING - void declaration
     */
    public void addAreas(PositionIterator parentIter, LayoutContext layoutContext) {
        this.getParentArea(null);
        this.addID();
        this.addMarkers(true, true);
        int iStartPos = 0;
        LayoutContext lc = new LayoutContext(0);
        while (parentIter.hasNext()) {
            LayoutProcessor childLM;
            LeafPosition lfp = (LeafPosition)parentIter.next();
            BreakPossPosIter breakPosIter = new BreakPossPosIter(this.childBreaks, iStartPos, lfp.getLeafPos() + 1);
            iStartPos = lfp.getLeafPos() + 1;
            while ((childLM = breakPosIter.getNextChildLM()) != null) {
                void var3_5;
                var3_5.addAreas(breakPosIter, lc);
            }
        }
        this.flush();
        this.addMarkers(true, true);
        this.childBreaks.clear();
        this.viewportBlockArea = null;
        this.curBlockArea = null;
    }

    public Area getParentArea(Area childArea) {
        if (this.curBlockArea == null) {
            this.viewportBlockArea = new BlockViewport();
            if (this.abProps.absolutePosition == 1) {
                this.viewportBlockArea.setXOffset(this.abProps.left);
                this.viewportBlockArea.setYOffset(this.abProps.top);
                this.viewportBlockArea.setWidth(this.abProps.right - this.abProps.left);
                this.viewportBlockArea.setHeight(this.abProps.bottom - this.abProps.top);
                this.viewportBlockArea.setCTM(this.absoluteCTM);
                this.viewportBlockArea.setClip(this.clip);
            } else {
                boolean rotated;
                double[] vals = this.absoluteCTM.toArray();
                boolean bl = rotated = vals[0] == 0.0;
                if (rotated) {
                    this.viewportBlockArea.setWidth(this.relDims.bpd);
                    this.viewportBlockArea.setHeight(this.getRotatedIPD());
                    this.viewportBlockArea.setCTM(this.absoluteCTM);
                    this.viewportBlockArea.setClip(this.clip);
                } else if (vals[0] == -1.0) {
                    this.viewportBlockArea.setWidth(this.relDims.ipd);
                    this.viewportBlockArea.setWidth(this.relDims.bpd);
                    this.viewportBlockArea.setCTM(this.absoluteCTM);
                    this.viewportBlockArea.setClip(this.clip);
                }
            }
            this.curBlockArea = new Block();
            this.viewportBlockArea.addBlock(this.curBlockArea);
            if (this.abProps.absolutePosition == 1) {
                this.viewportBlockArea.setPositioning(2);
            }
            Area parentArea = this.parentLM.getParentArea(this.curBlockArea);
            int referenceIPD = parentArea.getIPD();
            this.curBlockArea.setIPD(referenceIPD);
            this.setCurrentArea(this.viewportBlockArea);
        }
        return this.curBlockArea;
    }

    public void addChild(Area childArea) {
        if (this.curBlockArea != null) {
            this.curBlockArea.addBlock((Block)childArea);
        }
    }

    public void resetPosition(Position resetPos) {
        if (resetPos == null) {
            this.reset(null);
        }
    }
}

