/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr;

import java.util.ArrayList;
import java.util.List;
import org.apache.fop.area.Area;
import org.apache.fop.area.BlockParent;
import org.apache.fop.fo.flow.Marker;
import org.apache.fop.layoutmgr.BlockStackingLayoutManager;
import org.apache.fop.layoutmgr.BreakPoss;
import org.apache.fop.layoutmgr.BreakPossPosIter;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.LayoutProcessor;
import org.apache.fop.layoutmgr.LeafPosition;
import org.apache.fop.layoutmgr.MinOptMax;
import org.apache.fop.layoutmgr.Position;
import org.apache.fop.layoutmgr.PositionIterator;

public class FlowLayoutManager
extends BlockStackingLayoutManager {
    protected List blockBreaks = new ArrayList();
    private BlockParent[] currentAreas = new BlockParent[6];
    private int iStartPos = 0;

    /*
     * WARNING - void declaration
     */
    public BreakPoss getNextBreakPoss(LayoutContext context) {
        LayoutProcessor curLM;
        MinOptMax stackSize = new MinOptMax();
        while ((curLM = this.getChildLM()) != null) {
            BreakPoss bp;
            void var2_3;
            if (var2_3.generatesInlineAreas()) {
                this.getLogger().error("inline area not allowed under flow - ignoring");
                var2_3.setFinished(true);
                continue;
            }
            MinOptMax bpd = context.getStackLimit();
            LayoutContext childLC = new LayoutContext(0);
            boolean breakPage = false;
            childLC.setStackLimit(MinOptMax.subtract(bpd, stackSize));
            childLC.setRefIPD(context.getRefIPD());
            if (!var2_3.isFinished() && (bp = var2_3.getNextBreakPoss(childLC)) != null) {
                stackSize.add(bp.getStackingSize());
                this.blockBreaks.add(bp);
                childLC.setStackLimit(MinOptMax.subtract(bpd, stackSize));
                if (bp.isForcedBreak() || bp.nextBreakOverflows()) {
                    breakPage = true;
                }
            }
            if (stackSize.opt > context.getStackLimit().opt) {
                breakPage = true;
            }
            if (!breakPage) continue;
            return new BreakPoss(new LeafPosition(this, this.blockBreaks.size() - 1));
        }
        this.setFinished(true);
        if (this.blockBreaks.size() > 0) {
            return new BreakPoss(new LeafPosition(this, this.blockBreaks.size() - 1));
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public void addAreas(PositionIterator parentIter, LayoutContext layoutContext) {
        LayoutContext lc = new LayoutContext(0);
        while (parentIter.hasNext()) {
            LayoutProcessor childLM;
            LeafPosition lfp = (LeafPosition)parentIter.next();
            BreakPossPosIter breakPosIter = new BreakPossPosIter(this.blockBreaks, this.iStartPos, lfp.getLeafPos() + 1);
            this.iStartPos = lfp.getLeafPos() + 1;
            while ((childLM = breakPosIter.getNextChildLM()) != null) {
                void var3_4;
                var3_4.addAreas(breakPosIter, lc);
            }
        }
        this.flush();
    }

    public void addChild(Area childArea) {
        this.addChildToArea(childArea, this.currentAreas[childArea.getAreaClass()]);
    }

    public Area getParentArea(Area childArea) {
        BlockParent parentArea;
        this.currentAreas[parentArea.getAreaClass()] = parentArea = (BlockParent)this.parentLM.getParentArea(childArea);
        this.setCurrentArea(parentArea);
        return parentArea;
    }

    public void resetPosition(Position resetPos) {
        if (resetPos == null) {
            this.reset(null);
        }
    }

    public Marker retrieveMarker(String name, int pos, int boundary) {
        this.getLogger().error("Cannot retrieve a marker from the flow");
        return null;
    }
}

