/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr;

import org.apache.fop.layoutmgr.HyphContext;
import org.apache.fop.layoutmgr.MinOptMax;
import org.apache.fop.layoutmgr.SpaceSpecifier;

public class LayoutContext {
    public static final int LINEBREAK_AT_LF_ONLY = 1;
    public static final int NEW_AREA = 2;
    public static final int IPD_UNKNOWN = 4;
    public static final int CHECK_REF_AREA = 8;
    public static final int SUPPRESS_LEADING_SPACE = 16;
    public static final int FIRST_AREA = 32;
    public static final int TRY_HYPHENATE = 64;
    public static final int LAST_AREA = 128;
    public static final int RESOLVE_LEADING_SPACE = 256;
    public int flags;
    MinOptMax stackLimit;
    boolean bIsSpan;
    int refIPD;
    SpaceSpecifier trailingSpace;
    SpaceSpecifier leadingSpace;
    private HyphContext hyphContext = null;
    private double ipdAdjust = 0.0;
    private double dSpaceAdjust = 0.0;
    private int iLineHeight;
    private int iBaseline;

    public LayoutContext(LayoutContext parentLC) {
        this.flags = parentLC.flags;
        this.refIPD = parentLC.refIPD;
        this.stackLimit = null;
        this.leadingSpace = parentLC.leadingSpace;
        this.trailingSpace = parentLC.trailingSpace;
        this.hyphContext = parentLC.hyphContext;
        this.dSpaceAdjust = parentLC.dSpaceAdjust;
        this.iLineHeight = parentLC.iLineHeight;
        this.iBaseline = parentLC.iBaseline;
    }

    public LayoutContext(int flags) {
        this.flags = flags;
        this.refIPD = 0;
        this.stackLimit = new MinOptMax(0);
        this.leadingSpace = null;
        this.trailingSpace = null;
    }

    public void setFlags(int flags) {
        this.setFlags(flags, true);
    }

    public void setFlags(int flags, boolean bSet) {
        this.flags = bSet ? (this.flags |= flags) : (this.flags &= ~flags);
    }

    public void unsetFlags(int flags) {
        this.setFlags(flags, false);
    }

    public boolean isStart() {
        return (this.flags & 2) != 0;
    }

    public boolean startsNewArea() {
        return (this.flags & 2) != 0 && this.leadingSpace != null;
    }

    public boolean isFirstArea() {
        return (this.flags & 0x20) != 0;
    }

    public boolean isLastArea() {
        return (this.flags & 0x80) != 0;
    }

    public boolean suppressLeadingSpace() {
        return (this.flags & 0x10) != 0;
    }

    public void setLeadingSpace(SpaceSpecifier space) {
        this.leadingSpace = space;
    }

    public SpaceSpecifier getLeadingSpace() {
        return this.leadingSpace;
    }

    public boolean resolveLeadingSpace() {
        return (this.flags & 0x100) != 0;
    }

    public void setTrailingSpace(SpaceSpecifier space) {
        this.trailingSpace = space;
    }

    public SpaceSpecifier getTrailingSpace() {
        return this.trailingSpace;
    }

    public void setStackLimit(MinOptMax limit) {
        this.stackLimit = limit;
    }

    public MinOptMax getStackLimit() {
        return this.stackLimit;
    }

    public void setRefIPD(int ipd) {
        this.refIPD = ipd;
    }

    public int getRefIPD() {
        return this.refIPD;
    }

    public void setHyphContext(HyphContext hyph) {
        this.hyphContext = hyph;
    }

    public HyphContext getHyphContext() {
        return this.hyphContext;
    }

    public boolean tryHyphenate() {
        return (this.flags & 0x40) != 0;
    }

    public void setSpaceAdjust(double adjust) {
        this.dSpaceAdjust = adjust;
    }

    public double getSpaceAdjust() {
        return this.dSpaceAdjust;
    }

    public void setIPDAdjust(double ipdA) {
        this.ipdAdjust = ipdA;
    }

    public double getIPDAdjust() {
        return this.ipdAdjust;
    }

    public void setLineHeight(int lh) {
        this.iLineHeight = lh;
    }

    public int getLineHeight() {
        return this.iLineHeight;
    }

    public void setBaseline(int bl) {
        this.iBaseline = bl;
    }

    public int getBaseline() {
        return this.iBaseline;
    }
}

