/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr;

import org.apache.fop.area.Area;
import org.apache.fop.area.inline.InlineArea;
import org.apache.fop.layoutmgr.AbstractLayoutManager;
import org.apache.fop.layoutmgr.BreakPoss;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.LeafPosition;
import org.apache.fop.layoutmgr.MinOptMax;
import org.apache.fop.layoutmgr.Position;
import org.apache.fop.layoutmgr.PositionIterator;
import org.apache.fop.layoutmgr.SpaceSpecifier;

public class LeafNodeLayoutManager
extends AbstractLayoutManager {
    protected InlineArea curArea = null;
    private int alignment;
    private int lead;
    private MinOptMax ipd;

    public InlineArea get(LayoutContext context) {
        return this.curArea;
    }

    public boolean generatesInlineAreas() {
        return true;
    }

    public boolean resolved() {
        return false;
    }

    public void setCurrentArea(InlineArea ia) {
        this.curArea = ia;
    }

    public void setAlignment(int al) {
        this.alignment = al;
    }

    public void setLead(int l) {
        this.lead = l;
    }

    public void addChild(Area childArea) {
    }

    public Area getParentArea(Area childArea) {
        return null;
    }

    public BreakPoss getNextBreakPoss(LayoutContext context) {
        this.curArea = this.get(context);
        if (this.curArea == null) {
            this.setFinished(true);
            return null;
        }
        BreakPoss bp = new BreakPoss(new LeafPosition(this, 0), 23L);
        this.ipd = this.getAllocationIPD(context.getRefIPD());
        bp.setStackingSize(this.ipd);
        bp.setNonStackingSize(new MinOptMax(this.curArea.getHeight()));
        bp.setTrailingSpace(new SpaceSpecifier(false));
        int bpd = this.curArea.getHeight();
        switch (this.alignment) {
            case 49: {
                bp.setMiddle(bpd / 2);
                bp.setLead(bpd / 2);
                break;
            }
            case 94: {
                bp.setTotal(bpd);
                break;
            }
            case 13: {
                bp.setTotal(bpd);
                break;
            }
            default: {
                bp.setLead(bpd);
            }
        }
        this.setFinished(true);
        return bp;
    }

    protected MinOptMax getAllocationIPD(int refIPD) {
        return new MinOptMax(this.curArea.getIPD());
    }

    public void resetPosition(Position resetPos) {
        if (resetPos == null) {
            this.setFinished(false);
        }
    }

    public void addAreas(PositionIterator posIter, LayoutContext context) {
        this.parentLM.addChild(this.curArea);
        this.addID();
        this.offsetArea(context);
        this.widthAdjustArea(context);
        while (posIter.hasNext()) {
            posIter.next();
        }
    }

    protected void offsetArea(LayoutContext context) {
        int bpd = this.curArea.getHeight();
        switch (this.alignment) {
            case 49: {
                this.curArea.setOffset(context.getBaseline() - bpd / 2);
                break;
            }
            case 94: {
                break;
            }
            case 13: {
                this.curArea.setOffset(context.getLineHeight() - bpd);
                break;
            }
            default: {
                this.curArea.setOffset(context.getBaseline() - bpd);
            }
        }
    }

    protected void widthAdjustArea(LayoutContext context) {
        double dAdjust = context.getIPDAdjust();
        int width = this.ipd.opt;
        if (dAdjust < 0.0) {
            width = (int)((double)width + dAdjust * (double)(this.ipd.opt - this.ipd.min));
        } else if (dAdjust > 0.0) {
            width = (int)((double)width + dAdjust * (double)(this.ipd.max - this.ipd.opt));
        }
        this.curArea.setWidth(width);
    }

    public boolean canBreakBefore(LayoutContext context) {
        return true;
    }
}

