/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.fop.apps.FOPException;
import org.apache.fop.area.Area;
import org.apache.fop.area.AreaTree;
import org.apache.fop.area.AreaTreeModel;
import org.apache.fop.area.BeforeFloat;
import org.apache.fop.area.BodyRegion;
import org.apache.fop.area.Flow;
import org.apache.fop.area.Footnote;
import org.apache.fop.area.MainReference;
import org.apache.fop.area.PageViewport;
import org.apache.fop.area.RegionViewport;
import org.apache.fop.area.Resolveable;
import org.apache.fop.area.Span;
import org.apache.fop.fo.flow.Marker;
import org.apache.fop.fo.flow.StaticContent;
import org.apache.fop.fo.pagination.PageNumberGenerator;
import org.apache.fop.fo.pagination.PageSequence;
import org.apache.fop.fo.pagination.Region;
import org.apache.fop.fo.pagination.SimplePageMaster;
import org.apache.fop.layoutmgr.AbstractLayoutManager;
import org.apache.fop.layoutmgr.BreakPoss;
import org.apache.fop.layoutmgr.BreakPossPosIter;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.LayoutProcessor;
import org.apache.fop.layoutmgr.LeafPosition;
import org.apache.fop.layoutmgr.MinOptMax;
import org.apache.fop.layoutmgr.StaticContentLayoutManager;

public class PageLayoutManager
extends AbstractLayoutManager
implements Runnable {
    private PageNumberGenerator pageNumberGenerator;
    private int pageCount = 1;
    private String pageNumberString;
    private boolean isFirstPage = true;
    private boolean bFirstPage;
    private PageViewport curPage;
    private BodyRegion curBody;
    private Span curSpan;
    private int curSpanColumns;
    private Flow curFlow;
    private int flowBPD = 0;
    private int flowIPD = 0;
    private AreaTree areaTree;
    private PageSequence pageSequence;

    public PageLayoutManager(AreaTree areaTree, PageSequence pageseq) {
        this.areaTree = areaTree;
        this.pageSequence = pageseq;
    }

    public void setPageCounting(int pc, PageNumberGenerator generator) {
        this.pageCount = pc;
        this.pageNumberGenerator = generator;
        this.pageNumberString = this.pageNumberGenerator.makeFormattedPageNumber(this.pageCount);
    }

    public int getPageCount() {
        return this.pageCount;
    }

    public void run() {
        this.doLayout();
        this.flush();
    }

    protected void doLayout() {
        this.makeNewPage(false, false);
        this.createBodyMainReferenceArea();
        this.createSpan(1);
        this.flowIPD = this.curFlow.getIPD();
        LayoutContext childLC = new LayoutContext(0);
        while (!this.isFinished()) {
            BreakPoss bp = this.getNextBreakPoss(childLC);
            if (bp == null) continue;
            this.addAreas((BlockBreakPosition)bp.getPosition());
            this.finishPage();
            ++this.pageCount;
            this.pageNumberString = this.pageNumberGenerator.makeFormattedPageNumber(this.pageCount);
        }
        --this.pageCount;
    }

    /*
     * WARNING - void declaration
     */
    public BreakPoss getNextBreakPoss(LayoutContext context) {
        LayoutProcessor curLM;
        while ((curLM = this.getChildLM()) != null) {
            void var2_2;
            BreakPoss bp = null;
            LayoutContext childLC = new LayoutContext(0);
            childLC.setStackLimit(new MinOptMax(this.flowBPD));
            childLC.setRefIPD(this.flowIPD);
            if (!var2_2.isFinished()) {
                bp = var2_2.getNextBreakPoss(childLC);
            }
            if (bp == null) continue;
            return new BreakPoss(new BlockBreakPosition((LayoutProcessor)var2_2, bp));
        }
        this.setFinished(true);
        return null;
    }

    public String getCurrentPageNumber() {
        return this.pageNumberString;
    }

    public PageViewport resolveRefID(String ref) {
        List list = this.areaTree.getIDReferences(ref);
        if (list != null && list.size() > 0) {
            return (PageViewport)list.get(0);
        }
        return null;
    }

    public void addAreas(BlockBreakPosition bbp) {
        ArrayList<BreakPoss> list = new ArrayList<BreakPoss>();
        list.add(bbp.breakps);
        bbp.getLM().addAreas(new BreakPossPosIter(list, 0, 1), null);
    }

    public void addIDToPage(String id) {
        this.areaTree.addIDRef(id, this.curPage);
    }

    public void addUnresolvedArea(String id, Resolveable res) {
        this.curPage.addUnresolvedID(id, res);
        this.areaTree.addUnresolvedID(id, this.curPage);
    }

    public void addMarkerMap(Map marks, boolean start, boolean isfirst) {
        this.curPage.addMarkers(marks, start, isfirst);
    }

    public Marker retrieveMarker(String name, int pos, int boundary) {
        Marker mark = (Marker)this.curPage.getMarker(name, pos);
        if (mark == null && boundary != 65) {
            boolean doc = boundary == 19;
            AreaTreeModel atm = this.areaTree.getAreaTreeModel();
            int seq = atm.getPageSequenceCount();
            int page = atm.getPageCount(seq) - 1;
            while (page >= 0) {
                PageViewport pv = atm.getPage(seq, page);
                mark = (Marker)this.curPage.getMarker(name, pos);
                if (mark != null) {
                    return mark;
                }
                if (--page != -1 || !doc || seq <= 0) continue;
                page = atm.getPageCount(--seq) - 1;
            }
        }
        return mark;
    }

    public void addChild(Area childArea) {
        if (childArea == null) {
            return;
        }
        if (childArea.getAreaClass() == 0) {
            this.placeFlowRefArea(childArea);
        }
    }

    protected void placeFlowRefArea(Area area) {
        this.getParentArea(area);
    }

    protected void placeAbsoluteArea(Area area) {
    }

    protected void placeBeforeFloat(Area area) {
    }

    protected void placeSideFloat(Area area) {
    }

    protected void placeFootnote(Area area) {
    }

    private PageViewport makeNewPage(boolean bIsBlank, boolean bIsLast) {
        this.finishPage();
        try {
            this.curPage = this.pageSequence.createPage(this.pageCount, bIsBlank, this.isFirstPage, bIsLast);
            this.isFirstPage = false;
        }
        catch (FOPException fopex) {
            fopex.printStackTrace();
        }
        this.curPage.setPageNumber(this.getCurrentPageNumber());
        RegionViewport reg = this.curPage.getPage().getRegion(2);
        this.curBody = (BodyRegion)reg.getRegion();
        this.flowBPD = (int)reg.getViewArea().getHeight();
        return this.curPage;
    }

    private void layoutStaticContent(Region region, int regionClass) {
        StaticContent flow;
        if (region != null && (flow = this.pageSequence.getStaticContent(region.getRegionName())) != null) {
            RegionViewport reg = this.curPage.getPage().getRegion(regionClass);
            reg.getRegion().setIPD((int)reg.getViewArea().getWidth());
            if (reg == null) {
                this.getLogger().error("no region viewport: shouldn't happen");
            }
            StaticContentLayoutManager lm = flow.getLayoutManager();
            lm.setUserAgent(this.getUserAgent());
            lm.init();
            lm.setRegionReference(reg.getRegion());
            lm.setParent(this);
            LayoutContext childLC = new LayoutContext(0);
            childLC.setStackLimit(new MinOptMax((int)this.curPage.getViewArea().getHeight()));
            childLC.setRefIPD((int)reg.getViewArea().getWidth());
            while (!lm.isFinished()) {
                BreakPoss bp = lm.getNextBreakPoss(childLC);
                if (bp != null) {
                    ArrayList<BreakPoss> vecBreakPoss = new ArrayList<BreakPoss>();
                    vecBreakPoss.add(bp);
                    lm.addAreas(new BreakPossPosIter(vecBreakPoss, 0, vecBreakPoss.size()), null);
                    continue;
                }
                this.getLogger().error("bp==null  cls=" + regionClass);
            }
            lm.reset(null);
        }
    }

    private void finishPage() {
        if (this.curPage != null) {
            SimplePageMaster spm = this.pageSequence.getCurrentSimplePageMaster();
            this.layoutStaticContent(spm.getRegion("before"), 0);
            this.layoutStaticContent(spm.getRegion("after"), 4);
            this.layoutStaticContent(spm.getRegion("start"), 1);
            this.layoutStaticContent(spm.getRegion("end"), 3);
            this.areaTree.addPage(this.curPage);
            this.curPage = null;
            this.curBody = null;
            this.curSpan = null;
            this.curFlow = null;
        }
    }

    public Area getParentArea(Area childArea) {
        int aclass = childArea.getAreaClass();
        if (aclass == 0) {
            int breakVal = 8;
            if (breakVal != 8) {
                this.handleBreak(breakVal);
            } else if (this.curPage == null) {
                this.makeNewPage(false, false);
            }
            boolean bNeedSpan = false;
            int span = 57;
            int numCols = 1;
            if (span == 4) {
                // empty if block
            }
            if (this.curSpan == null) {
                this.createBodyMainReferenceArea();
                bNeedSpan = true;
            } else if (numCols != this.curSpanColumns) {
                if (this.curSpanColumns > 1) {
                    // empty if block
                }
                bNeedSpan = true;
            }
            if (bNeedSpan) {
                this.createSpan(numCols);
            } else if (this.curFlow == null) {
                this.createFlow();
            }
            return this.curFlow;
        }
        if (this.curPage == null) {
            this.makeNewPage(false, false);
        }
        if (aclass == 3) {
            BeforeFloat bf = this.curBody.getBeforeFloat();
            if (bf == null) {
                bf = new BeforeFloat();
                this.curBody.setBeforeFloat(bf);
            }
            return bf;
        }
        if (aclass == 4) {
            Footnote fn = this.curBody.getFootnote();
            if (fn == null) {
                fn = new Footnote();
                this.curBody.setFootnote(fn);
            }
            return fn;
        }
        return null;
    }

    protected void handleBreak(int breakVal) {
        if (breakVal == 16) {
            if (this.curSpan != null && this.curSpan.getColumnCount() != this.curSpanColumns) {
                this.createFlow();
                return;
            }
            breakVal = 65;
        }
        if (this.needEmptyPage(breakVal)) {
            this.curPage = this.makeNewPage(true, false);
        }
        if (this.needNewPage(breakVal)) {
            this.curPage = this.makeNewPage(false, false);
        }
    }

    private boolean needEmptyPage(int breakValue) {
        return false;
    }

    private boolean needNewPage(int breakValue) {
        return false;
    }

    private void createBodyMainReferenceArea() {
        this.curBody.setMainReference(new MainReference());
    }

    private Flow createFlow() {
        this.curFlow = new Flow();
        this.curFlow.setIPD(this.curSpan.getIPD());
        this.curSpan.addFlow(this.curFlow);
        return this.curFlow;
    }

    private void createSpan(int numCols) {
        this.curSpan = new Span(numCols);
        this.curSpan.setIPD((int)this.curPage.getPage().getRegion(2).getViewArea().getWidth());
        this.curBody.getMainReference().addSpan(this.curSpan);
        this.createFlow();
    }

    protected void flush() {
        this.finishPage();
    }

    private static class BlockBreakPosition
    extends LeafPosition {
        protected BreakPoss breakps;

        protected BlockBreakPosition(LayoutProcessor lm, BreakPoss bp) {
            super(lm, 0);
            this.breakps = bp;
        }
    }
}

