/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr.table;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.fop.area.Area;
import org.apache.fop.area.Block;
import org.apache.fop.fo.PropertyManager;
import org.apache.fop.layout.BackgroundProps;
import org.apache.fop.layout.BorderAndPadding;
import org.apache.fop.layoutmgr.BlockStackingLayoutManager;
import org.apache.fop.layoutmgr.BreakPoss;
import org.apache.fop.layoutmgr.BreakPossPosIter;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.LayoutProcessor;
import org.apache.fop.layoutmgr.LeafPosition;
import org.apache.fop.layoutmgr.MinOptMax;
import org.apache.fop.layoutmgr.Position;
import org.apache.fop.layoutmgr.PositionIterator;
import org.apache.fop.layoutmgr.TraitSetter;
import org.apache.fop.layoutmgr.table.Cell;
import org.apache.fop.layoutmgr.table.Column;

public class Row
extends BlockStackingLayoutManager {
    private List cellList = null;
    private List columns = null;
    private int rowHeight;
    private int yoffset;
    private BorderAndPadding borderProps = null;
    private BackgroundProps backgroundProps;

    protected void initProperties(PropertyManager propMgr) {
        this.borderProps = propMgr.getBorderAndPadding();
        this.backgroundProps = propMgr.getBackgroundProps();
    }

    public void setColumns(List cols) {
        this.columns = cols;
    }

    private void setupCells() {
        this.cellList = new ArrayList();
        while (this.childLMiter.hasNext()) {
            this.curChildLM = (LayoutProcessor)this.childLMiter.next();
            this.curChildLM.setUserAgent(this.getUserAgent());
            this.curChildLM.setParent(this);
            this.curChildLM.init();
            this.cellList.add(this.curChildLM);
        }
    }

    protected Cell getCellLM(int pos) {
        if (this.cellList == null) {
            this.setupCells();
        }
        if (pos < this.cellList.size()) {
            return (Cell)this.cellList.get(pos);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public BreakPoss getNextBreakPoss(LayoutContext context) {
        Cell curLM;
        BreakPoss lastPos = null;
        ArrayList breakList = new ArrayList();
        int min = 0;
        int opt = 0;
        int max = 0;
        int cellcount = 0;
        boolean over = false;
        while ((curLM = this.getCellLM(cellcount++)) != null) {
            void var2_9;
            ArrayList<BreakPoss> childBreaks = new ArrayList<BreakPoss>();
            MinOptMax stackSize = new MinOptMax();
            int ipd = context.getRefIPD();
            LayoutContext childLC = new LayoutContext(0);
            childLC.setStackLimit(MinOptMax.subtract(context.getStackLimit(), stackSize));
            int size = this.columns.size();
            Column col = cellcount > size - 1 ? (Column)this.columns.get(size - 1) : (Column)this.columns.get(cellcount - 1);
            childLC.setRefIPD(col.getWidth());
            while (!var2_9.isFinished()) {
                BreakPoss bp = var2_9.getNextBreakPoss(childLC);
                if (bp == null) continue;
                if (stackSize.opt + bp.getStackingSize().opt > context.getStackLimit().max) {
                    if (lastPos != null) {
                        LayoutProcessor lm = lastPos.getLayoutManager();
                        lm.resetPosition(lastPos.getPosition());
                        if (lm != var2_9) {
                            var2_9.resetPosition(null);
                        }
                    } else {
                        var2_9.resetPosition(null);
                    }
                    over = true;
                    break;
                }
                stackSize.add(bp.getStackingSize());
                lastPos = bp;
                childBreaks.add(bp);
                if (bp.nextBreakOverflows()) {
                    over = true;
                    break;
                }
                childLC.setStackLimit(MinOptMax.subtract(context.getStackLimit(), stackSize));
            }
            if (stackSize.min > min) {
                min = stackSize.min;
            }
            if (stackSize.opt > opt) {
                opt = stackSize.opt;
            }
            if (stackSize.max > max) {
                max = stackSize.max;
            }
            breakList.add(childBreaks);
        }
        this.rowHeight = opt;
        MinOptMax rowSize = new MinOptMax(min, opt, max);
        boolean fin = true;
        cellcount = 0;
        while ((curLM = this.getCellLM(cellcount++)) != null) {
            if (curLM.isFinished()) continue;
            fin = false;
            break;
        }
        this.setFinished(fin);
        RowPosition rp = new RowPosition(this, breakList.size() - 1, breakList);
        BreakPoss breakPoss = new BreakPoss(rp);
        if (over) {
            breakPoss.setFlag(1024, true);
        }
        breakPoss.setStackingSize(rowSize);
        return breakPoss;
    }

    /*
     * Unable to fully structure code
     */
    protected void reset(Position pos) {
        block3: {
            block2: {
                cellcount = 0;
                if (pos != null) break block2;
                if (true) ** GOTO lbl6
                do {
                    var2_3.resetPosition(null);
lbl6:
                    // 2 sources

                    v0 = ++cellcount;
                    ++cellcount;
                } while ((curLM = this.getCellLM(v0)) != null);
                break block3;
            }
            rpos = (RowPosition)pos;
            breaks = rpos.cellBreaks;
            if (true) ** GOTO lbl17
            do {
                childbreaks = (List)breaks.get(cellcount);
                curLM.resetPosition((Position)childbreaks.get(childbreaks.size() - 1));
lbl17:
                // 2 sources

                v1 = ++cellcount;
                ++cellcount;
            } while ((curLM = this.getCellLM(v1)) != null);
        }
        this.setFinished(false);
    }

    public void setYOffset(int off) {
        this.yoffset = off;
    }

    /*
     * WARNING - void declaration
     */
    public void addAreas(PositionIterator parentIter, LayoutContext layoutContext) {
        this.getParentArea(null);
        this.addID();
        int iStartPos = 0;
        LayoutContext lc = new LayoutContext(0);
        while (parentIter.hasNext()) {
            RowPosition lfp = (RowPosition)parentIter.next();
            int cellcount = 0;
            int xoffset = 0;
            Iterator iter = lfp.cellBreaks.iterator();
            while (iter.hasNext()) {
                Cell childLM;
                Column col;
                List cellsbr = (List)iter.next();
                BreakPossPosIter breakPosIter = new BreakPossPosIter(cellsbr, 0, cellsbr.size());
                iStartPos = lfp.getLeafPos() + 1;
                int size = this.columns.size();
                if (cellcount > size - 1) {
                    col = (Column)this.columns.get(size - 1);
                } else {
                    col = (Column)this.columns.get(cellcount);
                    ++cellcount;
                }
                while ((childLM = (Cell)breakPosIter.getNextChildLM()) != null) {
                    void var3_5;
                    var3_5.setXOffset(xoffset);
                    var3_5.setYOffset(this.yoffset);
                    var3_5.setRowHeight(this.rowHeight);
                    var3_5.addAreas(breakPosIter, lc);
                }
                xoffset += col.getWidth();
            }
        }
        this.flush();
    }

    public int getRowHeight() {
        return this.rowHeight;
    }

    public Area getParentArea(Area childArea) {
        return this.parentLM.getParentArea(childArea);
    }

    public void addChild(Area childArea) {
        this.parentLM.addChild(childArea);
    }

    public void resetPosition(Position resetPos) {
        if (resetPos == null) {
            this.reset(null);
        }
    }

    public Area getRowArea() {
        Block block = new Block();
        if (this.backgroundProps != null) {
            TraitSetter.addBackground(block, this.backgroundProps);
        }
        return block;
    }

    private class RowPosition
    extends LeafPosition {
        protected List cellBreaks;

        protected RowPosition(LayoutProcessor lm, int pos, List l) {
            super(lm, pos);
            this.cellBreaks = l;
        }
    }
}

