/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.mif;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.StructureHandler;
import org.apache.fop.fo.Title;
import org.apache.fop.fo.flow.Block;
import org.apache.fop.fo.flow.Flow;
import org.apache.fop.fo.pagination.LayoutMasterSet;
import org.apache.fop.fo.pagination.PageSequence;
import org.apache.fop.fo.pagination.PageSequenceMaster;
import org.apache.fop.fo.pagination.SimplePageMaster;
import org.apache.fop.layout.FontInfo;
import org.apache.fop.mif.MIFElement;
import org.apache.fop.mif.MIFFile;
import org.apache.fop.render.pdf.FontSetup;
import org.xml.sax.SAXException;

public class MIFHandler
extends StructureHandler {
    protected MIFFile mifFile;
    protected OutputStream outStream;
    private FontInfo fontInfo = new FontInfo();
    private MIFElement textFlow;
    private MIFElement para;

    public MIFHandler(OutputStream os) {
        this.outStream = os;
        FontSetup.setup(this.fontInfo, null);
    }

    public FontInfo getFontInfo() {
        return this.fontInfo;
    }

    public void startDocument() throws SAXException {
        this.mifFile = new MIFFile();
        try {
            this.mifFile.output(this.outStream);
        }
        catch (IOException ioe) {
            throw new SAXException(ioe);
        }
    }

    public void endDocument() throws SAXException {
        this.mifFile.finish(true);
        try {
            this.mifFile.output(this.outStream);
            this.outStream.flush();
        }
        catch (IOException ioe) {
            throw new SAXException(ioe);
        }
    }

    public void startPageSequence(PageSequence pageSeq, Title seqTitle, LayoutMasterSet lms) {
        String name = pageSeq.getProperty("master-reference").getString();
        SimplePageMaster spm = lms.getSimplePageMaster(name);
        if (spm == null) {
            PageSequenceMaster psm = lms.getPageSequenceMaster(name);
        } else {
            MIFElement prop = new MIFElement("PageType");
            prop.setValue("BodyPage");
            MIFElement page = new MIFElement("Page");
            page.addElement(prop);
            prop = new MIFElement("PageBackground");
            prop.setValue("'Default'");
            page.addElement(prop);
            MIFElement textRect = new MIFElement("TextRect");
            prop = new MIFElement("ID");
            prop.setValue("1");
            textRect.addElement(prop);
            prop = new MIFElement("ShapeRect");
            prop.setValue("0.0 841.889 453.543 0.0");
            textRect.addElement(prop);
            page.addElement(textRect);
            textRect = new MIFElement("TextRect");
            prop = new MIFElement("ID");
            prop.setValue("2");
            textRect.addElement(prop);
            prop = new MIFElement("ShapeRect");
            prop.setValue("0.0 841.889 453.543 187.65");
            textRect.addElement(prop);
            page.addElement(textRect);
            this.mifFile.addPage(page);
        }
    }

    public void endPageSequence(PageSequence pageSeq) throws FOPException {
    }

    public void startFlow(Flow fl) {
        this.textFlow = new MIFElement("TextFlow");
    }

    public void endFlow(Flow fl) {
        this.textFlow.finish(true);
        this.mifFile.addElement(this.textFlow);
        this.textFlow = null;
    }

    public void startBlock(Block bl) {
        this.para = new MIFElement("Para");
        this.textFlow.addElement(this.para);
    }

    public void endBlock(Block bl) {
        this.para.finish(true);
        this.para = null;
    }

    public void characters(char[] data, int start, int length) {
        if (this.para != null) {
            String str = new String(data, start, length);
            if ((str = str.trim()).length() == 0) {
                return;
            }
            MIFElement line = new MIFElement("ParaLine");
            MIFElement prop = new MIFElement("TextRectID");
            prop.setValue("2");
            line.addElement(prop);
            prop = new MIFElement("String");
            prop.setValue("\"" + str + "\"");
            line.addElement(prop);
            this.para.addElement(line);
        }
    }
}

