/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.fop.pdf.PDFStream;
import org.apache.fop.pdf.PDFXObject;

public class PDFFormXObject
extends PDFXObject {
    private PDFStream contents;
    private String resRef;

    public PDFFormXObject(int number, int xnumber, PDFStream cont, String ref) {
        super(number, xnumber, null);
        this.contents = cont;
        this.resRef = ref;
    }

    protected int output(OutputStream stream) throws IOException {
        int length = 0;
        String dictEntries = this.contents.applyFilters();
        String p = this.number + " " + this.generation + " obj\n";
        p = p + "<</Type /XObject\n";
        p = p + "/Subtype /Form\n";
        p = p + "/FormType 1\n";
        p = p + "/BBox [0 0 1000 1000]\n";
        p = p + "/Matrix [1 0 0 1 0 0]\n";
        p = p + "/Resources " + this.resRef + "\n";
        p = p + "/Length " + (this.contents.getDataLength() + 1) + "\n";
        p = p + dictEntries;
        p = p + ">>\n";
        byte[] pdfBytes = p.getBytes();
        stream.write(pdfBytes);
        length += pdfBytes.length;
        length += this.contents.outputStreamData(stream);
        pdfBytes = "endobj\n".getBytes();
        stream.write(pdfBytes);
        this.contents = null;
        return length += pdfBytes.length;
    }
}

