/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pcl;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;
import org.apache.fop.render.PrintRenderer;
import org.apache.fop.render.pcl.PCLStream;

public class PCLRenderer
extends PrintRenderer {
    protected PCLStream currentStream;
    private int pageHeight = 7920;
    private int curdiv = 0;
    private int divisions = -1;
    private int paperheight = -1;
    private int orientation = -1;
    private int topmargin = -1;
    private int leftmargin = -1;
    private int fullmargin = 0;
    private final boolean debug = false;
    private int xoffset = -180;
    private Hashtable options;

    public void setProducer(String producer) {
    }

    public void setFont(String name, float size) {
        int fontcode = 0;
        if (name.length() > 1 && name.charAt(0) == 'F') {
            try {
                fontcode = Integer.parseInt(name.substring(1));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        switch (fontcode) {
            case 1: {
                this.currentStream.add("\u001b(0N\u001b(s1p" + size / 1000.0f + "v0s0b16602T");
                break;
            }
            case 2: {
                this.currentStream.add("\u001b(0N\u001b(s1p" + size / 1000.0f + "v1s0b16602T");
                break;
            }
            case 3: {
                this.currentStream.add("\u001b(0N\u001b(s1p" + size / 1000.0f + "v0s3b16602T");
                break;
            }
            case 4: {
                this.currentStream.add("\u001b(0N\u001b(s1p" + size / 1000.0f + "v1s3b16602T");
                break;
            }
            case 5: {
                this.currentStream.add("\u001b(0N\u001b(s1p" + size / 1000.0f + "v0s0b16901T");
                break;
            }
            case 6: {
                this.currentStream.add("\u001b(0N\u001b(s1p" + size / 1000.0f + "v1s0b16901T");
                break;
            }
            case 7: {
                this.currentStream.add("\u001b(0N\u001b(s1p" + size / 1000.0f + "v0s3b16901T");
                break;
            }
            case 8: {
                this.currentStream.add("\u001b(0N\u001b(s1p" + size / 1000.0f + "v1s3b16901T");
                break;
            }
            case 9: {
                this.currentStream.add("\u001b(0N\u001b(s0p" + 120.01f / (size / 1000.0f) + "h0s0b4099T");
                break;
            }
            case 10: {
                this.currentStream.add("\u001b(0N\u001b(s0p" + 120.01f / (size / 1000.0f) + "h1s0b4099T");
                break;
            }
            case 11: {
                this.currentStream.add("\u001b(0N\u001b(s0p" + 120.01f / (size / 1000.0f) + "h0s3b4099T");
                break;
            }
            case 12: {
                this.currentStream.add("\u001b(0N\u001b(s0p" + 120.01f / (size / 1000.0f) + "h1s3b4099T");
                break;
            }
            case 13: {
                this.currentStream.add("\u001b(19M\u001b(s1p" + size / 1000.0f + "v0s0b16686T");
                break;
            }
            case 14: {
                this.currentStream.add("\u001b(14L\u001b(s1p" + size / 1000.0f + "v0s0b45101T");
                break;
            }
            default: {
                this.currentStream.add("\u001b(0N\u001b(s" + size / 1000.0f + "V");
            }
        }
    }

    public void startRenderer(OutputStream outputStream) throws IOException {
        this.getLogger().info("rendering areas to PCL");
        this.currentStream = new PCLStream(outputStream);
        if (this.orientation > -1) {
            this.currentStream.add("\u001b&l" + this.orientation + "O");
        } else {
            this.currentStream.add("\u001b&l0O");
        }
        this.xoffset = this.orientation == 1 || this.orientation == 3 ? -144 : -180;
        this.currentStream.add("\u001b9\u001b&l0E");
    }

    public void stopRenderer() throws IOException {
    }
}

