/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.ps;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferInt;
import java.awt.image.ImageObserver;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.io.IOException;
import java.text.AttributedCharacterIterator;
import java.util.ArrayList;
import org.apache.batik.ext.awt.g2d.AbstractGraphics2D;
import org.apache.batik.ext.awt.g2d.GraphicContext;
import org.apache.fop.layout.FontInfo;
import org.apache.fop.layout.FontState;
import org.apache.fop.render.ps.PSGenerator;

public class PSGraphics2D
extends AbstractGraphics2D {
    private boolean standalone = false;
    protected PSGenerator gen;
    protected FontState fontState;
    protected String currentFontName;
    protected int currentFontSize;
    protected int currentYPosition = 0;
    protected int currentXPosition = 0;
    protected Color currentColour = new Color(0, 0, 0);
    protected FontInfo fontInfo;
    private Graphics2D fmg;

    public PSGraphics2D(boolean textAsShapes, PSGenerator gen) {
        super(textAsShapes);
        BufferedImage bi = new BufferedImage(1, 1, 2);
        this.fmg = bi.createGraphics();
        this.gen = gen;
    }

    public PSGraphics2D(PSGraphics2D g) {
        super((AbstractGraphics2D)g);
        BufferedImage bi = new BufferedImage(1, 1, 2);
        this.fmg = bi.createGraphics();
    }

    public void setGraphicContext(GraphicContext c) {
        this.gc = c;
    }

    public Graphics create() {
        return new PSGraphics2D(this);
    }

    protected void handleIOException(IOException ioe) {
        ioe.printStackTrace();
    }

    public boolean drawImage(Image img, int x, int y, ImageObserver observer) {
        int width = img.getWidth(observer);
        int height = img.getHeight(observer);
        if (width == -1 || height == -1) {
            return false;
        }
        Dimension size = new Dimension(width, height);
        BufferedImage buf = this.buildBufferedImage(size);
        Graphics2D g = buf.createGraphics();
        g.setComposite(AlphaComposite.SrcOver);
        g.setBackground(new Color(1, 1, 1, 0));
        g.setPaint(new Color(1, 1, 1, 0));
        g.fillRect(0, 0, width, height);
        g.clip(new Rectangle(0, 0, buf.getWidth(), buf.getHeight()));
        if (!g.drawImage(img, 0, 0, observer)) {
            return false;
        }
        g.dispose();
        byte[] result = new byte[buf.getWidth() * buf.getHeight() * 3];
        Raster raster = buf.getData();
        DataBuffer bd = raster.getDataBuffer();
        int count = 0;
        switch (bd.getDataType()) {
            case 3: {
                int[][] idata = ((DataBufferInt)bd).getBankData();
                int i = 0;
                while (i < idata.length) {
                    int j = 0;
                    while (j < idata[i].length) {
                        if ((idata[i][j] >> 24 & 0xFF) != 255) {
                            result[count++] = -1;
                            result[count++] = -1;
                            result[count++] = -1;
                        } else {
                            result[count++] = (byte)(idata[i][j] >> 16 & 0xFF);
                            result[count++] = (byte)(idata[i][j] >> 8 & 0xFF);
                            result[count++] = (byte)(idata[i][j] & 0xFF);
                        }
                        ++j;
                    }
                    ++i;
                }
                break;
            }
        }
        return true;
    }

    public BufferedImage buildBufferedImage(Dimension size) {
        return new BufferedImage(size.width, size.height, 2);
    }

    public boolean drawImage(Image img, int x, int y, int width, int height, ImageObserver observer) {
        System.out.println("drawImage");
        return true;
    }

    public void dispose() {
        this.gen = null;
        this.fontState = null;
        this.currentFontName = null;
        this.currentColour = null;
        this.fontInfo = null;
    }

    public void draw(Shape s) {
        try {
            this.gen.saveGraphicsState();
            Shape imclip = this.getClip();
            this.writeClip(imclip);
            Color c = this.getColor();
            this.gen.writeln(c.getRed() + " " + c.getGreen() + " " + c.getBlue() + " setrgbcolor");
            this.applyPaint(this.getPaint(), false);
            this.applyStroke(this.getStroke());
            this.gen.writeln("newpath");
            PathIterator iter = s.getPathIterator(this.getTransform());
            while (!iter.isDone()) {
                double[] vals = new double[6];
                int type = iter.currentSegment(vals);
                switch (type) {
                    case 3: {
                        this.gen.writeln(this.gen.formatDouble(1000.0 * vals[0]) + " " + this.gen.formatDouble(1000.0 * vals[1]) + " " + this.gen.formatDouble(1000.0 * vals[2]) + " " + this.gen.formatDouble(1000.0 * vals[3]) + " " + this.gen.formatDouble(1000.0 * vals[4]) + " " + this.gen.formatDouble(1000.0 * vals[5]) + " curveto");
                        break;
                    }
                    case 1: {
                        this.gen.writeln(this.gen.formatDouble(1000.0 * vals[0]) + " " + this.gen.formatDouble(1000.0 * vals[1]) + " lineto");
                        break;
                    }
                    case 0: {
                        this.gen.writeln(this.gen.formatDouble(1000.0 * vals[0]) + " " + this.gen.formatDouble(1000.0 * vals[1]) + " M");
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 4: {
                        this.gen.writeln("closepath");
                        break;
                    }
                }
                iter.next();
            }
            this.doDrawing(false, true, false);
            this.gen.restoreGraphicsState();
        }
        catch (IOException ioe) {
            this.handleIOException(ioe);
        }
    }

    protected void writeClip(Shape s) {
        try {
            PathIterator iter = s.getPathIterator(this.getTransform());
            this.gen.writeln("newpath");
            while (!iter.isDone()) {
                double[] vals = new double[6];
                int type = iter.currentSegment(vals);
                switch (type) {
                    case 3: {
                        this.gen.writeln(this.gen.formatDouble(1000.0 * vals[0]) + " " + this.gen.formatDouble(1000.0 * vals[1]) + " " + this.gen.formatDouble(1000.0 * vals[2]) + " " + this.gen.formatDouble(1000.0 * vals[3]) + " " + this.gen.formatDouble(1000.0 * vals[4]) + " " + this.gen.formatDouble(1000.0 * vals[5]) + " curveto");
                        break;
                    }
                    case 1: {
                        this.gen.writeln(this.gen.formatDouble(1000.0 * vals[0]) + " " + this.gen.formatDouble(1000.0 * vals[1]) + " lineto");
                        break;
                    }
                    case 0: {
                        this.gen.writeln(this.gen.formatDouble(1000.0 * vals[0]) + " " + this.gen.formatDouble(1000.0 * vals[1]) + " M");
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 4: {
                        this.gen.writeln("closepath");
                        break;
                    }
                }
                iter.next();
            }
            this.gen.writeln("clippath");
        }
        catch (IOException ioe) {
            this.handleIOException(ioe);
        }
    }

    protected void applyPaint(Paint paint, boolean fill) {
        if (paint instanceof GradientPaint) {
            GradientPaint gp = (GradientPaint)paint;
            Color c1 = gp.getColor1();
            Color c2 = gp.getColor2();
            Point2D p1 = gp.getPoint1();
            Point2D p2 = gp.getPoint2();
            ArrayList<Double> theCoords = new ArrayList<Double>();
            theCoords.add(new Double(p1.getX()));
            theCoords.add(new Double(p1.getY()));
            theCoords.add(new Double(p2.getX()));
            theCoords.add(new Double(p2.getY()));
            ArrayList<Boolean> theExtend = new ArrayList<Boolean>();
            theExtend.add(new Boolean(true));
            theExtend.add(new Boolean(true));
            ArrayList<Double> theDomain = new ArrayList<Double>();
            theDomain.add(new Double(0.0));
            theDomain.add(new Double(1.0));
            ArrayList<Double> theEncode = new ArrayList<Double>();
            theEncode.add(new Double(0.0));
            theEncode.add(new Double(1.0));
            theEncode.add(new Double(0.0));
            theEncode.add(new Double(1.0));
            ArrayList<Double> theBounds = new ArrayList<Double>();
            theBounds.add(new Double(0.0));
            theBounds.add(new Double(1.0));
            ArrayList<Color> someColors = new ArrayList<Color>();
            Color color1 = new Color(c1.getRed(), c1.getGreen(), c1.getBlue());
            someColors.add(color1);
            Color color2 = new Color(c2.getRed(), c2.getGreen(), c2.getBlue());
            someColors.add(color2);
        } else if (paint instanceof TexturePaint) {
            // empty if block
        }
    }

    protected void applyStroke(Stroke stroke) {
        try {
            if (stroke instanceof BasicStroke) {
                BasicStroke bs = (BasicStroke)stroke;
                float[] da = bs.getDashArray();
                if (da != null) {
                    this.gen.writeln("[");
                    int count = 0;
                    while (count < da.length) {
                        this.gen.writeln("" + 1000 * (int)da[count]);
                        if (count < da.length - 1) {
                            this.gen.writeln(" ");
                        }
                        ++count;
                    }
                    this.gen.writeln("] ");
                    float offset = bs.getDashPhase();
                    this.gen.writeln(1000 * (int)offset + " setdash");
                }
                int ec = bs.getEndCap();
                switch (ec) {
                    case 0: {
                        this.gen.writeln("0 setlinecap");
                        break;
                    }
                    case 1: {
                        this.gen.writeln("1 setlinecap");
                        break;
                    }
                    case 2: {
                        this.gen.writeln("2 setlinecap");
                    }
                }
                int lj = bs.getLineJoin();
                switch (lj) {
                    case 0: {
                        this.gen.writeln("0 setlinejoin");
                        break;
                    }
                    case 1: {
                        this.gen.writeln("1 setlinejoin");
                        break;
                    }
                    case 2: {
                        this.gen.writeln("2 setlinejoin");
                    }
                }
                float lw = bs.getLineWidth();
                this.gen.writeln(this.gen.formatDouble(1000.0f * lw) + " setlinewidth");
                float ml = bs.getMiterLimit();
                this.gen.writeln(this.gen.formatDouble(1000.0f * ml) + " setmiterlimit");
            }
        }
        catch (IOException ioe) {
            this.handleIOException(ioe);
        }
    }

    public void drawRenderedImage(RenderedImage img, AffineTransform xform) {
        System.out.println("drawRenderedImage");
    }

    public void drawRenderableImage(RenderableImage img, AffineTransform xform) {
        System.out.println("drawRenderableImage");
    }

    public void drawString(String s, float x, float y) {
        try {
            System.out.println("drawString(String)");
            this.gen.writeln("BT");
            Shape imclip = this.getClip();
            this.writeClip(imclip);
            Color c = this.getColor();
            this.gen.writeln(c.getRed() + " " + c.getGreen() + " " + c.getBlue() + " setrgbcolor");
            AffineTransform trans = this.getTransform();
            trans.translate(x, y);
            double[] vals = new double[6];
            trans.getMatrix(vals);
            this.gen.writeln(this.gen.formatDouble(vals[0]) + " " + this.gen.formatDouble(vals[1]) + " " + this.gen.formatDouble(vals[2]) + " " + this.gen.formatDouble(vals[3]) + " " + this.gen.formatDouble(vals[4]) + " " + this.gen.formatDouble(vals[5]) + " " + this.gen.formatDouble(vals[6]) + " Tm [" + s + "]");
            this.gen.writeln("ET");
        }
        catch (IOException ioe) {
            this.handleIOException(ioe);
        }
    }

    public void drawString(AttributedCharacterIterator iterator, float x, float y) {
        try {
            System.err.println("drawString(AttributedCharacterIterator)");
            this.gen.writeln("BT");
            Shape imclip = this.getClip();
            this.writeClip(imclip);
            Color c = this.getColor();
            this.currentColour = new Color(c.getRed(), c.getGreen(), c.getBlue());
            c = this.getBackground();
            Color col = new Color(c.getRed(), c.getGreen(), c.getBlue());
            AffineTransform trans = this.getTransform();
            trans.translate(x, y);
            double[] vals = new double[6];
            trans.getMatrix(vals);
            char ch = iterator.first();
            while (ch != '\uffff') {
                this.gen.writeln(this.gen.formatDouble(vals[0]) + " " + this.gen.formatDouble(vals[1]) + " " + this.gen.formatDouble(vals[2]) + " " + this.gen.formatDouble(vals[3]) + " " + this.gen.formatDouble(vals[4]) + " " + this.gen.formatDouble(vals[5]) + " " + this.gen.formatDouble(vals[6]) + " Tm [" + ch + "]");
                ch = iterator.next();
            }
            this.gen.writeln("ET");
        }
        catch (IOException ioe) {
            this.handleIOException(ioe);
        }
    }

    public void fill(Shape s) {
        try {
            this.gen.writeln("gsave");
            Shape imclip = this.getClip();
            this.writeClip(imclip);
            Color c = this.getColor();
            this.gen.writeln(c.getRed() + " " + c.getGreen() + " " + c.getBlue() + " setrgbcolor");
            this.applyPaint(this.getPaint(), true);
            this.gen.writeln("newpath");
            PathIterator iter = s.getPathIterator(this.getTransform());
            while (!iter.isDone()) {
                double[] vals = new double[6];
                int type = iter.currentSegment(vals);
                switch (type) {
                    case 3: {
                        this.gen.writeln(this.gen.formatDouble(1000.0 * vals[0]) + " " + this.gen.formatDouble(1000.0 * vals[1]) + " " + this.gen.formatDouble(1000.0 * vals[2]) + " " + this.gen.formatDouble(1000.0 * vals[3]) + " " + this.gen.formatDouble(1000.0 * vals[4]) + " " + this.gen.formatDouble(1000.0 * vals[5]) + " curveto");
                        break;
                    }
                    case 1: {
                        this.gen.writeln(this.gen.formatDouble(1000.0 * vals[0]) + " " + this.gen.formatDouble(1000.0 * vals[1]) + " lineto");
                        break;
                    }
                    case 0: {
                        this.gen.writeln(this.gen.formatDouble(1000.0 * vals[0]) + " " + this.gen.formatDouble(1000.0 * vals[1]) + " M");
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 4: {
                        this.gen.writeln("closepath");
                        break;
                    }
                }
                iter.next();
            }
            this.doDrawing(true, false, iter.getWindingRule() == 0);
            this.gen.writeln("grestore");
        }
        catch (IOException ioe) {
            this.handleIOException(ioe);
        }
    }

    protected void doDrawing(boolean fill, boolean stroke, boolean nonzero) throws IOException {
        if (fill) {
            if (stroke) {
                if (!nonzero) {
                    this.gen.writeln("stroke");
                } else {
                    this.gen.writeln("stroke");
                }
            } else if (!nonzero) {
                this.gen.writeln("fill");
            } else {
                this.gen.writeln("fill");
            }
        } else {
            this.gen.writeln("stroke");
        }
    }

    public GraphicsConfiguration getDeviceConfiguration() {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
    }

    public FontMetrics getFontMetrics(Font f) {
        return this.fmg.getFontMetrics(f);
    }

    public void setXORMode(Color c1) {
        System.out.println("setXORMode");
    }

    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
        System.out.println("copyArea");
    }
}

