/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.tools.xslt;

import java.io.InputStream;
import java.io.Writer;
import java.util.Hashtable;
import java.util.Map;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;

public class TraxTransform {
    private static Map stylesheetCache = new Hashtable();

    public static Transformer getTransformer(String xsltFilename, boolean cache) {
        try {
            if (cache && stylesheetCache.containsKey(xsltFilename)) {
                Templates cachedStylesheet = (Templates)stylesheetCache.get(xsltFilename);
                return cachedStylesheet.newTransformer();
            }
            StreamSource xslSheet = new StreamSource(xsltFilename);
            TransformerFactory factory = TransformerFactory.newInstance();
            Templates compiledSheet = factory.newTemplates(xslSheet);
            if (cache) {
                stylesheetCache.put(xsltFilename, compiledSheet);
            }
            return compiledSheet.newTransformer();
        }
        catch (TransformerConfigurationException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static void transform(String xmlSource, String xslURL, String outputFile) {
        TraxTransform.transform(new StreamSource(xmlSource), new StreamSource(xslURL), new StreamResult(outputFile));
    }

    public static void transform(Document xmlSource, String xslURL, String outputFile) {
        TraxTransform.transform(new DOMSource(xmlSource), new StreamSource(xslURL), new StreamResult(outputFile));
    }

    public static void transform(String xmlSource, String xslURL, Writer output) {
        TraxTransform.transform(new StreamSource(xmlSource), new StreamSource(xslURL), new StreamResult(output));
    }

    public static void transform(Document xmlSource, InputStream xsl, Document outputDoc) {
        TraxTransform.transform(new DOMSource(xmlSource), new StreamSource(xsl), new DOMResult(outputDoc));
    }

    public static void transform(Source xmlSource, Source xslSource, Result result) {
        try {
            Transformer transformer;
            if (xslSource.getSystemId() == null) {
                TransformerFactory factory = TransformerFactory.newInstance();
                transformer = factory.newTransformer(xslSource);
            } else {
                transformer = TraxTransform.getTransformer(xslSource.getSystemId(), true);
            }
            transformer.transform(xmlSource, result);
        }
        catch (TransformerConfigurationException ex) {
            ex.printStackTrace();
        }
        catch (TransformerException ex) {
            ex.printStackTrace();
        }
    }
}

