/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.traits;

import org.apache.fop.datatypes.Space;
import org.apache.fop.fo.Property;
import org.apache.fop.layoutmgr.MinOptMax;

public class SpaceVal {
    private final MinOptMax space;
    private final boolean bConditional;
    private final boolean bForcing;
    private final int iPrecedence;

    public SpaceVal(Space spaceprop) {
        this.space = new MinOptMax(spaceprop.getMinimum().getLength().getValue(), spaceprop.getOptimum().getLength().getValue(), spaceprop.getMaximum().getLength().getValue());
        this.bConditional = spaceprop.getConditionality().getEnum() == 18;
        Property precProp = spaceprop.getPrecedence();
        if (precProp.getNumber() != null) {
            this.iPrecedence = precProp.getNumber().intValue();
            this.bForcing = false;
        } else {
            this.bForcing = precProp.getEnum() == 33;
            this.iPrecedence = 0;
        }
    }

    public SpaceVal(MinOptMax space, boolean bConditional, boolean bForcing, int iPrecedence) {
        this.space = space;
        this.bConditional = bConditional;
        this.bForcing = bForcing;
        this.iPrecedence = iPrecedence;
    }

    public boolean isConditional() {
        return this.bConditional;
    }

    public boolean isForcing() {
        return this.bForcing;
    }

    public int getPrecedence() {
        return this.iPrecedence;
    }

    public MinOptMax getSpace() {
        return this.space;
    }
}

