/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.orb.rmi.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class NativeLibraryTest {
    private static final String NATIVE_CLZ = "org.openorb.orb.rmi.DeserializationKernelNative";
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$org$openorb$orb$rmi$util$SetMethodTest;
    static /* synthetic */ Class class$org$openorb$orb$rmi$util$NativeLibraryTest;

    private static boolean loadNativeLibrary(String libMgrClzName) {
        boolean bSuccess = false;
        String methName = "load";
        try {
            System.out.println("Loading native library via manager '" + libMgrClzName + "'...( java.library.path=" + System.getProperty("java.library.path") + " )");
            Class<?> libmgrClz = Class.forName(libMgrClzName);
            Method method = libmgrClz.getDeclaredMethod("load", new Class[0]);
            bSuccess = (Boolean)method.invoke(null, null);
        }
        catch (ClassNotFoundException ex) {
            throw new Error("Couldn't find class '" + libMgrClzName + "'");
        }
        catch (NoSuchMethodException ex) {
            throw new Error("Couldn't find method 'load' in '" + libMgrClzName + "'");
        }
        catch (IllegalAccessException ex) {
            throw new Error("Access not allowed for method 'load' in '" + libMgrClzName + "'");
        }
        catch (InvocationTargetException ex) {
            throw new Error("Exception while calling method 'load' in '" + libMgrClzName + "'");
        }
        catch (Throwable th) {
            throw new Error("An unexpected error occured: " + th);
        }
        return bSuccess;
    }

    public static boolean checkAllocateNewObject() {
        boolean result = false;
        try {
            String IBM_CLZ_NAME;
            String IBM_ALLOC_CLZ_NAME;
            System.out.println("Checking whether the VM methods are accessible... (java.library.path=" + System.getProperty("java.library.path") + ")");
            Class<?> clz = null;
            String SUN_ALLOC_CLZ_NAME = "com.sun.corba.se.internal.io.IIOPInputStream";
            try {
                System.out.println("Checking for Sun VM...");
                clz = Class.forName("com.sun.corba.se.internal.io.IIOPInputStream");
                System.out.println("Found a Sun VM!");
                NativeLibraryTest.loadNativeLibrary("com.sun.corba.se.internal.io.LibraryManager");
            }
            catch (ClassNotFoundException ex) {
                System.out.println("Couldn't find class 'com.sun.corba.se.internal.io.IIOPInputStream'. No Sun VM!");
            }
            if (clz == null) {
                IBM_ALLOC_CLZ_NAME = "java.io.ObjectInputStream";
                IBM_CLZ_NAME = "com.ibm.rmi.io.JNIReflectField";
                try {
                    System.out.println("Checking for IBM 1.3.x VM...");
                    Class.forName("com.ibm.rmi.io.JNIReflectField");
                    clz = Class.forName("java.io.ObjectInputStream");
                    System.out.println("Found an IBM 1.3.x VM!");
                    NativeLibraryTest.loadNativeLibrary("com.ibm.rmi.io.LibraryManager");
                }
                catch (ClassNotFoundException ex) {
                    System.out.println("Couldn't find class 'com.ibm.rmi.io.JNIReflectField'. No IBM 1.3.x VM!");
                }
            }
            if (clz == null) {
                IBM_ALLOC_CLZ_NAME = "java.io.ObjectStreamClass";
                IBM_CLZ_NAME = "com.ibm.rmi.io.PureReflectField";
                try {
                    System.out.println("Checking for IBM 1.4.x VM...");
                    Class.forName("com.ibm.rmi.io.PureReflectField");
                    clz = Class.forName("java.io.ObjectStreamClass");
                    System.out.println("Found an IBM 1.4.x VM!");
                }
                catch (ClassNotFoundException ex) {
                    System.out.println("Couldn't find class 'com.ibm.rmi.io.PureReflectField'. No IBM 1.4.x VM!");
                }
            }
            Method method = null;
            String METHOD_NAME = "allocateNewObject";
            try {
                System.out.println("Trying to access method 'allocateNewObject'...");
                method = clz.getDeclaredMethod("allocateNewObject", class$java$lang$Class == null ? (class$java$lang$Class = NativeLibraryTest.class$("java.lang.Class")) : class$java$lang$Class, class$java$lang$Class == null ? (class$java$lang$Class = NativeLibraryTest.class$("java.lang.Class")) : class$java$lang$Class);
                method.setAccessible(true);
                System.out.println("Got access to method 'allocateNewObject'!");
            }
            catch (NoSuchMethodException ex) {
                System.out.println("Couldn't find method 'allocateNewObject'!");
            }
            if (method != null) {
                try {
                    System.out.println("Trying to invoke method 'allocateNewObject'...");
                    result = method.invoke(null, class$java$lang$String == null ? (class$java$lang$String = NativeLibraryTest.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = NativeLibraryTest.class$("java.lang.String")) : class$java$lang$String) != null;
                    System.out.println("Successfully invoked method 'allocateNewObject'! (created object is " + (result ? "not null" : "null") + ")");
                }
                catch (InvocationTargetException ex) {
                    System.out.println("An error occured while invoking method 'allocateNewObject'! (" + ex + ")");
                }
                catch (UnsatisfiedLinkError ule) {
                    System.out.println("The library that provides the method 'allocateNewObject' could no be loaded! (" + ule + ")");
                }
            }
        }
        catch (Throwable th) {
            th.printStackTrace();
        }
        if (!result) {
            System.out.println("\n\nIf you do not get a success message above it is most likely that you will need the openorb native library!");
        }
        return result;
    }

    private static boolean invokeMethod(Object dknObj, Object obj, String memberName, Object val) {
        boolean result = false;
        try {
            String methodName = "setObjectField";
            Method m = null;
            if (val instanceof Boolean) {
                methodName = "setBooleanField";
                m = dknObj.getClass().getDeclaredMethod(methodName, class$java$lang$Class == null ? (class$java$lang$Class = NativeLibraryTest.class$("java.lang.Class")) : class$java$lang$Class, class$java$lang$String == null ? (class$java$lang$String = NativeLibraryTest.class$("java.lang.String")) : class$java$lang$String, class$java$lang$Object == null ? (class$java$lang$Object = NativeLibraryTest.class$("java.lang.Object")) : class$java$lang$Object, Boolean.TYPE);
            } else if (val instanceof Byte) {
                methodName = "setByteField";
                m = dknObj.getClass().getDeclaredMethod(methodName, class$java$lang$Class == null ? (class$java$lang$Class = NativeLibraryTest.class$("java.lang.Class")) : class$java$lang$Class, class$java$lang$String == null ? (class$java$lang$String = NativeLibraryTest.class$("java.lang.String")) : class$java$lang$String, class$java$lang$Object == null ? (class$java$lang$Object = NativeLibraryTest.class$("java.lang.Object")) : class$java$lang$Object, Byte.TYPE);
            } else if (val instanceof Character) {
                methodName = "setCharField";
                m = dknObj.getClass().getDeclaredMethod(methodName, class$java$lang$Class == null ? (class$java$lang$Class = NativeLibraryTest.class$("java.lang.Class")) : class$java$lang$Class, class$java$lang$String == null ? (class$java$lang$String = NativeLibraryTest.class$("java.lang.String")) : class$java$lang$String, class$java$lang$Object == null ? (class$java$lang$Object = NativeLibraryTest.class$("java.lang.Object")) : class$java$lang$Object, Character.TYPE);
            } else if (val instanceof Short) {
                methodName = "setShortField";
                m = dknObj.getClass().getDeclaredMethod(methodName, class$java$lang$Class == null ? (class$java$lang$Class = NativeLibraryTest.class$("java.lang.Class")) : class$java$lang$Class, class$java$lang$String == null ? (class$java$lang$String = NativeLibraryTest.class$("java.lang.String")) : class$java$lang$String, class$java$lang$Object == null ? (class$java$lang$Object = NativeLibraryTest.class$("java.lang.Object")) : class$java$lang$Object, Short.TYPE);
            } else if (val instanceof Integer) {
                methodName = "setIntField";
                m = dknObj.getClass().getDeclaredMethod(methodName, class$java$lang$Class == null ? (class$java$lang$Class = NativeLibraryTest.class$("java.lang.Class")) : class$java$lang$Class, class$java$lang$String == null ? (class$java$lang$String = NativeLibraryTest.class$("java.lang.String")) : class$java$lang$String, class$java$lang$Object == null ? (class$java$lang$Object = NativeLibraryTest.class$("java.lang.Object")) : class$java$lang$Object, Integer.TYPE);
            } else if (val instanceof Long) {
                methodName = "setLongField";
                m = dknObj.getClass().getDeclaredMethod(methodName, class$java$lang$Class == null ? (class$java$lang$Class = NativeLibraryTest.class$("java.lang.Class")) : class$java$lang$Class, class$java$lang$String == null ? (class$java$lang$String = NativeLibraryTest.class$("java.lang.String")) : class$java$lang$String, class$java$lang$Object == null ? (class$java$lang$Object = NativeLibraryTest.class$("java.lang.Object")) : class$java$lang$Object, Long.TYPE);
            } else if (val instanceof Float) {
                methodName = "setFloatField";
                m = dknObj.getClass().getDeclaredMethod(methodName, class$java$lang$Class == null ? (class$java$lang$Class = NativeLibraryTest.class$("java.lang.Class")) : class$java$lang$Class, class$java$lang$String == null ? (class$java$lang$String = NativeLibraryTest.class$("java.lang.String")) : class$java$lang$String, class$java$lang$Object == null ? (class$java$lang$Object = NativeLibraryTest.class$("java.lang.Object")) : class$java$lang$Object, Float.TYPE);
            } else if (val instanceof Double) {
                methodName = "setDoubleField";
                m = dknObj.getClass().getDeclaredMethod(methodName, class$java$lang$Class == null ? (class$java$lang$Class = NativeLibraryTest.class$("java.lang.Class")) : class$java$lang$Class, class$java$lang$String == null ? (class$java$lang$String = NativeLibraryTest.class$("java.lang.String")) : class$java$lang$String, class$java$lang$Object == null ? (class$java$lang$Object = NativeLibraryTest.class$("java.lang.Object")) : class$java$lang$Object, Double.TYPE);
            } else {
                m = dknObj.getClass().getDeclaredMethod(methodName, class$java$lang$Class == null ? (class$java$lang$Class = NativeLibraryTest.class$("java.lang.Class")) : class$java$lang$Class, class$java$lang$String == null ? (class$java$lang$String = NativeLibraryTest.class$("java.lang.String")) : class$java$lang$String, class$java$lang$Object == null ? (class$java$lang$Object = NativeLibraryTest.class$("java.lang.Object")) : class$java$lang$Object, class$java$lang$Object == null ? (class$java$lang$Object = NativeLibraryTest.class$("java.lang.Object")) : class$java$lang$Object);
            }
            System.out.print("#### Invoking method '" + methodName + "'...");
            m.invoke(dknObj, obj.getClass(), memberName, obj, val);
            System.out.println(" ... done!");
            result = true;
        }
        catch (Throwable th) {
            System.out.println("### An unexpected error occured: ");
            th.printStackTrace();
        }
        return result;
    }

    public static boolean testNativeLibrary() {
        boolean result = false;
        Object obj = null;
        try {
            System.out.println("Testing the native library... (java.library.path=" + System.getProperty("java.library.path") + ")");
            System.out.println("# 1. Loading class 'org.openorb.orb.rmi.DeserializationKernelNative'...");
            Class<?> clz = Class.forName(NATIVE_CLZ);
            System.out.println("# 2. Creating instance of class 'org.openorb.orb.rmi.DeserializationKernelNative'...");
            Object dkn = clz.newInstance();
            String METHOD_NAME = "allocateNewObject";
            System.out.println("# 3. Getting method '" + METHOD_NAME + "' from class '" + NATIVE_CLZ + "'...");
            Method method = clz.getDeclaredMethod(METHOD_NAME, class$java$lang$Class == null ? (class$java$lang$Class = NativeLibraryTest.class$("java.lang.Class")) : class$java$lang$Class, class$java$lang$Class == null ? (class$java$lang$Class = NativeLibraryTest.class$("java.lang.Class")) : class$java$lang$Class);
            System.out.println("# 4. Invoking method '" + METHOD_NAME + "' from class '" + NATIVE_CLZ + "'...");
            obj = method.invoke(dkn, class$org$openorb$orb$rmi$util$SetMethodTest == null ? (class$org$openorb$orb$rmi$util$SetMethodTest = NativeLibraryTest.class$("org.openorb.orb.rmi.util.SetMethodTest")) : class$org$openorb$orb$rmi$util$SetMethodTest, class$org$openorb$orb$rmi$util$SetMethodTest == null ? (class$org$openorb$orb$rmi$util$SetMethodTest = NativeLibraryTest.class$("org.openorb.orb.rmi.util.SetMethodTest")) : class$org$openorb$orb$rmi$util$SetMethodTest);
            System.out.println("# 5. Successfully invoked method '" + METHOD_NAME + "' from class '" + NATIVE_CLZ + "'!");
            System.out.println("\n Instance of SetMethodTest class (just created):\n" + obj + "\n");
            NativeLibraryTest.invokeMethod(dkn, obj, "m_o", new String("Hello world!"));
            NativeLibraryTest.invokeMethod(dkn, obj, "m_v", Boolean.TRUE);
            NativeLibraryTest.invokeMethod(dkn, obj, "m_b", new Byte(125));
            NativeLibraryTest.invokeMethod(dkn, obj, "m_c", new Character('c'));
            NativeLibraryTest.invokeMethod(dkn, obj, "m_s", new Short(-25536));
            NativeLibraryTest.invokeMethod(dkn, obj, "m_i", new Integer(100000));
            NativeLibraryTest.invokeMethod(dkn, obj, "m_j", new Long(100000000000L));
            NativeLibraryTest.invokeMethod(dkn, obj, "m_f", new Float(5.2f));
            NativeLibraryTest.invokeMethod(dkn, obj, "m_d", new Double(10.2));
            System.out.println("\n Instance of SetMethodTest class (members set):\n" + obj + "\n");
        }
        catch (Throwable th) {
            System.out.println("### An unexpected error occured: " + th);
            th.printStackTrace();
            return false;
        }
        return result;
    }

    public static void main(String[] args) {
        int ret_code;
        if (args.length != 1) {
            System.out.println("Usage: " + (class$org$openorb$orb$rmi$util$NativeLibraryTest == null ? (class$org$openorb$orb$rmi$util$NativeLibraryTest = NativeLibraryTest.class$("org.openorb.orb.rmi.util.NativeLibraryTest")) : class$org$openorb$orb$rmi$util$NativeLibraryTest).getName() + " <check|test|dumparch>");
            ret_code = 2;
        } else if (args[0].equalsIgnoreCase("check")) {
            System.out.println("Checking whether a library is necessary or not...");
            ret_code = NativeLibraryTest.checkAllocateNewObject() ? 0 : 1;
        } else if (args[0].equalsIgnoreCase("test")) {
            ret_code = NativeLibraryTest.testNativeLibrary() ? 0 : 1;
        } else if (args[0].equalsIgnoreCase("dumparch")) {
            String arch = System.getProperty("os.arch");
            System.out.println(arch);
            ret_code = 0;
        } else {
            ret_code = 3;
        }
        System.exit(ret_code);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

