/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;

public class DiffFileOutputStream
extends OutputStream {
    private File m_file;
    private RandomAccessFile m_io;
    private boolean m_wt = false;
    private int m_pos = 0;
    private static final int RB_SIZE = 1024;
    private byte[] m_rb = new byte[1024];
    private int m_rbIdx = 0;
    private int m_rbLen = 0;

    public DiffFileOutputStream(File file) throws FileNotFoundException {
        if (!file.exists()) {
            this.m_io = new RandomAccessFile(file, "rw");
            this.m_wt = true;
            return;
        }
        if (!file.canWrite()) {
            throw new FileNotFoundException("Cannot write to file '" + file + "'");
        }
        this.m_file = file;
        this.m_io = new RandomAccessFile(file, "r");
    }

    public DiffFileOutputStream(String filename) throws FileNotFoundException {
        this(new File(filename));
    }

    public static boolean copyFileNoClobber(File src, File dest) throws IOException {
        FileInputStream is = new FileInputStream(src);
        DiffFileOutputStream os = new DiffFileOutputStream(dest);
        byte[] buf = new byte[1024];
        int len = 0;
        while ((len = ((InputStream)is).read(buf)) > 0) {
            os.write(buf, 0, len);
        }
        ((InputStream)is).close();
        os.close();
        return os.isWriting();
    }

    public static boolean copyFileNoClobber(String src, String dest) throws IOException {
        return DiffFileOutputStream.copyFileNoClobber(new File(src), new File(dest));
    }

    public boolean isWriting() {
        return this.m_wt;
    }

    public void write(int b) throws IOException {
        if (this.checkReadahead(1L)) {
            this.m_io.write(b);
            ++this.m_pos;
            return;
        }
        if (this.m_rb[this.m_rbIdx] == (byte)(b & 0xFF)) {
            ++this.m_rbIdx;
            ++this.m_pos;
            return;
        }
        this.openForWrite();
        this.m_io.write(b);
        ++this.m_pos;
    }

    /*
     * Unable to fully structure code
     */
    public void write(byte[] b, int off, int len) throws IOException {
        if (off >= 0 && len >= 0 && b.length >= off + len) ** GOTO lbl17
        throw new IllegalArgumentException();
lbl-1000:
        // 1 sources

        {
            if (!this.checkReadahead(len)) ** GOTO lbl16
            this.m_io.write(b, off, len);
            this.m_pos += len;
            return;
lbl-1000:
            // 1 sources

            {
                if (b[off] != this.m_rb[this.m_rbIdx]) {
                    this.openForWrite();
                    this.m_io.write(b, off, len);
                    this.m_pos += len;
                    return;
                }
                ++this.m_rbIdx;
                ++this.m_pos;
                ++off;
                --len;
lbl16:
                // 2 sources

                ** while (this.m_rbIdx < this.m_rbLen && len > 0)
            }
lbl17:
            // 2 sources

            ** while (len > 0)
        }
lbl18:
        // 1 sources

    }

    public void close() throws IOException {
        if (this.m_io.length() > (long)this.m_pos) {
            if (!this.m_wt) {
                this.openForWrite();
            }
            this.m_io.setLength(this.m_pos);
        }
        this.m_io.close();
    }

    private boolean checkReadahead(long size) throws IOException {
        if (this.m_wt) {
            return true;
        }
        if (this.m_rbLen - this.m_rbIdx > 0) {
            return false;
        }
        if (this.m_io.length() < (long)this.m_pos + size) {
            this.openForWrite();
            return true;
        }
        this.m_rbIdx = 0;
        this.m_rbLen = this.m_io.read(this.m_rb);
        return false;
    }

    private void openForWrite() throws IOException {
        this.m_io.close();
        this.m_io = new RandomAccessFile(this.m_file, "rw");
        this.m_io.seek(this.m_pos);
        this.m_wt = true;
    }

    public static void main(String[] args) throws IOException {
        if (args.length != 2) {
            System.out.println("usage: java org.openorb.util.DiffFileOutputStream <source> <destination>");
            System.out.println("Copies the file, if the files are the same the destination is not touched");
            return;
        }
        DiffFileOutputStream.copyFileNoClobber(args[0], args[1]);
    }
}

