/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.util;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectStreamClass;
import java.io.ObjectStreamField;
import java.io.OutputStream;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Comparator;
import org.openorb.util.ReflectionUtils;

public final class RepoIDHelper {
    private static OutputStream s_dummy_output_stream = new DummyOutputStream();
    private static Comparator s_field_lex_comparator = new Comparator(){

        public int compare(Object obj1, Object obj2) {
            if (obj1 == obj2) {
                return 0;
            }
            String fld1 = ((ObjectStreamField)obj1).getName();
            String fld2 = ((ObjectStreamField)obj2).getName();
            return fld1.compareTo(fld2);
        }
    };
    public static final int TYPE_PLAIN = 0;
    public static final int TYPE_STUB = 1;
    public static final int TYPE_HELPER = 2;
    public static final int TYPE_HOLDER = 3;
    public static final int TYPE_DEFAULT_FACTORY = 4;
    public static final int TYPE_OPERATIONS = 255;
    public static final int TYPE_IMPLBASE = 256;
    public static final int TYPE_POA = 257;
    public static final int TYPE_POATIE = 258;
    public static final int TYPE_TIE = 259;
    static /* synthetic */ Class class$java$io$Serializable;
    static /* synthetic */ Class class$java$rmi$Remote;
    static /* synthetic */ Class class$java$io$Externalizable;

    private RepoIDHelper() {
    }

    public static String decorate(String name, int type) {
        StringBuffer ret = new StringBuffer();
        switch (type) {
            case 1: 
            case 256: {
                ret.append('_');
                break;
            }
        }
        ret.append(name);
        switch (type) {
            case 0: {
                break;
            }
            case 1: {
                ret.append("Stub");
                break;
            }
            case 2: {
                ret.append("Helper");
                break;
            }
            case 3: {
                ret.append("Holder");
                break;
            }
            case 4: {
                ret.append("DefaultFactory");
                break;
            }
            case 255: {
                ret.append("Operations");
                break;
            }
            case 256: {
                ret.append("ImplBase");
                break;
            }
            case 257: {
                ret.append("POA");
                break;
            }
            case 258: {
                ret.append("POATie");
                break;
            }
            case 259: {
                ret.append("Tie");
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return ret.toString();
    }

    /*
     * Unable to fully structure code
     */
    public static boolean checkID(String id) {
        block8: {
            block10: {
                block9: {
                    if (!id.startsWith("IDL:")) break block8;
                    dot = id.indexOf(46);
                    lcl = id.lastIndexOf(58);
                    fsla = id.indexOf(47);
                    lsla = id.lastIndexOf(47, lcl);
                    if (dot >= lcl) break block9;
                    prev = fsla;
                    while ((dot = id.lastIndexOf(46, prev)) >= 0) {
                        if (!RepoIDHelper.checkIdentifier(id.substring(dot + 1, prev))) {
                            return false;
                        }
                        prev = dot - 1;
                    }
                    if (RepoIDHelper.checkIdentifier(id.substring(4, prev + 1))) ** GOTO lbl19
                    return false;
lbl-1000:
                    // 1 sources

                    {
                        nsla = id.indexOf(47, fsla + 1);
                        if (!RepoIDHelper.checkIdentifier(id.substring(fsla + 1, nsla))) {
                            return false;
                        }
                        fsla = nsla;
lbl19:
                        // 2 sources

                        ** while (fsla != lsla)
                    }
lbl20:
                    // 1 sources

                    break block10;
                }
                if (lsla >= 0) {
                    fsla = 3;
                    while (fsla != lsla) {
                        nsla = id.indexOf(47, fsla + 1);
                        if (!RepoIDHelper.checkIdentifier(id.substring(fsla + 1, nsla))) {
                            return false;
                        }
                        fsla = nsla;
                    }
                } else {
                    lsla = 3;
                }
            }
            return RepoIDHelper.checkIdentifier(id.substring(lsla + 1, lcl)) != false;
        }
        return id.indexOf(58) > 0;
    }

    public static boolean checkIdentifier(String name) {
        if (name.length() == 0) {
            return false;
        }
        char c = name.charAt(0);
        if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z')) {
            return false;
        }
        int i = 1;
        while (i < name.length()) {
            c = name.charAt(i);
            if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '0' || c >= '1' && c <= '9' || c == '_')) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static String idToPackage(String name) {
        if (name.startsWith("IDL:")) {
            StringBuffer ret = new StringBuffer();
            int dot = name.indexOf(46);
            int lcl = name.lastIndexOf(58);
            int fsla = name.indexOf(47);
            int lsla = name.lastIndexOf(47, lcl);
            if (dot < lcl) {
                int prev = fsla;
                while ((dot = name.lastIndexOf(46, prev)) >= 0) {
                    ret.append(name.substring(dot + 1, prev)).append('.');
                    prev = dot - 1;
                }
                ret.append(name.substring(4, prev + 1));
                if (fsla != lsla) {
                    ret.append('.').append(name.substring(fsla + 1, lsla).replace('/', '.'));
                }
            } else if (lsla >= 0) {
                ret.append(name.substring(4, lsla).replace('/', '.'));
            }
            return ret.toString();
        }
        if (name.startsWith("RMI:")) {
            throw new IllegalArgumentException();
        }
        throw new IllegalArgumentException();
    }

    public static String idToClassname(String name) {
        if (name.startsWith("IDL:")) {
            int end = name.lastIndexOf(58);
            int beg = name.lastIndexOf(47, end);
            if (beg == -1) {
                beg = 3;
            }
            return name.substring(beg + 1, end);
        }
        if (name.startsWith("RMI:")) {
            throw new IllegalArgumentException();
        }
        throw new IllegalArgumentException();
    }

    public static String idToClass(String name) {
        return RepoIDHelper.idToClass(name, 0);
    }

    public static String idToClass(String name, int type) {
        if (name.startsWith("IDL:")) {
            StringBuffer ret = new StringBuffer();
            int dot = name.indexOf(46);
            int lcl = name.lastIndexOf(58);
            int fsla = name.indexOf(47);
            int lsla = name.lastIndexOf(47, lcl);
            if (dot < lcl) {
                int prev = fsla - 1;
                while ((dot = name.lastIndexOf(46, prev)) >= 0) {
                    ret.append(name.substring(dot + 1, prev + 1)).append('.');
                    prev = dot - 1;
                }
                ret.append(name.substring(4, prev + 1)).append('.');
                if (fsla != lsla) {
                    ret.append(name.substring(fsla + 1, lsla).replace('/', '.')).append('.');
                }
            } else if (lsla >= 0) {
                ret.append(name.substring(4, lsla).replace('/', '.')).append('.');
            } else {
                lsla = 3;
            }
            ret.append(RepoIDHelper.decorate(name.substring(lsla + 1, lcl), type));
            return ret.toString();
        }
        if (name.startsWith("RMI:")) {
            throw new IllegalArgumentException();
        }
        throw new IllegalArgumentException();
    }

    public static Object createIsATest(String id) {
        try {
            if (id.startsWith("IDL:")) {
                return new IsA(id);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return id;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String[] mangleClassName(Class clz) {
        if (clz.isArray()) {
            String[] names = new String[]{clz.getName(), null};
            int l = 1;
            Class<?> base = clz.getComponentType();
            while (base.isArray()) {
                base = base.getComponentType();
                ++l;
            }
            if (base.isPrimitive()) {
                if (base.equals(Boolean.TYPE)) {
                    names[1] = "seq" + l + "_boolean";
                    return names;
                } else if (base.equals(Byte.TYPE)) {
                    names[1] = "seq" + l + "_octet";
                    return names;
                } else if (base.equals(Short.TYPE)) {
                    names[1] = "seq" + l + "_short";
                    return names;
                } else if (base.equals(Integer.TYPE)) {
                    names[1] = "seq" + l + "_long";
                    return names;
                } else if (base.equals(Long.TYPE)) {
                    names[1] = "seq" + l + "_long_long";
                    return names;
                } else if (base.equals(Float.TYPE)) {
                    names[1] = "seq" + l + "_float";
                    return names;
                } else if (base.equals(Double.TYPE)) {
                    names[1] = "seq" + l + "_double";
                    return names;
                } else {
                    if (!base.equals(Character.TYPE)) throw new Error("Invalid primitive type");
                    names[1] = "seq" + l + "_wchar";
                }
                return names;
            } else {
                String[] cnames = RepoIDHelper.extractClassName(base);
                names[1] = "seq" + l + "_" + cnames[1];
            }
            return names;
        }
        String[] cnames = RepoIDHelper.extractClassName(clz);
        if (cnames[0].length() != 0) return new String[]{cnames[0] + '.' + cnames[1], cnames[1]};
        return new String[]{cnames[1], cnames[1]};
    }

    public static String unmangleClassName(String className) {
        return className;
    }

    public static String[] extractClassName(Class clz) {
        String[] ret;
        if (clz.isArray() || clz.isPrimitive()) {
            throw new IllegalArgumentException("Class is primitive or array type");
        }
        Package pkg = clz.getPackage();
        if (pkg != null) {
            ret = new String[]{pkg.getName(), null};
            ret[1] = clz.getName().substring(ret[0].length() + 1);
        } else {
            String clzName = clz.getName();
            if (clzName != null && clzName.lastIndexOf(46) != -1) {
                ret = new String[]{null, null};
                ret[0] = clzName.substring(0, clzName.lastIndexOf(46));
                ret[1] = clzName.substring(ret[0].length() + 1);
            } else {
                ret = new String[]{"", clzName};
            }
        }
        return ret;
    }

    public static void mangleMemberNames(Class clz, String[] memberNames) {
        String[] cln = RepoIDHelper.extractClassName(clz);
        int i = 0;
        while (i < memberNames.length) {
            if (memberNames[i].startsWith("_")) {
                memberNames[i] = "J" + memberNames[i];
            }
            if (memberNames[i].equals(cln[1])) {
                memberNames[i] = memberNames[i] + "_";
            }
            ++i;
        }
    }

    public static String unmangleRepoIDtoClassName(String repoID) {
        if (!repoID.startsWith("RMI:")) {
            return null;
        }
        int idx = repoID.indexOf(58, 5);
        if (idx < 0) {
            return null;
        }
        return RepoIDHelper.unmangleClassName(repoID.substring(4, idx));
    }

    public static String getRepoID(Class clz) {
        String result = null;
        if (clz != null) {
            String[] names = RepoIDHelper.mangleClassName(clz);
            if (clz.isArray()) {
                Class<?> cmpt = clz.getComponentType();
                result = "RMI:" + names[0] + ":";
                if (ReflectionUtils.isAssignableFrom("org.omg.CORBA.portable.ValueBase", cmpt)) {
                    long repo_id_hash = RepoIDHelper.calculateStructuralHash(cmpt);
                    String hash = Long.toHexString(repo_id_hash).toUpperCase();
                    result = result + "0000000000000000".substring(hash.length()) + hash;
                    ObjectStreamClass wubble = ObjectStreamClass.lookup(cmpt);
                    hash = Long.toHexString(wubble.getSerialVersionUID()).toUpperCase();
                    result = result + ":" + "0000000000000000".substring(hash.length()) + hash;
                } else if (!(!(class$java$io$Serializable == null ? (class$java$io$Serializable = RepoIDHelper.class$("java.io.Serializable")) : class$java$io$Serializable).isAssignableFrom(cmpt) || (class$java$rmi$Remote == null ? (class$java$rmi$Remote = RepoIDHelper.class$("java.rmi.Remote")) : class$java$rmi$Remote).isAssignableFrom(cmpt) || ReflectionUtils.isAssignableFrom("org.omg.CORBA.Object", cmpt) || ReflectionUtils.isAssignableFrom("org.omg.CORBA.portable.IDLEntity", cmpt) && cmpt.isInterface())) {
                    String repo_id = RepoIDHelper.getRepoID(cmpt);
                    result = result + repo_id.substring(repo_id.indexOf(58, 5) + 1);
                } else {
                    result = result + "0000000000000000";
                }
            } else if (!(class$java$io$Serializable == null ? (class$java$io$Serializable = RepoIDHelper.class$("java.io.Serializable")) : class$java$io$Serializable).isAssignableFrom(clz) || ReflectionUtils.isAssignableFrom("org.omg.CORBA.Object", clz) || ReflectionUtils.isAssignableFrom("org.omg.CORBA.portable.ValueBase", clz) || (class$java$rmi$Remote == null ? (class$java$rmi$Remote = RepoIDHelper.class$("java.rmi.Remote")) : class$java$rmi$Remote).isAssignableFrom(clz)) {
                result = "RMI:" + names[0] + ":0000000000000000";
            } else {
                String hash = Long.toHexString(RepoIDHelper.getRepoIDHash(clz)).toUpperCase();
                hash = "0000000000000000".substring(hash.length()) + hash;
                result = "RMI:" + names[0] + ":" + hash;
                if (!(class$java$io$Externalizable == null ? (class$java$io$Externalizable = RepoIDHelper.class$("java.io.Externalizable")) : class$java$io$Externalizable).isAssignableFrom(clz)) {
                    ObjectStreamClass wubble = ObjectStreamClass.lookup(clz);
                    if (wubble != null) {
                        hash = Long.toHexString(wubble.getSerialVersionUID()).toUpperCase();
                        result = result + ":" + "0000000000000000".substring(hash.length()) + hash;
                    } else {
                        result = "RMI:" + names[0] + ":0000000000000000";
                    }
                }
            }
            result = result.intern();
        } else {
            Thread.dumpStack();
        }
        return result;
    }

    public static long getRepoIDHash(Class clz) {
        long result = 0L;
        if (clz != null) {
            if (clz.isArray()) {
                Class<?> cmpt = clz.getComponentType();
                if (ReflectionUtils.isAssignableFrom("org.omg.CORBA.portable.ValueBase", cmpt)) {
                    result = RepoIDHelper.calculateStructuralHash(cmpt);
                } else if (!(!(class$java$io$Serializable == null ? (class$java$io$Serializable = RepoIDHelper.class$("java.io.Serializable")) : class$java$io$Serializable).isAssignableFrom(cmpt) || (class$java$rmi$Remote == null ? (class$java$rmi$Remote = RepoIDHelper.class$("java.rmi.Remote")) : class$java$rmi$Remote).isAssignableFrom(cmpt) || ReflectionUtils.isAssignableFrom("org.omg.CORBA.Object", cmpt) || ReflectionUtils.isAssignableFrom("org.omg.CORBA.portable.IDLEntity", cmpt) && cmpt.isInterface())) {
                    result = RepoIDHelper.getRepoIDHash(cmpt);
                }
            } else if ((class$java$io$Serializable == null ? (class$java$io$Serializable = RepoIDHelper.class$("java.io.Serializable")) : class$java$io$Serializable).isAssignableFrom(clz) && !ReflectionUtils.isAssignableFrom("org.omg.CORBA.Object", clz) && !ReflectionUtils.isAssignableFrom("org.omg.CORBA.portable.ValueBase", clz) && !(class$java$rmi$Remote == null ? (class$java$rmi$Remote = RepoIDHelper.class$("java.rmi.Remote")) : class$java$rmi$Remote).isAssignableFrom(clz)) {
                result = RepoIDHelper.calculateStructuralHash(clz);
            }
        } else {
            Thread.dumpStack();
        }
        return result;
    }

    private static boolean isCustom(Class clz) {
        boolean result = false;
        if (clz != null) {
            if (!ReflectionUtils.isAssignableFrom("org.omg.CORBA.portable.IDLEntity", clz)) {
                Class superclz;
                if ((class$java$io$Externalizable == null ? (class$java$io$Externalizable = RepoIDHelper.class$("java.io.Externalizable")) : class$java$io$Externalizable).isAssignableFrom(clz)) {
                    result = true;
                } else if (!clz.isArray() && !(result = ReflectionUtils.hasWriteObjectMethod(clz)) && (superclz = clz.getSuperclass()) != null) {
                    result = RepoIDHelper.isCustom(superclz);
                }
            }
        } else {
            Thread.dumpStack();
        }
        return result;
    }

    public static long calculateStructuralHash(Class clz) {
        if ((class$java$io$Externalizable == null ? (class$java$io$Externalizable = RepoIDHelper.class$("java.io.Externalizable")) : class$java$io$Externalizable).isAssignableFrom(clz)) {
            return 1L;
        }
        if (!(class$java$io$Serializable == null ? (class$java$io$Serializable = RepoIDHelper.class$("java.io.Serializable")) : class$java$io$Serializable).isAssignableFrom(clz)) {
            return 0L;
        }
        ObjectStreamClass osc = ObjectStreamClass.lookup(clz);
        if (osc == null) {
            return 0L;
        }
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA");
            DataOutputStream dos = new DataOutputStream(new DigestOutputStream(s_dummy_output_stream, digest));
            Class parent = clz.getSuperclass();
            if (parent != null && (class$java$io$Serializable == null ? (class$java$io$Serializable = RepoIDHelper.class$("java.io.Serializable")) : class$java$io$Serializable).isAssignableFrom(parent)) {
                dos.writeLong(RepoIDHelper.calculateStructuralHash(parent));
            } else {
                dos.writeLong(0L);
            }
            dos.writeInt(RepoIDHelper.isCustom(clz) ? 2 : 1);
            ObjectStreamField[] sfields = osc.getFields();
            Arrays.sort(sfields, s_field_lex_comparator);
            int i = 0;
            while (i < sfields.length) {
                dos.writeUTF(sfields[i].getName());
                if (sfields[i].isPrimitive()) {
                    dos.writeUTF("" + sfields[i].getTypeCode());
                } else {
                    dos.writeUTF(sfields[i].getTypeString());
                }
                ++i;
            }
            dos.close();
            byte[] sha = digest.digest();
            long repoIDHash = 0L;
            int i2 = 0;
            while (i2 < (8 < sha.length ? 8 : sha.length)) {
                repoIDHash += (long)(sha[i2] & 0xFF) << i2 * 8;
                ++i2;
            }
            return repoIDHash;
        }
        catch (NoSuchAlgorithmException ex) {
            return -6075936380747386867L;
        }
        catch (IOException ex) {
            throw new InternalError("Unexpected IOException (" + ex + ")");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class IsA {
        private String m_me;
        private String m_nomi;
        private int m_minor;

        public IsA(String me) throws NumberFormatException {
            this.m_me = me;
            int idx = this.m_me.lastIndexOf(46);
            this.m_nomi = this.m_me.substring(0, idx + 1);
            this.m_minor = Integer.parseInt(this.m_me.substring(idx + 1));
        }

        public String toString() {
            return this.m_me;
        }

        public boolean equals(Object obj) {
            int minor;
            if (obj == null) {
                return false;
            }
            if (this == obj) {
                return true;
            }
            String str = obj.toString();
            if (str.equals(this.m_me)) {
                return true;
            }
            if (!str.startsWith(this.m_nomi)) {
                return false;
            }
            try {
                minor = Integer.parseInt(str.substring(this.m_nomi.length()));
            }
            catch (NumberFormatException ex) {
                return false;
            }
            return this.m_minor <= minor;
        }

        public int hashCode() {
            return this.m_nomi.hashCode();
        }
    }

    private static class DummyOutputStream
    extends OutputStream {
        private DummyOutputStream() {
        }

        public void write(int b) {
        }

        public void write(byte[] buf) {
        }

        public void write(byte[] buf, int off, int len) {
        }

        public void flush() {
        }

        public void close() {
        }
    }
}

