/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.util;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.WeakHashMap;

public class WeakHashSet
extends AbstractSet
implements Set {
    private WeakHashMap m_map;
    private static final Object INMAP = new Object();

    public WeakHashSet() {
        this.m_map = new WeakHashMap();
    }

    public WeakHashSet(Collection c) {
        this.m_map = new WeakHashMap(Math.max(2 * c.size(), 11));
        this.addAll(c);
    }

    public WeakHashSet(int initialCapacity, float loadFactor) {
        this.m_map = new WeakHashMap(initialCapacity, loadFactor);
    }

    public WeakHashSet(int initialCapacity) {
        this.m_map = new WeakHashMap(initialCapacity);
    }

    public Iterator iterator() {
        return ((AbstractMap)this.m_map).keySet().iterator();
    }

    public int size() {
        return this.m_map.size();
    }

    public boolean isEmpty() {
        return this.m_map.isEmpty();
    }

    public boolean contains(Object o) {
        return this.m_map.containsKey(o);
    }

    public boolean add(Object o) {
        return this.m_map.put(o, INMAP) == null;
    }

    public boolean remove(Object o) {
        return this.m_map.remove(o) == INMAP;
    }

    public void clear() {
        this.m_map.clear();
    }
}

