/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.openorb.util.ZipHandle;

public final class ZipUtil {
    private ZipUtil() {
    }

    public static ZipHandle createZip(String name) throws IOException {
        return new ZipHandle(null, new ZipOutputStream(new FileOutputStream(name)));
    }

    public static ZipHandle openZip(String name) throws IOException {
        return new ZipHandle(new ZipFile(new File(name)), null);
    }

    public static void closeZip(ZipHandle handle) throws IOException {
        if (handle.getIn() != null) {
            handle.getIn().close();
        }
        if (handle.getOut() != null) {
            handle.getOut().close();
        }
    }

    private static ZipEntry newEntry(String name) {
        return new ZipEntry(name);
    }

    public static void insert(String src_name, String dst_name, ZipHandle dest) throws IOException {
        int read;
        byte[] buffer = new byte[5000];
        ZipOutputStream outputZip = dest.getOut();
        ZipEntry entry = ZipUtil.newEntry(dst_name);
        outputZip.putNextEntry(entry);
        FileInputStream input = new FileInputStream(new File(src_name));
        do {
            read = input.read(buffer);
            outputZip.write(buffer, 0, read);
        } while (read == 5000);
        outputZip.closeEntry();
        input.close();
    }

    public static void addZipFileToZip(ZipEntry src_entry, ZipFile inputZip, String dst_name, ZipOutputStream outputZip) throws IOException {
        byte[] buffer = new byte[500];
        ZipEntry dst_entry = ZipUtil.newEntry(dst_name);
        outputZip.putNextEntry(dst_entry);
        InputStream input = inputZip.getInputStream(src_entry);
        long size = 0L;
        long init = src_entry.getSize();
        if (!src_entry.isDirectory()) {
            long read;
            do {
                read = input.read(buffer);
                outputZip.write(buffer, 0, (int)read);
            } while ((size += read) != init);
        }
        outputZip.closeEntry();
        input.close();
    }

    public static void copy(ZipHandle src, ZipHandle dst, String[] no_copy_list) throws IOException {
        Enumeration<? extends ZipEntry> enumeration = src.getIn().entries();
        ZipEntry entry_src = null;
        while (enumeration.hasMoreElements()) {
            entry_src = enumeration.nextElement();
            if (!ZipUtil.notInList(no_copy_list, entry_src)) continue;
            ZipUtil.addZipFileToZip(entry_src, src.getIn(), entry_src.getName(), dst.getOut());
        }
    }

    public static boolean containsFile(ZipHandle handle, String file) {
        return handle.getIn().getEntry(file) != null;
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] getFileContent(ZipHandle handle, String file) {
        ZipEntry entry = handle.getIn().getEntry(file);
        byte[] content = null;
        try {
            int b;
            InputStream input = handle.getIn().getInputStream(entry);
            content = new byte[(int)entry.getSize()];
            int i = 0;
            while ((b = input.read()) != -1) {
                void var5_7;
                content[i++] = (byte)var5_7;
            }
            input.close();
        }
        catch (IOException ex) {
            System.err.println("IOException caught during read() or close(): " + ex);
            return null;
        }
        return content;
    }

    private static boolean notInList(String[] list, ZipEntry entry) {
        String name = entry.getName();
        if (list == null) {
            return true;
        }
        int i = 0;
        while (i < list.length) {
            if (list[i].equals(name)) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

