/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.util.launcher;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.StringTokenizer;
import java.util.Vector;

public class ModuleClassLoader
extends URLClassLoader {
    private static final String LAUNCHER_CP_KEY = "openorb.env.cp";

    public ModuleClassLoader() throws Exception {
        super(new URL[0], (ClassLoader)null);
        this.initialize(this.locateDirectories(null));
        this.setupAdditionalPath();
    }

    public ModuleClassLoader(String module) throws Exception {
        super(new URL[0], (ClassLoader)null);
        this.initialize(this.locateDirectories(module));
        this.setupAdditionalPath();
    }

    private void setupAdditionalPath() {
        String cp = System.getProperty(LAUNCHER_CP_KEY);
        if (cp != null && cp.length() > 0) {
            StringTokenizer strtokizer = new StringTokenizer(cp, File.pathSeparator);
            while (strtokizer.hasMoreElements()) {
                String strtok = strtokizer.nextToken();
                File fil = new File(strtok);
                if (!fil.exists()) continue;
                try {
                    super.addURL(fil.toURL());
                }
                catch (MalformedURLException mue) {
                    System.err.println("Unable to add path element: " + fil);
                }
            }
        }
    }

    private void initialize(File[] directories) {
        JarFiles jarFilter = new JarFiles();
        int i = 0;
        while (i < directories.length) {
            File[] dirList = directories[i].listFiles(jarFilter);
            if (dirList != null) {
                int loop = 0;
                while (loop < dirList.length) {
                    try {
                        super.addURL(dirList[loop].toURL());
                    }
                    catch (MalformedURLException mue) {
                        System.err.println("Unable to add JAR file: " + dirList[loop]);
                    }
                    ++loop;
                }
            }
            ++i;
        }
    }

    private File[] locateDirectories(String module) throws Exception {
        File fromFile;
        URL from = this.getClass().getProtectionDomain().getCodeSource().getLocation();
        try {
            fromFile = new File(from.getFile()).getCanonicalFile();
        }
        catch (IOException ioe) {
            throw new Exception("Unable to locate: " + from.toExternalForm());
        }
        String root = fromFile.getParentFile().getParentFile().getParent();
        File orbRoot = new File(root, "OpenORB");
        if (!orbRoot.exists()) {
            throw new Exception("ERROR: missing 'OpenORB' directory in root: " + root);
        }
        File toolsRoot = new File(root, "tools");
        if (!toolsRoot.exists()) {
            throw new Exception("ERROR: missing 'tools' directory in root: " + root);
        }
        Vector<File> fileList = new Vector<File>(4);
        fileList.add(new File(orbRoot, "lib").getCanonicalFile());
        fileList.add(new File(root, "SSL/lib").getCanonicalFile());
        fileList.add(new File(root, "SSL/lib/ext").getCanonicalFile());
        fileList.add(new File(toolsRoot, "lib").getCanonicalFile());
        fileList.add(new File(toolsRoot, "lib/ext").getCanonicalFile());
        fileList.add(new File(toolsRoot, "lib/ext/build").getCanonicalFile());
        String ourPrefix = "org.openorb.";
        if (module != null && module.startsWith("org.openorb.")) {
            String shortName = module.substring("org.openorb.".length());
            int dot = shortName.indexOf(46);
            if (dot > 0) {
                shortName = shortName.substring(0, dot);
            }
            if ("ccs".equals(shortName)) {
                this.addDependency(fileList, new File(root, "ConcurrencyControlService/lib"));
                this.addDependency(fileList, new File(root, "TransactionService/lib"));
                this.addDependency(fileList, new File(root, "TransactionService/lib/ext"));
            } else if ("orb".equals(shortName)) {
                this.addDependency(fileList, new File(root, "NamingService/lib"));
            } else if ("constraint".equals(shortName)) {
                this.addDependency(fileList, new File(root, "EvaluatorUtility/lib"));
            } else if ("event".equals(shortName)) {
                this.addDependency(fileList, new File(root, "EventService/lib"));
            } else if ("ir".equals(shortName)) {
                this.addDependency(fileList, new File(root, "InterfaceRepository/lib"));
                this.addDependency(fileList, new File(root, "TransactionService/lib"));
                this.addDependency(fileList, new File(root, "TransactionService/lib/ext"));
                this.addDependency(fileList, new File(root, "PersistentStateService/lib"));
            } else if ("board".equals(shortName)) {
                this.addDependency(fileList, new File(root, "ManagementBoard/lib"));
                this.addDependency(fileList, new File(root, "ManagementBoard/lib/ext"));
                this.addDependency(fileList, new File(root, "TransactionService/lib"));
                this.addDependency(fileList, new File(root, "TransactionService/lib/ext"));
                this.addDependency(fileList, new File(root, "PersistentStateService/lib"));
                this.addDependency(fileList, new File(root, "EvaluatorUtility/lib"));
                this.addDependency(fileList, new File(root, "NotificationService/lib"));
                this.addDependency(fileList, new File(root, "InterfaceRepository/lib"));
                this.addDependency(fileList, new File(root, "TradingService/lib"));
                this.addDependency(fileList, new File(root, "NamingService/lib"));
            } else if ("tns".equals(shortName)) {
                this.addDependency(fileList, new File(root, "NamingService/lib"));
            } else if ("ins".equals(shortName)) {
                this.addDependency(fileList, new File(root, "NamingService/lib"));
                this.addDependency(fileList, new File(root, "TransactionService/lib"));
                this.addDependency(fileList, new File(root, "PersistentStateService/lib"));
            } else if ("notify".equals(shortName)) {
                this.addDependency(fileList, new File(root, "NotificationService/lib"));
                this.addDependency(fileList, new File(root, "EvaluatorUtility/lib"));
                this.addDependency(fileList, new File(root, "TransactionService/lib"));
                this.addDependency(fileList, new File(root, "TransactionService/lib/ext"));
                this.addDependency(fileList, new File(root, "PersistentStateService/lib"));
            } else if ("pss".equals(shortName)) {
                this.addDependency(fileList, new File(root, "PersistentStateService/lib"));
                this.addDependency(fileList, new File(root, "TransactionService/lib"));
                this.addDependency(fileList, new File(root, "TransactionService/lib/ext"));
            } else if ("property".equals(shortName)) {
                this.addDependency(fileList, new File(root, "PropertyService/lib"));
            } else if ("time".equals(shortName)) {
                this.addDependency(fileList, new File(root, "EventService/lib"));
                this.addDependency(fileList, new File(root, "TimeService/lib"));
            } else if ("trader".equals(shortName)) {
                this.addDependency(fileList, new File(root, "TradingService/lib"));
                this.addDependency(fileList, new File(root, "EvaluatorUtility/lib"));
                this.addDependency(fileList, new File(root, "PersistentStateService/lib"));
                this.addDependency(fileList, new File(root, "TransactionService/lib"));
                this.addDependency(fileList, new File(root, "TransactionService/lib/ext"));
                this.addDependency(fileList, new File(root, "InterfaceRepository/lib"));
            } else if ("ots".equals(shortName)) {
                this.addDependency(fileList, new File(root, "TransactionService/lib"));
                this.addDependency(fileList, new File(root, "TransactionService/lib/ext"));
            }
        }
        Object[] retValue = new File[fileList.size()];
        fileList.copyInto(retValue);
        return retValue;
    }

    private void addDependency(Vector depList, File directory) throws Exception {
        if (!directory.exists()) {
            throw new Exception("Unable to configure module because of a missing dependency: " + directory);
        }
        depList.add(directory);
    }

    private class JarFiles
    implements FilenameFilter {
        private JarFiles() {
        }

        public boolean accept(File dir, String name) {
            return name.endsWith(".jar");
        }
    }
}

