/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.util.launcher;

import java.util.Properties;

public final class PropertyManager {
    public static final PropertyManager JAVA_PROTOCOL_HANDLER_PKGS = PropertyManager.getPropertyManager("java.protocol.handler.pkgs", "|");
    private final Properties m_properties;
    private final String m_name;
    private final String m_separator;

    private PropertyManager(Properties properties, String name, String separator) {
        this.m_properties = properties;
        this.m_name = name;
        this.m_separator = separator;
    }

    public static PropertyManager getPropertyManager(Properties properties, String name, String separator) {
        return new PropertyManager(properties, name, separator);
    }

    public static PropertyManager getPropertyManager(Properties properties, String name) {
        return PropertyManager.getPropertyManager(properties, name, " ");
    }

    public static PropertyManager getPropertyManager(String name, String separator) {
        return PropertyManager.getPropertyManager(System.getProperties(), name, separator);
    }

    public static PropertyManager getPropertyManager(String name) {
        return PropertyManager.getPropertyManager(name, " ");
    }

    public String getSeparator() {
        return this.m_separator;
    }

    public String getName() {
        return this.m_name;
    }

    public String getValue() {
        return this.m_properties.getProperty(this.m_name);
    }

    public Object setValue(String value) {
        return this.m_properties.setProperty(this.m_name, value);
    }

    public Object setValue(String prefix, String postfix) {
        if (null != prefix) {
            if (null != postfix) {
                return this.setValue(prefix + this.m_separator + postfix);
            }
            return this.setValue(prefix);
        }
        if (null != postfix) {
            return this.setValue(postfix);
        }
        return this.setValue(null);
    }

    public void prefixValue(String value) {
        this.setValue(value, this.getValue());
    }

    public void postfixValue(String value) {
        this.setValue(this.getValue(), value);
    }
}

