/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.util.logger;

import org.apache.avalon.framework.logger.Logger;
import org.openorb.util.logger.AbstractLoggerTeam;
import org.openorb.util.logger.LoggerTeam;

public final class DiagnosticsLoggerTeam
extends AbstractLoggerTeam {
    private final Logger m_diagnosticsLogger;

    public DiagnosticsLoggerTeam(Logger mainLogger, Logger diagnosticsLogger) {
        super(mainLogger);
        this.m_diagnosticsLogger = null == diagnosticsLogger ? AbstractLoggerTeam.NULL_LOGGER : diagnosticsLogger;
    }

    protected boolean isNullLogger() {
        return super.isNullLogger() && this.m_diagnosticsLogger.equals(AbstractLoggerTeam.NULL_LOGGER);
    }

    public Logger getMember(Object tag) {
        return LoggerTeam.StandardTags.DIAGNOSTIC_LOGGER_TAG.equals(tag) ? this.m_diagnosticsLogger : super.getMember(tag);
    }

    public LoggerTeam createChildLoggerTeam(String name) {
        return this.isNullLogger() ? AbstractLoggerTeam.NULL_LOGGER : new DiagnosticsLoggerTeam(this.getMember(LoggerTeam.StandardTags.MAIN_LOGGER_TAG).getChildLogger(name), this.getMember(LoggerTeam.StandardTags.DIAGNOSTIC_LOGGER_TAG).getChildLogger(name));
    }

    public LoggerTeam createPrefixingLoggerTeam() {
        return this.isNullLogger() ? AbstractLoggerTeam.NULL_LOGGER : new DiagnosticsLoggerTeam(this.createPrefixingLogger(this.getMember(LoggerTeam.StandardTags.MAIN_LOGGER_TAG)), this.createPrefixingLogger(this.getMember(LoggerTeam.StandardTags.DIAGNOSTIC_LOGGER_TAG)));
    }

    public static LoggerTeam narrow(Logger logger, Logger diagnosticsParent, String childName) {
        if (logger instanceof LoggerTeam) {
            return (LoggerTeam)logger;
        }
        return new DiagnosticsLoggerTeam(logger, diagnosticsParent.getChildLogger(childName));
    }
}

