/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.util.service;

import java.io.File;
import java.io.FileInputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Properties;
import org.apache.avalon.framework.CascadingRuntimeException;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.logger.LogKitLogger;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.MissingArgumentException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.UnrecognizedOptionException;
import org.apache.log.Hierarchy;
import org.apache.log.LogTarget;
import org.apache.log.Logger;
import org.apache.log.Priority;
import org.apache.log.format.ExtendedPatternFormatter;
import org.apache.log.format.Formatter;
import org.apache.log.output.io.FileTarget;
import org.apache.log.output.io.StreamTarget;
import org.omg.CORBA.ORB;
import org.openorb.util.ORBUtils;
import org.openorb.util.logger.NullLoggerTeam;
import org.openorb.util.service.ServiceBase;
import org.openorb.util.service.ServiceContext;

public abstract class ServerBase {
    public static final String DEFAULT_FORMAT = "[%{thread}] [%5.5{priority}] (%{category}): %{message}\\n%{throwable}";
    public static final String DEFAULT_FILE_FORMAT = "[%{rtime}] [%{thread}] [%5.5{priority}] (%{category}): %{message}\\n%{throwable}";
    private org.apache.avalon.framework.logger.Logger m_logger = null;
    private ORB m_orb = null;
    private boolean m_initialized = false;
    private ServiceBase m_service = null;
    private ServiceContext m_svc_ctx = null;
    private Parameters m_svc_params = null;
    private String m_serviceClassNameStr = null;
    private boolean m_isFileLogging = false;

    public final CommandLine init(String[] args) {
        return this.init(args, null, null, null);
    }

    public final CommandLine init(String[] args, Options options) {
        return this.init(args, options, null, null);
    }

    public final CommandLine init(String[] args, Properties props) {
        return this.init(args, null, props, null);
    }

    public final CommandLine init(String[] args, Options options, Properties props) {
        return this.init(args, options, props, null);
    }

    public final CommandLine init(String[] args, Options options, Properties props, Parameters params) {
        try {
            this.m_service = this.createService();
            this.m_svc_ctx = this.createServiceContext();
            this.m_svc_params = new Parameters();
            CommandLine cmdline = this.parseArguments(ORBUtils.extractNonORBArgs(args), options, this.m_svc_params);
            if (params != null) {
                this.m_svc_params.merge(params);
            }
            this.m_logger = this.createLogger(this.m_service.getShortName(), this.m_svc_params);
            this.consolePrintln(this.getVersionString());
            this.m_orb = this.createORB(ORBUtils.extractORBArgs(args), props);
            this.m_svc_ctx.put("ORB", this.m_orb);
            this.handleArguments(cmdline, this.m_svc_params);
            this.initService(this.m_service, this.m_svc_ctx, this.m_svc_params);
            this.m_initialized = true;
            return cmdline;
        }
        catch (CascadingRuntimeException ex) {
            ex.getCause().printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        System.exit(5);
        return null;
    }

    public org.apache.avalon.framework.logger.Logger getLogger() {
        return this.m_logger;
    }

    protected org.apache.avalon.framework.logger.Logger createLogger(String name, Parameters svc_params) {
        try {
            Priority priority;
            String priorityStr = this.m_svc_params.getParameter("d", Priority.INFO.getName());
            Priority priority2 = priority = 0 == priorityStr.length() ? Priority.INFO : Priority.getPriorityForName((String)priorityStr.toUpperCase());
            if (Priority.NONE.equals(priority)) {
                return NullLoggerTeam.getInstance();
            }
            Hierarchy hierarchy = new Hierarchy();
            ExtendedPatternFormatter formatter = new ExtendedPatternFormatter(DEFAULT_FORMAT);
            StreamTarget systemOutTarget = new StreamTarget((OutputStream)System.out, (Formatter)formatter);
            hierarchy.setDefaultLogTarget((LogTarget)systemOutTarget);
            hierarchy.setDefaultPriority(priority);
            Logger logKitLogger = hierarchy.getLoggerFor(name);
            LogKitLogger result = new LogKitLogger(logKitLogger);
            this.configureLogger(logKitLogger, this.m_svc_params);
            return result;
        }
        catch (Throwable ex) {
            throw new CascadingRuntimeException("Unexpected exception while creating logger.", ex);
        }
    }

    protected void configureLogger(Object logger, Parameters svc_params) {
        if (logger instanceof Logger) {
            String priorityStr;
            Logger logKitLogger = (Logger)logger;
            if (svc_params.isParameter("l")) {
                String defaultLogfileName = this.m_service.getShortName() + ".log";
                String logfileName = svc_params.getParameter("l", defaultLogfileName);
                if (logfileName.length() == 0) {
                    logfileName = defaultLogfileName;
                }
                try {
                    File file = new File(logfileName);
                    ExtendedPatternFormatter formatter = new ExtendedPatternFormatter(DEFAULT_FILE_FORMAT);
                    FileTarget target = new FileTarget(file, true, (Formatter)formatter);
                    logKitLogger.setLogTargets(new LogTarget[]{target});
                    this.m_isFileLogging = true;
                }
                catch (Exception ex) {
                    logKitLogger.error("unable to write to " + logfileName + " logfile", (Throwable)ex);
                }
            }
            if ((priorityStr = this.m_svc_params.getParameter("d", Priority.INFO.getName()).toUpperCase()).length() == 0) {
                priorityStr = Priority.INFO.getName();
            }
            logKitLogger.setPriority(Priority.getPriorityForName((String)priorityStr.toUpperCase()));
        }
    }

    protected ServiceContext createServiceContext() {
        return new ServiceContext();
    }

    private Options createCmdineOptions(Options options) {
        if (options == null) {
            options = new Options();
        }
        options.addOption(new Option("h", "help", false, "print this message and exit"));
        OptionBuilder.withArgName((String)"level");
        OptionBuilder.hasOptionalArg();
        OptionBuilder.withLongOpt((String)"debug");
        OptionBuilder.withDescription((String)"enable debugging output. (Optional) Level values: none, debug, info, warn, error. Default is debug.");
        options.addOption(OptionBuilder.create((String)"d"));
        options.addOption(new Option("v", "version", false, "print the version information and exit"));
        OptionBuilder.withArgName((String)"logfile");
        OptionBuilder.hasOptionalArg();
        OptionBuilder.withLongOpt((String)"logfile");
        OptionBuilder.withDescription((String)"log to a file in the current working folder. Default file is <service>.log");
        options.addOption(OptionBuilder.create((String)"l"));
        options.addOption(new Option("u", "printCorbalocURL", false, "print the corbaloc url for the service"));
        options.addOption(new Option("i", "printIOR", false, "print the ior of the service"));
        OptionBuilder.withArgName((String)"directory");
        OptionBuilder.hasOptionalArg();
        OptionBuilder.withLongOpt((String)"writeIORFile");
        OptionBuilder.withDescription((String)"write the ior to a file in the specified directory. Default is current working folder.");
        options.addOption(OptionBuilder.create((String)"f"));
        OptionBuilder.withArgName((String)"directory");
        OptionBuilder.hasOptionalArg();
        OptionBuilder.withLongOpt((String)"writeCorbalocURL");
        OptionBuilder.withDescription((String)"write the corbaloc url to a file in the specified directory. Default is current working folder.");
        options.addOption(OptionBuilder.create((String)"U"));
        options.addOption(new Option("e", "default", false, "use the DefaultCorbalocService (IIOP port 683)."));
        OptionBuilder.withArgName((String)"service");
        OptionBuilder.hasArg();
        OptionBuilder.withLongOpt((String)"noBind");
        OptionBuilder.withDescription((String)"do not bind to the specified service. Service values: Naming, Corbaloc.");
        options.addOption(OptionBuilder.create((String)"n"));
        return options;
    }

    private CommandLine parseArguments(String[] args, Options opts, Parameters svc_params) {
        Options options = this.createCmdineOptions(opts);
        CommandLine line = null;
        try {
            GnuParser parser = new GnuParser();
            line = parser.parse(options, args);
        }
        catch (UnrecognizedOptionException ex) {
            System.err.println(ex.getMessage() + "\n");
            this.printUsage(options, 2);
        }
        catch (MissingArgumentException ex) {
            System.err.println("\nMissing argument: " + ex.getMessage() + "\n");
            this.printUsage(options, 2);
        }
        catch (ParseException ex) {
            System.err.println("Unexpected exception occured: " + (Object)((Object)ex) + "\n");
            System.exit(2);
        }
        if (line != null) {
            if (line.hasOption("h")) {
                this.printUsage(options, 1);
            } else if (line.hasOption("v")) {
                System.out.println(this.getVersionString());
                System.exit(1);
            }
            this.handleStdArguments(line, svc_params, options);
        }
        return line;
    }

    private void handleStdArguments(CommandLine line, Parameters svc_params, Options options) {
        if (line.hasOption("d")) {
            svc_params.setParameter("d", line.getOptionValue("d", ""));
        }
        if (line.hasOption("l")) {
            svc_params.setParameter("l", line.getOptionValue("l", ""));
        }
        svc_params.setParameter("u", line.hasOption("u") ? Boolean.TRUE.toString() : Boolean.FALSE.toString());
        svc_params.setParameter("i", line.hasOption("i") ? Boolean.TRUE.toString() : Boolean.FALSE.toString());
        if (line.hasOption("f")) {
            svc_params.setParameter("f", line.getOptionValue("f", ""));
        }
        if (line.hasOption("U")) {
            svc_params.setParameter("U", line.getOptionValue("U", ""));
        }
        svc_params.setParameter("e", line.hasOption("e") ? Boolean.TRUE.toString() : Boolean.FALSE.toString());
        Boolean optBindNS = Boolean.TRUE;
        Boolean optBindCorbaloc = Boolean.TRUE;
        if (line.hasOption("n")) {
            String[] values = line.getOptionValues("n");
            int ii = 0;
            while (ii < values.length) {
                if (values[ii].equalsIgnoreCase("Corbaloc")) {
                    optBindCorbaloc = Boolean.FALSE;
                } else if (values[ii].equalsIgnoreCase("Naming")) {
                    optBindNS = Boolean.FALSE;
                } else {
                    System.err.println("\nInvalid service for --noBind argument\n");
                    this.printUsage(options, 2);
                }
                ++ii;
            }
        }
        svc_params.setParameter("bindCorbaloc", optBindCorbaloc.toString());
        svc_params.setParameter("bindNaming", optBindNS.toString());
    }

    private String getVersionString() {
        return this.m_service.getLongName() + " " + this.m_service.getVersion() + " " + "Copyright (c) 2002-2005 The Community OpenORB";
    }

    private void printUsage(Options options, int exitCode) {
        HelpFormatter formatter = new HelpFormatter();
        String name = "start " + this.getClass().getName();
        formatter.printHelp(name, options);
        System.exit(exitCode);
    }

    protected void handleArguments(CommandLine cmdline, Parameters params) {
    }

    private ORB createORB(String[] args, Properties props) {
        this.getLogger().debug("Initializing ORB instance");
        Properties p = null;
        p = props == null ? new Properties() : (Properties)((Hashtable)props).clone();
        if (this.shallUseOpenORB(p)) {
            ((Hashtable)p).put("org.omg.CORBA.ORBClass", "org.openorb.orb.core.ORB");
            ((Hashtable)p).put("org.omg.CORBA.ORBSingletonClass", "org.openorb.orb.core.ORBSingleton");
            boolean bDefault = false;
            try {
                bDefault = this.m_svc_params.getParameterAsBoolean("e");
            }
            catch (ParameterException ex) {
                // empty catch block
            }
            if (bDefault) {
                ((Hashtable)p).put("ImportModule.CorbalocService", "${openorb.home}config/default.xml#DefaultCorbalocService");
            } else {
                ((Hashtable)p).put("ImportModule.CorbalocService", "${openorb.home}config/default.xml#CorbalocService");
            }
        }
        this.getLogger().info("calling ORB.init");
        this.getLogger().debug("calling ORB.init");
        return ORB.init((String[])args, (Properties)p);
    }

    private boolean shallUseOpenORB(Properties props) {
        String orbclass = null;
        if (props != null) {
            orbclass = props.getProperty("org.omg.CORBA.ORBClass");
        }
        if (orbclass == null) {
            orbclass = this.getSystemProperty("org.omg.CORBA.ORBClass");
        }
        if (orbclass == null) {
            orbclass = this.getPropertyFromFile("org.omg.CORBA.ORBClass");
        }
        return orbclass == null || orbclass.length() == 0 || orbclass.equals("org.openorb.orb.core.ORB");
    }

    private String getSystemProperty(String name) {
        try {
            return System.getProperty(name);
        }
        catch (SecurityException ex) {
            return null;
        }
    }

    private String getPropertyFromFile(String name) {
        File propFile = null;
        try {
            File userPropFile;
            String userHome = System.getProperty("user.home");
            if (userHome != null && (userPropFile = new File(userHome + File.separator + "orb.properties")).exists()) {
                propFile = userPropFile;
            }
        }
        catch (SecurityException ex) {
            // empty catch block
        }
        if (propFile == null) {
            try {
                File javaPropFile;
                String javaHome = System.getProperty("java.home");
                if (javaHome != null && (javaPropFile = new File(javaHome + File.separator + "lib" + File.separator + "orb.properties")).exists()) {
                    propFile = javaPropFile;
                }
            }
            catch (SecurityException ex) {
                // empty catch block
            }
        }
        if (propFile == null) {
            return null;
        }
        Properties file_props = new Properties();
        try {
            FileInputStream fis = new FileInputStream(propFile);
            try {
                file_props.load(fis);
                Object var6_8 = null;
            }
            catch (Throwable throwable) {
                Object var6_9 = null;
                fis.close();
                throw throwable;
            }
            fis.close();
            {
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        return file_props.getProperty(name);
    }

    private ServiceBase createService() {
        ServiceBase result = null;
        try {
            if (this.m_serviceClassNameStr == null || this.m_serviceClassNameStr.length() <= 0) {
                String clzName = this.getClass().getName();
                int dot = clzName.lastIndexOf(46);
                this.m_serviceClassNameStr = clzName.substring(0, dot) + ".Service";
            }
            Class<?> clzService = Thread.currentThread().getContextClassLoader().loadClass(this.m_serviceClassNameStr);
            result = (ServiceBase)clzService.newInstance();
        }
        catch (Exception ex) {
            throw new CascadingRuntimeException("The creation of the service failed", (Throwable)ex);
        }
        return result;
    }

    private void initService(ServiceBase svc, ServiceContext context, Parameters params) {
        try {
            this.getLogger().debug("Invoking preInitService");
            this.preInitService(context, params);
        }
        catch (Exception ex) {
            this.getLogger().error("Pre-initialization of the service failed!", (Throwable)ex);
            throw new CascadingRuntimeException("Pre-initialization of the service failed", (Throwable)ex);
        }
        this.getLogger().debug("Initializing the service instance");
        try {
            this.getLogger().debug("LogEnabling the service instance");
            svc.enableLogging(this.getLogger().getChildLogger("svc"));
            this.getLogger().debug("Contextualizing the service instance");
            context.makeReadOnly();
            svc.contextualize((Context)context);
            this.getLogger().debug("Parameterizing the service instance");
            params.makeReadOnly();
            svc.parameterize(params);
            this.getLogger().debug("Initializing the service instance");
            svc.initialize();
        }
        catch (Exception ex) {
            this.getLogger().error("Creation of the service failed!", (Throwable)ex);
            throw new CascadingRuntimeException("The creation of the service failed", (Throwable)ex);
        }
    }

    public final void run() {
        if (!this.m_initialized) {
            this.getLogger().error("The server has not been initialized yet!");
            throw new IllegalStateException("The server has not been initialized yet");
        }
        this.getLogger().debug("Starting the service");
        try {
            this.m_service.start();
            ServerShutdownHook srvShutdownHook = new ServerShutdownHook(this.m_orb, this.m_service, this.m_isFileLogging ? null : this.getLogger());
            Runtime rt = Runtime.getRuntime();
            rt.addShutdownHook(srvShutdownHook);
            this.consolePrintln("Service started. Press CTRL-C to stop the service!");
            this.m_orb.run();
        }
        catch (Exception ex) {
            this.getLogger().error("Start of the service failed!", (Throwable)ex);
            throw new CascadingRuntimeException("The start of the service failed", (Throwable)ex);
        }
    }

    public ORB getORB() {
        return this.m_orb;
    }

    public ServiceContext getServiceContext() {
        if (!this.m_initialized) {
            throw new IllegalStateException("not initialized");
        }
        return this.m_svc_ctx;
    }

    public Parameters getServiceParameters() {
        if (!this.m_initialized) {
            throw new IllegalStateException("not initialized");
        }
        return this.m_svc_params;
    }

    public void setServiceClassName(String classNameStr) {
        this.m_serviceClassNameStr = classNameStr;
    }

    protected void preInitService(ServiceContext context, Parameters params) {
    }

    protected void consolePrintln(String msg) {
        boolean wasLogged = false;
        if (this.m_logger != null && this.m_logger.isInfoEnabled()) {
            this.getLogger().info(msg);
            wasLogged = true;
        }
        if (this.m_isFileLogging || !wasLogged) {
            System.out.println(msg);
        }
    }

    private static class ServerShutdownHook
    extends Thread {
        private ORB m_orb;
        private ServiceBase m_svc;
        private org.apache.avalon.framework.logger.Logger m_logger;

        public ServerShutdownHook(ORB orb, ServiceBase svc, org.apache.avalon.framework.logger.Logger logger) {
            this.m_orb = orb;
            this.m_svc = svc;
            this.m_logger = logger;
        }

        public void run() {
            if (this.m_logger != null) {
                this.m_logger.info("Stopping the service.");
            } else {
                System.out.println("Stopping the service.");
            }
            try {
                this.m_svc.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.m_svc.dispose();
            this.m_orb.shutdown(true);
        }
    }
}

