/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.pool.KeyedObjectPool;
import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.PoolableObjectFactory;

public final class PoolUtils {
    private static Timer MIN_IDLE_TIMER;

    public static PoolableObjectFactory adapt(KeyedPoolableObjectFactory keyedFactory) throws IllegalArgumentException {
        return PoolUtils.adapt(keyedFactory, new Object());
    }

    public static PoolableObjectFactory adapt(KeyedPoolableObjectFactory keyedFactory, Object key) throws IllegalArgumentException {
        return new PoolableObjectFactoryAdaptor(keyedFactory, key);
    }

    public static KeyedPoolableObjectFactory adapt(PoolableObjectFactory factory) throws IllegalArgumentException {
        return new KeyedPoolableObjectFactoryAdaptor(factory);
    }

    public static ObjectPool adapt(KeyedObjectPool keyedPool) throws IllegalArgumentException {
        return PoolUtils.adapt(keyedPool, new Object());
    }

    public static ObjectPool adapt(KeyedObjectPool keyedPool, Object key) throws IllegalArgumentException {
        return new ObjectPoolAdaptor(keyedPool, key);
    }

    public static KeyedObjectPool adapt(ObjectPool pool) throws IllegalArgumentException {
        return new KeyedObjectPoolAdaptor(pool);
    }

    public static ObjectPool checkedPool(ObjectPool pool, Class type) {
        if (pool == null) {
            throw new IllegalArgumentException("pool must not be null.");
        }
        if (type == null) {
            throw new IllegalArgumentException("type must not be null.");
        }
        return new CheckedObjectPool(pool, type);
    }

    public static KeyedObjectPool checkedPool(KeyedObjectPool keyedPool, Class type) {
        if (keyedPool == null) {
            throw new IllegalArgumentException("keyedPool must not be null.");
        }
        if (type == null) {
            throw new IllegalArgumentException("type must not be null.");
        }
        return new CheckedKeyedObjectPool(keyedPool, type);
    }

    public static TimerTask checkMinIdle(ObjectPool pool, int minIdle, long period) throws IllegalArgumentException {
        if (pool == null) {
            throw new IllegalArgumentException("keyedPool must not be null.");
        }
        if (minIdle < 0) {
            throw new IllegalArgumentException("minIdle must be non-negative.");
        }
        ObjectPoolMinIdleTimerTask task = new ObjectPoolMinIdleTimerTask(pool, minIdle);
        PoolUtils.getMinIdleTimer().schedule((TimerTask)task, 0L, period);
        return task;
    }

    public static TimerTask checkMinIdle(KeyedObjectPool keyedPool, Object key, int minIdle, long period) throws IllegalArgumentException {
        if (keyedPool == null) {
            throw new IllegalArgumentException("keyedPool must not be null.");
        }
        if (key == null) {
            throw new IllegalArgumentException("key must not be null.");
        }
        if (minIdle < 0) {
            throw new IllegalArgumentException("minIdle must be non-negative.");
        }
        KeyedObjectPoolMinIdleTimerTask task = new KeyedObjectPoolMinIdleTimerTask(keyedPool, key, minIdle);
        PoolUtils.getMinIdleTimer().schedule((TimerTask)task, 0L, period);
        return task;
    }

    public static Map checkMinIdle(KeyedObjectPool keyedPool, Collection keys, int minIdle, long period) throws IllegalArgumentException {
        if (keys == null) {
            throw new IllegalArgumentException("keys must not be null.");
        }
        HashMap tasks = new HashMap(keys.size());
        for (Object key : keys) {
            TimerTask task = PoolUtils.checkMinIdle(keyedPool, key, minIdle, period);
            tasks.put(key, task);
        }
        return tasks;
    }

    public static void prefill(ObjectPool pool, int count) throws Exception, IllegalArgumentException {
        if (pool == null) {
            throw new IllegalArgumentException("keyedPool must not be null.");
        }
        for (int i = 0; i < count; ++i) {
            pool.addObject();
        }
    }

    public static void prefill(KeyedObjectPool keyedPool, Object key, int count) throws Exception, IllegalArgumentException {
        if (keyedPool == null) {
            throw new IllegalArgumentException("keyedPool must not be null.");
        }
        if (key == null) {
            throw new IllegalArgumentException("key must not be null.");
        }
        for (int i = 0; i < count; ++i) {
            keyedPool.addObject(key);
        }
    }

    public static void prefill(KeyedObjectPool keyedPool, Collection keys, int count) throws Exception, IllegalArgumentException {
        if (keys == null) {
            throw new IllegalArgumentException("keys must not be null.");
        }
        Iterator iter = keys.iterator();
        while (iter.hasNext()) {
            PoolUtils.prefill(keyedPool, iter.next(), count);
        }
    }

    public static ObjectPool synchronizedPool(ObjectPool pool) {
        return new SynchronizedObjectPool(pool);
    }

    public static KeyedObjectPool synchronizedPool(KeyedObjectPool keyedPool) {
        return new SynchronizedKeyedObjectPool(keyedPool);
    }

    public static PoolableObjectFactory synchronizedPoolableFactory(PoolableObjectFactory factory) {
        return new SynchronizedPoolableObjectFactory(factory);
    }

    public static KeyedPoolableObjectFactory synchronizedPoolableFactory(KeyedPoolableObjectFactory keyedFactory) {
        return new SynchronizedKeyedPoolableObjectFactory(keyedFactory);
    }

    private static synchronized Timer getMinIdleTimer() {
        if (MIN_IDLE_TIMER == null) {
            MIN_IDLE_TIMER = new Timer(true);
        }
        return MIN_IDLE_TIMER;
    }

    private static class SynchronizedKeyedPoolableObjectFactory
    implements KeyedPoolableObjectFactory {
        private final Object lock;
        private final KeyedPoolableObjectFactory keyedFactory;

        SynchronizedKeyedPoolableObjectFactory(KeyedPoolableObjectFactory keyedFactory) throws IllegalArgumentException {
            if (keyedFactory == null) {
                throw new IllegalArgumentException("keyedFactory must not be null.");
            }
            this.keyedFactory = keyedFactory;
            this.lock = new Object();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object makeObject(Object key) throws Exception {
            Object object = this.lock;
            synchronized (object) {
                return this.keyedFactory.makeObject(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void destroyObject(Object key, Object obj) throws Exception {
            Object object = this.lock;
            synchronized (object) {
                this.keyedFactory.destroyObject(key, obj);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean validateObject(Object key, Object obj) {
            Object object = this.lock;
            synchronized (object) {
                return this.keyedFactory.validateObject(key, obj);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void activateObject(Object key, Object obj) throws Exception {
            Object object = this.lock;
            synchronized (object) {
                this.keyedFactory.activateObject(key, obj);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void passivateObject(Object key, Object obj) throws Exception {
            Object object = this.lock;
            synchronized (object) {
                this.keyedFactory.passivateObject(key, obj);
            }
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("SynchronizedKeyedPoolableObjectFactory");
            sb.append("{keyedFactory=").append(this.keyedFactory);
            sb.append('}');
            return sb.toString();
        }
    }

    private static class SynchronizedPoolableObjectFactory
    implements PoolableObjectFactory {
        private final Object lock;
        private final PoolableObjectFactory factory;

        SynchronizedPoolableObjectFactory(PoolableObjectFactory factory) throws IllegalArgumentException {
            if (factory == null) {
                throw new IllegalArgumentException("factory must not be null.");
            }
            this.factory = factory;
            this.lock = new Object();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object makeObject() throws Exception {
            Object object = this.lock;
            synchronized (object) {
                return this.factory.makeObject();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void destroyObject(Object obj) throws Exception {
            Object object = this.lock;
            synchronized (object) {
                this.factory.destroyObject(obj);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean validateObject(Object obj) {
            Object object = this.lock;
            synchronized (object) {
                return this.factory.validateObject(obj);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void activateObject(Object obj) throws Exception {
            Object object = this.lock;
            synchronized (object) {
                this.factory.activateObject(obj);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void passivateObject(Object obj) throws Exception {
            Object object = this.lock;
            synchronized (object) {
                this.factory.passivateObject(obj);
            }
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("SynchronizedPoolableObjectFactory");
            sb.append("{factory=").append(this.factory);
            sb.append('}');
            return sb.toString();
        }
    }

    private static class SynchronizedKeyedObjectPool
    implements KeyedObjectPool {
        private final Object lock;
        private final KeyedObjectPool keyedPool;

        SynchronizedKeyedObjectPool(KeyedObjectPool keyedPool) throws IllegalArgumentException {
            if (keyedPool == null) {
                throw new IllegalArgumentException("keyedPool must not be null.");
            }
            this.keyedPool = keyedPool;
            this.lock = new Object();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object borrowObject(Object key) throws Exception, NoSuchElementException, IllegalStateException {
            Object object = this.lock;
            synchronized (object) {
                return this.keyedPool.borrowObject(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void returnObject(Object key, Object obj) throws Exception {
            Object object = this.lock;
            synchronized (object) {
                this.keyedPool.returnObject(key, obj);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void invalidateObject(Object key, Object obj) throws Exception {
            Object object = this.lock;
            synchronized (object) {
                this.keyedPool.invalidateObject(key, obj);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addObject(Object key) throws Exception, IllegalStateException, UnsupportedOperationException {
            Object object = this.lock;
            synchronized (object) {
                this.keyedPool.addObject(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getNumIdle(Object key) throws UnsupportedOperationException {
            Object object = this.lock;
            synchronized (object) {
                return this.keyedPool.getNumIdle(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getNumActive(Object key) throws UnsupportedOperationException {
            Object object = this.lock;
            synchronized (object) {
                return this.keyedPool.getNumActive(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getNumIdle() throws UnsupportedOperationException {
            Object object = this.lock;
            synchronized (object) {
                return this.keyedPool.getNumIdle();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getNumActive() throws UnsupportedOperationException {
            Object object = this.lock;
            synchronized (object) {
                return this.keyedPool.getNumActive();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() throws Exception, UnsupportedOperationException {
            Object object = this.lock;
            synchronized (object) {
                this.keyedPool.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear(Object key) throws Exception, UnsupportedOperationException {
            Object object = this.lock;
            synchronized (object) {
                this.keyedPool.clear(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws Exception {
            Object object = this.lock;
            synchronized (object) {
                this.keyedPool.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setFactory(KeyedPoolableObjectFactory factory) throws IllegalStateException, UnsupportedOperationException {
            Object object = this.lock;
            synchronized (object) {
                this.keyedPool.setFactory(factory);
            }
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("SynchronizedKeyedObjectPool");
            sb.append("{keyedPool=").append(this.keyedPool);
            sb.append('}');
            return sb.toString();
        }
    }

    private static class SynchronizedObjectPool
    implements ObjectPool {
        private final Object lock;
        private final ObjectPool pool;

        SynchronizedObjectPool(ObjectPool pool) throws IllegalArgumentException {
            if (pool == null) {
                throw new IllegalArgumentException("keyedPool must not be null.");
            }
            this.pool = pool;
            this.lock = new Object();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object borrowObject() throws Exception, NoSuchElementException, IllegalStateException {
            Object object = this.lock;
            synchronized (object) {
                return this.pool.borrowObject();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void returnObject(Object obj) throws Exception {
            Object object = this.lock;
            synchronized (object) {
                this.pool.returnObject(obj);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void invalidateObject(Object obj) throws Exception {
            Object object = this.lock;
            synchronized (object) {
                this.pool.invalidateObject(obj);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addObject() throws Exception, IllegalStateException, UnsupportedOperationException {
            Object object = this.lock;
            synchronized (object) {
                this.pool.addObject();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getNumIdle() throws UnsupportedOperationException {
            Object object = this.lock;
            synchronized (object) {
                return this.pool.getNumIdle();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getNumActive() throws UnsupportedOperationException {
            Object object = this.lock;
            synchronized (object) {
                return this.pool.getNumActive();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() throws Exception, UnsupportedOperationException {
            Object object = this.lock;
            synchronized (object) {
                this.pool.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws Exception {
            Object object = this.lock;
            synchronized (object) {
                this.pool.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setFactory(PoolableObjectFactory factory) throws IllegalStateException, UnsupportedOperationException {
            Object object = this.lock;
            synchronized (object) {
                this.pool.setFactory(factory);
            }
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("SynchronizedObjectPool");
            sb.append("{keyedPool=").append(this.pool);
            sb.append('}');
            return sb.toString();
        }
    }

    private static class KeyedObjectPoolMinIdleTimerTask
    extends TimerTask {
        private final int minIdle;
        private final Object key;
        private final KeyedObjectPool pool;

        KeyedObjectPoolMinIdleTimerTask(KeyedObjectPool pool, Object key, int minIdle) throws IllegalArgumentException {
            if (pool == null) {
                throw new IllegalArgumentException("keyedPool must not be null.");
            }
            this.pool = pool;
            this.key = key;
            this.minIdle = minIdle;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            boolean success = false;
            try {
                if (this.pool.getNumIdle(this.key) < this.minIdle) {
                    this.pool.addObject(this.key);
                }
                success = true;
            }
            catch (Exception e) {
                this.cancel();
            }
            finally {
                if (!success) {
                    this.cancel();
                }
            }
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("KeyedObjectPoolMinIdleTimerTask");
            sb.append("{minIdle=").append(this.minIdle);
            sb.append(", key=").append(this.key);
            sb.append(", keyedPool=").append(this.pool);
            sb.append('}');
            return sb.toString();
        }
    }

    private static class ObjectPoolMinIdleTimerTask
    extends TimerTask {
        private final int minIdle;
        private final ObjectPool pool;

        ObjectPoolMinIdleTimerTask(ObjectPool pool, int minIdle) throws IllegalArgumentException {
            if (pool == null) {
                throw new IllegalArgumentException("poll must not be null.");
            }
            this.pool = pool;
            this.minIdle = minIdle;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            boolean success = false;
            try {
                if (this.pool.getNumIdle() < this.minIdle) {
                    this.pool.addObject();
                }
                success = true;
            }
            catch (Exception e) {
                this.cancel();
            }
            finally {
                if (!success) {
                    this.cancel();
                }
            }
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("ObjectPoolMinIdleTimerTask");
            sb.append("{minIdle=").append(this.minIdle);
            sb.append(", keyedPool=").append(this.pool);
            sb.append('}');
            return sb.toString();
        }
    }

    private static class CheckedKeyedObjectPool
    implements KeyedObjectPool {
        private final Class type;
        private final KeyedObjectPool keyedPool;

        CheckedKeyedObjectPool(KeyedObjectPool keyedPool, Class type) {
            if (keyedPool == null) {
                throw new IllegalArgumentException("keyedPool must not be null.");
            }
            if (type == null) {
                throw new IllegalArgumentException("type must not be null.");
            }
            this.keyedPool = keyedPool;
            this.type = type;
        }

        public Object borrowObject(Object key) throws Exception, NoSuchElementException, IllegalStateException {
            Object obj = this.keyedPool.borrowObject(key);
            if (this.type.isInstance(obj)) {
                return obj;
            }
            throw new ClassCastException("Borrowed object for key: " + key + " is not of type: " + this.type.getName() + " was: " + obj);
        }

        public void returnObject(Object key, Object obj) throws Exception {
            if (!this.type.isInstance(obj)) {
                throw new ClassCastException("Returned object for key: " + key + " is not of type: " + this.type.getName() + " was: " + obj);
            }
            this.keyedPool.returnObject(key, obj);
        }

        public void invalidateObject(Object key, Object obj) throws Exception {
            if (!this.type.isInstance(obj)) {
                throw new ClassCastException("Invalidated object for key: " + key + " is not of type: " + this.type.getName() + " was: " + obj);
            }
            this.keyedPool.invalidateObject(key, obj);
        }

        public void addObject(Object key) throws Exception, IllegalStateException, UnsupportedOperationException {
            this.keyedPool.addObject(key);
        }

        public int getNumIdle(Object key) throws UnsupportedOperationException {
            return this.keyedPool.getNumIdle(key);
        }

        public int getNumActive(Object key) throws UnsupportedOperationException {
            return this.keyedPool.getNumActive(key);
        }

        public int getNumIdle() throws UnsupportedOperationException {
            return this.keyedPool.getNumIdle();
        }

        public int getNumActive() throws UnsupportedOperationException {
            return this.keyedPool.getNumActive();
        }

        public void clear() throws Exception, UnsupportedOperationException {
            this.keyedPool.clear();
        }

        public void clear(Object key) throws Exception, UnsupportedOperationException {
            this.keyedPool.clear(key);
        }

        public void close() throws Exception {
            this.keyedPool.close();
        }

        public void setFactory(KeyedPoolableObjectFactory factory) throws IllegalStateException, UnsupportedOperationException {
            this.keyedPool.setFactory(factory);
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("CheckedKeyedObjectPool");
            sb.append("{type=").append(this.type);
            sb.append(", keyedPool=").append(this.keyedPool);
            sb.append('}');
            return sb.toString();
        }
    }

    private static class CheckedObjectPool
    implements ObjectPool {
        private final Class type;
        private final ObjectPool pool;

        CheckedObjectPool(ObjectPool pool, Class type) {
            if (pool == null) {
                throw new IllegalArgumentException("pool must not be null.");
            }
            if (type == null) {
                throw new IllegalArgumentException("type must not be null.");
            }
            this.pool = pool;
            this.type = type;
        }

        public Object borrowObject() throws Exception, NoSuchElementException, IllegalStateException {
            Object obj = this.pool.borrowObject();
            if (this.type.isInstance(obj)) {
                return obj;
            }
            throw new ClassCastException("Borrowed object is not of type: " + this.type.getName() + " was: " + obj);
        }

        public void returnObject(Object obj) throws Exception {
            if (!this.type.isInstance(obj)) {
                throw new ClassCastException("Returned object is not of type: " + this.type.getName() + " was: " + obj);
            }
            this.pool.returnObject(obj);
        }

        public void invalidateObject(Object obj) throws Exception {
            if (!this.type.isInstance(obj)) {
                throw new ClassCastException("Invalidated object is not of type: " + this.type.getName() + " was: " + obj);
            }
            this.pool.invalidateObject(obj);
        }

        public void addObject() throws Exception, IllegalStateException, UnsupportedOperationException {
            this.pool.addObject();
        }

        public int getNumIdle() throws UnsupportedOperationException {
            return this.pool.getNumIdle();
        }

        public int getNumActive() throws UnsupportedOperationException {
            return this.pool.getNumActive();
        }

        public void clear() throws Exception, UnsupportedOperationException {
            this.pool.clear();
        }

        public void close() throws Exception {
            this.pool.close();
        }

        public void setFactory(PoolableObjectFactory factory) throws IllegalStateException, UnsupportedOperationException {
            this.pool.setFactory(factory);
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("CheckedObjectPool");
            sb.append("{type=").append(this.type);
            sb.append(", keyedPool=").append(this.pool);
            sb.append('}');
            return sb.toString();
        }
    }

    private static class KeyedObjectPoolAdaptor
    implements KeyedObjectPool {
        private final ObjectPool pool;

        KeyedObjectPoolAdaptor(ObjectPool pool) throws IllegalArgumentException {
            if (pool == null) {
                throw new IllegalArgumentException("keyedPool must not be null.");
            }
            this.pool = pool;
        }

        public Object borrowObject(Object key) throws Exception, NoSuchElementException, IllegalStateException {
            return this.pool.borrowObject();
        }

        public void returnObject(Object key, Object obj) throws Exception {
            this.pool.returnObject(obj);
        }

        public void invalidateObject(Object key, Object obj) throws Exception {
            this.pool.invalidateObject(obj);
        }

        public void addObject(Object key) throws Exception, IllegalStateException {
            this.pool.addObject();
        }

        public int getNumIdle(Object key) throws UnsupportedOperationException {
            return this.pool.getNumIdle();
        }

        public int getNumActive(Object key) throws UnsupportedOperationException {
            return this.pool.getNumActive();
        }

        public int getNumIdle() throws UnsupportedOperationException {
            return this.pool.getNumIdle();
        }

        public int getNumActive() throws UnsupportedOperationException {
            return this.pool.getNumActive();
        }

        public void clear() throws Exception, UnsupportedOperationException {
            this.pool.clear();
        }

        public void clear(Object key) throws Exception, UnsupportedOperationException {
            this.pool.clear();
        }

        public void close() throws Exception {
            this.pool.close();
        }

        public void setFactory(KeyedPoolableObjectFactory factory) throws IllegalStateException, UnsupportedOperationException {
            this.pool.setFactory(PoolUtils.adapt(factory));
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("KeyedObjectPoolAdaptor");
            sb.append("{keyedPool=").append(this.pool);
            sb.append('}');
            return sb.toString();
        }
    }

    private static class ObjectPoolAdaptor
    implements ObjectPool {
        private final Object key;
        private final KeyedObjectPool keyedPool;

        ObjectPoolAdaptor(KeyedObjectPool keyedPool, Object key) throws IllegalArgumentException {
            if (keyedPool == null) {
                throw new IllegalArgumentException("keyedPool must not be null.");
            }
            if (key == null) {
                throw new IllegalArgumentException("key must not be null.");
            }
            this.keyedPool = keyedPool;
            this.key = key;
        }

        public Object borrowObject() throws Exception, NoSuchElementException, IllegalStateException {
            return this.keyedPool.borrowObject(this.key);
        }

        public void returnObject(Object obj) throws Exception {
            this.keyedPool.returnObject(this.key, obj);
        }

        public void invalidateObject(Object obj) throws Exception {
            this.keyedPool.invalidateObject(this.key, obj);
        }

        public void addObject() throws Exception, IllegalStateException {
            this.keyedPool.addObject(this.key);
        }

        public int getNumIdle() throws UnsupportedOperationException {
            return this.keyedPool.getNumIdle(this.key);
        }

        public int getNumActive() throws UnsupportedOperationException {
            return this.keyedPool.getNumActive(this.key);
        }

        public void clear() throws Exception, UnsupportedOperationException {
            this.keyedPool.clear();
        }

        public void close() throws Exception {
            this.keyedPool.close();
        }

        public void setFactory(PoolableObjectFactory factory) throws IllegalStateException, UnsupportedOperationException {
            this.keyedPool.setFactory(PoolUtils.adapt(factory));
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("ObjectPoolAdaptor");
            sb.append("{key=").append(this.key);
            sb.append(", keyedPool=").append(this.keyedPool);
            sb.append('}');
            return sb.toString();
        }
    }

    private static class KeyedPoolableObjectFactoryAdaptor
    implements KeyedPoolableObjectFactory {
        private final PoolableObjectFactory factory;

        KeyedPoolableObjectFactoryAdaptor(PoolableObjectFactory factory) throws IllegalArgumentException {
            if (factory == null) {
                throw new IllegalArgumentException("factory must not be null.");
            }
            this.factory = factory;
        }

        public Object makeObject(Object key) throws Exception {
            return this.factory.makeObject();
        }

        public void destroyObject(Object key, Object obj) throws Exception {
            this.factory.destroyObject(obj);
        }

        public boolean validateObject(Object key, Object obj) {
            return this.factory.validateObject(obj);
        }

        public void activateObject(Object key, Object obj) throws Exception {
            this.factory.activateObject(obj);
        }

        public void passivateObject(Object key, Object obj) throws Exception {
            this.factory.passivateObject(obj);
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("KeyedPoolableObjectFactoryAdaptor");
            sb.append("{factory=").append(this.factory);
            sb.append('}');
            return sb.toString();
        }
    }

    private static class PoolableObjectFactoryAdaptor
    implements PoolableObjectFactory {
        private final Object key;
        private final KeyedPoolableObjectFactory keyedFactory;

        PoolableObjectFactoryAdaptor(KeyedPoolableObjectFactory keyedFactory, Object key) throws IllegalArgumentException {
            if (keyedFactory == null) {
                throw new IllegalArgumentException("keyedFactory must not be null.");
            }
            if (key == null) {
                throw new IllegalArgumentException("key must not be null.");
            }
            this.keyedFactory = keyedFactory;
            this.key = key;
        }

        public Object makeObject() throws Exception {
            return this.keyedFactory.makeObject(this.key);
        }

        public void destroyObject(Object obj) throws Exception {
            this.keyedFactory.destroyObject(this.key, obj);
        }

        public boolean validateObject(Object obj) {
            return this.keyedFactory.validateObject(this.key, obj);
        }

        public void activateObject(Object obj) throws Exception {
            this.keyedFactory.activateObject(this.key, obj);
        }

        public void passivateObject(Object obj) throws Exception {
            this.keyedFactory.passivateObject(this.key, obj);
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("PoolableObjectFactoryAdaptor");
            sb.append("{key=").append(this.key);
            sb.append(", keyedFactory=").append(this.keyedFactory);
            sb.append('}');
            return sb.toString();
        }
    }
}

