/*
 * Decompiled with CFR 0.152.
 */
package com.n2bb.LogModule;

import com.n2bb.smp.Constants.Events;
import com.n2bb.smp.LogClient;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Vector;

public class N2BB_LogClient {
    public static final int LOG_EMERGENCY = 0;
    public static final int LOG_ALERT = 1;
    public static final int LOG_CRITICAL = 2;
    public static final int LOG_ERROR = 3;
    public static final int LOG_WARNING = 4;
    public static final int LOG_NOTICE = 5;
    public static final int LOG_INFO = 6;
    public static final int LOG_CORBAMETHOD = 7;
    public static final int LOG_STACKTRACE = 8;
    public static final int LOG_DEBUG = 9;
    public static final int LOG_ALL = 10;
    public static final int SETTINGSSERVER_INITFAILED = 0;
    public static final int SETTINGSSERVER_NOTFOUND = 1;
    public static final int SETTINGSSERVER_INVALIDNAME = 2;
    public static final int SETTINGSSERVER_CONFLICTINGSETTING = 3;
    public static final int SETTINGSSERVER_READONLY = 4;
    public static final int SETTINGSSERVER_UNSUPPORTEDSETTING = 5;
    public static final int SETTINGSSERVER_WRONGTYPE = 6;
    public static final int SETTINGSSERVER_FIXEDSETTING = 7;
    private static final String[] MESSAGETABLE = new String[]{"Failed to initialize SClient", "Setting not found: $(1)", "Invalid setting name: $(1)", "Conflicting setting: $(1)", "Read-only setting: $(1)", "Unsupported setting: $(1)", "Wrong type: $(1)", "Setting has fixed value: $(1)"};
    private static final String UNKNOWN = "Unknown";
    private DatagramSocket m_dgSocket = null;
    private int m_logServerPort = 60101;
    private InetAddress m_logServerAddress = null;
    private String m_ipAddress = null;
    private String m_facility = null;
    private int m_bufferSize = 65535;
    private Vector m_messageQueue;
    private static N2BB_LogClient m_instance = null;
    private boolean m_overrideCentralLogging = false;
    private LogClient smpClient = LogClient.instance();
    private DatagramSocket m_dgAlertSocket = null;
    private InetAddress m_alertServerAddress = null;
    private int m_alertServerPort = 4490;
    private String m_ipAddressAlert = null;
    private boolean m_alertsEnabled = true;

    public static N2BB_LogClient instance() {
        if (m_instance == null) {
            m_instance = new N2BB_LogClient("DEFAULT");
        }
        return m_instance;
    }

    public static N2BB_LogClient instance(String facility) {
        if (m_instance == null) {
            m_instance = new N2BB_LogClient(facility);
        } else {
            m_instance.setFacility(facility);
        }
        return m_instance;
    }

    public static N2BB_LogClient instance(String facility, int bufferSize) {
        N2BB_LogClient.instance(facility).setBufferSize(bufferSize);
        return m_instance;
    }

    protected N2BB_LogClient(String facility) {
        this.m_facility = facility;
        this.m_messageQueue = new Vector();
        this.m_overrideCentralLogging = Boolean.getBoolean("OverrideCentralLogging");
        this.initAlerts();
        this.initSocket();
    }

    public void setFacility(String facility) {
        this.m_facility = facility;
    }

    public String getFacility() {
        return this.m_facility;
    }

    public void setBufferSize(int bufferSize) {
        try {
            this.m_bufferSize = bufferSize;
            if (this.m_dgSocket != null) {
                this.m_dgSocket.setSendBufferSize(this.m_bufferSize);
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
    }

    private void initAlerts() {
        try {
            String value = System.getProperty("logClientAlertsEnabled", "true");
            if (value.equalsIgnoreCase("false")) {
                this.m_alertsEnabled = false;
            }
            if (this.m_alertsEnabled) {
                this.m_alertServerPort = Integer.parseInt(System.getProperty("logClientAlertsPort", "4490"));
                this.m_dgAlertSocket = new DatagramSocket();
                this.m_dgAlertSocket.setSendBufferSize(this.m_bufferSize);
                this.m_ipAddressAlert = InetAddress.getLocalHost().getHostAddress();
                this.m_alertServerAddress = InetAddress.getByName("Alerts");
            }
        }
        catch (Exception e) {
            this.m_alertsEnabled = false;
            System.out.println("N2BB_LogClient.initAlerts exception: " + e);
            System.out.println("N2BB_LogClient.initAlerts NO ALERTS WILL BE SENT");
            e.printStackTrace();
        }
    }

    protected void logAlert(int specificTrapID, String facility, String message) {
        try {
            if (!this.m_alertsEnabled) {
                return;
            }
            StringBuffer finalMsg = new StringBuffer();
            finalMsg.append(specificTrapID).append(" ").append(facility);
            finalMsg.append(" (").append(this.m_ipAddressAlert).append(") ").append(message);
            String msg = finalMsg.toString();
            DatagramPacket packet = new DatagramPacket(msg.getBytes("UTF-8"), msg.getBytes("UTF-8").length, this.m_alertServerAddress, this.m_alertServerPort);
            this.m_dgSocket.send(packet);
        }
        catch (Exception e) {
            System.out.println("N2BB_LogClient.logAlert Exception: " + e);
            e.printStackTrace();
        }
    }

    private boolean initSocket() {
        boolean retval = true;
        try {
            this.m_dgSocket = new DatagramSocket();
            this.m_dgSocket.setSendBufferSize(this.m_bufferSize);
            this.m_logServerAddress = InetAddress.getLocalHost();
            if (this.m_logServerAddress != null) {
                this.m_ipAddress = this.m_logServerAddress.getHostAddress();
            }
        }
        catch (SocketException se) {
            System.out.println("N2BB_LogClient.initSocket: Unable to open datagram socket--will retry later.  Caching log messages.");
            retval = false;
        }
        catch (UnknownHostException uhe) {
            System.out.println("N2BB_LogClient.initSocket: Unable to determine host IP address--will retry later.  Caching log messages.");
            retval = false;
        }
        return retval;
    }

    public boolean logMessage(String msgclass, String msgmethod, String message, int logLevel, String facility) {
        boolean retval = true;
        StringBuffer finalMsg = new StringBuffer(logLevel + " " + facility + " ");
        for (int i = 0; i < 10 - facility.length(); ++i) {
            finalMsg.append(' ');
        }
        finalMsg.append(msgclass + "." + msgmethod + "(): " + message);
        if (this.m_overrideCentralLogging) {
            System.out.println(finalMsg);
        } else {
            this.m_messageQueue.add(finalMsg.toString());
            boolean socketValid = true;
            if (this.m_dgSocket == null || this.m_ipAddress == null) {
                socketValid = this.initSocket();
            }
            if (socketValid) {
                String msg = "";
                while (this.m_messageQueue.size() > 0) {
                    try {
                        msg = (String)this.m_messageQueue.remove(0);
                        DatagramPacket packet = new DatagramPacket(msg.getBytes("UTF-8"), msg.getBytes("UTF-8").length, this.m_logServerAddress, this.m_logServerPort);
                        this.m_dgSocket.send(packet);
                    }
                    catch (ArrayIndexOutOfBoundsException aioobe) {
                    }
                    catch (IOException e) {
                        System.out.println("N2BB_LogClient.logMessage: Unable to send message to the logger. Exception caught");
                        System.out.println("Exception : " + e);
                        e.printStackTrace();
                        this.m_messageQueue.add(0, msg);
                        retval = false;
                    }
                }
            }
        }
        return retval;
    }

    public boolean logMessage(String msgclass, String msgmethod, String message, int logLevel) {
        return this.logMessage(msgclass, msgmethod, message, logLevel, this.m_facility);
    }

    public boolean logMessage(String msgclass, String msgmethod, String message) {
        return this.logMessage(msgclass, msgmethod, message, 9, this.m_facility);
    }

    public boolean logStackTrace(String msgclass, String msgmethod, String reason, Throwable th, int log_level) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        th.printStackTrace(pw);
        pw.close();
        String msg = reason + "\n" + th.getMessage() + "\n" + sw.toString();
        return this.logMessage(msgclass, msgmethod, msg, log_level);
    }

    public boolean logStackTrace(String msgclass, String msgmethod, String reason, Throwable th) {
        return this.logStackTrace(msgclass, msgmethod, reason, th, 3);
    }

    public void debug(String msgclass, String msgmethod, String message) {
        this.logMessage(msgclass, msgmethod, message, 9);
    }

    public void info(String msgclass, String msgmethod, String message) {
        this.logMessage(msgclass, msgmethod, message, 6);
    }

    public void notice(String msgclass, String msgmethod, String message) {
        this.logMessage(msgclass, msgmethod, message, 5);
    }

    public void warning(String msgclass, String msgmethod, String message) {
        this.logMessage(msgclass, msgmethod, message, 4);
    }

    public void error(String msgclass, String msgmethod, String message) {
        this.logMessage(msgclass, msgmethod, message, 3);
    }

    public void critical(String msgclass, String msgmethod, String message) {
        this.logMessage(msgclass, msgmethod, message, 2);
    }

    public boolean LogSettingsServerFailed(String msgclass, String msgmethod, int MESSAGETYPE, String settingName) {
        int msgloglevel = 3;
        if (MESSAGETYPE == 0) {
            msgloglevel = 2;
        }
        String[] params = new String[]{settingName};
        return this.logMessage(msgclass, msgmethod, this.applyParams(MESSAGETABLE[MESSAGETYPE], params), msgloglevel);
    }

    private String applyParams(String format, String[] params) {
        StringBuffer formatValue = new StringBuffer(format);
        int index = 0;
        while ((index = formatValue.toString().indexOf("$(")) != -1) {
            Integer paramidx;
            int endex = formatValue.toString().indexOf(")", index);
            String in = formatValue.substring(index + 2, endex);
            try {
                paramidx = new Integer(in);
            }
            catch (NumberFormatException nfe) {
                paramidx = new Integer(Integer.MAX_VALUE);
            }
            formatValue.delete(index, endex + 1);
            if (paramidx - 1 < params.length) {
                formatValue.insert(index, params[paramidx - 1]);
                continue;
            }
            formatValue.insert(index, "");
        }
        return formatValue.toString();
    }

    public boolean LogCreateOrbFailed(String msgclass, String msgmethod, String reason) {
        return this.logMessage(msgclass, msgmethod, "Create ORB failed: " + reason, 0);
    }

    public boolean LogDestroyOrbFailed(String msgclass, String msgmethod, String reason) {
        return this.logMessage(msgclass, msgmethod, "Destroy ORB failed: " + reason, 3);
    }

    public boolean LogInvalidRootPoaName(String msgclass, String msgmethod, String invalidPoaName) {
        return this.logMessage(msgclass, msgmethod, "Invalid name for root POA: " + invalidPoaName, 0);
    }

    public boolean LogResolveRootPoaFailed(String msgclass, String msgmethod) {
        return this.logMessage(msgclass, msgmethod, "Failed to resolve root POA", 0);
    }

    public boolean LogNarrowFailed(String msgclass, String msgmethod, String objectType, String reason) {
        return this.logMessage(msgclass, msgmethod, "Failed to narrow object to " + objectType + ": " + reason, 3);
    }

    public boolean LogFactoryCreated(String msgclass, String msgmethod, String factoryType, String factoryName) {
        return this.logMessage(msgclass, msgmethod, factoryType + " factory created named '" + factoryName + "'", 6);
    }

    public boolean LogFactoryCreateFailed(String msgclass, String msgmethod, String factoryType, String factoryName) {
        String msg = "Unable to create " + factoryType + " named '" + factoryName + "'";
        this.logAlert(620, this.m_facility, "LogFactoryCreateFailed: " + msg);
        return this.logMessage(msgclass, msgmethod, msg, 0);
    }

    public boolean LogFactoryDestroyed(String msgclass, String msgmethod, String factoryType, String factoryName) {
        return this.logMessage(msgclass, msgmethod, factoryType + " factory destroyed named '" + factoryName + "'", 6);
    }

    public boolean LogFactoryDestroyFailed(String msgclass, String msgmethod, String factoryType, String factoryName) {
        return this.logMessage(msgclass, msgmethod, "Unable to destroy " + factoryType + " factory named '" + factoryName + "'", 3);
    }

    public boolean LogFactoryNameRegistered(String msgclass, String msgmethod, String factoryType, String factoryName, String factoryContext) {
        return this.logMessage(msgclass, msgmethod, factoryType + " Factory '" + factoryName + "' is registered with the Naming Service as " + factoryContext, 6);
    }

    public boolean LogFactoryOutOfService(String msgclass, String msgmethod, String factoryType, String factoryName, String attemptedAction) {
        return this.logMessage(msgclass, msgmethod, factoryType + " Factory '" + factoryName + "' is out of service; can't " + attemptedAction, 6);
    }

    public boolean LogChannelNameRegistered(String msgclass, String msgmethod, String channel, String channelContext) {
        return this.logMessage(msgclass, msgmethod, "Notification Channel '" + channel + "' registered with Naming Service as " + channelContext, 6);
    }

    public boolean LogServantCreated(String msgclass, String msgmethod, String servantType, String servantName) {
        return this.logMessage(msgclass, msgmethod, "Created " + servantType + " servant named '" + servantName + "'", 6);
    }

    public boolean LogDuplicateServant(String msgclass, String msgmethod, String servantType, String servantName) {
        String msg = "Duplicate " + servantType + " named '" + servantName + "'";
        this.logAlert(605, this.m_facility, "LogDuplicateServant: " + msg);
        return this.logMessage(msgclass, msgmethod, msg, 3);
    }

    public boolean LogServantDestroyed(String msgclass, String msgmethod, String servantType, String servantName) {
        return this.logMessage(msgclass, msgmethod, "Destroyed " + servantType + " servant named '" + servantName + "'", 9);
    }

    public boolean LogCreateFailed(String msgclass, String msgmethod, String type, String reason) {
        String msg = "Unable to create " + type + ": " + reason;
        this.logAlert(620, this.m_facility, "LogCreateFailed: " + msg);
        return this.logMessage(msgclass, msgmethod, msg, 3);
    }

    public boolean LogNotFound(String msgclass, String msgmethod, String what) {
        return this.logMessage(msgclass, msgmethod, what + " not found", 4);
    }

    public boolean LogOutOfService(String msgclass, String msgmethod, String what) {
        return this.logMessage(msgclass, msgmethod, what + " is out of service", 4);
    }

    public boolean LogNonexistent(String msgclass, String msgmethod, String what) {
        return this.logMessage(msgclass, msgmethod, what + " does not exist", 4);
    }

    public boolean LogProvisionSuccess(String msgclass, String msgmethod, String what) {
        return this.logMessage(msgclass, msgmethod, what + " Successfully provisioned", 6);
    }

    public boolean LogProvisionFailed(String msgclass, String msgmethod, String what) {
        return this.logMessage(msgclass, msgmethod, "Unable to provision " + what, 3);
    }

    public boolean LogPackageProvisionSuccess(String msgclass, String msgmethod, String pkg, String provider) {
        return this.logMessage(msgclass, msgmethod, "Package " + pkg + " from " + provider + " Successfully provisioned", 6);
    }

    public boolean LogPackagePartialExport(String msgclass, String msgmethod, String pkg, String provider, String reason) {
        String msg = "Package " + pkg + " from " + provider + " Partially Exported. Reason: " + reason;
        this.logAlert(820, this.m_facility, "LogPackagePartialExport: " + msg);
        return this.logMessage(msgclass, msgmethod, msg, 3);
    }

    public boolean LogPackageProvisionFailed(String msgclass, String msgmethod, String pkg, String provider, String reason) {
        String msg = "Unable to provision package " + pkg + " from " + provider + ": " + reason;
        this.logAlert(810, this.m_facility, "LogPackageProvisionFailed: " + msg);
        return this.logMessage(msgclass, msgmethod, msg, 3);
    }

    public boolean LogNotProvisioned(String msgclass, String msgmethod, String what, String action) {
        return this.logMessage(msgclass, msgmethod, "Object " + what + " is not provisioned: " + action, 4);
    }

    public boolean LogIsNull(String msgclass, String msgmethod, String what, String action) {
        return this.logMessage(msgclass, msgmethod, what + " is null: " + action, 3);
    }

    public boolean LogReady(String msgclass, String msgmethod, String what) {
        return this.logMessage(msgclass, msgmethod, what + " is ready", 6);
    }

    public boolean LogUnknownHost(String msgclass, String msgmethod, String what) {
        return this.logMessage(msgclass, msgmethod, "Unknown host: " + what, 2);
    }

    public boolean LogAdministrativeStateChanged(String msgclass, String msgmethod, String eventName, String wherePublished) {
        return this.logMessage(msgclass, msgmethod, "Published AdministrativeStateChangeEvent " + eventName + " from " + wherePublished, 9);
    }

    public boolean LogOperationalStateChanged(String msgclass, String msgmethod, String eventName, String wherePublished) {
        return this.logMessage(msgclass, msgmethod, "Published OperationStateChangeEvent " + eventName + " from " + wherePublished, 9);
    }

    public boolean LogProvisioningStateChanged(String msgclass, String msgmethod, String eventName, String wherePublished) {
        return this.logMessage(msgclass, msgmethod, "Published ProvisioningStateChangeEvent " + eventName + " from " + wherePublished, 6);
    }

    public boolean LogInvalidStateChange(String msgclass, String msgmethod, String where, String origState, String attemptedNewState) {
        return this.logMessage(msgclass, msgmethod, "Invalid state change in " + where + ": cannot change " + origState + " state to " + attemptedNewState, 3);
    }

    public boolean LogOracleConnectionFailed(String msgclass, String msgmethod, String reason) {
        String msg = "Oracle: Connection failed: " + reason;
        this.logAlert(310, this.m_facility, "LogOracleError: " + msg);
        return this.logMessage(msgclass, msgmethod, msg, 0);
    }

    public boolean LogOraclePrepareStatementsFailed(String msgclass, String msgmethod, String reason) {
        String msg = "Oracle: Unable to prepare SQL statements: " + reason;
        this.logAlert(310, this.m_facility, "LogOracleError: " + msg);
        return this.logMessage(msgclass, msgmethod, msg, 0);
    }

    public boolean LogOracleReadFailed(String msgclass, String msgmethod, String item, String reason) {
        String msg = "Oracle: Unable to read object " + item + ": " + reason;
        this.logAlert(310, this.m_facility, "LogOracleError: " + msg);
        return this.logMessage(msgclass, msgmethod, msg, 0);
    }

    public boolean LogOracleWriteFailed(String msgclass, String msgmethod, String item, String reason) {
        String msg = "Oracle: Unable to write object " + item + ": " + reason;
        this.logAlert(310, this.m_facility, "LogOracleError: " + msg);
        return this.logMessage(msgclass, msgmethod, msg, 0);
    }

    public boolean LogOracleDeleteFailed(String msgclass, String msgmethod, String item, String reason) {
        String msg = "Oracle: Unable to delete object " + item + ": " + reason;
        this.logAlert(310, this.m_facility, "LogOracleError: " + msg);
        return this.logMessage(msgclass, msgmethod, msg, 0);
    }

    public boolean LogPersistenceUsingDefault(String msgclass, String msgmethod, String where, String named, String defaultPersist) {
        return this.logMessage(msgclass, msgmethod, "Unable to determine requested persistence method in " + where + ": " + named + ".  Defaulting to " + defaultPersist, 2);
    }

    public boolean LogCBIState(String msgclass, String msgmethod, String state) {
        return this.logMessage(msgclass, msgmethod, "CBI is " + state, 6);
    }

    public boolean LogBillingDown(String msgclass, String msgmethod, String SMSId, String action) {
        String msg = "Server down detected: " + SMSId + " while attempting " + action;
        this.logAlert(960, this.m_facility, "LogBillingDown: " + msg);
        return this.logMessage(msgclass, msgmethod, msg, 3);
    }

    public boolean LogRPCTimeout(String msgclass, String msgmethod, String call, String reason) {
        String msg = "CBI RPC call " + call + " timed out: " + reason;
        this.logAlert(930, this.m_facility, "LogRPCTimeout: " + msg);
        return this.logMessage(msgclass, msgmethod, msg, 3);
    }

    public boolean LogRPCServerError(String msgclass, String msgmethod, String call, String reason) {
        return this.logMessage(msgclass, msgmethod, "CBI RPC call " + call + " received Server Error: " + reason, 3);
    }

    public boolean LogRPCException(String msgclass, String msgmethod, String call, String reason) {
        return this.logMessage(msgclass, msgmethod, "CBI RPC call " + call + " raised exception: " + reason, 3);
    }

    public boolean LogRetryFailed(String msgclass, String msgmethod, String call, String numRetries) {
        return this.logMessage(msgclass, msgmethod, "CBI RPC call " + call + "failed.  Number of retries attempted: " + numRetries, 3);
    }

    public boolean LogMethodEntry(String msgclass, String msgmethod) {
        return this.logMessage(msgclass, msgmethod, "Method Entered", 9);
    }

    public boolean LogMethodExit(String msgclass, String msgmethod) {
        return this.logMessage(msgclass, msgmethod, "Method Exited", 9);
    }

    public boolean LogMethodEntry(String msgclass, String msgmethod, String message) {
        return this.logMessage(msgclass, msgmethod, "Method Entered: " + message, 9);
    }

    public boolean LogMethodExit(String msgclass, String msgmethod, String message) {
        return this.logMessage(msgclass, msgmethod, "Method Exited: " + message, 9);
    }

    public boolean LogNotImplemented(String msgclass, String msgmethod, String method) {
        String msg = method + " not implemented";
        this.logAlert(630, this.m_facility, "LogNotImplemented: " + msg);
        return this.logMessage(msgclass, msgmethod, msg, 3);
    }

    public boolean LogElapsedTime(String msgclass, String msgmethod, String action, String time) {
        return this.logMessage(msgclass, msgmethod, "Total time (msecs) to " + action + ": " + time, 6);
    }

    public boolean LogServerStartup(String msgclass, String msgmethod, String server) {
        String msg = server + " Server started";
        this.logAlert(110, this.m_facility, "LogServerStartup: " + msg);
        return this.logMessage(msgclass, msgmethod, msg, 6);
    }

    public boolean LogServerShutdown(String msgclass, String msgmethod, String server) {
        String msg = server + " Server stopped";
        this.logAlert(120, this.m_facility, "LogServerShutdown: " + msg);
        return this.logMessage(msgclass, msgmethod, msg, 6);
    }

    public boolean LogCorbaException(String msgclass, String msgmethod, String exception, String action) {
        String msg = "Caught CORBA." + exception + " exception while " + action;
        this.logAlert(610, this.m_facility, "LogCorbaException: " + msg);
        return this.logMessage(msgclass, msgmethod, msg, 3);
    }

    public boolean LogUnknownException(String msgclass, String msgmethod, String action) {
        String msg = "Caught unknown exception while " + action;
        this.logAlert(615, this.m_facility, "LogUnknownException: " + msg);
        return this.logMessage(msgclass, msgmethod, msg, 3);
    }

    public boolean LogUnspecifiedException(String msgclass, String msgmethod, String action, String message) {
        String msg = "Caught Unspecified Exception while " + action + ": " + message;
        this.logAlert(625, this.m_facility, "LogUnspecifiedException: " + msg);
        return this.logMessage(msgclass, msgmethod, msg, 4);
    }

    public boolean LogCBIUpstreamFailed(String msgclass, String msgmethod, String transactionType, String transactionKey, String sequenceNo, String reason) {
        String msg = "CBI " + transactionType + " for ID='" + transactionKey + "' with sequence number " + sequenceNo + " failed: " + reason;
        this.logAlert(950, this.m_facility, "LogCBIUpstreamFailed: " + msg);
        return this.logMessage(msgclass, msgmethod, msg, 3);
    }

    public boolean LogCBIUpstreamSucceeded(String msgclass, String msgmethod, String transactionType, String transactionKey) {
        return this.logMessage(msgclass, msgmethod, "CBI " + transactionType + " for " + transactionKey + " succeeded", 6);
    }

    public boolean LogNotificationChannelCreated(String msgclass, String msgmethod, String name) {
        return this.logMessage(msgclass, msgmethod, "Notification channel created named " + name, 6);
    }

    public boolean LogNotificationChannelCreateFailed(String msgclass, String msgmethod, String name) {
        return this.logMessage(msgclass, msgmethod, "Failed to create Notification Channel named " + name, 3);
    }

    public boolean LogSetFactoryObjectSucceeded(String msgclass, String msgmethod, String name, String factory) {
        return this.logMessage(msgclass, msgmethod, "Successfully set factory object for " + name + " to " + factory, 6);
    }

    public boolean LogSetFactoryObjectFailed(String msgclass, String msgmethod, String name, String factory, String reason) {
        return this.logMessage(msgclass, msgmethod, "Failed to set Factory object for " + name + " to " + factory + ": " + reason, 3);
    }

    public boolean LogThreadpoolCreated(String msgclass, String msgmethod, String threadpool, String numthreads) {
        return this.logMessage(msgclass, msgmethod, "Created " + threadpool + " threadpool containing " + numthreads + " threads", 6);
    }

    public boolean LogThreadpoolCreateFailed(String msgclass, String msgmethod, String threadpool, String numthreads, String reason) {
        return this.logMessage(msgclass, msgmethod, "Failed to create " + threadpool + " threadpool containing " + numthreads + " threads: " + reason, 3);
    }

    public boolean LogRPCHandlesCreated(String msgclass, String msgmethod, String numhandles) {
        return this.logMessage(msgclass, msgmethod, "Created " + numhandles + "RPC Handles", 6);
    }

    public boolean LogRPCHandlesCreateFailed(String msgclass, String msgmethod, String numhandles, String reason) {
        return this.logMessage(msgclass, msgmethod, "Failed to create " + numhandles + " RPC Handles: " + reason, 3);
    }

    public boolean LogpersistFailed(String msgclass, String msgmethod, String item, String reason) {
        return this.logMessage(msgclass, msgmethod, "Failed to persist object " + item + ": " + reason, 0);
    }

    public boolean LogUnPersistFailed(String msgclass, String msgmethod, String item, String reason) {
        return this.logMessage(msgclass, msgmethod, "Failed to unpersist object " + item + ": " + reason, 0);
    }

    public boolean LogPublishNotificationFailed(String msgclass, String msgmethod, String item, String reason) {
        return this.logMessage(msgclass, msgmethod, "Failed to publish Notification event " + item + ": " + reason, 4);
    }

    public boolean LogServerUp(String msgclass, String msgmethod, String server) {
        return this.logMessage(msgclass, msgmethod, server + " Server is Up", 6);
    }

    public boolean LogServerDown(String msgclass, String msgmethod, String server) {
        return this.logMessage(msgclass, msgmethod, server + " Server is Down", 3);
    }

    public boolean LogServerUnknown(String msgclass, String msgmethod, String server, String reason) {
        return this.logMessage(msgclass, msgmethod, server + " Server status is Unknown: " + reason, 3);
    }

    public boolean LogContentStoreFailed(String msgclass, String msgmethod, String contentStoreName, String contentName, String assetName, String errorMsg) {
        String msg = "Creation of content '" + contentName + "' associated with asset '" + assetName + "' on content store '" + contentStoreName + "' failed: " + errorMsg;
        this.logAlert(830, this.m_facility, "LogContentStoreFailed: " + msg);
        return this.logMessage(msgclass, msgmethod, msg, 3);
    }

    public boolean LogAssetPlayFailed(String msgclass, String msgmethod, String assetName, String sessionID, String errorMsg) {
        String msg = "Asset play failed associated with asset '" + assetName + "' and session '" + sessionID + "' - message: " + errorMsg;
        this.logAlert(510, this.m_facility, "LogAssetPlayFailed: " + msg);
        return this.logMessage(msgclass, msgmethod, msg, 3);
    }

    public boolean LogStreamFailure(String msgclass, String msgmethod, String assetName, String sessionID, String errorMsg) {
        String msg = "Asset play associated with asset '" + assetName + "' and session '" + sessionID + "' failed due to a problem on StreamService (VOD pump) - message: " + errorMsg;
        this.logAlert(520, this.m_facility, "LogStreamFailure: " + msg);
        return this.logMessage(msgclass, msgmethod, msg, 3);
    }

    public boolean LogPassThruReceiptRequest(String msgclass, String msgmethod, long transactionId, String originatingIP, String destinationIP) {
        String msg = String.format("PassThru Receipt Request with transaction id '%d' sent from '%s', destined for user at '%s'", transactionId, originatingIP, destinationIP);
        this.smpClient.logEventCounter(new Timestamp(System.currentTimeMillis()), Events.PASSTHRU_RECEIPT_REQUEST.getCode(), 1L);
        return this.logMessage(msgclass, msgmethod, msg, 9);
    }

    public boolean LogPassThruReceiptConfirm(String msgclass, String msgmethod, long transactionId, int responseCode) {
        String msg = String.format("PassThru Receipt Confirm with transaction id '%d' has response code '%d'", transactionId, responseCode);
        this.smpClient.logEventCounter(new Timestamp(System.currentTimeMillis()), Events.PASSTHRU_RECEIPT_CONFIRM.getCode(), 1L);
        return this.logMessage(msgclass, msgmethod, msg, 9);
    }

    public boolean LogPassThruReceiptIndication(String msgclass, String msgmethod, long transactionId, String originatingIP, String destinationIP) {
        String msg = String.format("PassThru Receipt Indication with transaction id '%d' sent from '%s', destined for user at '%s'", transactionId, originatingIP, destinationIP);
        this.smpClient.logEventCounter(new Timestamp(System.currentTimeMillis()), Events.PASSTHRU_RECEIPT_INDICATION.getCode(), 1L);
        return this.logMessage(msgclass, msgmethod, msg, 9);
    }

    public boolean LogPassThruReceiptResponse(String msgclass, String msgmethod, long transactionId, int responseCode) {
        String msg = String.format("PassThru Receipt Response with transaction id '%d' has response code '%d'", transactionId, responseCode);
        this.smpClient.logEventCounter(new Timestamp(System.currentTimeMillis()), Events.PASSTHRU_RECEIPT_RESPONSE.getCode(), 1L);
        return this.logMessage(msgclass, msgmethod, msg, 9);
    }

    public boolean LogPassThruRequest(String msgclass, String msgmethod, long transactionId, String originatingIP, String destinationIP) {
        String msg = String.format("PassThru Request with transaction id '%d' sent from '%s', destined for user at '%s'", transactionId, originatingIP, destinationIP);
        this.smpClient.logEventCounter(new Timestamp(System.currentTimeMillis()), Events.PASSTHRU_REQUEST.getCode(), 1L);
        return this.logMessage(msgclass, msgmethod, msg, 9);
    }

    public boolean LogPassThruIndication(String msgclass, String msgmethod, long transactionId, String originatingIP, String destinationIP) {
        String msg = String.format("PassThru Indication with transaction id '%d' sent from '%s', destined for user at '%s'", transactionId, originatingIP, destinationIP);
        this.smpClient.logEventCounter(new Timestamp(System.currentTimeMillis()), Events.PASSTHRU_INDICATION.getCode(), 1L);
        return this.logMessage(msgclass, msgmethod, msg, 9);
    }

    public boolean LogEJBCommError(String msgclass, String msgmethod, String msg, Throwable th) {
        this.logAlert(970, this.m_facility, "LogEJBCommError: " + msg);
        return this.logStackTrace(msgclass, msgmethod, msg, th, 3);
    }

    public boolean LogCBIObjectField(String myclass, String mymethod, String field, String value) {
        return this.logMessage(myclass, mymethod, field + " == " + value, 9);
    }

    public boolean LogBADataObjectField(String myclass, String mymethod, String field, String value) {
        return this.LogCBIObjectField(myclass, mymethod, field, value);
    }

    public boolean logMessage(String message, int logLevel, String facility) {
        return this.logMessage(UNKNOWN, UNKNOWN, message, logLevel, facility);
    }

    public boolean logMessage(String message, int logLevel) {
        return this.logMessage(message, logLevel, this.m_facility);
    }

    public boolean logMessage(String message) {
        return this.logMessage(message, 9, this.m_facility);
    }

    public boolean LogSettingsServerFailed(int MESSAGETYPE, String settingName) {
        return this.LogSettingsServerFailed(UNKNOWN, UNKNOWN, MESSAGETYPE, settingName);
    }

    public boolean LogCreateOrbFailed(String reason) {
        return this.LogCreateOrbFailed(UNKNOWN, UNKNOWN, reason);
    }

    public boolean LogDestroyOrbFailed(String reason) {
        return this.LogDestroyOrbFailed(UNKNOWN, UNKNOWN, reason);
    }

    public boolean LogInvalidRootPoaName(String invalidPoaName) {
        return this.LogInvalidRootPoaName(UNKNOWN, UNKNOWN, invalidPoaName);
    }

    public boolean LogResolveRootPoaFailed() {
        return this.LogResolveRootPoaFailed(UNKNOWN, UNKNOWN);
    }

    public boolean LogNarrowFailed(String objectType, String reason) {
        return this.LogNarrowFailed(UNKNOWN, UNKNOWN, objectType, reason);
    }

    public boolean LogFactoryCreated(String factoryType, String factoryName) {
        return this.LogFactoryCreated(UNKNOWN, UNKNOWN, factoryType, factoryName);
    }

    public boolean LogFactoryCreateFailed(String factoryType, String factoryName) {
        return this.LogFactoryCreateFailed(UNKNOWN, UNKNOWN, factoryType, factoryName);
    }

    public boolean LogFactoryDestroyed(String factoryType, String factoryName) {
        return this.LogFactoryDestroyed(UNKNOWN, UNKNOWN, factoryType, factoryName);
    }

    public boolean LogFactoryDestroyFailed(String factoryType, String factoryName) {
        return this.LogFactoryDestroyFailed(UNKNOWN, UNKNOWN, factoryType, factoryName);
    }

    public boolean LogFactoryNameRegistered(String factoryType, String factoryName, String factoryContext) {
        return this.LogFactoryNameRegistered(UNKNOWN, UNKNOWN, factoryType, factoryName, factoryContext);
    }

    public boolean LogFactoryOutOfService(String factoryType, String factoryName, String attemptedAction) {
        return this.LogFactoryOutOfService(UNKNOWN, UNKNOWN, factoryType, factoryName, attemptedAction);
    }

    public boolean LogChannelNameRegistered(String channel, String channelContext) {
        return this.LogChannelNameRegistered(UNKNOWN, UNKNOWN, channel, channelContext);
    }

    public boolean LogServantCreated(String servantType, String servantName) {
        return this.LogServantCreated(UNKNOWN, UNKNOWN, servantType, servantName);
    }

    public boolean LogDuplicateServant(String servantType, String servantName) {
        return this.LogDuplicateServant(UNKNOWN, UNKNOWN, servantType, servantName);
    }

    public boolean LogServantDestroyed(String servantType, String servantName) {
        return this.LogServantDestroyed(UNKNOWN, UNKNOWN, servantType, servantName);
    }

    public boolean LogCreateFailed(String type, String reason) {
        return this.LogCreateFailed(UNKNOWN, UNKNOWN, type, reason);
    }

    public boolean LogNotFound(String what) {
        return this.LogNotFound(UNKNOWN, UNKNOWN, what);
    }

    public boolean LogOutOfService(String what) {
        return this.LogOutOfService(UNKNOWN, UNKNOWN, what);
    }

    public boolean LogNonexistent(String what) {
        return this.LogNonexistent(UNKNOWN, UNKNOWN, what);
    }

    public boolean LogProvisionSuccess(String what) {
        return this.LogProvisionSuccess(UNKNOWN, UNKNOWN, what);
    }

    public boolean LogProvisionFailed(String what) {
        return this.LogProvisionFailed(UNKNOWN, UNKNOWN, what);
    }

    public boolean LogNotProvisioned(String what, String action) {
        return this.LogNotProvisioned(UNKNOWN, UNKNOWN, what, action);
    }

    public boolean LogIsNull(String what, String action) {
        return this.LogIsNull(UNKNOWN, UNKNOWN, what, action);
    }

    public boolean LogReady(String what) {
        return this.LogReady(UNKNOWN, UNKNOWN, what);
    }

    public boolean LogUnknownHost(String what) {
        return this.LogUnknownHost(UNKNOWN, UNKNOWN, what);
    }

    public boolean LogAdministrativeStateChanged(String eventName, String wherePublished) {
        return this.LogAdministrativeStateChanged(UNKNOWN, UNKNOWN, eventName, wherePublished);
    }

    public boolean LogOperationalStateChanged(String eventName, String wherePublished) {
        return this.LogOperationalStateChanged(UNKNOWN, UNKNOWN, eventName, wherePublished);
    }

    public boolean LogProvisioningStateChanged(String eventName, String wherePublished) {
        return this.LogProvisioningStateChanged(UNKNOWN, UNKNOWN, eventName, wherePublished);
    }

    public boolean LogInvalidStateChange(String where, String origState, String attemptedNewState) {
        return this.LogInvalidStateChange(UNKNOWN, UNKNOWN, where, origState, attemptedNewState);
    }

    public boolean LogOracleConnectionFailed(String where) {
        return this.LogOracleConnectionFailed(UNKNOWN, UNKNOWN, where);
    }

    public boolean LogOraclePrepareStatementsFailed(String where) {
        return this.LogOraclePrepareStatementsFailed(UNKNOWN, UNKNOWN, where);
    }

    public boolean LogOracleReadFailed(String where, String item) {
        return this.LogOracleReadFailed(UNKNOWN, UNKNOWN, where, item);
    }

    public boolean LogOracleWriteFailed(String where, String item) {
        return this.LogOracleWriteFailed(UNKNOWN, UNKNOWN, where, item);
    }

    public boolean LogOracleDeleteFailed(String where, String item) {
        return this.LogOracleDeleteFailed(UNKNOWN, UNKNOWN, where, item);
    }

    public boolean LogPersistenceUsingDefault(String where, String named, String defaultPersist) {
        return this.LogPersistenceUsingDefault(UNKNOWN, UNKNOWN, where, named, defaultPersist);
    }

    public boolean LogCBIState(String state) {
        return this.LogCBIState(UNKNOWN, UNKNOWN, state);
    }

    public boolean LogRPCTimeout(String call, String reason) {
        return this.LogRPCTimeout(UNKNOWN, UNKNOWN, call, reason);
    }

    public boolean LogRPCServerError(String call, String reason) {
        return this.LogRPCServerError(UNKNOWN, UNKNOWN, call, reason);
    }

    public boolean LogRPCException(String call, String reason) {
        return this.LogRPCException(UNKNOWN, UNKNOWN, call, reason);
    }

    public boolean LogRetryFailed(String call, String numRetries) {
        return this.LogRetryFailed(UNKNOWN, UNKNOWN, call, numRetries);
    }

    public boolean LogMethodEntry(String method) {
        return this.LogMethodEntry(UNKNOWN, method);
    }

    public boolean LogMethodExit(String method) {
        return this.LogMethodExit(UNKNOWN, method);
    }

    public boolean LogNotImplemented(String method) {
        return this.LogNotImplemented(UNKNOWN, UNKNOWN, method);
    }

    public boolean LogElapsedTime(String action, String time) {
        return this.LogElapsedTime(UNKNOWN, UNKNOWN, action, time);
    }

    public boolean LogServerStartup(String server) {
        return this.LogServerStartup(UNKNOWN, UNKNOWN, server);
    }

    public boolean LogServerShutdown(String server) {
        return this.LogServerShutdown(UNKNOWN, UNKNOWN, server);
    }

    public boolean LogUnspecifiedException(String action, String message) {
        return this.LogUnspecifiedException(UNKNOWN, UNKNOWN, action, message);
    }

    public boolean LogCBIUpstreamFailed(String transactionType, String transactionKey, String sequenceNo, String reason) {
        return this.LogCBIUpstreamFailed(UNKNOWN, UNKNOWN, transactionType, transactionKey, sequenceNo, reason);
    }

    public boolean LogCBIUpstreamSucceeded(String transactionType, String transactionKey) {
        return this.LogCBIUpstreamSucceeded(UNKNOWN, UNKNOWN, transactionType, transactionKey);
    }

    public boolean LogInvalidLicenseKey(String msgclass, String msgmethod) {
        String msg = "Invalid license key.";
        this.logAlert(635, this.m_facility, "LogInvalidLicenseKey: " + msg);
        return this.logMessage(msgclass, msgmethod, msg, 3);
    }

    public boolean LogSRMNotConnected(String msgclass, String msgmethod) {
        String msg = "SRM not connected";
        this.logAlert(640, this.m_facility, "LogSRMNotConnected: " + msg);
        return this.logMessage(msgclass, msgmethod, msg, 3);
    }

    public boolean LogSessionSoftLimitExceeded(String msgclass, String msgmethod, int numsessions) {
        String msgOut = "Session soft limit exceeded.  " + numsessions + " sessions currently set up.";
        this.logAlert(645, this.m_facility, "LogSessionSoftLimitExceeded: " + msgOut);
        return this.logMessage(msgclass, msgmethod, msgOut, 4);
    }

    public boolean LogSessionHardLimitExceeded(String msgclass, String msgmethod, int numsessions, String sessionid) {
        String msgOut = "Session hard limit exceeded.  " + numsessions + " sessions currently set up.  Failing session " + sessionid;
        this.logAlert(645, this.m_facility, "LogSessionHardLimitExceeded: " + msgOut);
        return this.logMessage(msgclass, msgmethod, msgOut, 3);
    }

    public boolean LogDiscardingDSMCCMessage(String msgclass, String msgmethod, String messagetype, String sessionid, int secondsInQueue, int timeout) {
        String logMsg = "Discarding '" + messagetype + "' message for session '" + sessionid + "': " + "message in queue for " + secondsInQueue + " seconds " + "(longer than " + timeout + " seconds)";
        this.logAlert(650, this.m_facility, "LogDiscardingDSMSCCMessage: " + logMsg);
        return this.logMessage(msgclass, msgmethod, logMsg, 3);
    }

    public boolean LogIncompleteResourceNegotiation(String msgclass, String msgmethod, String sessionid) {
        String logMsg = "Session '" + sessionid + "' destroyed " + "without receiving SessionAddResourceConfirm from DNCS";
        this.logAlert(655, this.m_facility, "LogDiscardingDSMSCCMessage: " + logMsg);
        return this.logMessage(msgclass, msgmethod, logMsg, 3);
    }

    public boolean LogSessionFailed(String msgclass, String msgmethod, String sessionid, String reason) {
        String msgOut = "Session '" + sessionid + "' failed:  " + reason;
        this.logAlert(665, this.m_facility, "LogSessionFailed: " + msgOut);
        return this.logMessage(msgclass, msgmethod, msgOut, 3);
    }

    public boolean LogFailedCatalog(String msgclass, String msgmethod, String errorMsg) {
        this.logAlert(1100, this.m_facility, "LogFailedCatalog: " + errorMsg);
        return this.logMessage(msgclass, msgmethod, errorMsg, 3);
    }

    public boolean LogLscpConnectionFailure(String msgclass, String msgmethod, InetSocketAddress lscpServer, InetSocketAddress client, long milliseconds, String message) {
        String logMsg = "Client " + client + " could not connect to LSCPServer " + lscpServer + " after " + milliseconds + " milliseconds: " + message;
        this.logAlert(400, this.m_facility, "LogLscpConnectionFailure: " + logMsg);
        return this.logMessage(msgclass, msgmethod, logMsg, 3);
    }

    public boolean LogPublishFailed(String msgclass, String msgmethod, String errorMsg) {
        this.logAlert(1110, this.m_facility, "LogPublishFailed: " + errorMsg);
        return this.logMessage(msgclass, msgmethod, errorMsg, 3);
    }

    public boolean LogSessionTooShort(String msgclass, String msgmethod, String sessionID, int qamtsid) {
        String errorMsg = "Suspected tuning problem for Session " + sessionID + " on QAM with output TSID of " + qamtsid;
        this.logAlert(700, this.m_facility, "LogSessionTooShort: " + errorMsg);
        return this.logMessage(msgclass, msgmethod, errorMsg, 3);
    }

    public boolean LogQAMRetirement(String msgclass, String msgmethod, int qamtsid, int errors, int interval) {
        String errorMsg = "Auto Retiring QAM with TSID of " + qamtsid + " for having " + errors + " errors in " + interval + " seconds";
        this.logAlert(710, this.m_facility, "LogQAMRetirement: " + errorMsg);
        return this.logMessage(msgclass, msgmethod, errorMsg, 3);
    }

    public boolean LogPassThruException(String msgclass, String msgmethod, String message) {
        this.logAlert(750, this.m_facility, message);
        return this.logMessage(msgclass, msgmethod, message, 3);
    }

    public boolean LogSettopError(String msgclass, String msgmethod, String terminalName, Date errorTime, int errorCode, String errorData) {
        String errorMsg = "terminalName: " + terminalName + "\ttime: " + errorTime + "\tcode: " + errorCode + "\tdata: " + errorData;
        if (errorCode == 5070 || errorCode == 5071 || errorCode == 5080) {
            this.logAlert(410, this.m_facility, "LogSettopError: " + errorMsg);
        } else if (errorCode <= 3999 && errorCode >= 1000 || errorCode == 5020 || errorCode == 5030) {
            this.logAlert(450, this.m_facility, "LogSettopError: " + errorMsg);
        }
        return this.logMessage(msgclass, msgmethod, errorMsg, 4);
    }

    public boolean LogRTIContentTransferFailed(String msgclass, String msgmethod, String packageName, String contentName, String contentStoreName, String reason) {
        String msg = String.format("RTI Content transfered failed on package %s for content %s on contentstore %s. Reason: %s", packageName, contentName, contentStoreName, reason);
        return this.logMessage(msgclass, msgmethod, msg, 3);
    }

    public boolean LogFreeMemory(String msgclass, String msgmethod, String msg) {
        Runtime rt = Runtime.getRuntime();
        long bytes = rt.maxMemory() - rt.totalMemory() + rt.freeMemory();
        String str = String.format("%s : Free memory = %,d Kb.", msg, bytes / 1024L);
        return this.logMessage(msgclass, msgmethod, str, 6);
    }
}

