/*
 * Decompiled with CFR 0.152.
 */
package com.n2bb.common.socket;

import com.n2bb.LogModule.N2BB_LogClient;
import com.n2bb.common.socket.SocketData;
import com.n2bb.common.util.Queue;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Iterator;

public abstract class ReaderThread
extends Thread {
    private String myclass = "ReaderThread";
    private Queue readQueue = new Queue();
    protected Selector selector = Selector.open();
    private boolean done = false;
    protected boolean pauseSelector = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(SelectableChannel channel) throws ClosedChannelException {
        ReaderThread readerThread = this;
        synchronized (readerThread) {
            this.pauseSelector = true;
        }
        this.selector.wakeup();
        channel.register(this.selector, 1);
        readerThread = this;
        synchronized (readerThread) {
            this.pauseSelector = false;
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregister(SelectableChannel channel) throws IOException {
        ReaderThread readerThread = this;
        synchronized (readerThread) {
            this.pauseSelector = true;
        }
        this.selector.wakeup();
        channel.close();
        readerThread = this;
        synchronized (readerThread) {
            this.pauseSelector = false;
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerListener(SelectableChannel channel) throws ClosedChannelException {
        ReaderThread readerThread = this;
        synchronized (readerThread) {
            this.pauseSelector = true;
        }
        this.selector.wakeup();
        channel.register(this.selector, 16);
        readerThread = this;
        synchronized (readerThread) {
            this.pauseSelector = false;
            this.notify();
        }
    }

    public void shutdown() {
        this.done = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void put(SocketData data) {
        Queue queue = this.readQueue;
        synchronized (queue) {
            this.readQueue.add(data);
            this.readQueue.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SocketData get() {
        SocketData retval = null;
        Queue queue = this.readQueue;
        synchronized (queue) {
            while (!this.done && (retval = (SocketData)this.readQueue.remove()) == null) {
                try {
                    this.readQueue.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        String mymethod = "run";
        while (!this.done) {
            ReaderThread readerThread = this;
            synchronized (readerThread) {
                if (this.pauseSelector) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                }
            }
            try {
                if (this.selector.select() <= 0) continue;
                Iterator<SelectionKey> it = this.selector.selectedKeys().iterator();
                while (it.hasNext()) {
                    SelectionKey currentKey = it.next();
                    it.remove();
                    this.handleKey(currentKey);
                }
            }
            catch (IOException io) {
                N2BB_LogClient.instance().logStackTrace(this.myclass, mymethod, "Caught IO Exception", (Throwable)io, 3);
            }
        }
    }

    protected void handleKey(SelectionKey currentKey) throws IOException {
        if (currentKey.isValid() && currentKey.isReadable()) {
            SelectableChannel sc = currentKey.channel();
            SocketData data = this.read(sc);
            this.put(data);
        }
    }

    protected abstract SocketData read(SelectableChannel var1);
}

