/*
 * Decompiled with CFR 0.152.
 */
package com.n2bb.common.socket;

import com.n2bb.common.socket.ConnectionManager;
import com.n2bb.common.socket.SocketData;
import com.n2bb.common.socket.UDPReaderThread;
import com.n2bb.common.socket.UDPWriterThread;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.SocketAddress;
import java.nio.channels.DatagramChannel;

public class UDPConnectionManager
extends ConnectionManager {
    private UDPWriterThread writer = new UDPWriterThread();
    private UDPReaderThread reader = new UDPReaderThread();

    public void start() {
        this.writer.start();
        this.reader.start();
    }

    public void shutdown() {
        this.reader.shutdown();
        this.reader.interrupt();
        this.writer.shutdown();
        this.writer.interrupt();
    }

    public DatagramChannel addChannel() throws IOException {
        DatagramChannel channel = DatagramChannel.open();
        channel.configureBlocking(false);
        this.reader.register(channel);
        return channel;
    }

    public DatagramChannel addListener(SocketAddress address) throws IOException {
        DatagramChannel channel = this.addChannel();
        DatagramSocket sock = channel.socket();
        sock.bind(address);
        return channel;
    }

    public void removeListener(DatagramChannel channel) {
        try {
            channel.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void write(SocketData data) {
        this.writer.put(data);
    }

    public SocketData read() {
        return this.reader.get();
    }
}

