/*
 * Decompiled with CFR 0.152.
 */
package com.n2bb.corba.orb;

import com.n2bb.LogModule.N2BB_LogClient;
import com.n2bb.corba.orb.OrbAccessory;
import com.n2bb.corba.orb.OrbProperties;
import java.util.Hashtable;
import java.util.Properties;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;

public class OrbUtility {
    public static final String myclass = "OrbUtility";
    Hashtable<String, OrbAccessory> m_orbMap = new Hashtable();
    String m_defOrb = "JacORB";
    private static OrbUtility m_instance = null;

    private OrbUtility(String defaultOrb) {
        this.m_defOrb = defaultOrb;
    }

    private OrbUtility() {
    }

    public static OrbUtility instance() {
        if (m_instance == null) {
            m_instance = new OrbUtility();
        }
        return m_instance;
    }

    public static OrbUtility instance(String defOrbVendor) {
        if (m_instance == null) {
            m_instance = new OrbUtility(defOrbVendor);
        }
        return m_instance;
    }

    OrbAccessory createOrbAccessory(String orbID, ORB orbRef) throws InvalidName {
        OrbAccessory oa = new OrbAccessory(orbID, orbRef);
        return oa;
    }

    public OrbAccessory getOrb() {
        return this.getOrb(this.m_defOrb);
    }

    public OrbAccessory getOrb(String orbType) {
        OrbProperties op = OrbProperties.getInstance(orbType);
        String orbID = op.getDefaultOrbID();
        OrbAccessory oa = this.m_orbMap.get(orbID);
        if (oa == null) {
            Properties props = op.getProperties(orbID);
            N2BB_LogClient.instance().debug(myclass, "getOrb", "preparing to create a new orb with props: " + props);
            ORB orb = this.initializeOrb(props);
            N2BB_LogClient.instance().debug(myclass, "getOrb", "Orb initialized...");
            try {
                oa = this.createOrbAccessory(orbID, orb);
                N2BB_LogClient.instance().debug(myclass, "getOrb", "OrbAccessory is created for orbID: " + orbID);
                this.m_orbMap.put(orbID, oa);
            }
            catch (Exception ex) {
                N2BB_LogClient.instance().error(myclass, "getOrb", "Exception in getOrb.  " + ex.getMessage());
                ex.printStackTrace();
            }
        }
        return oa;
    }

    public OrbAccessory getOrb(String orbType, String orbID) {
        OrbAccessory oa;
        ORB orb = null;
        N2BB_LogClient.instance().debug(myclass, "getOrb", "trying to obtain OrbAccessory for orbID: " + orbID);
        if (orbID == null || orbID.equals("")) {
            OrbProperties op = OrbProperties.getInstance(orbType);
            orbID = op.getDefaultOrbID();
        }
        if ((oa = this.m_orbMap.get(orbID)) == null) {
            N2BB_LogClient.instance().debug(myclass, "getOrb", "Could not find existing OrbAccessory for orbID: " + orbID);
            OrbProperties op = OrbProperties.getInstance(orbType);
            Properties props = op.getProperties(orbID);
            N2BB_LogClient.instance().debug(myclass, "getOrb", "preparing to create a new orb with props: " + props);
            orb = this.initializeOrb(props);
            N2BB_LogClient.instance().debug(myclass, "getOrb", "Orb initialized...");
            try {
                oa = this.createOrbAccessory(orbID, orb);
                N2BB_LogClient.instance().debug(myclass, "getOrb", "OrbAccessory is created for orbID: " + orbID);
                this.m_orbMap.put(orbID, oa);
            }
            catch (Exception ex) {
                N2BB_LogClient.instance().error(myclass, "getOrb", "Exception in getOrb.  " + ex.getMessage());
                ex.printStackTrace();
            }
        }
        return oa;
    }

    public OrbAccessory getOrb(String orbType, String[] args) {
        java.lang.Object orb = null;
        OrbProperties op = OrbProperties.getInstance(orbType);
        String orbID = op.getDefaultOrbID();
        return this.getOrb(orbType, orbID, args);
    }

    public OrbAccessory getOrb(String orbType, String orbID, String[] args) {
        ORB orb = null;
        OrbAccessory oa = this.m_orbMap.get(orbID);
        if (oa == null) {
            OrbProperties op = OrbProperties.getInstance(orbType);
            Properties props = op.getProperties(orbID);
            N2BB_LogClient.instance().debug(myclass, "getOrb", "preparing to create a new orb with props: " + props);
            orb = this.initializeOrb(args, props);
            N2BB_LogClient.instance().debug(myclass, "getOrb", "Orb initialized...");
            try {
                oa = this.createOrbAccessory(orbID, orb);
                N2BB_LogClient.instance().debug(myclass, "getOrb", "OrbAccessory is created for orbID: " + orbID);
                this.m_orbMap.put(orbID, oa);
            }
            catch (Exception ex) {
                N2BB_LogClient.instance().error(myclass, "getOrb", "Exception in getOrb.  " + ex.getMessage());
                ex.printStackTrace();
            }
        }
        return oa;
    }

    public OrbAccessory getOrb(String orbType, Properties props) {
        OrbProperties op = OrbProperties.getInstance(orbType);
        String orbID = op.extractOrbID(props);
        N2BB_LogClient.instance().debug(myclass, "getOrb", "Trying to obtain OrbAccessory with orbID: " + orbID);
        OrbAccessory oa = this.m_orbMap.get(orbID);
        if (oa == null) {
            N2BB_LogClient.instance().debug(myclass, "getOrb", "Could not find existing OrbAccessory for orbID: " + orbID);
            ORB orb = this.initializeOrb(props);
            N2BB_LogClient.instance().debug(myclass, "getOrb", "Orb initialized...");
            try {
                oa = this.createOrbAccessory(orbID, orb);
                N2BB_LogClient.instance().debug(myclass, "getOrb", "OrbAccessory is created for orbID: " + orbID);
                this.m_orbMap.put(orbID, oa);
            }
            catch (Exception ex) {
                N2BB_LogClient.instance().error(myclass, "getOrb", "Error occurred while creating OrbAccessory.  " + ex.getMessage());
                ex.printStackTrace();
            }
        } else {
            N2BB_LogClient.instance().debug(myclass, "getOrb", "Found existing OrbAccessory for orbID: " + orbID + ".  Use the existing orb.");
        }
        return oa;
    }

    public ORB initializeOrb(Properties props) {
        String[] args = new String[]{};
        return this.initializeOrb(args, props);
    }

    public ORB initializeOrb(String[] args, Properties props) {
        N2BB_LogClient.instance().debug(myclass, "initializeOrb", "Trying to initialize orb with props: " + props);
        ORB orb = ORB.init((String[])args, (Properties)props);
        return orb;
    }

    public static void main(String[] args) {
        try {
            System.out.println("Creating the OrbUtility.....");
            OrbUtility ou = OrbUtility.instance();
            System.out.println("Using the OrbUtility to get the OrbAccessory.....");
            OrbAccessory oa = ou.getOrb("JacORB", "TestJacorb", args);
            String[] strPath = new String[]{"Factories", "PackageFactory"};
            if (oa != null) {
                Object obj;
                System.out.println("Got the OrbAccessory....now, let's check the naming context...");
                if (oa.getNamingContext() != null) {
                    System.out.println("Got the naming context!!!!! Check the package factory now....");
                }
                if ((obj = oa.getFactoryObject(strPath)) != null) {
                    System.out.println("Able to resolve NameService and obtain a factory object from there!!!!!");
                } else {
                    System.out.println("Unable to resolve NameService and obtain a factory object from there");
                }
            }
            System.out.println("----------------------------------------------------");
            System.out.println("Second Go Through........\n");
            System.out.println("22222 Using the OrbUtility to get the OrbAccessory.....");
            OrbAccessory oa2 = ou.getOrb("JacORB", args);
            if (oa2 != null) {
                Object obj2;
                System.out.println("22222 Got the OrbAccessory....now, let's check the naming context...");
                if (oa2.getNamingContext() != null) {
                    System.out.println("22222 Got the naming context!!!!! Check the package factory now....");
                }
                if ((obj2 = oa2.getFactoryObject(strPath)) != null) {
                    System.out.println("22222 Able to resolve NameService and obtain a factory object from there!!!!!");
                } else {
                    System.out.println("22222 Unable to resolve NameService and obtain a factory object from there");
                }
            }
            System.out.println("************************************");
            System.out.println("Trying the first connectione again");
            if (oa != null) {
                Object obj;
                if (oa.getNamingContext() != null) {
                    System.out.println("11111111 Got the naming context!!!!! Check the package factory now....");
                }
                if ((obj = oa.getFactoryObject(strPath)) != null) {
                    System.out.println("11111111 Able to resolve NameService and obtain a factory object from there!!!!!");
                } else {
                    System.out.println("11111111 Unable to resolve NameService and obtain a factory object from there");
                }
            }
        }
        catch (Exception ex) {
            System.out.println("Caught exception : " + ex.toString());
            ex.printStackTrace();
        }
    }
}

