/*
 * Decompiled with CFR 0.152.
 */
package file.namingPersistence;

import file.namingPersistence.NamingObjectBase;
import file.namingPersistence.NamingObjectBaseRef;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import namingPersistence.NamingObject;
import namingPersistence.NamingObjectHome;
import namingPersistence.NamingObjectRef;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.Object;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;
import org.omg.CosPersistentState.CatalogBase;
import org.omg.CosPersistentState.NotFound;
import org.omg.CosPersistentState.StorageHomeBase;
import org.omg.CosPersistentState.StorageObject;
import org.omg.CosPersistentState.StorageObjectRef;
import org.omg.CosPersistentState.YieldRef;
import org.openorb.pss.connector.PID;
import org.openorb.pss.connector.PersistenceException;
import org.openorb.pss.connector.file.FileCatalogBase;
import org.openorb.pss.connector.file.FileKeyBag;
import org.openorb.pss.connector.file.NotFoundException;
import org.openorb.pss.connector.file.PersistentObject;
import org.openorb.pss.connector.file.PersistentObjectHome;

public class NamingObjectHomeBase
extends LocalObject
implements NamingObjectHome,
PersistentObjectHome {
    private final ArrayList _incarnations = new ArrayList();
    private CatalogBase _catalog;
    private PID _pid;

    public java.lang.Object find_by_short_pid(byte[] short_pid) throws NotFound {
        ArrayList arrayList = this._incarnations;
        synchronized (arrayList) {
            Iterator it = ((AbstractList)this._incarnations).iterator();
            while (it.hasNext()) {
                PersistentObject obj = (PersistentObject)it.next();
                if (!obj.getPID().is_same_short(short_pid)) continue;
                PersistentObject persistentObject = obj;
                return persistentObject;
            }
        }
        StorageObject obj = null;
        try {
            obj = ((FileCatalogBase)this._catalog).incarnate((StorageHomeBase)this, short_pid, "PSDL:namingPersistence/NamingObjectBase:1.0");
        }
        catch (NotFoundException ex) {
            throw new NotFound();
        }
        this.register_type_incarnation(obj);
        return obj;
    }

    public CatalogBase get_catalog() {
        return this._catalog;
    }

    public NamingObjectBase _create(String componentName, Object namingObj) {
        NamingObjectBase obj = (NamingObjectBase)((FileCatalogBase)this._catalog).create_object((StorageHomeBase)this, "PSDL:namingPersistence/NamingObjectBase:1.0");
        this.register_type_incarnation(obj);
        obj.componentName(componentName);
        obj.namingObj(namingObj);
        return obj;
    }

    public NamingObjectBase _create() {
        NamingObjectBase obj = (NamingObjectBase)((FileCatalogBase)this._catalog).create_object((StorageHomeBase)this, "PSDL:namingPersistence/NamingObjectBase:1.0");
        this.register_type_incarnation(obj);
        return obj;
    }

    public NamingObjectBaseRef _create(String componentName, Object namingObj, YieldRef yr) {
        NamingObjectBase obj = this._create(componentName, namingObj);
        return new NamingObjectBaseRef(obj.get_pid(), this._catalog);
    }

    public NamingObjectBaseRef _create(YieldRef yr) {
        NamingObjectBase obj = this._create();
        return new NamingObjectBaseRef(obj.get_pid(), this._catalog);
    }

    public NamingObject create(String componentName, Object namingObj) {
        NamingObjectBase obj = (NamingObjectBase)((FileCatalogBase)this._catalog).create_object((StorageHomeBase)this, "PSDL:namingPersistence/NamingObjectBase:1.0");
        this.register_type_incarnation(obj);
        obj.componentName(componentName);
        obj.namingObj(namingObj);
        return obj;
    }

    public NamingObject find_by_componentName(String componentName) throws NotFound {
        Enumeration _enum = ((FileCatalogBase)this._catalog).getSequentialAccess(this._pid);
        FileKeyBag _bag = null;
        while (_enum.hasMoreElements()) {
            _bag = (FileKeyBag)_enum.nextElement();
            if (_bag == null) break;
            String _tmp_componentName = _bag.input.read_string();
            Object _tmp_namingObj = _bag.input.read_Object();
            if (!componentName.equals(_tmp_componentName)) continue;
            return (NamingObject)this.find_by_short_pid(_bag.short_pid);
        }
        throw new NotFound();
    }

    public NamingObjectRef find_ref_by_componentName(String componentName) {
        Enumeration _enum = ((FileCatalogBase)this._catalog).getSequentialAccess(this._pid);
        FileKeyBag _bag = null;
        while (_enum.hasMoreElements()) {
            _bag = (FileKeyBag)_enum.nextElement();
            if (_bag == null) break;
            String _tmp_componentName = _bag.input.read_string();
            Object _tmp_namingObj = _bag.input.read_Object();
            if (!componentName.equals(_tmp_componentName)) continue;
            return new NamingObjectBaseRef(_bag.short_pid, this);
        }
        return null;
    }

    public void setPersistentLinks(CatalogBase catalog, PID pid) {
        this._catalog = catalog;
        this._pid = pid;
    }

    public StorageObjectRef create_reference(byte[] pid) {
        return new NamingObjectBaseRef(pid, this._catalog);
    }

    public StorageObject create_object() {
        return ((FileCatalogBase)this._catalog).create_empty_object((StorageHomeBase)this, "PSDL:namingPersistence/NamingObjectBase:1.0");
    }

    public PID getPID() {
        return this._pid;
    }

    public void remove_storage_type(PID pid) throws NotFoundException {
        this.unregister_type_incarnation(pid);
        ((FileCatalogBase)this._catalog).delete(this._pid, pid);
    }

    public boolean is_stored(PID pid) {
        return ((FileCatalogBase)this._catalog).stored(this._pid, pid);
    }

    public void refresh(PersistentObject storage_type) {
        try {
            InputStream input = ((FileCatalogBase)this._catalog).entry(this._pid, storage_type.getPID());
            storage_type.read(input);
        }
        catch (NotFoundException ex) {
            throw new PersistenceException(1, CompletionStatus.COMPLETED_NO);
        }
    }

    public void refreshAll() {
        ArrayList arrayList = this._incarnations;
        synchronized (arrayList) {
            Iterator it = ((AbstractList)this._incarnations).iterator();
            while (it.hasNext()) {
                this.refresh((PersistentObject)it.next());
            }
        }
    }

    public void flush(PersistentObject storage_type) {
        if (this._catalog.access_mode() != 1) {
            throw new PersistenceException("Bad access mode.", 6, CompletionStatus.COMPLETED_NO);
        }
        OutputStream output = ((FileCatalogBase)this._catalog).create_new_entry(this._pid, storage_type.getPID());
        storage_type.write(output);
        ((FileCatalogBase)this._catalog).entry(this._pid, storage_type.getPID(), output);
    }

    public StorageObject deref(PID pid) {
        try {
            return (StorageObject)this.find_by_short_pid(pid.short_value());
        }
        catch (NotFound notFound) {
            return null;
        }
    }

    private void register_type_incarnation(java.lang.Object type) {
        ArrayList arrayList = this._incarnations;
        synchronized (arrayList) {
            this._incarnations.add(type);
        }
    }

    private void unregister_type_incarnation(PID pid) {
        ArrayList arrayList = this._incarnations;
        synchronized (arrayList) {
            Iterator it = ((AbstractList)this._incarnations).iterator();
            while (it.hasNext()) {
                PersistentObject obj = (PersistentObject)it.next();
                if (!obj.getPID().is_same(pid)) continue;
                it.remove();
            }
            this._incarnations.trimToSize();
        }
    }
}

