/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.ins;

import java.util.Vector;
import namingPersistence.NamingContextHome;
import namingPersistence.NamingContextRef;
import namingPersistence.NamingObject;
import namingPersistence.NamingObjectHome;
import namingPersistence.NamingObjectRef;
import namingPersistence.ProxyNamingContext;
import namingPersistence.ProxyNamingContextHome;
import namingPersistence.ProxyNamingContextRef;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CosNaming.Binding;
import org.omg.CosNaming.BindingIteratorHolder;
import org.omg.CosNaming.BindingListHolder;
import org.omg.CosNaming.BindingType;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContext;
import org.omg.CosNaming.NamingContextExtHelper;
import org.omg.CosNaming.NamingContextExtPOA;
import org.omg.CosNaming.NamingContextExtPackage.InvalidAddress;
import org.omg.CosNaming.NamingContextPackage.AlreadyBound;
import org.omg.CosNaming.NamingContextPackage.CannotProceed;
import org.omg.CosNaming.NamingContextPackage.InvalidName;
import org.omg.CosNaming.NamingContextPackage.NotEmpty;
import org.omg.CosNaming.NamingContextPackage.NotFound;
import org.omg.CosNaming.NamingContextPackage.NotFoundReason;
import org.omg.PortableServer.POAPackage.WrongAdapter;
import org.omg.PortableServer.POAPackage.WrongPolicy;
import org.openorb.ins.BindingIteratorImpl;
import org.openorb.ins.CallbackManagerImpl;
import org.openorb.ins.callback.EventType;
import org.openorb.ns.util.NamingUtils;

public class NamingContextExImpl
extends NamingContextExtPOA {
    private ORB m_orb;
    private CallbackManagerImpl m_callback;
    private NamingContextHome m_ncHome;
    private NamingObjectHome m_noHome;
    private ProxyNamingContextHome m_pncHome;
    private static boolean s_shutdown = false;
    private namingPersistence.NamingContext m_nc_root;

    protected NamingContextExImpl(ORB orb, CallbackManagerImpl callback, NamingContextHome nc_home, NamingObjectHome no_home, ProxyNamingContextHome pnc_home) {
        this.m_orb = orb;
        this.m_callback = callback;
        this.m_ncHome = nc_home;
        this.m_noHome = no_home;
        this.m_pncHome = pnc_home;
    }

    public void bind(NameComponent[] n, Object obj) throws NotFound, CannotProceed, InvalidName, AlreadyBound {
        if (n.length == 0) {
            throw new InvalidName();
        }
        this.verbose("\nBind an object ( " + n[n.length - 1].id + " )");
        NameComponent[] componentName = this.getNameComponent(n);
        String componentName_str = NamingUtils.to_string(componentName);
        this.verbose("componentName :" + componentName_str);
        try {
            this.m_noHome.find_by_componentName(componentName_str);
            this.verbose(" NamingObject already bound " + componentName_str);
            throw new AlreadyBound();
        }
        catch (org.omg.CosPersistentState.NotFound ex) {
            this.m_noHome.create(componentName_str, obj);
            this.addNamingObject(componentName);
            this.m_callback.report_object_event(this.getPath(componentName), EventType.ADD, obj);
            return;
        }
    }

    public void rebind(NameComponent[] n, Object obj) throws NotFound, CannotProceed, InvalidName {
        if (n.length == 0) {
            throw new InvalidName();
        }
        this.verbose("\nRebind an object ( " + n[n.length - 1].id + " )");
        NameComponent[] componentName = this.getNameComponent(n);
        String componentName_str = NamingUtils.to_string(componentName);
        this.verbose("componentName : " + componentName_str);
        try {
            NamingObject no = this.m_noHome.find_by_componentName(componentName_str);
            this.verbose(" NamingObject already exist " + componentName_str);
            no.namingObj(obj);
        }
        catch (org.omg.CosPersistentState.NotFound ex) {
            this.m_noHome.create(componentName_str, obj);
            this.addNamingObject(componentName);
        }
        this.m_callback.report_object_event(this.getPath(componentName), EventType.UPDATE, obj);
    }

    public void bind_context(NameComponent[] n, NamingContext nc) throws NotFound, CannotProceed, InvalidName, AlreadyBound {
        if (n.length == 0) {
            throw new InvalidName();
        }
        this.verbose("Bind a context ( " + n[n.length - 1].id + " )");
        boolean is_local = ((ObjectImpl)nc)._is_local();
        this.verbose("is local : " + is_local);
        NameComponent[] componentName = this.getNameComponent(n);
        String componentName_str = NamingUtils.to_string(componentName);
        this.verbose("componentName : " + componentName_str);
        if (is_local) {
            try {
                this.m_ncHome.find_by_componentName(componentName_str);
                this.verbose(" NamingContext already exist " + componentName_str);
                throw new AlreadyBound();
            }
            catch (org.omg.CosPersistentState.NotFound ex) {
                try {
                    byte[] id = this._poa().reference_to_id((Object)nc);
                    namingPersistence.NamingContext namingContext = this.getNamingContext(id);
                    namingContext.componentName(componentName_str);
                    this.addNamingContext(componentName);
                }
                catch (WrongAdapter e) {
                    e.printStackTrace();
                }
                catch (WrongPolicy p) {
                    p.printStackTrace();
                }
            }
        } else {
            try {
                this.m_pncHome.find_by_componentName(componentName_str);
                this.verbose(" ProxyNamingContext already exist : " + componentName_str);
                throw new AlreadyBound();
            }
            catch (org.omg.CosPersistentState.NotFound ex) {
                this.m_pncHome.create(componentName_str, nc);
                this.addProxyNamingContext(componentName);
            }
        }
        this.verbose("CALLBACK BIND");
        this.m_callback.report_naming_context_event(this.getPath(componentName), EventType.ADD);
    }

    public void rebind_context(NameComponent[] n, NamingContext nc) throws NotFound, CannotProceed, InvalidName {
        if (n.length == 0) {
            throw new InvalidName();
        }
        this.verbose("Rebind a context ( " + n[n.length - 1].id + " )");
        NameComponent[] componentName = this.getNameComponent(n);
        String componentName_str = NamingUtils.to_string(componentName);
        boolean is_local = ((ObjectImpl)nc)._is_local();
        if (is_local) {
            try {
                this.m_ncHome.find_by_componentName(componentName_str);
                this.verbose(" NamingContext already exist " + componentName_str);
                this.unbind(n);
            }
            catch (org.omg.CosPersistentState.NotFound ex) {
                this.verbose("Warning: A NotFound exception occured while unbinding! " + (java.lang.Object)((java.lang.Object)ex));
            }
            try {
                byte[] id = this._poa().reference_to_id((Object)nc);
                namingPersistence.NamingContext namingContext = this.getNamingContext(id);
                if (!namingContext.componentName().equals("")) {
                    throw new CannotProceed(nc, n);
                }
                namingContext.componentName(componentName_str);
                this.addNamingContext(componentName);
            }
            catch (WrongAdapter e) {
                e.printStackTrace();
            }
            catch (WrongPolicy p) {
                p.printStackTrace();
            }
        } else {
            this.m_pncHome.create(componentName_str, nc);
            this.addProxyNamingContext(componentName);
        }
        this.m_callback.report_naming_context_event(this.getPath(componentName), EventType.UPDATE);
    }

    public Object resolve(NameComponent[] n) throws NotFound, CannotProceed, InvalidName {
        if (n.length == 0) {
            throw new InvalidName();
        }
        this.verbose("Resolve an object ( " + n[n.length - 1].id + " )");
        NameComponent[] componentName = this.getNameComponent(n);
        String componentName_str = NamingUtils.to_string(componentName);
        this.verbose("componentName : " + componentName_str);
        try {
            NamingObject no = this.m_noHome.find_by_componentName(componentName_str);
            return no.namingObj();
        }
        catch (org.omg.CosPersistentState.NotFound e) {
            try {
                namingPersistence.NamingContext nc = this.m_ncHome.find_by_componentName(componentName_str);
                return this.createReference(nc);
            }
            catch (org.omg.CosPersistentState.NotFound ex) {
                try {
                    ProxyNamingContext pnc = this.m_pncHome.find_by_componentName(componentName_str);
                    return pnc.ctx();
                }
                catch (org.omg.CosPersistentState.NotFound nf) {
                    this.verbose(" Object not found " + componentName_str);
                    throw new NotFound(NotFoundReason.missing_node, n);
                }
            }
        }
    }

    public void unbind(NameComponent[] n) throws NotFound, CannotProceed, InvalidName {
        if (n.length == 0) {
            throw new InvalidName();
        }
        this.verbose("Unbind ( " + n[n.length - 1].id + " )");
        NameComponent[] componentName = this.getNameComponent(n);
        String componentName_str = NamingUtils.to_string(componentName);
        this.verbose("componentName_str : " + componentName_str);
        try {
            namingPersistence.NamingContext nc = this.m_ncHome.find_by_componentName(componentName_str);
            this.verbose("unbind the namingContext : " + componentName_str);
            this.removeNamingContext(componentName);
            nc.componentName("");
            this.m_callback.report_naming_context_event(this.getPath(componentName), EventType.REMOVE);
        }
        catch (org.omg.CosPersistentState.NotFound ex) {
            try {
                ProxyNamingContext pnc = this.m_pncHome.find_by_componentName(componentName_str);
                this.verbose("unbind the ProxyNamingContext : " + componentName_str);
                this.removeProxyNamingContext(componentName);
                pnc.destroy_object();
                this.m_callback.report_naming_context_event(this.getPath(componentName), EventType.REMOVE);
            }
            catch (org.omg.CosPersistentState.NotFound e) {
                try {
                    NamingObject no = this.m_noHome.find_by_componentName(componentName_str);
                    this.verbose("unbind the naming object : " + componentName_str);
                    this.removeNamingObject(componentName);
                    no.destroy_object();
                    this.m_callback.report_naming_context_event(this.getPath(componentName), EventType.REMOVE);
                }
                catch (org.omg.CosPersistentState.NotFound e2) {
                    this.verbose(" node not found : " + componentName_str);
                    throw new NotFound(NotFoundReason.not_context, n);
                }
            }
        }
    }

    public NamingContext new_context() {
        this.verbose("Create a new context");
        NamingContextRef[] nc_children = new NamingContextRef[]{};
        NamingObjectRef[] no_children = new NamingObjectRef[]{};
        ProxyNamingContextRef[] pnc_children = new ProxyNamingContextRef[]{};
        namingPersistence.NamingContext newNamingContext = this.m_ncHome.create("", nc_children, no_children, pnc_children);
        return this.createReference(newNamingContext);
    }

    public NamingContext bind_new_context(NameComponent[] n) throws NotFound, AlreadyBound, CannotProceed, InvalidName {
        if (n.length == 0) {
            throw new InvalidName();
        }
        this.verbose("bind_new_context : " + NamingUtils.to_string(n));
        NamingContext nc = this.new_context();
        this.bind_context(n, nc);
        return nc;
    }

    public void destroy() throws NotEmpty {
        block12: {
            this.verbose("Destroy a NamingContext");
            namingPersistence.NamingContext nc = null;
            try {
                nc = this.getNamingContext();
                if (nc.equals(this.getNc_root())) {
                    if (NamingContextExImpl.is_shutdown()) {
                        this._orb().shutdown(false);
                        return;
                    }
                    throw new NO_PERMISSION();
                }
                NamingContextRef[] nc_children = nc.nc_children();
                NamingObjectRef[] no_children = nc.no_children();
                ProxyNamingContextRef[] pnc_children = nc.pnc_children();
                if (nc_children.length == 0 && no_children.length == 0 && pnc_children.length == 0) {
                    String componentName_str = nc.componentName();
                    this.verbose("componentName : " + componentName_str);
                    NameComponent[] componentName = null;
                    try {
                        componentName = NamingUtils.to_name(componentName_str);
                    }
                    catch (InvalidName in) {
                        System.out.println("Invalid Name");
                        return;
                    }
                    this.removeNamingContext(componentName);
                    nc.destroy_object();
                    NameComponent[] path = new NameComponent[componentName.length - 1];
                    int k = 1;
                    while (k < componentName.length) {
                        path[k - 1] = componentName[k];
                        ++k;
                    }
                    this.m_callback.report_naming_context_event(path, EventType.REMOVE);
                    break block12;
                }
                throw new NotEmpty();
            }
            catch (NotFound e) {
                ProxyNamingContext pnc = null;
                try {
                    pnc = this.getProxyNamingContext();
                    pnc.destroy_object();
                    String componentName_str = nc.componentName();
                    this.verbose("componentName : " + componentName_str);
                    NameComponent[] componentName = null;
                    try {
                        componentName = NamingUtils.to_name(componentName_str);
                    }
                    catch (InvalidName in) {
                        System.out.println("Invalid Name");
                        return;
                    }
                    this.m_callback.report_naming_context_event(this.getPath(componentName), EventType.REMOVE);
                }
                catch (NotFound ex) {
                    System.out.println(" Binding not found ! ");
                    return;
                }
            }
        }
    }

    public void list(int how_many, BindingListHolder bl, BindingIteratorHolder bi) {
        this.verbose("List all objects");
        int max = 0;
        namingPersistence.NamingContext nc = null;
        try {
            nc = this.getNamingContext();
        }
        catch (NotFound e) {
            e.printStackTrace();
            throw new OBJECT_NOT_EXIST();
        }
        this.verbose("nc : " + nc.componentName());
        NamingObjectRef[] no_children = nc.no_children();
        NamingContextRef[] nc_children = nc.nc_children();
        ProxyNamingContextRef[] pnc_children = nc.pnc_children();
        int bindings_size = no_children.length + nc_children.length + pnc_children.length;
        this.verbose("bindings_size " + bindings_size);
        Binding[] bindings = new Binding[bindings_size];
        int i = 0;
        while (i < no_children.length) {
            NamingObjectRef child = no_children[i];
            NamingObject namingObject = (NamingObject)child.deref();
            bindings[i] = this.getBinding(namingObject);
            ++i;
        }
        int i2 = 0;
        while (i2 < nc_children.length) {
            namingPersistence.NamingContext namingContext = (namingPersistence.NamingContext)nc_children[i2].deref();
            bindings[i2 + no_children.length] = this.getBinding(namingContext);
            ++i2;
        }
        int i3 = 0;
        while (i3 < pnc_children.length) {
            ProxyNamingContext proxyNamingContext = (ProxyNamingContext)pnc_children[i3].deref();
            bindings[i3 - pnc_children.length] = this.getBinding(proxyNamingContext);
            ++i3;
        }
        max = bindings_size < how_many ? bindings_size : how_many;
        this.verbose("max : " + max);
        bl.value = new Binding[max];
        int k = 0;
        while (k < max) {
            bl.value[k] = bindings[k];
            ++k;
        }
        this.verbose("how_many : " + how_many);
        this.verbose("bindings_size : " + bindings_size);
        if (how_many < bindings_size) {
            Vector<Binding> next = new Vector<Binding>();
            int i4 = how_many;
            while (i4 < bindings_size) {
                next.addElement(bindings[i4]);
                ++i4;
            }
            this.verbose(" next size : " + next.size());
            BindingIteratorImpl b = new BindingIteratorImpl(this.m_orb, next);
            bi.value = b._this();
        } else {
            bi.value = new BindingIteratorImpl(this.m_orb, new Vector())._this();
        }
    }

    public String to_string(NameComponent[] n) throws InvalidName {
        return NamingUtils.to_string(n);
    }

    public NameComponent[] to_name(String sn) throws InvalidName {
        this.verbose("to_name " + sn);
        return NamingUtils.to_name(sn);
    }

    public String to_url(String addr, String sn) throws InvalidAddress, InvalidName {
        this.verbose("Get an URL");
        return NamingUtils.to_url(addr, sn);
    }

    public Object resolve_str(String n) throws NotFound, CannotProceed, InvalidName {
        NameComponent[] name = NamingUtils.to_name(n);
        return this.resolve(name);
    }

    private String adaptName(String n) {
        StringBuffer str = new StringBuffer(n.length());
        int i = 0;
        while (i < n.length()) {
            char c = n.charAt(i);
            if (c == '/' || c == '.') {
                str.append("\\");
            }
            str.append(c);
            ++i;
        }
        return str.toString();
    }

    private String removeExtra(String n) {
        StringBuffer str = new StringBuffer(n.length());
        int i = 0;
        while (i < n.length()) {
            char c = n.charAt(i);
            if (c != '\\') {
                str.append(c);
            }
            ++i;
        }
        return str.toString();
    }

    private String checkFormat(String addr) throws InvalidAddress {
        Vector<String> list = new Vector<String>();
        try {
            int index;
            int old = 0;
            while (true) {
                if ((index = addr.indexOf(",", old)) == -1) break;
                list.addElement(addr.substring(old, index));
                old = index + 1;
            }
            list.addElement(addr.substring(old));
            int i = 0;
            while (i < list.size()) {
                String ad = (String)list.elementAt(i);
                index = addr.indexOf("@");
                if (index != -1 && (index = ad.substring(0, index).indexOf(".")) == -1) {
                    throw new InvalidAddress();
                }
                ++i;
            }
        }
        catch (InvalidAddress ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new InvalidAddress();
        }
        return addr;
    }

    private String adaptToURL(String sn) throws InvalidName {
        return sn;
    }

    private NameComponent[] getNameComponent(NameComponent[] n) throws NotFound {
        namingPersistence.NamingContext p_namingContext = this.getNamingContext();
        try {
            NameComponent[] currentName = NamingUtils.to_name(p_namingContext.componentName());
            NameComponent[] nameComponent = new NameComponent[n.length + currentName.length];
            int k = 0;
            while (k < currentName.length) {
                nameComponent[k] = currentName[k];
                ++k;
            }
            int k2 = 0;
            while (k2 < n.length) {
                nameComponent[currentName.length + k2] = n[k2];
                ++k2;
            }
            return nameComponent;
        }
        catch (InvalidName e) {
            e.printStackTrace();
            return null;
        }
    }

    private namingPersistence.NamingContext getNamingContext() throws NotFound {
        return this.getNamingContext(this._object_id());
    }

    private namingPersistence.NamingContext getNamingContext(byte[] pid) throws NotFound {
        this.verbose("getNamingContext");
        try {
            return (namingPersistence.NamingContext)this.m_ncHome.get_catalog().find_by_pid(pid);
        }
        catch (org.omg.CosPersistentState.NotFound nf) {
            throw new NotFound();
        }
    }

    private ProxyNamingContext getProxyNamingContext() throws NotFound {
        byte[] nc_id = this._object_id();
        try {
            return (ProxyNamingContext)this.m_pncHome.get_catalog().find_by_pid(nc_id);
        }
        catch (org.omg.CosPersistentState.NotFound nf) {
            throw new NotFound();
        }
    }

    private void addNamingContext(NameComponent[] componentName) {
        namingPersistence.NamingContext parent = null;
        try {
            this.verbose("addNamingContext : " + NamingUtils.to_string(componentName));
            NameComponent[] parentName = new NameComponent[componentName.length - 1];
            int i = 0;
            while (i < parentName.length) {
                parentName[i] = componentName[i];
                ++i;
            }
            this.verbose("parent nameComponent : " + NamingUtils.to_string(parentName));
            parent = this.m_ncHome.find_by_componentName(NamingUtils.to_string(parentName));
        }
        catch (org.omg.CosPersistentState.NotFound e) {
            e.printStackTrace();
            return;
        }
        catch (InvalidName ex) {
            ex.printStackTrace();
        }
        try {
            NamingContextRef namingContextRef = this.m_ncHome.find_ref_by_componentName(NamingUtils.to_string(componentName));
            NamingContextRef[] children = parent.nc_children();
            this.verbose("parent children : " + children.length);
            NamingContextRef[] update_children = new NamingContextRef[children.length + 1];
            int k = 0;
            while (k < update_children.length - 1) {
                update_children[k] = children[k];
                ++k;
            }
            update_children[update_children.length - 1] = namingContextRef;
            parent.nc_children(update_children);
        }
        catch (InvalidName e) {
            e.printStackTrace();
        }
    }

    private void addNamingObject(NameComponent[] componentName) {
        namingPersistence.NamingContext parent = null;
        try {
            this.verbose(" addNamingObject " + NamingUtils.to_string(componentName));
            NameComponent[] parentName = new NameComponent[componentName.length - 1];
            int i = 0;
            while (i < parentName.length) {
                parentName[i] = componentName[i];
                ++i;
            }
            String parentName_str = NamingUtils.to_string(parentName);
            this.verbose("parentName : " + parentName_str);
            parent = this.m_ncHome.find_by_componentName(parentName_str);
        }
        catch (org.omg.CosPersistentState.NotFound e) {
            e.printStackTrace();
        }
        catch (InvalidName ex) {
            ex.printStackTrace();
        }
        try {
            NamingObjectRef objectRef = this.m_noHome.find_ref_by_componentName(NamingUtils.to_string(componentName));
            NamingObjectRef[] children = parent.no_children();
            NamingObjectRef[] update_children = new NamingObjectRef[children.length + 1];
            int k = 0;
            while (k < update_children.length - 1) {
                update_children[k] = children[k];
                ++k;
            }
            update_children[update_children.length - 1] = objectRef;
            parent.no_children(update_children);
        }
        catch (InvalidName ex) {
            ex.printStackTrace();
        }
    }

    private void addProxyNamingContext(NameComponent[] componentName) {
        NameComponent[] parentName = new NameComponent[componentName.length - 1];
        int i = 0;
        while (i < parentName.length) {
            parentName[i] = componentName[i];
            ++i;
        }
        namingPersistence.NamingContext parent = null;
        try {
            parent = this.m_ncHome.find_by_componentName(NamingUtils.to_string(parentName));
        }
        catch (org.omg.CosPersistentState.NotFound e) {
            e.printStackTrace();
        }
        catch (InvalidName ex) {
            ex.printStackTrace();
        }
        try {
            ProxyNamingContextRef proxyNamingContextRef = this.m_pncHome.find_ref_by_componentName(NamingUtils.to_string(componentName));
            ProxyNamingContextRef[] children = parent.pnc_children();
            ProxyNamingContextRef[] update_children = new ProxyNamingContextRef[children.length + 1];
            int k = 0;
            while (k < update_children.length - 1) {
                update_children[k] = children[k];
                ++k;
            }
            update_children[update_children.length - 1] = proxyNamingContextRef;
            parent.pnc_children(update_children);
        }
        catch (InvalidName ex) {
            ex.printStackTrace();
        }
    }

    private void removeNamingObject(NameComponent[] componentName) {
        this.verbose("removeNamingObject");
        NameComponent[] parentName = new NameComponent[componentName.length - 1];
        int i = 0;
        while (i < parentName.length) {
            parentName[i] = componentName[i];
            ++i;
        }
        namingPersistence.NamingContext parent = null;
        try {
            parent = this.m_ncHome.find_by_componentName(NamingUtils.to_string(parentName));
        }
        catch (org.omg.CosPersistentState.NotFound e) {
            e.printStackTrace();
        }
        catch (InvalidName ex) {
            ex.printStackTrace();
        }
        try {
            NamingObjectRef objectRef = this.m_noHome.find_ref_by_componentName(NamingUtils.to_string(componentName));
            String objectRefName = ((NamingObject)objectRef.deref()).componentName();
            NamingObjectRef[] children = parent.no_children();
            NamingObjectRef[] update_children = new NamingObjectRef[children.length - 1];
            int index = children.length - 1;
            int k = 0;
            while (k < children.length - 1) {
                String childrenName = ((NamingObject)children[k].deref()).componentName();
                if (childrenName.equals(objectRefName)) {
                    index = k;
                    break;
                }
                update_children[k] = children[k];
                ++k;
            }
            int i2 = index + 1;
            while (i2 < children.length) {
                update_children[i2 - 1] = children[i2];
                ++i2;
            }
            parent.no_children(update_children);
        }
        catch (InvalidName ex) {
            ex.printStackTrace();
        }
    }

    private void removeNamingContext(NameComponent[] componentName) {
        this.verbose("removeNamingContext");
        NameComponent[] parentName = new NameComponent[componentName.length - 1];
        int i = 0;
        while (i < parentName.length) {
            parentName[i] = componentName[i];
            ++i;
        }
        namingPersistence.NamingContext parent = null;
        try {
            parent = this.m_ncHome.find_by_componentName(NamingUtils.to_string(parentName));
        }
        catch (org.omg.CosPersistentState.NotFound e) {
            e.printStackTrace();
        }
        catch (InvalidName ex) {
            ex.printStackTrace();
        }
        try {
            NamingContextRef objectRef = this.m_ncHome.find_ref_by_componentName(NamingUtils.to_string(componentName));
            String objectRefName = ((namingPersistence.NamingContext)objectRef.deref()).componentName();
            this.verbose("find ref  " + objectRefName);
            NamingContextRef[] children = parent.nc_children();
            NamingContextRef[] update_children = new NamingContextRef[children.length - 1];
            int index = children.length - 1;
            int k = 0;
            while (k < children.length - 1) {
                String childrenName = ((namingPersistence.NamingContext)children[k].deref()).componentName();
                this.verbose("children " + k + " " + childrenName);
                if (childrenName.equals(objectRefName)) {
                    index = k;
                    break;
                }
                update_children[k] = children[k];
                ++k;
            }
            this.verbose("index : " + index);
            int i2 = index + 1;
            while (i2 < children.length) {
                update_children[i2 - 1] = children[i2];
                ++i2;
            }
            parent.nc_children(update_children);
        }
        catch (InvalidName ex) {
            ex.printStackTrace();
        }
    }

    private void removeProxyNamingContext(NameComponent[] componentName) {
        NameComponent[] parentName = new NameComponent[componentName.length - 1];
        int i = 0;
        while (i < parentName.length) {
            parentName[i] = componentName[i];
            ++i;
        }
        namingPersistence.NamingContext parent = null;
        try {
            parent = this.m_ncHome.find_by_componentName(NamingUtils.to_string(parentName));
        }
        catch (org.omg.CosPersistentState.NotFound e) {
            e.printStackTrace();
        }
        catch (InvalidName ex) {
            ex.printStackTrace();
        }
        try {
            ProxyNamingContextRef objectRef = this.m_pncHome.find_ref_by_componentName(NamingUtils.to_string(componentName));
            String objectRefName = ((ProxyNamingContext)objectRef.deref()).componentName();
            ProxyNamingContextRef[] children = parent.pnc_children();
            ProxyNamingContextRef[] update_children = new ProxyNamingContextRef[children.length - 1];
            int index = children.length - 1;
            int k = 0;
            while (k < children.length - 1) {
                ProxyNamingContext context = (ProxyNamingContext)children[k].deref();
                String childrenName = context.componentName();
                if (childrenName.equals(objectRefName)) {
                    index = k;
                    break;
                }
                update_children[k] = children[k];
                ++k;
            }
            int i2 = index + 1;
            while (i2 < children.length) {
                update_children[i2 - 1] = children[i2];
                ++i2;
            }
            parent.pnc_children(update_children);
        }
        catch (InvalidName ex) {
            ex.printStackTrace();
        }
    }

    private NamingContext createReference(namingPersistence.NamingContext nc) {
        this.verbose("createReference");
        byte[] nc_pid = nc.get_pid();
        Object ncObj = null;
        try {
            ncObj = this._poa().create_reference_with_id(nc_pid, NamingContextExtHelper.id());
            return NamingContextExtHelper.narrow((Object)ncObj);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private Binding getBinding(NamingObject no) {
        this.verbose("getBinding namingObject");
        Binding binding = new Binding();
        try {
            NameComponent[] name = new NameComponent[1];
            NameComponent[] componentName = NamingUtils.to_name(no.componentName());
            name[0] = componentName[componentName.length - 1];
            binding.binding_name = name;
            binding.binding_type = BindingType.nobject;
        }
        catch (InvalidName e) {
            e.printStackTrace();
        }
        return binding;
    }

    private Binding getBinding(namingPersistence.NamingContext nc) {
        this.verbose("getBinding namingContext");
        Binding binding = new Binding();
        try {
            NameComponent[] name = new NameComponent[1];
            this.verbose("componentName : " + nc.componentName());
            NameComponent[] componentName = NamingUtils.to_name(nc.componentName());
            name[0] = componentName[componentName.length - 1];
            binding.binding_name = name;
            binding.binding_type = BindingType.ncontext;
        }
        catch (InvalidName e) {
            e.printStackTrace();
        }
        return binding;
    }

    private Binding getBinding(ProxyNamingContext pnc) {
        Binding binding = new Binding();
        try {
            NameComponent[] name = new NameComponent[1];
            NameComponent[] componentName = NamingUtils.to_name(pnc.componentName());
            name[0] = componentName[componentName.length - 1];
            binding.binding_name = name;
            binding.binding_type = BindingType.ncontext;
        }
        catch (InvalidName e) {
            e.printStackTrace();
        }
        return binding;
    }

    private NameComponent[] getPath(NameComponent[] componentName) {
        NameComponent[] path = new NameComponent[componentName.length - 1];
        int k = 1;
        while (k < componentName.length) {
            path[k - 1] = componentName[k];
            ++k;
        }
        return path;
    }

    private void verbose(String message) {
    }

    public static boolean is_shutdown() {
        return s_shutdown;
    }

    public static void set_shutdown(boolean shutdown) {
        s_shutdown = shutdown;
    }

    namingPersistence.NamingContext getNc_root() {
        return this.m_nc_root;
    }

    void setNc_root(namingPersistence.NamingContext nc_root) {
        this.m_nc_root = nc_root;
    }
}

