/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.ins;

import namingPersistence.NamingContext;
import namingPersistence.NamingContextHome;
import namingPersistence.NamingContextRef;
import namingPersistence.NamingObjectHome;
import namingPersistence.NamingObjectRef;
import namingPersistence.ProxyNamingContextHome;
import namingPersistence.ProxyNamingContextRef;
import org.apache.avalon.framework.CascadingRuntimeException;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CosNaming.NamingContextExt;
import org.omg.CosNaming.NamingContextExtHelper;
import org.omg.CosPersistentState.Connector;
import org.omg.CosPersistentState.ConnectorRegistry;
import org.omg.CosPersistentState.ConnectorRegistryHelper;
import org.omg.CosPersistentState.NotFound;
import org.omg.CosPersistentState.Parameter;
import org.omg.CosPersistentState.Session;
import org.omg.PortableServer.IdAssignmentPolicyValue;
import org.omg.PortableServer.IdUniquenessPolicyValue;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import org.omg.PortableServer.POAManagerPackage.AdapterInactive;
import org.omg.PortableServer.RequestProcessingPolicyValue;
import org.omg.PortableServer.Servant;
import org.omg.PortableServer.ServantRetentionPolicyValue;
import org.openorb.ins.CallbackManagerImpl;
import org.openorb.ins.NamingContextExImpl;
import org.openorb.util.service.ServiceBase;

public class Service
extends ServiceBase {
    public static final String PERSISTENCE_MEMORY = "memory";
    public static final String PERSISTENCE_MEMORY_CLASS = "org.openorb.pss.Memory";
    public static final String PERSISTENCE_FILE = "file";
    public static final String PERSISTENCE_FILE_CLASS = "org.openorb.pss.File";
    public static final String PERSISTENCE_DATABASE = "database";
    public static final String PERSISTENCE_DATABASE_CLASS = "org.openorb.pss.Database";
    public static final String OPT_PERSISTENCE = "p";
    public static final String OPT_PERSISTENCE_LONG = "persistenceType";
    public static final String OPT_PERSISTENCE_ARG_NAME = "type";
    public static final String OPT_PERSISTENCE_DESCRIP = "the persistence type to be used: \"memory\"|\"file\"|\"database\" (default: memory)";
    public static final String OPT_SHUTDOWN_ROOT = "s";
    public static final String OPT_SHUTDOWN_ROOT_LONG = "shutdownRoot";
    public static final String OPT_SHUTDOWN_ROOT_DESCRIP = "enable shutting down the root context";
    private POA m_root_poa = null;
    private POA m_ns_poa = null;

    private java.lang.Object createNSPOA() throws Exception {
        POA root_poa = POAHelper.narrow((Object)((POA)this.createPOA()));
        Policy[] policies = new Policy[]{root_poa.create_request_processing_policy(RequestProcessingPolicyValue.USE_DEFAULT_SERVANT), root_poa.create_servant_retention_policy(ServantRetentionPolicyValue.NON_RETAIN), root_poa.create_id_uniqueness_policy(IdUniquenessPolicyValue.MULTIPLE_ID), root_poa.create_id_assignment_policy(IdAssignmentPolicyValue.USER_ID)};
        return root_poa.create_POA("NSPOA", root_poa.the_POAManager(), policies);
    }

    public void initializeService() {
        try {
            ORB orb = (ORB)this.getContext().get((java.lang.Object)"ORB");
            if (orb != null) {
                this.m_root_poa = POAHelper.narrow((Object)((POA)this.createPOA()));
                this.m_ns_poa = POAHelper.narrow((Object)((POA)this.createNSPOA()));
                String persistence = this.getParameters().getParameter(OPT_PERSISTENCE, PERSISTENCE_MEMORY);
                String persistenceClass = PERSISTENCE_MEMORY_CLASS;
                if (persistence.equals(PERSISTENCE_FILE)) {
                    persistenceClass = PERSISTENCE_FILE_CLASS;
                } else if (persistence.equals(PERSISTENCE_DATABASE)) {
                    persistenceClass = PERSISTENCE_DATABASE_CLASS;
                } else if (!persistence.equals(PERSISTENCE_MEMORY)) {
                    this.getLogger().warn("Unknown persistency type '" + persistence + "', defaulting to memory persistence.");
                    persistence = PERSISTENCE_MEMORY;
                }
                this.initPSS(orb, persistenceClass, persistence + ".");
            }
        }
        catch (Exception ex) {
            this.getLogger().fatalError("Exception occured while initializing the service", (Throwable)ex);
            throw new CascadingRuntimeException("Problem while initializing the service", (Throwable)ex);
        }
    }

    public void startService() {
        try {
            if (this.m_root_poa != null) {
                this.m_root_poa.the_POAManager().activate();
            }
        }
        catch (AdapterInactive ex) {
            this.getLogger().fatalError("The POAManager is inactive!", (Throwable)ex);
            throw new CascadingRuntimeException("The POAManager is inactive!", (Throwable)ex);
        }
    }

    public void stopService() {
        try {
            if (this.m_root_poa != null) {
                this.m_root_poa.the_POAManager().deactivate(false, true);
            }
        }
        catch (AdapterInactive ex) {
            this.getLogger().fatalError("The POAManager is inactive!", (Throwable)ex);
            throw new CascadingRuntimeException("The POAManager is inactive!", (Throwable)ex);
        }
    }

    private void initPSS(ORB orb, String connectorClass, String connectorPrefix) {
        try {
            Object pss = orb.resolve_initial_references("PSS");
            ConnectorRegistry registry = ConnectorRegistryHelper.narrow((Object)pss);
            Connector connector = registry.find_connector(connectorClass);
            Service.register_factories(connector, connectorPrefix);
            Parameter[] parameters = new Parameter[]{};
            Session session = connector.create_basic_session((short)1, "", parameters);
            CallbackManagerImpl ns_callback = new CallbackManagerImpl();
            this.registerObject("CallbackManager", ns_callback._this(orb));
            NamingContextHome nc_home = (NamingContextHome)session.find_storage_home("PSDL:namingPersistence/NamingContextHomeBase:1.0");
            NamingObjectHome no_home = (NamingObjectHome)session.find_storage_home("PSDL:namingPersistence/NamingObjectHomeBase:1.0");
            ProxyNamingContextHome pcn_home = (ProxyNamingContextHome)session.find_storage_home("PSDL:namingPersistence/ProxyNamingContextHomeBase:1.0");
            NamingContextExImpl defaultNaming = new NamingContextExImpl(orb, ns_callback, nc_home, no_home, pcn_home);
            this.m_ns_poa.set_servant((Servant)defaultNaming);
            boolean bShutdown = this.getParameters().getParameterAsBoolean(OPT_SHUTDOWN_ROOT);
            NamingContextExImpl.set_shutdown(bShutdown);
            NamingContext rootNamingContext = null;
            try {
                rootNamingContext = nc_home.find_by_componentName("NameService");
            }
            catch (NotFound e) {
                NamingContextRef[] nc_children = new NamingContextRef[]{};
                NamingObjectRef[] no_children = new NamingObjectRef[]{};
                ProxyNamingContextRef[] pnc_children = new ProxyNamingContextRef[]{};
                rootNamingContext = nc_home.create("NameService", nc_children, no_children, pnc_children);
            }
            defaultNaming.setNc_root(rootNamingContext);
            byte[] root_pid = rootNamingContext.get_pid();
            NamingContextExt rootObj = NamingContextExtHelper.narrow((Object)this.m_ns_poa.create_reference_with_id(root_pid, NamingContextExtHelper.id()));
            this.registerObject("NamingContextExt", (Object)rootObj);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static void register_factories(Connector connector, String persistence_type) {
        try {
            connector.register_storage_object_factory("PSDL:namingPersistence/NamingContextBase:1.0", Thread.currentThread().getContextClassLoader().loadClass(persistence_type + "namingPersistence.NamingContextBase"));
            connector.register_storage_home_factory("PSDL:namingPersistence/NamingContextHomeBase:1.0", Thread.currentThread().getContextClassLoader().loadClass(persistence_type + "namingPersistence.NamingContextHomeBase"));
            connector.register_storage_object_factory("PSDL:namingPersistence/NamingObjectBase:1.0", Thread.currentThread().getContextClassLoader().loadClass(persistence_type + "namingPersistence.NamingObjectBase"));
            connector.register_storage_home_factory("PSDL:namingPersistence/NamingObjectHomeBase:1.0", Thread.currentThread().getContextClassLoader().loadClass(persistence_type + "namingPersistence.NamingObjectHomeBase"));
            connector.register_storage_object_factory("PSDL:namingPersistence/ProxyNamingContextBase:1.0", Thread.currentThread().getContextClassLoader().loadClass(persistence_type + "namingPersistence.ProxyNamingContextBase"));
            connector.register_storage_home_factory("PSDL:namingPersistence/ProxyNamingContextHomeBase:1.0", Thread.currentThread().getContextClassLoader().loadClass(persistence_type + "namingPersistence.ProxyNamingContextHomeBase"));
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }
}

