/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.ns.test.jndi;

import java.util.Hashtable;
import java.util.Properties;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameClassPair;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.UserException;
import org.omg.PortableServer.POA;
import org.openorb.ns.test.jndi.DummyPOA;
import org.openorb.tns.MapNamingContext;

public class NamingTest
extends TestCase {
    private MapNamingContext m_map_ctx = null;
    private Context m_root_ctx = null;
    private Object m_impl = null;
    private ORB m_orb;
    static /* synthetic */ Class class$org$openorb$ns$test$jndi$NamingTest;

    public NamingTest(String name) {
        super(name);
        String[] args = new String[]{};
        this.m_orb = ORB.init((String[])args, null);
        this.m_map_ctx = new MapNamingContext(this.m_orb, null, null);
        try {
            Properties props = new Properties();
            ((Hashtable)props).put("InitialRootContext", this.m_map_ctx.getRootCtxt());
            ((Hashtable)props).put("java.naming.factory.initial", "org.openorb.ns.jndi.CtxFactory");
            this.m_root_ctx = new InitialContext(props);
        }
        catch (NamingException ex) {
            Assert.fail((String)ex.toString());
        }
    }

    protected void setUp() {
        try {
            POA rootPOA = (POA)this.m_orb.resolve_initial_references("RootPOA");
            this.m_impl = new DummyImpl(rootPOA)._this(this.m_orb);
            rootPOA.the_POAManager().activate();
        }
        catch (UserException ex) {
            Assert.fail((String)("exception during setup:" + ex.toString()));
        }
    }

    protected void tearDown() {
    }

    private Context getInitialContext() {
        return this.m_root_ctx;
    }

    public void testBind() {
        try {
            Context ctx = this.getInitialContext();
            ctx.bind("new_target", (java.lang.Object)this.m_impl);
            try {
                ctx.bind("new_target", (java.lang.Object)this.m_impl);
                Assert.fail((String)"Able to bind twice");
            }
            catch (NameAlreadyBoundException nameAlreadyBoundException) {}
        }
        catch (NamingException ex) {
            Assert.fail((String)ex.toString());
        }
    }

    public void testCompose() {
        try {
            Context ctx = this.getInitialContext();
            String res = ctx.composeName("target", "prefix");
            Name name = ctx.composeName(new CompositeName("target"), new CompositeName("prefix"));
        }
        catch (NamingException ex) {
            Assert.fail((String)ex.toString());
        }
    }

    public void testRebind() {
        try {
            Context ctx = this.getInitialContext();
            ctx.rebind("target", (java.lang.Object)this.m_impl);
        }
        catch (NamingException ex) {
            Assert.fail((String)ex.toString());
        }
    }

    public void testResolve() {
        try {
            this.testRebind();
            Context ctx = this.getInitialContext();
            java.lang.Object obj1 = ctx.lookup("target");
            java.lang.Object object = ctx.lookupLink("target");
        }
        catch (NamingException ex) {
            Assert.fail((String)ex.toString());
        }
    }

    public void testUnbind() {
        try {
            this.testRebind();
            Context ctx = this.getInitialContext();
            ctx.unbind("target");
        }
        catch (NamingException ex) {
            Assert.fail((String)ex.toString());
        }
    }

    public void testSubContext() {
        try {
            Context ctx = this.getInitialContext();
            ctx.createSubcontext("sub");
            ctx.destroySubcontext("sub");
        }
        catch (NamingException ex) {
            Assert.fail((String)ex.toString());
        }
    }

    public void testError() {
        try {
            Context ctx = this.getInitialContext();
            Context sub = ctx.createSubcontext("sub");
            sub.bind("target1", (java.lang.Object)this.m_impl);
            try {
                ctx.destroySubcontext("sub");
                Assert.fail((String)"The subconstext should not be destroyed !");
            }
            catch (NamingException e) {
                sub.unbind("target1");
                sub.close();
                ctx.destroySubcontext("sub");
                return;
            }
        }
        catch (NamingException ex) {
            Assert.fail((String)ex.toString());
        }
    }

    public void testRename() {
        try {
            this.testRebind();
            Context ctx = this.getInitialContext();
            ctx.rename("target", "other");
            ctx.unbind("other");
        }
        catch (NamingException ex) {
            Assert.fail((String)ex.toString());
        }
    }

    public void testList() {
        try {
            Context ctx = this.getInitialContext();
            ctx.createSubcontext("sub");
            NamingEnumeration<NameClassPair> namingEnumeration = ctx.list("sub");
            namingEnumeration = ctx.listBindings("sub");
            CompositeName cname = new CompositeName("sub");
            NamingEnumeration<NameClassPair> namingEnumeration2 = ctx.list(cname);
        }
        catch (NamingException ex) {
            Assert.fail((String)ex.toString());
        }
    }

    public void testEnum() {
        try {
            Context ctx = this.getInitialContext();
            Context sub = ctx.createSubcontext("sub");
            sub.bind("target1", (java.lang.Object)this.m_impl);
            sub.bind("target2", (java.lang.Object)this.m_impl);
            sub.bind("target3", (java.lang.Object)this.m_impl);
            sub.bind("target4", (java.lang.Object)this.m_impl);
            sub.bind("target5", (java.lang.Object)this.m_impl);
            NamingEnumeration<NameClassPair> namingEnumeration = ctx.list("sub");
            while (namingEnumeration.hasMore()) {
                namingEnumeration.next();
            }
            namingEnumeration.close();
            sub.unbind("target1");
            sub.unbind("target2");
            sub.unbind("target3");
            sub.unbind("target4");
            sub.unbind("target5");
            ctx.destroySubcontext("sub");
        }
        catch (NamingException ex) {
            Assert.fail((String)ex.toString());
        }
    }

    public void testContextEnvironement() {
        try {
            Context ctx = this.getInitialContext();
            ctx.addToEnvironment("foo", "bar");
            Hashtable<?, ?> tbl = ctx.getEnvironment();
            if (tbl.get("foo") == null) {
                Assert.fail((String)"Incorrect environment");
            }
            ctx.removeFromEnvironment("foo");
        }
        catch (NamingException ex) {
            Assert.fail((String)ex.toString());
        }
    }

    public void testContextParser() {
        try {
            Context ctx = this.getInitialContext();
            NameParser parser = ctx.getNameParser("");
            Name name = parser.parse("a.b.c");
        }
        catch (NamingException ex) {
            Assert.fail((String)ex.toString());
        }
    }

    public static void main(String[] args) {
        TestRunner.run((Test)new TestSuite(class$org$openorb$ns$test$jndi$NamingTest == null ? (class$org$openorb$ns$test$jndi$NamingTest = NamingTest.class$("org.openorb.ns.test.jndi.NamingTest")) : class$org$openorb$ns$test$jndi$NamingTest));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class DummyImpl
    extends DummyPOA {
        private POA m_poa;

        DummyImpl(POA poa) {
            this.m_poa = poa;
        }

        public POA _default_POA() {
            return this.m_poa;
        }

        public void hello(String str) {
            System.out.println(str);
        }
    }
}

