/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.tns;

import java.io.OutputStream;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.avalon.framework.CascadingRuntimeException;
import org.apache.avalon.framework.logger.LogKitLogger;
import org.apache.avalon.framework.logger.Logger;
import org.apache.log.Hierarchy;
import org.apache.log.LogTarget;
import org.apache.log.Priority;
import org.apache.log.format.ExtendedPatternFormatter;
import org.apache.log.format.Formatter;
import org.apache.log.output.io.StreamTarget;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CosNaming.Binding;
import org.omg.CosNaming.BindingHolder;
import org.omg.CosNaming.BindingIterator;
import org.omg.CosNaming.BindingIteratorHelper;
import org.omg.CosNaming.BindingIteratorHolder;
import org.omg.CosNaming.BindingIteratorPOA;
import org.omg.CosNaming.BindingListHolder;
import org.omg.CosNaming.BindingType;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContext;
import org.omg.CosNaming.NamingContextExt;
import org.omg.CosNaming.NamingContextExtHelper;
import org.omg.CosNaming.NamingContextExtPOA;
import org.omg.CosNaming.NamingContextExtPackage.InvalidAddress;
import org.omg.CosNaming.NamingContextHolder;
import org.omg.CosNaming.NamingContextPackage.AlreadyBound;
import org.omg.CosNaming.NamingContextPackage.CannotProceed;
import org.omg.CosNaming.NamingContextPackage.InvalidName;
import org.omg.CosNaming.NamingContextPackage.NotEmpty;
import org.omg.CosNaming.NamingContextPackage.NotFound;
import org.omg.CosNaming.NamingContextPackage.NotFoundReason;
import org.omg.PortableServer.IdAssignmentPolicyValue;
import org.omg.PortableServer.IdUniquenessPolicyValue;
import org.omg.PortableServer.ImplicitActivationPolicyValue;
import org.omg.PortableServer.LifespanPolicyValue;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAManagerPackage.AdapterInactive;
import org.omg.PortableServer.POAPackage.AdapterAlreadyExists;
import org.omg.PortableServer.POAPackage.InvalidPolicy;
import org.omg.PortableServer.POAPackage.WrongAdapter;
import org.omg.PortableServer.POAPackage.WrongPolicy;
import org.omg.PortableServer.RequestProcessingPolicyValue;
import org.omg.PortableServer.Servant;
import org.omg.PortableServer.ServantRetentionPolicyValue;
import org.openorb.ns.util.NamingUtils;

public class MapNamingContext
extends TreeMap {
    public static final String DEFAULT_FORMAT = "[%{thread}] [%5.5{priority}] (%{category}): %{message}\\n%{throwable}";
    private Logger m_logger = null;
    private ORB m_orb;
    private Set m_subContexts = new HashSet();
    public static final int SHUTDOWN_DISALLOW = 0;
    public static final int SHUTDOWN_DESTROY_POA = 1;
    public static final int SHUTDOWN_DESTROY_ORB = 2;
    private int m_shutdownMode = 0;
    private NamingContextExt m_rootCtxt = null;
    private POA m_firstPOA;
    private POA m_ctxtPOA;
    private POA m_iterPOA;
    private NamingContextExtImpl m_ctxtImpl = new NamingContextExtImpl();
    private BindingIteratorImpl m_iterImpl = new BindingIteratorImpl();
    private static int s_nameservs = 0;
    private String m_endpoint = null;

    public static Logger createLogger(String name) {
        LogKitLogger result = null;
        try {
            Hierarchy hierarchy = new Hierarchy();
            hierarchy.setDefaultLogTarget((LogTarget)new StreamTarget((OutputStream)System.out, (Formatter)new ExtendedPatternFormatter(DEFAULT_FORMAT)));
            hierarchy.setDefaultPriority(Priority.INFO);
            result = new LogKitLogger(hierarchy.getLoggerFor(name));
        }
        catch (Throwable ex) {
            throw new CascadingRuntimeException("Unexpected exception while creating logger.", ex);
        }
        return result;
    }

    public Logger getLogger() {
        if (this.m_logger == null) {
            this.m_logger = MapNamingContext.createLogger("tns");
        }
        return this.m_logger;
    }

    public MapNamingContext(ORB orb, POA rootPOA, Logger logger) {
        if (logger != null) {
            this.m_logger = logger;
        }
        try {
            this.init(orb, rootPOA, null);
        }
        catch (AdapterAlreadyExists ex) {
            if (this.getLogger().isErrorEnabled()) {
                this.getLogger().error("The RootPOA already exists.", (Throwable)ex);
            }
            throw new INTERNAL("The RootPOA already exists (" + (java.lang.Object)((java.lang.Object)ex) + ")");
        }
    }

    private void init(ORB orb, POA rootPOA, String poaName) throws AdapterAlreadyExists {
        this.m_orb = orb;
        if (rootPOA == null) {
            try {
                rootPOA = (POA)orb.resolve_initial_references("RootPOA");
            }
            catch (org.omg.CORBA.ORBPackage.InvalidName ex) {
                if (this.getLogger().isErrorEnabled()) {
                    this.getLogger().error("Unable to resolve RootPOA.", (Throwable)ex);
                }
                throw new INTERNAL("Unable to resolve RootPOA (" + (java.lang.Object)((java.lang.Object)ex) + ")");
            }
        }
        Policy[] policies = new Policy[]{rootPOA.create_servant_retention_policy(ServantRetentionPolicyValue.NON_RETAIN), rootPOA.create_id_assignment_policy(IdAssignmentPolicyValue.USER_ID), rootPOA.create_id_uniqueness_policy(IdUniquenessPolicyValue.MULTIPLE_ID), rootPOA.create_implicit_activation_policy(ImplicitActivationPolicyValue.NO_IMPLICIT_ACTIVATION), rootPOA.create_lifespan_policy(LifespanPolicyValue.TRANSIENT), rootPOA.create_request_processing_policy(RequestProcessingPolicyValue.USE_DEFAULT_SERVANT)};
        try {
            this.m_firstPOA = this.m_ctxtPOA = rootPOA.create_POA(poaName == null ? "NameServ_" + s_nameservs++ : poaName, null, policies);
            policies[1] = rootPOA.create_id_assignment_policy(IdAssignmentPolicyValue.SYSTEM_ID);
            this.m_iterPOA = this.m_firstPOA.create_POA("_IterPOA", this.m_firstPOA.the_POAManager(), policies);
        }
        catch (InvalidPolicy ex) {
            if (this.getLogger().isErrorEnabled()) {
                this.getLogger().error("Invalid policy passed to POA creation.", (Throwable)ex);
            }
            throw new INTERNAL("Invalid policy passed to POA creation (" + (java.lang.Object)((java.lang.Object)ex) + ")");
        }
        try {
            this.m_ctxtPOA.set_servant((Servant)this.m_ctxtImpl);
            this.m_iterPOA.set_servant((Servant)this.m_iterImpl);
        }
        catch (WrongPolicy ex) {
            if (this.getLogger().isErrorEnabled()) {
                this.getLogger().error("POA has wrong policies.", (Throwable)ex);
            }
            throw new INTERNAL("POA has wrong policies (" + (java.lang.Object)((java.lang.Object)ex) + ")");
        }
        this.m_rootCtxt = NamingContextExtHelper.narrow((Object)this.m_ctxtPOA.create_reference_with_id(new byte[0], NamingContextExtHelper.id()));
    }

    public void activate() {
        try {
            this.m_ctxtPOA.the_POAManager().activate();
        }
        catch (AdapterInactive ex) {
            if (this.getLogger().isErrorEnabled()) {
                this.getLogger().error("Adapter is inactive.", (Throwable)ex);
            }
            throw new INTERNAL("Adapter is inactive (" + (java.lang.Object)((java.lang.Object)ex) + ")");
        }
    }

    public NamingContextExt getRootCtxt() {
        return this.m_rootCtxt;
    }

    public String getCorbaname(String str) {
        if (this.m_endpoint == null) {
            throw new IllegalStateException("Nameservice has not been bound as a corbaloc");
        }
        try {
            return NamingUtils.to_url(this.m_endpoint, str);
        }
        catch (InvalidName ex) {
            if (this.getLogger().isErrorEnabled()) {
                this.getLogger().error("Invalid name " + str + ".", (Throwable)ex);
            }
            throw new IllegalArgumentException("Invalid name " + str + " (" + (java.lang.Object)((java.lang.Object)ex) + ")");
        }
        catch (InvalidAddress ex) {
            if (this.getLogger().isErrorEnabled()) {
                this.getLogger().error("Address is invalid.", (Throwable)ex);
            }
            throw new IllegalArgumentException("Address is invalid (" + (java.lang.Object)((java.lang.Object)ex) + ")");
        }
    }

    public String getCorbaname(NameComponent[] name) {
        String str;
        if (this.m_endpoint == null) {
            throw new IllegalStateException("Nameservice has not been bound as a corbaloc");
        }
        try {
            str = this.m_ctxtImpl.to_string(name);
        }
        catch (InvalidName ex) {
            if (this.getLogger().isErrorEnabled()) {
                this.getLogger().error("Invalid name " + name + ".", (Throwable)ex);
            }
            throw new IllegalArgumentException("Invalid name " + name + " (" + (java.lang.Object)((java.lang.Object)ex) + ")");
        }
        return this.getCorbaname(str);
    }

    public boolean getAllowSelfDestruct() {
        return this.m_shutdownMode != 0;
    }

    public void setAllowSelfDestruct(boolean allowSelfDestruct) {
        this.m_shutdownMode = allowSelfDestruct ? 1 : 0;
    }

    public void setShutdownMode(int shutdownMode) {
        if (shutdownMode != 0 && shutdownMode != 1 && shutdownMode != 2) {
            throw new IllegalArgumentException("Illegal shutdown mode");
        }
        this.m_shutdownMode = shutdownMode;
    }

    public void deactivate(boolean waitForComplete) {
        this.m_ctxtPOA.destroy(true, waitForComplete);
    }

    public java.lang.Object put(java.lang.Object key, java.lang.Object value) {
        if (key == null) {
            throw new NullPointerException("Null keys cannot be used.");
        }
        if (value != null && !(value instanceof Object)) {
            throw new ClassCastException("Only org.omg.CORBA.Object may be used as values in this map.");
        }
        if (key instanceof String) {
            return this.putStr((String)key, (Object)value);
        }
        if (key instanceof NameComponent[]) {
            return this.putName((NameComponent[])key, (Object)value);
        }
        throw new ClassCastException("Key type not compatable.");
    }

    public Object putName(NameComponent[] name, Object obj) {
        String str;
        if (name.length == 0) {
            throw new IllegalArgumentException("Name is invalid: Zero length");
        }
        try {
            str = this.m_ctxtImpl.to_string(name);
        }
        catch (InvalidName ex) {
            if (this.getLogger().isErrorEnabled()) {
                this.getLogger().error("Invalid name " + name + ".", (Throwable)ex);
            }
            throw new IllegalArgumentException("Invalid name " + name + " (" + (java.lang.Object)((java.lang.Object)ex) + ")");
        }
        MapNamingContext mapNamingContext = this;
        synchronized (mapNamingContext) {
            if (this.m_subContexts.contains(str)) {
                throw new IllegalStateException("Name is bound to a context");
            }
            this.addContext(NamingUtils.parent(name));
            Object object = super.put(str, obj);
            return object;
        }
    }

    public Object putStr(String str, Object obj) {
        NameComponent[] name;
        if (str.length() == 0) {
            throw new IllegalArgumentException("Name is invalid: Zero length string");
        }
        boolean addBinding = true;
        if (str.endsWith("/")) {
            int pp = str.length() - 2;
            while (pp >= 0 && str.charAt(pp) == '\\') {
                --pp;
            }
            if (pp >= 0 && (str.length() - pp) % 2 == 0) {
                str = str.substring(0, str.length() - 2);
                addBinding = false;
            }
        }
        try {
            name = this.m_ctxtImpl.to_name(str);
        }
        catch (InvalidName ex) {
            if (this.getLogger().isErrorEnabled()) {
                this.getLogger().error("Invalid name " + str + ".", (Throwable)ex);
            }
            throw new IllegalArgumentException("Invalid name " + str + " (" + (java.lang.Object)((java.lang.Object)ex) + ")");
        }
        MapNamingContext mapNamingContext = this;
        synchronized (mapNamingContext) {
            if (addBinding) {
                if (this.m_subContexts.contains(str)) {
                    throw new IllegalStateException("Name is bound to a context");
                }
                this.addContext(NamingUtils.parent(name));
                Object object = super.put(str, obj);
                return object;
            }
            this.addContext(name);
            Object object = null;
            return object;
        }
    }

    public NamingContextExt addContext(String context) {
        NameComponent[] name;
        try {
            name = this.m_ctxtImpl.to_name(context);
        }
        catch (InvalidName ex) {
            if (this.getLogger().isErrorEnabled()) {
                this.getLogger().error("Invalid name " + context + ".", (Throwable)ex);
            }
            throw new IllegalArgumentException("Invalid name " + context + " (" + (java.lang.Object)((java.lang.Object)ex) + ")");
        }
        return this.addContext(name);
    }

    public NamingContextExt addContext(NameComponent[] name) {
        if (name.length == 0) {
            return this.m_rootCtxt;
        }
        String[] ctxt = new String[name.length];
        try {
            ctxt[name.length - 1] = this.m_ctxtImpl.to_string(name);
        }
        catch (InvalidName ex) {
            if (this.getLogger().isErrorEnabled()) {
                this.getLogger().error("Invalid name " + name + ".", (Throwable)ex);
            }
            throw new IllegalArgumentException("Invalid name " + name + " (" + (java.lang.Object)((java.lang.Object)ex) + ")");
        }
        int i = name.length - 2;
        while (i >= 0) {
            ctxt[i] = NamingUtils.parent(ctxt[i + 1]);
            --i;
        }
        NamingContextExt last = null;
        MapNamingContext mapNamingContext = this;
        synchronized (mapNamingContext) {
            int i2 = 0;
            while (i2 < ctxt.length) {
                java.lang.Object find = this.get(ctxt[i2]);
                if (find == null) break;
                if (!(find instanceof NamingContext)) {
                    throw new IllegalStateException("Could not create context \"" + ctxt[i2] + "\", already bound to object");
                }
                if (!this.m_subContexts.contains(ctxt[i2])) {
                    throw new IllegalStateException("Could not create context \"" + ctxt[i2] + "\", already bound to external context");
                }
                last = (NamingContextExt)find;
                ++i2;
            }
            while (i2 < ctxt.length) {
                last = this.m_ctxtImpl.createRef(ctxt[i2]);
                ++i2;
            }
        }
        return last;
    }

    public synchronized boolean removeContext(String context) {
        if (this.m_subContexts.remove(context)) {
            super.remove(context);
            super.subMap(context + '/', context + 48).clear();
            return true;
        }
        return false;
    }

    public synchronized boolean isContext(String context) {
        return this.m_subContexts.contains(context);
    }

    public void putAll(Map p1) {
        if (p1 instanceof MapNamingContext) {
            super.putAll(p1);
        } else {
            Iterator i = p1.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry e = i.next();
                this.put(e.getKey(), e.getValue());
            }
        }
    }

    private NameComponent[] tailOffExternal(String name, NamingContextHolder parent) throws NotFound {
        NameComponent[] rest;
        String par = name;
        while (par.length() > 0) {
            NameComponent[] rest2;
            java.lang.Object obj = this.get(par);
            if (obj == null) {
                par = NamingUtils.parent(par);
                continue;
            }
            try {
                rest2 = this.m_ctxtImpl.to_name(name.substring(par.length() + 1));
            }
            catch (InvalidName ex) {
                if (this.getLogger().isErrorEnabled()) {
                    this.getLogger().error("Invalid name " + name + ".", (Throwable)ex);
                }
                throw new INTERNAL("Invalid name " + name + " (" + (java.lang.Object)((java.lang.Object)ex) + ")");
            }
            if (obj instanceof NamingContext) {
                if (this.m_subContexts.contains(par)) {
                    throw new NotFound(NotFoundReason.missing_node, rest2);
                }
                parent.value = (NamingContext)obj;
                return rest2;
            }
            throw new NotFound(NotFoundReason.not_context, rest2);
        }
        try {
            rest = this.m_ctxtImpl.to_name(name);
        }
        catch (InvalidName ex) {
            if (this.getLogger().isErrorEnabled()) {
                this.getLogger().error("Invalid name " + name + ".", (Throwable)ex);
            }
            throw new INTERNAL("Invalid name " + name + " (" + (java.lang.Object)((java.lang.Object)ex) + ")");
        }
        throw new NotFound(NotFoundReason.missing_node, rest);
    }

    private void putToMap(String key, java.lang.Object value) {
        super.put(key, value);
    }

    private class BindingIteratorImpl
    extends BindingIteratorPOA {
        private Map m_iteratorData = new HashMap();

        private BindingIteratorImpl() {
        }

        public BindingIterator createIterator(String parent, String last, Iterator itt, SortedMap subMap) {
            IteratorData id = new IteratorData();
            id.setParent(parent);
            id.setLast(last);
            id.setItt(itt);
            id.setSubMap(subMap);
            try {
                BindingIterator bi = BindingIteratorHelper.narrow((Object)MapNamingContext.this.m_iterPOA.create_reference(BindingIteratorHelper.id()));
                this.m_iteratorData.put(new ByteSeqKey(MapNamingContext.this.m_iterPOA.reference_to_id((Object)bi)), id);
                return bi;
            }
            catch (WrongPolicy ex) {
                if (MapNamingContext.this.getLogger().isErrorEnabled()) {
                    MapNamingContext.this.getLogger().error("POA has wrong policies.", (Throwable)ex);
                }
                throw new INTERNAL("POA has wrong policies (" + (java.lang.Object)((java.lang.Object)ex) + ")");
            }
            catch (WrongAdapter ex) {
                if (MapNamingContext.this.getLogger().isErrorEnabled()) {
                    MapNamingContext.this.getLogger().error("Wrong adapter used.", (Throwable)ex);
                }
                throw new INTERNAL("Wrong adapter used (" + (java.lang.Object)((java.lang.Object)ex) + ")");
            }
        }

        public void destroy() {
            MapNamingContext mapNamingContext = MapNamingContext.this;
            synchronized (mapNamingContext) {
                if (this.m_iteratorData.remove(this.getKey()) == null) {
                    throw new OBJECT_NOT_EXIST(0, CompletionStatus.COMPLETED_YES);
                }
            }
        }

        public boolean next_one(BindingHolder b) {
            boolean rootParent;
            Map.Entry next = null;
            MapNamingContext mapNamingContext = MapNamingContext.this;
            synchronized (mapNamingContext) {
                IteratorData id = (IteratorData)this.m_iteratorData.get(this.getKey());
                if (id == null) {
                    throw new OBJECT_NOT_EXIST(0, CompletionStatus.COMPLETED_YES);
                }
                rootParent = id.getParent().length() == 0;
                while (next == null && id.getItt().hasNext()) {
                    try {
                        do {
                            next = (Map.Entry)id.getItt().next();
                            id.setLast((String)next.getKey());
                            String tpar = NamingUtils.parent(id.getLast());
                            if (tpar.equals(id.getParent())) continue;
                            id.setSubMap(id.getSubMap().tailMap(tpar + 48));
                            id.setItt(id.getSubMap().entrySet().iterator());
                            next = null;
                        } while (next == null && id.getItt().hasNext());
                    }
                    catch (ConcurrentModificationException ex) {
                        id.setSubMap(id.getSubMap().tailMap(id.getLast() + '\u0000'));
                        id.setItt(id.getSubMap().entrySet().iterator());
                    }
                }
            }
            if (next == null) {
                b.value = new Binding(new NameComponent[0], BindingType.nobject);
                return false;
            }
            b.value = next.getValue() instanceof NamingContext ? new Binding(null, BindingType.ncontext) : new Binding(null, BindingType.nobject);
            String name = (String)next.getKey();
            if (!rootParent) {
                name = name.substring(NamingUtils.parent(name).length() + 1);
            }
            try {
                b.value.binding_name = MapNamingContext.this.m_ctxtImpl.to_name(name);
            }
            catch (InvalidName ex) {
                if (MapNamingContext.this.getLogger().isErrorEnabled()) {
                    MapNamingContext.this.getLogger().error("Invalid name " + name + ".", (Throwable)ex);
                }
                throw new INTERNAL("Invalid name " + name + " (" + (java.lang.Object)((java.lang.Object)ex) + ")");
            }
            return true;
        }

        public boolean next_n(int how_many, BindingListHolder bl) {
            boolean rootParent;
            int count = 0;
            Map.Entry[] ents = new Map.Entry[how_many];
            MapNamingContext mapNamingContext = MapNamingContext.this;
            synchronized (mapNamingContext) {
                IteratorData id = (IteratorData)this.m_iteratorData.get(this.getKey());
                if (id == null) {
                    throw new OBJECT_NOT_EXIST(0, CompletionStatus.COMPLETED_YES);
                }
                rootParent = id.getParent().length() == 0;
                while (count < how_many && id.getItt().hasNext()) {
                    try {
                        do {
                            ents[count] = (Map.Entry)id.getItt().next();
                            id.setLast((String)ents[count].getKey());
                            String tpar = NamingUtils.parent(id.getLast());
                            if (tpar.equals(id.getParent())) {
                                ++count;
                                continue;
                            }
                            id.setSubMap(id.getSubMap().tailMap(tpar + 48));
                            id.setItt(id.getSubMap().entrySet().iterator());
                        } while (count < how_many && id.getItt().hasNext());
                    }
                    catch (ConcurrentModificationException ex) {
                        id.setSubMap(id.getSubMap().tailMap(id.getLast() + '\u0000'));
                        id.setItt(id.getSubMap().entrySet().iterator());
                    }
                }
            }
            if (count == 0) {
                bl.value = new Binding[0];
                return false;
            }
            Binding[] ret = new Binding[count];
            try {
                int i = 0;
                while (i < count) {
                    ret[i] = ents[i].getValue() instanceof NamingContext ? new Binding(null, BindingType.ncontext) : new Binding(null, BindingType.nobject);
                    String name = (String)ents[i].getKey();
                    if (!rootParent) {
                        name = name.substring(NamingUtils.parent(name).length() + 1);
                    }
                    ret[i].binding_name = MapNamingContext.this.m_ctxtImpl.to_name(name);
                    ++i;
                }
            }
            catch (InvalidName ex) {
                if (MapNamingContext.this.getLogger().isErrorEnabled()) {
                    MapNamingContext.this.getLogger().error("Invalid Name", (Throwable)ex);
                }
                throw new INTERNAL(ex.toString());
            }
            bl.value = ret;
            return true;
        }

        private java.lang.Object getKey() {
            return new ByteSeqKey(this._object_id());
        }
    }

    private static class IteratorData {
        private String m_parent;
        private String m_last;
        private Iterator m_itt;
        private SortedMap m_subMap;

        private IteratorData() {
        }

        private String getParent() {
            return this.m_parent;
        }

        private void setParent(String parent) {
            this.m_parent = parent;
        }

        private String getLast() {
            return this.m_last;
        }

        private void setLast(String last) {
            this.m_last = last;
        }

        private Iterator getItt() {
            return this.m_itt;
        }

        private void setItt(Iterator itt) {
            this.m_itt = itt;
        }

        private SortedMap getSubMap() {
            return this.m_subMap;
        }

        private void setSubMap(SortedMap subMap) {
            this.m_subMap = subMap;
        }
    }

    private class NamingContextExtImpl
    extends NamingContextExtPOA {
        private NamingContextExtImpl() {
        }

        public Object resolve(NameComponent[] n) throws NotFound, CannotProceed, InvalidName {
            NameComponent[] parent_name;
            NamingContextHolder parent;
            if (n.length == 0) {
                throw new InvalidName();
            }
            String name = this.getPrefix() + this.to_string(n);
            MapNamingContext mapNamingContext = MapNamingContext.this;
            synchronized (mapNamingContext) {
                if (MapNamingContext.this.m_rootCtxt == null) {
                    if (MapNamingContext.this.m_shutdownMode == 1) {
                        throw new OBJECT_NOT_EXIST(0, CompletionStatus.COMPLETED_YES);
                    }
                    throw new COMM_FAILURE(0, CompletionStatus.COMPLETED_NO);
                }
                if (MapNamingContext.this.containsKey(name)) {
                    Object object = (Object)MapNamingContext.this.get(name);
                    return object;
                }
                parent = new NamingContextHolder();
                parent_name = MapNamingContext.this.tailOffExternal(name, parent);
            }
            return parent.value.resolve(parent_name);
        }

        public Object resolve_str(String name) throws NotFound, CannotProceed, InvalidName {
            NameComponent[] parent_name;
            NamingContextHolder parent;
            this.to_name(name);
            name = this.getPrefix() + name;
            MapNamingContext mapNamingContext = MapNamingContext.this;
            synchronized (mapNamingContext) {
                if (MapNamingContext.this.m_rootCtxt == null) {
                    if (MapNamingContext.this.m_shutdownMode == 1) {
                        throw new OBJECT_NOT_EXIST(0, CompletionStatus.COMPLETED_YES);
                    }
                    throw new COMM_FAILURE(0, CompletionStatus.COMPLETED_NO);
                }
                if (MapNamingContext.this.containsKey(name)) {
                    Object object = (Object)MapNamingContext.this.get(name);
                    return object;
                }
                parent = new NamingContextHolder();
                parent_name = MapNamingContext.this.tailOffExternal(name, parent);
            }
            return parent.value.resolve(parent_name);
        }

        public void bind(NameComponent[] n, Object obj) throws NotFound, CannotProceed, InvalidName, AlreadyBound {
            NameComponent[] parent_name;
            NamingContextHolder parent;
            if (n.length == 0) {
                throw new InvalidName();
            }
            String name = this.getPrefix() + this.to_string(n);
            String cname = NamingUtils.parent(name);
            MapNamingContext mapNamingContext = MapNamingContext.this;
            synchronized (mapNamingContext) {
                if (MapNamingContext.this.m_rootCtxt == null) {
                    if (MapNamingContext.this.m_shutdownMode == 1) {
                        throw new OBJECT_NOT_EXIST(0, CompletionStatus.COMPLETED_YES);
                    }
                    throw new COMM_FAILURE(0, CompletionStatus.COMPLETED_NO);
                }
                if (MapNamingContext.this.containsKey(name)) {
                    throw new AlreadyBound();
                }
                if (cname.length() == 0 || MapNamingContext.this.m_subContexts.contains(cname)) {
                    MapNamingContext.this.putToMap(name, obj);
                    return;
                }
                parent = new NamingContextHolder();
                parent_name = MapNamingContext.this.tailOffExternal(name, parent);
            }
            parent.value.bind(parent_name, obj);
        }

        public void rebind(NameComponent[] n, Object obj) throws NotFound, CannotProceed, InvalidName {
            NameComponent[] parent_name;
            NamingContextHolder parent;
            if (n.length == 0) {
                throw new InvalidName();
            }
            String name = this.getPrefix() + this.to_string(n);
            String cname = NamingUtils.parent(name);
            MapNamingContext mapNamingContext = MapNamingContext.this;
            synchronized (mapNamingContext) {
                if (MapNamingContext.this.m_rootCtxt == null) {
                    if (MapNamingContext.this.m_shutdownMode == 1) {
                        throw new OBJECT_NOT_EXIST(0, CompletionStatus.COMPLETED_YES);
                    }
                    throw new COMM_FAILURE(0, CompletionStatus.COMPLETED_NO);
                }
                if (MapNamingContext.this.m_subContexts.contains(name)) {
                    NamingContextExt ref;
                    if (((Object)MapNamingContext.this.get(name))._is_equivalent(obj)) {
                        return;
                    }
                    if (cname.length() != 0) {
                        ref = (NamingContextExt)MapNamingContext.this.get(cname);
                        if (ref == null) {
                            ref = this.createRef(cname);
                        }
                    } else {
                        ref = MapNamingContext.this.m_rootCtxt;
                    }
                    throw new CannotProceed((NamingContext)ref, new NameComponent[]{n[n.length - 1]});
                }
                if (cname.length() == 0 || MapNamingContext.this.m_subContexts.contains(cname)) {
                    MapNamingContext.this.putToMap(name, obj);
                    return;
                }
                parent = new NamingContextHolder();
                parent_name = MapNamingContext.this.tailOffExternal(name, parent);
            }
            parent.value.rebind(parent_name, obj);
        }

        public void unbind(NameComponent[] n) throws NotFound, CannotProceed, InvalidName {
            NameComponent[] parent_name;
            NamingContextHolder parent;
            if (n.length == 0) {
                throw new InvalidName();
            }
            String name = this.getPrefix() + this.to_string(n);
            MapNamingContext mapNamingContext = MapNamingContext.this;
            synchronized (mapNamingContext) {
                if (MapNamingContext.this.m_rootCtxt == null) {
                    if (MapNamingContext.this.m_shutdownMode == 1) {
                        throw new OBJECT_NOT_EXIST(0, CompletionStatus.COMPLETED_YES);
                    }
                    throw new COMM_FAILURE(0, CompletionStatus.COMPLETED_NO);
                }
                if (MapNamingContext.this.m_subContexts.contains(name)) {
                    NamingContextExt ref;
                    String cname = NamingUtils.parent(name);
                    if (cname.length() != 0) {
                        ref = (NamingContextExt)MapNamingContext.this.get(cname);
                        if (ref == null) {
                            ref = this.createRef(cname);
                        }
                    } else {
                        ref = MapNamingContext.this.m_rootCtxt;
                    }
                    throw new CannotProceed((NamingContext)ref, new NameComponent[]{n[n.length - 1]});
                }
                if (MapNamingContext.this.remove(name) != null) {
                    return;
                }
                parent = new NamingContextHolder();
                parent_name = MapNamingContext.this.tailOffExternal(name, parent);
            }
            parent.value.unbind(parent_name);
        }

        public NamingContext bind_new_context(NameComponent[] n) throws NotFound, AlreadyBound, CannotProceed, InvalidName {
            NameComponent[] parent_name;
            NamingContextHolder parent;
            if (n.length == 0) {
                throw new InvalidName();
            }
            String name = this.getPrefix() + this.to_string(n);
            String cname = NamingUtils.parent(name);
            MapNamingContext mapNamingContext = MapNamingContext.this;
            synchronized (mapNamingContext) {
                if (MapNamingContext.this.m_rootCtxt == null) {
                    if (MapNamingContext.this.m_shutdownMode == 1) {
                        throw new OBJECT_NOT_EXIST(0, CompletionStatus.COMPLETED_YES);
                    }
                    throw new COMM_FAILURE(0, CompletionStatus.COMPLETED_NO);
                }
                if (MapNamingContext.this.containsKey(name)) {
                    throw new AlreadyBound();
                }
                if (cname.length() == 0 || MapNamingContext.this.m_subContexts.contains(cname)) {
                    NamingContextExt namingContextExt = this.createRef(name);
                    return namingContextExt;
                }
                parent = new NamingContextHolder();
                parent_name = MapNamingContext.this.tailOffExternal(name, parent);
            }
            return parent.value.bind_new_context(parent_name);
        }

        public void bind_context(NameComponent[] n, NamingContext nc) throws NotFound, CannotProceed, InvalidName, AlreadyBound {
            NameComponent[] parent_name;
            NamingContextHolder parent;
            if (n.length == 0) {
                throw new InvalidName();
            }
            String name = this.getPrefix() + this.to_string(n);
            String cname = NamingUtils.parent(name);
            MapNamingContext mapNamingContext = MapNamingContext.this;
            synchronized (mapNamingContext) {
                if (MapNamingContext.this.m_rootCtxt == null) {
                    if (MapNamingContext.this.m_shutdownMode == 1) {
                        throw new OBJECT_NOT_EXIST(0, CompletionStatus.COMPLETED_YES);
                    }
                    throw new COMM_FAILURE(0, CompletionStatus.COMPLETED_NO);
                }
                if (MapNamingContext.this.containsKey(name)) {
                    throw new AlreadyBound();
                }
                if (cname.length() == 0 || MapNamingContext.this.m_subContexts.contains(cname)) {
                    MapNamingContext.this.putToMap(name, nc);
                    return;
                }
                parent = new NamingContextHolder();
                parent_name = MapNamingContext.this.tailOffExternal(name, parent);
            }
            parent.value.bind_context(parent_name, nc);
        }

        public void rebind_context(NameComponent[] n, NamingContext nc) throws NotFound, CannotProceed, InvalidName {
            NameComponent[] parent_name;
            NamingContextHolder parent;
            if (n.length == 0) {
                throw new InvalidName();
            }
            String name = this.getPrefix() + this.to_string(n);
            String cname = NamingUtils.parent(name);
            MapNamingContext mapNamingContext = MapNamingContext.this;
            synchronized (mapNamingContext) {
                if (MapNamingContext.this.m_rootCtxt == null) {
                    if (MapNamingContext.this.m_shutdownMode == 1) {
                        throw new OBJECT_NOT_EXIST(0, CompletionStatus.COMPLETED_YES);
                    }
                    throw new COMM_FAILURE(0, CompletionStatus.COMPLETED_NO);
                }
                if (MapNamingContext.this.m_subContexts.contains(name)) {
                    NamingContextExt ref;
                    if (((Object)MapNamingContext.this.get(name))._is_equivalent((Object)nc)) {
                        return;
                    }
                    if (cname.length() != 0) {
                        ref = (NamingContextExt)MapNamingContext.this.get(cname);
                        if (ref == null) {
                            ref = this.createRef(cname);
                        }
                    } else {
                        ref = MapNamingContext.this.m_rootCtxt;
                    }
                    throw new CannotProceed((NamingContext)ref, new NameComponent[]{n[n.length - 1]});
                }
                if (cname.length() == 0 || MapNamingContext.this.m_subContexts.contains(cname)) {
                    MapNamingContext.this.putToMap(name, nc);
                    return;
                }
                parent = new NamingContextHolder();
                parent_name = MapNamingContext.this.tailOffExternal(name, parent);
            }
            parent.value.rebind_context(parent_name, nc);
        }

        public NamingContext new_context() {
            MapNamingContext newImpl = new MapNamingContext(this._orb(), MapNamingContext.this.m_firstPOA, MapNamingContext.this.getLogger());
            newImpl.m_firstPOA = MapNamingContext.this.m_firstPOA;
            newImpl.setAllowSelfDestruct(true);
            return newImpl.getRootCtxt();
        }

        public void destroy() throws NotEmpty {
            String name = this.getPrefix();
            if (name.length() == 0) {
                MapNamingContext mapNamingContext = MapNamingContext.this;
                synchronized (mapNamingContext) {
                    if (!MapNamingContext.this.isEmpty()) {
                        throw new NotEmpty();
                    }
                    if (MapNamingContext.this.m_shutdownMode == 0) {
                        throw new NO_PERMISSION();
                    }
                    MapNamingContext.this.m_rootCtxt = null;
                }
                if (MapNamingContext.this.m_shutdownMode == 1) {
                    MapNamingContext.this.m_ctxtPOA.destroy(true, false);
                } else {
                    this._orb().shutdown(false);
                }
                return;
            }
            name = name.substring(0, name.length() - 1);
            MapNamingContext mapNamingContext = MapNamingContext.this;
            synchronized (mapNamingContext) {
                if (MapNamingContext.this.m_rootCtxt == null) {
                    if (MapNamingContext.this.m_shutdownMode == 1) {
                        throw new OBJECT_NOT_EXIST(0, CompletionStatus.COMPLETED_YES);
                    }
                    throw new COMM_FAILURE(0, CompletionStatus.COMPLETED_NO);
                }
                if (!MapNamingContext.this.subMap(name + '/', name + 48).isEmpty()) {
                    throw new NotEmpty();
                }
                MapNamingContext.this.remove(name);
                MapNamingContext.this.m_subContexts.remove(name);
            }
        }

        public NameComponent[] to_name(String sn) throws InvalidName {
            return NamingUtils.to_name(sn);
        }

        public String to_string(NameComponent[] n) throws InvalidName {
            return NamingUtils.to_string(n);
        }

        public String to_url(String addr, String sn) throws InvalidAddress, InvalidName {
            return NamingUtils.to_url(addr, sn);
        }

        public void list(int how_many, BindingListHolder bl, BindingIteratorHolder bi) {
            Iterator itt;
            SortedMap subMap;
            String parent = this.getPrefix();
            String last = null;
            if (parent.length() > 0) {
                parent = parent.substring(0, parent.length() - 1);
            }
            int count = 0;
            Map.Entry[] ents = new Map.Entry[how_many];
            MapNamingContext mapNamingContext = MapNamingContext.this;
            synchronized (mapNamingContext) {
                subMap = parent.length() == 0 ? MapNamingContext.this : MapNamingContext.this.subMap(parent + '/', parent + 48);
                itt = subMap.entrySet().iterator();
                while (count < how_many && itt.hasNext()) {
                    ents[count] = itt.next();
                    last = (String)ents[count].getKey();
                    String tpar = NamingUtils.parent(last);
                    if (tpar.equals(parent)) {
                        ++count;
                        continue;
                    }
                    subMap = subMap.tailMap(tpar + 48);
                    itt = subMap.entrySet().iterator();
                }
            }
            if (count == 0) {
                bl.value = new Binding[0];
            } else {
                Binding[] ret = new Binding[count];
                int i = 0;
                while (i < count) {
                    ret[i] = ents[i].getValue() instanceof NamingContext ? new Binding(null, BindingType.ncontext) : new Binding(null, BindingType.nobject);
                    String name = (String)ents[i].getKey();
                    if (parent.length() != 0) {
                        name = name.substring(NamingUtils.parent(name).length() + 1);
                    }
                    try {
                        ret[i].binding_name = MapNamingContext.this.m_ctxtImpl.to_name(name);
                    }
                    catch (InvalidName ex) {
                        if (MapNamingContext.this.getLogger().isErrorEnabled()) {
                            MapNamingContext.this.getLogger().error("Invalid name " + name + ".", (Throwable)ex);
                        }
                        throw new INTERNAL("Invalid name " + name + " (" + (java.lang.Object)((java.lang.Object)ex) + ")");
                    }
                    ++i;
                }
                bl.value = ret;
            }
            if (itt.hasNext()) {
                if (last == null) {
                    last = "";
                }
                bi.value = MapNamingContext.this.m_iterImpl.createIterator(parent, last, itt, subMap);
            }
        }

        private String getPrefix() {
            String prefix = new String(this._object_id());
            if (prefix.length() == 0) {
                return "";
            }
            if (!MapNamingContext.this.m_subContexts.contains(prefix)) {
                throw new OBJECT_NOT_EXIST(0, CompletionStatus.COMPLETED_YES);
            }
            return prefix + "/";
        }

        NamingContextExt createRef(String name) {
            NamingContextExt ret = NamingContextExtHelper.narrow((Object)MapNamingContext.this.m_ctxtPOA.create_reference_with_id(name.getBytes(), NamingContextExtHelper.id()));
            MapNamingContext.this.m_subContexts.add(name);
            MapNamingContext.this.putToMap(name, ret);
            return ret;
        }
    }

    private static class ByteSeqKey {
        private byte[] m_key;
        private int m_hashCode;

        public ByteSeqKey(byte[] key) {
            this.m_key = key;
            this.m_hashCode = 0;
            int i = 0;
            while (i < this.m_key.length) {
                this.m_hashCode = 31 * this.m_hashCode + this.m_key[i];
                ++i;
            }
        }

        public int hashCode() {
            return this.m_hashCode;
        }

        public boolean equals(java.lang.Object obj) {
            if (obj == null || !(obj instanceof ByteSeqKey)) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            ByteSeqKey b2 = (ByteSeqKey)obj;
            if (b2.m_hashCode != this.m_hashCode) {
                return false;
            }
            return Arrays.equals(this.m_key, b2.m_key);
        }
    }
}

