/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.tns;

import org.apache.avalon.framework.CascadingRuntimeException;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import org.openorb.tns.MapNamingContext;
import org.openorb.util.service.ServiceBase;

public class Service
extends ServiceBase {
    public static final String OPT_SHUTDOWN_ROOT = "s";
    public static final String OPT_SHUTDOWN_ROOT_LONG = "shutdownRoot";
    public static final String OPT_SHUTDOWN_ROOT_DESCRIP = "enable shutting down the root context";
    private POA m_poa = null;
    private MapNamingContext m_naming_context = null;

    public void initializeService() {
        try {
            ORB orb = (ORB)this.getContext().get((java.lang.Object)"ORB");
            if (orb != null) {
                this.m_poa = POAHelper.narrow((Object)((POA)this.createPOA()));
                this.m_naming_context = new MapNamingContext(orb, this.m_poa, this.getLogger());
                boolean bShutdown = this.getParameters().getParameterAsBoolean(OPT_SHUTDOWN_ROOT);
                this.m_naming_context.setShutdownMode(bShutdown ? 2 : 0);
                this.registerObject("NamingContextExt", (Object)this.m_naming_context.getRootCtxt());
            }
        }
        catch (Exception ex) {
            this.getLogger().fatalError("Exception occured while initializing the service", (Throwable)ex);
            throw new CascadingRuntimeException("Problem while initializing the service", (Throwable)ex);
        }
    }

    public void startService() {
        this.m_naming_context.activate();
    }

    public void stopService() {
        this.m_naming_context.deactivate(true);
    }
}

