/*
 * Decompiled with CFR 0.152.
 */
package file.org.openorb.notify.persistence;

import file.org.openorb.notify.persistence.EventChannelBase;
import file.org.openorb.notify.persistence.EventChannelBaseRef;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;
import org.omg.CosNotification.Property;
import org.omg.CosNotification.PropertyHelper;
import org.omg.CosPersistentState.CatalogBase;
import org.omg.CosPersistentState.NotFound;
import org.omg.CosPersistentState.StorageHomeBase;
import org.omg.CosPersistentState.StorageObject;
import org.omg.CosPersistentState.StorageObjectRef;
import org.omg.CosPersistentState.YieldRef;
import org.openorb.notify.persistence.ConnectionInfo;
import org.openorb.notify.persistence.ConnectionInfoHelper;
import org.openorb.notify.persistence.EventChannel;
import org.openorb.notify.persistence.EventChannelHome;
import org.openorb.notify.persistence.EventChannelRef;
import org.openorb.notify.persistence.EventTypeInfo;
import org.openorb.notify.persistence.EventTypeInfoHelper;
import org.openorb.pss.connector.PID;
import org.openorb.pss.connector.PersistenceException;
import org.openorb.pss.connector.file.FileCatalogBase;
import org.openorb.pss.connector.file.FileKeyBag;
import org.openorb.pss.connector.file.NotFoundException;
import org.openorb.pss.connector.file.PersistentObject;
import org.openorb.pss.connector.file.PersistentObjectHome;

public class EventChannelHomeBase
extends LocalObject
implements EventChannelHome,
PersistentObjectHome {
    private final ArrayList _incarnations = new ArrayList();
    private CatalogBase _catalog;
    private PID _pid;

    public Object find_by_short_pid(byte[] short_pid) throws NotFound {
        ArrayList arrayList = this._incarnations;
        synchronized (arrayList) {
            Iterator it = ((AbstractList)this._incarnations).iterator();
            while (it.hasNext()) {
                PersistentObject obj = (PersistentObject)it.next();
                if (!obj.getPID().is_same_short(short_pid)) continue;
                PersistentObject persistentObject = obj;
                return persistentObject;
            }
        }
        StorageObject obj = null;
        try {
            obj = ((FileCatalogBase)this._catalog).incarnate((StorageHomeBase)this, short_pid, "PSDL:openorb.org/notify/persistence/EventChannelBase:1.0");
        }
        catch (NotFoundException ex) {
            throw new NotFound();
        }
        this.register_type_incarnation(obj);
        return obj;
    }

    public CatalogBase get_catalog() {
        return this._catalog;
    }

    public EventChannelBase _create(int id, ConnectionInfo def_consumer_admin, ConnectionInfo[] consumer_admins, ConnectionInfo def_supplier_admin, ConnectionInfo[] supplier_admins, Property[] qos_properties, Property[] admin_properties, int next_consumer_admin_id, int next_supplier_admin_id, int connected_consumers, int connected_suppliers, EventTypeInfo[] published_events, EventTypeInfo[] subscribed_events) {
        EventChannelBase obj = (EventChannelBase)((FileCatalogBase)this._catalog).create_object((StorageHomeBase)this, "PSDL:openorb.org/notify/persistence/EventChannelBase:1.0");
        this.register_type_incarnation(obj);
        obj.id(id);
        obj.def_consumer_admin(def_consumer_admin);
        obj.consumer_admins(consumer_admins);
        obj.def_supplier_admin(def_supplier_admin);
        obj.supplier_admins(supplier_admins);
        obj.qos_properties(qos_properties);
        obj.admin_properties(admin_properties);
        obj.next_consumer_admin_id(next_consumer_admin_id);
        obj.next_supplier_admin_id(next_supplier_admin_id);
        obj.connected_consumers(connected_consumers);
        obj.connected_suppliers(connected_suppliers);
        obj.published_events(published_events);
        obj.subscribed_events(subscribed_events);
        return obj;
    }

    public EventChannelBase _create() {
        EventChannelBase obj = (EventChannelBase)((FileCatalogBase)this._catalog).create_object((StorageHomeBase)this, "PSDL:openorb.org/notify/persistence/EventChannelBase:1.0");
        this.register_type_incarnation(obj);
        return obj;
    }

    public EventChannelBaseRef _create(int id, ConnectionInfo def_consumer_admin, ConnectionInfo[] consumer_admins, ConnectionInfo def_supplier_admin, ConnectionInfo[] supplier_admins, Property[] qos_properties, Property[] admin_properties, int next_consumer_admin_id, int next_supplier_admin_id, int connected_consumers, int connected_suppliers, EventTypeInfo[] published_events, EventTypeInfo[] subscribed_events, YieldRef yr) {
        EventChannelBase obj = this._create(id, def_consumer_admin, consumer_admins, def_supplier_admin, supplier_admins, qos_properties, admin_properties, next_consumer_admin_id, next_supplier_admin_id, connected_consumers, connected_suppliers, published_events, subscribed_events);
        return new EventChannelBaseRef(obj.get_pid(), this._catalog);
    }

    public EventChannelBaseRef _create(YieldRef yr) {
        EventChannelBase obj = this._create();
        return new EventChannelBaseRef(obj.get_pid(), this._catalog);
    }

    public EventChannel create(int id, ConnectionInfo def_consumer_admin, ConnectionInfo[] consumer_admins, ConnectionInfo def_supplier_admin, ConnectionInfo[] supplier_admins, Property[] qos_properties, Property[] admin_properties, int next_consumer_admin_id, int next_supplier_admin_id, int connected_consumers, int connected_suppliers, EventTypeInfo[] published_events, EventTypeInfo[] subscribed_events) {
        EventChannelBase obj = (EventChannelBase)((FileCatalogBase)this._catalog).create_object((StorageHomeBase)this, "PSDL:openorb.org/notify/persistence/EventChannelBase:1.0");
        this.register_type_incarnation(obj);
        obj.id(id);
        obj.def_consumer_admin(def_consumer_admin);
        obj.consumer_admins(consumer_admins);
        obj.def_supplier_admin(def_supplier_admin);
        obj.supplier_admins(supplier_admins);
        obj.qos_properties(qos_properties);
        obj.admin_properties(admin_properties);
        obj.next_consumer_admin_id(next_consumer_admin_id);
        obj.next_supplier_admin_id(next_supplier_admin_id);
        obj.connected_consumers(connected_consumers);
        obj.connected_suppliers(connected_suppliers);
        obj.published_events(published_events);
        obj.subscribed_events(subscribed_events);
        return obj;
    }

    public EventChannel find_by_id(int id) throws NotFound {
        Enumeration _enum = ((FileCatalogBase)this._catalog).getSequentialAccess(this._pid);
        FileKeyBag _bag = null;
        while (_enum.hasMoreElements()) {
            _bag = (FileKeyBag)_enum.nextElement();
            if (_bag == null) break;
            int _tmp_id = _bag.input.read_long();
            ConnectionInfo _tmp_def_consumer_admin = ConnectionInfoHelper.read(_bag.input);
            int size7 = _bag.input.read_ulong();
            ConnectionInfo[] _tmp_consumer_admins = new ConnectionInfo[size7];
            int i7 = 0;
            while (i7 < _tmp_consumer_admins.length) {
                _tmp_consumer_admins[i7] = ConnectionInfoHelper.read(_bag.input);
                ++i7;
            }
            ConnectionInfo _tmp_def_supplier_admin = ConnectionInfoHelper.read(_bag.input);
            size7 = _bag.input.read_ulong();
            ConnectionInfo[] _tmp_supplier_admins = new ConnectionInfo[size7];
            i7 = 0;
            while (i7 < _tmp_supplier_admins.length) {
                _tmp_supplier_admins[i7] = ConnectionInfoHelper.read(_bag.input);
                ++i7;
            }
            size7 = _bag.input.read_ulong();
            Property[] _tmp_qos_properties = new Property[size7];
            i7 = 0;
            while (i7 < _tmp_qos_properties.length) {
                _tmp_qos_properties[i7] = PropertyHelper.read(_bag.input);
                ++i7;
            }
            size7 = _bag.input.read_ulong();
            Property[] _tmp_admin_properties = new Property[size7];
            i7 = 0;
            while (i7 < _tmp_admin_properties.length) {
                _tmp_admin_properties[i7] = PropertyHelper.read(_bag.input);
                ++i7;
            }
            int _tmp_next_consumer_admin_id = _bag.input.read_long();
            int _tmp_next_supplier_admin_id = _bag.input.read_long();
            int _tmp_connected_consumers = _bag.input.read_long();
            int _tmp_connected_suppliers = _bag.input.read_long();
            size7 = _bag.input.read_ulong();
            EventTypeInfo[] _tmp_published_events = new EventTypeInfo[size7];
            i7 = 0;
            while (i7 < _tmp_published_events.length) {
                _tmp_published_events[i7] = EventTypeInfoHelper.read(_bag.input);
                ++i7;
            }
            size7 = _bag.input.read_ulong();
            EventTypeInfo[] _tmp_subscribed_events = new EventTypeInfo[size7];
            i7 = 0;
            while (i7 < _tmp_subscribed_events.length) {
                _tmp_subscribed_events[i7] = EventTypeInfoHelper.read(_bag.input);
                ++i7;
            }
            if (id != _tmp_id) continue;
            return (EventChannel)this.find_by_short_pid(_bag.short_pid);
        }
        throw new NotFound();
    }

    public EventChannelRef find_ref_by_id(int id) {
        Enumeration _enum = ((FileCatalogBase)this._catalog).getSequentialAccess(this._pid);
        FileKeyBag _bag = null;
        while (_enum.hasMoreElements()) {
            _bag = (FileKeyBag)_enum.nextElement();
            if (_bag == null) break;
            int _tmp_id = _bag.input.read_long();
            ConnectionInfo _tmp_def_consumer_admin = ConnectionInfoHelper.read(_bag.input);
            int size7 = _bag.input.read_ulong();
            ConnectionInfo[] _tmp_consumer_admins = new ConnectionInfo[size7];
            int i7 = 0;
            while (i7 < _tmp_consumer_admins.length) {
                _tmp_consumer_admins[i7] = ConnectionInfoHelper.read(_bag.input);
                ++i7;
            }
            ConnectionInfo _tmp_def_supplier_admin = ConnectionInfoHelper.read(_bag.input);
            size7 = _bag.input.read_ulong();
            ConnectionInfo[] _tmp_supplier_admins = new ConnectionInfo[size7];
            i7 = 0;
            while (i7 < _tmp_supplier_admins.length) {
                _tmp_supplier_admins[i7] = ConnectionInfoHelper.read(_bag.input);
                ++i7;
            }
            size7 = _bag.input.read_ulong();
            Property[] _tmp_qos_properties = new Property[size7];
            i7 = 0;
            while (i7 < _tmp_qos_properties.length) {
                _tmp_qos_properties[i7] = PropertyHelper.read(_bag.input);
                ++i7;
            }
            size7 = _bag.input.read_ulong();
            Property[] _tmp_admin_properties = new Property[size7];
            i7 = 0;
            while (i7 < _tmp_admin_properties.length) {
                _tmp_admin_properties[i7] = PropertyHelper.read(_bag.input);
                ++i7;
            }
            int _tmp_next_consumer_admin_id = _bag.input.read_long();
            int _tmp_next_supplier_admin_id = _bag.input.read_long();
            int _tmp_connected_consumers = _bag.input.read_long();
            int _tmp_connected_suppliers = _bag.input.read_long();
            size7 = _bag.input.read_ulong();
            EventTypeInfo[] _tmp_published_events = new EventTypeInfo[size7];
            i7 = 0;
            while (i7 < _tmp_published_events.length) {
                _tmp_published_events[i7] = EventTypeInfoHelper.read(_bag.input);
                ++i7;
            }
            size7 = _bag.input.read_ulong();
            EventTypeInfo[] _tmp_subscribed_events = new EventTypeInfo[size7];
            i7 = 0;
            while (i7 < _tmp_subscribed_events.length) {
                _tmp_subscribed_events[i7] = EventTypeInfoHelper.read(_bag.input);
                ++i7;
            }
            if (id != _tmp_id) continue;
            return new EventChannelBaseRef(_bag.short_pid, this);
        }
        return null;
    }

    public void setPersistentLinks(CatalogBase catalog, PID pid) {
        this._catalog = catalog;
        this._pid = pid;
    }

    public StorageObjectRef create_reference(byte[] pid) {
        return new EventChannelBaseRef(pid, this._catalog);
    }

    public StorageObject create_object() {
        return ((FileCatalogBase)this._catalog).create_empty_object((StorageHomeBase)this, "PSDL:openorb.org/notify/persistence/EventChannelBase:1.0");
    }

    public PID getPID() {
        return this._pid;
    }

    public void remove_storage_type(PID pid) throws NotFoundException {
        this.unregister_type_incarnation(pid);
        ((FileCatalogBase)this._catalog).delete(this._pid, pid);
    }

    public boolean is_stored(PID pid) {
        return ((FileCatalogBase)this._catalog).stored(this._pid, pid);
    }

    public void refresh(PersistentObject storage_type) {
        try {
            InputStream input = ((FileCatalogBase)this._catalog).entry(this._pid, storage_type.getPID());
            storage_type.read(input);
        }
        catch (NotFoundException ex) {
            throw new PersistenceException(1, CompletionStatus.COMPLETED_NO);
        }
    }

    public void refreshAll() {
        ArrayList arrayList = this._incarnations;
        synchronized (arrayList) {
            Iterator it = ((AbstractList)this._incarnations).iterator();
            while (it.hasNext()) {
                this.refresh((PersistentObject)it.next());
            }
        }
    }

    public void flush(PersistentObject storage_type) {
        if (this._catalog.access_mode() != 1) {
            throw new PersistenceException("Bad access mode.", 6, CompletionStatus.COMPLETED_NO);
        }
        OutputStream output = ((FileCatalogBase)this._catalog).create_new_entry(this._pid, storage_type.getPID());
        storage_type.write(output);
        ((FileCatalogBase)this._catalog).entry(this._pid, storage_type.getPID(), output);
    }

    public StorageObject deref(PID pid) {
        try {
            return (StorageObject)this.find_by_short_pid(pid.short_value());
        }
        catch (NotFound notFound) {
            return null;
        }
    }

    private void register_type_incarnation(Object type) {
        ArrayList arrayList = this._incarnations;
        synchronized (arrayList) {
            this._incarnations.add(type);
        }
    }

    private void unregister_type_incarnation(PID pid) {
        ArrayList arrayList = this._incarnations;
        synchronized (arrayList) {
            Iterator it = ((AbstractList)this._incarnations).iterator();
            while (it.hasNext()) {
                PersistentObject obj = (PersistentObject)it.next();
                if (!obj.getPID().is_same(pid)) continue;
                it.remove();
            }
            this._incarnations.trimToSize();
        }
    }
}

