/*
 * Decompiled with CFR 0.152.
 */
package file.org.openorb.notify.persistence;

import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;
import org.omg.CosNotification.Property;
import org.omg.CosNotification.PropertyHelper;
import org.omg.CosNotifyChannelAdmin.InterFilterGroupOperator;
import org.omg.CosNotifyChannelAdmin.InterFilterGroupOperatorHelper;
import org.omg.CosPersistentState.ForUpdate;
import org.omg.CosPersistentState.StorageHomeBase;
import org.openorb.notify.persistence.ConnectionInfo;
import org.openorb.notify.persistence.ConnectionInfoHelper;
import org.openorb.notify.persistence.EventTypeInfo;
import org.openorb.notify.persistence.EventTypeInfoHelper;
import org.openorb.notify.persistence.ReferenceInfo;
import org.openorb.notify.persistence.ReferenceInfoHelper;
import org.openorb.notify.persistence.SupplierAdmin;
import org.openorb.pss.connector.PID;
import org.openorb.pss.connector.PersistenceException;
import org.openorb.pss.connector.file.NotFoundException;
import org.openorb.pss.connector.file.PersistentObject;
import org.openorb.pss.connector.file.PersistentObjectHome;

public class SupplierAdminBase
implements SupplierAdmin,
PersistentObject {
    protected ReferenceInfo[] _filters_state;
    protected ReferenceInfo[] _mapping_filters_state;
    protected int _next_filter_id_state;
    protected EventTypeInfo[] _event_types_state;
    protected int _id_state;
    protected int _channel_id_state;
    protected InterFilterGroupOperator _filter_operator_state;
    protected Property[] _qos_properties_state;
    protected ConnectionInfo[] _pull_consumers_state;
    protected ConnectionInfo[] _push_consumers_state;
    protected int _next_pull_consumer_id_state;
    protected int _next_push_consumer_id_state;
    private PID _pid;
    private StorageHomeBase _home_base;
    private PersistentObject _container = null;

    public void embeddedBuilder() {
    }

    public void destroy_object() {
        if (this._container != null) {
            return;
        }
        try {
            ((PersistentObjectHome)this._home_base).remove_storage_type(this._pid);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    public boolean object_exists() {
        if (this._container != null) {
            return true;
        }
        return ((PersistentObjectHome)this._home_base).is_stored(this._pid);
    }

    public byte[] get_pid() {
        if (this._container != null) {
            throw new PersistenceException("Null container.", 10, CompletionStatus.COMPLETED_NO);
        }
        return this._pid.value();
    }

    public byte[] get_short_pid() {
        if (this._container != null) {
            throw new PersistenceException("Null container.", 10, CompletionStatus.COMPLETED_NO);
        }
        return this._pid.short_value();
    }

    public StorageHomeBase get_storage_home() {
        return this._home_base;
    }

    public final ReferenceInfo[] filters() {
        return this._filters_state;
    }

    public final ReferenceInfo[] filters(ForUpdate fu) {
        this.refreshIncarnation();
        return this._filters_state;
    }

    public final void filters(ReferenceInfo[] _arg) {
        this._filters_state = _arg;
        this.flushIncarnation();
    }

    public final ReferenceInfo[] mapping_filters() {
        return this._mapping_filters_state;
    }

    public final ReferenceInfo[] mapping_filters(ForUpdate fu) {
        this.refreshIncarnation();
        return this._mapping_filters_state;
    }

    public final void mapping_filters(ReferenceInfo[] _arg) {
        this._mapping_filters_state = _arg;
        this.flushIncarnation();
    }

    public final int next_filter_id() {
        return this._next_filter_id_state;
    }

    public final void next_filter_id(int _arg) {
        this._next_filter_id_state = _arg;
        this.flushIncarnation();
    }

    public final EventTypeInfo[] event_types() {
        return this._event_types_state;
    }

    public final EventTypeInfo[] event_types(ForUpdate fu) {
        this.refreshIncarnation();
        return this._event_types_state;
    }

    public final void event_types(EventTypeInfo[] _arg) {
        this._event_types_state = _arg;
        this.flushIncarnation();
    }

    public final int id() {
        return this._id_state;
    }

    public final void id(int _arg) {
        this._id_state = _arg;
        this.flushIncarnation();
    }

    public final int channel_id() {
        return this._channel_id_state;
    }

    public final void channel_id(int _arg) {
        this._channel_id_state = _arg;
        this.flushIncarnation();
    }

    public final InterFilterGroupOperator filter_operator() {
        return this._filter_operator_state;
    }

    public final InterFilterGroupOperator filter_operator(ForUpdate fu) {
        this.refreshIncarnation();
        return this._filter_operator_state;
    }

    public final void filter_operator(InterFilterGroupOperator _arg) {
        this._filter_operator_state = _arg;
        this.flushIncarnation();
    }

    public final Property[] qos_properties() {
        return this._qos_properties_state;
    }

    public final Property[] qos_properties(ForUpdate fu) {
        this.refreshIncarnation();
        return this._qos_properties_state;
    }

    public final void qos_properties(Property[] _arg) {
        this._qos_properties_state = _arg;
        this.flushIncarnation();
    }

    public final ConnectionInfo[] pull_consumers() {
        return this._pull_consumers_state;
    }

    public final ConnectionInfo[] pull_consumers(ForUpdate fu) {
        this.refreshIncarnation();
        return this._pull_consumers_state;
    }

    public final void pull_consumers(ConnectionInfo[] _arg) {
        this._pull_consumers_state = _arg;
        this.flushIncarnation();
    }

    public final ConnectionInfo[] push_consumers() {
        return this._push_consumers_state;
    }

    public final ConnectionInfo[] push_consumers(ForUpdate fu) {
        this.refreshIncarnation();
        return this._push_consumers_state;
    }

    public final void push_consumers(ConnectionInfo[] _arg) {
        this._push_consumers_state = _arg;
        this.flushIncarnation();
    }

    public final int next_pull_consumer_id() {
        return this._next_pull_consumer_id_state;
    }

    public final void next_pull_consumer_id(int _arg) {
        this._next_pull_consumer_id_state = _arg;
        this.flushIncarnation();
    }

    public final int next_push_consumer_id() {
        return this._next_push_consumer_id_state;
    }

    public final void next_push_consumer_id(int _arg) {
        this._next_push_consumer_id_state = _arg;
        this.flushIncarnation();
    }

    public PID getPID() {
        return this._pid;
    }

    public void setPersistentLinks(PID pid, StorageHomeBase home_base) {
        this._pid = pid;
        this._home_base = home_base;
    }

    public void write(OutputStream output) {
        output.write_ulong(this.filters().length);
        int i7 = 0;
        while (i7 < this.filters().length) {
            ReferenceInfoHelper.write(output, this.filters()[i7]);
            ++i7;
        }
        output.write_ulong(this.mapping_filters().length);
        int i72 = 0;
        while (i72 < this.mapping_filters().length) {
            ReferenceInfoHelper.write(output, this.mapping_filters()[i72]);
            ++i72;
        }
        output.write_long(this.next_filter_id());
        output.write_ulong(this.event_types().length);
        int i73 = 0;
        while (i73 < this.event_types().length) {
            EventTypeInfoHelper.write(output, this.event_types()[i73]);
            ++i73;
        }
        output.write_long(this.id());
        output.write_long(this.channel_id());
        InterFilterGroupOperatorHelper.write(output, this.filter_operator());
        output.write_ulong(this.qos_properties().length);
        int i74 = 0;
        while (i74 < this.qos_properties().length) {
            PropertyHelper.write(output, this.qos_properties()[i74]);
            ++i74;
        }
        output.write_ulong(this.pull_consumers().length);
        int i75 = 0;
        while (i75 < this.pull_consumers().length) {
            ConnectionInfoHelper.write(output, this.pull_consumers()[i75]);
            ++i75;
        }
        output.write_ulong(this.push_consumers().length);
        int i76 = 0;
        while (i76 < this.push_consumers().length) {
            ConnectionInfoHelper.write(output, this.push_consumers()[i76]);
            ++i76;
        }
        output.write_long(this.next_pull_consumer_id());
        output.write_long(this.next_push_consumer_id());
    }

    public void read(InputStream input) {
        int size7 = input.read_ulong();
        this._filters_state = new ReferenceInfo[size7];
        int i7 = 0;
        while (i7 < this._filters_state.length) {
            this._filters_state[i7] = ReferenceInfoHelper.read(input);
            ++i7;
        }
        size7 = input.read_ulong();
        this._mapping_filters_state = new ReferenceInfo[size7];
        i7 = 0;
        while (i7 < this._mapping_filters_state.length) {
            this._mapping_filters_state[i7] = ReferenceInfoHelper.read(input);
            ++i7;
        }
        this._next_filter_id_state = input.read_long();
        size7 = input.read_ulong();
        this._event_types_state = new EventTypeInfo[size7];
        i7 = 0;
        while (i7 < this._event_types_state.length) {
            this._event_types_state[i7] = EventTypeInfoHelper.read(input);
            ++i7;
        }
        this._id_state = input.read_long();
        this._channel_id_state = input.read_long();
        this._filter_operator_state = InterFilterGroupOperatorHelper.read(input);
        size7 = input.read_ulong();
        this._qos_properties_state = new Property[size7];
        i7 = 0;
        while (i7 < this._qos_properties_state.length) {
            this._qos_properties_state[i7] = PropertyHelper.read(input);
            ++i7;
        }
        size7 = input.read_ulong();
        this._pull_consumers_state = new ConnectionInfo[size7];
        i7 = 0;
        while (i7 < this._pull_consumers_state.length) {
            this._pull_consumers_state[i7] = ConnectionInfoHelper.read(input);
            ++i7;
        }
        size7 = input.read_ulong();
        this._push_consumers_state = new ConnectionInfo[size7];
        i7 = 0;
        while (i7 < this._push_consumers_state.length) {
            this._push_consumers_state[i7] = ConnectionInfoHelper.read(input);
            ++i7;
        }
        this._next_pull_consumer_id_state = input.read_long();
        this._next_push_consumer_id_state = input.read_long();
    }

    public void markAsEmbedded(PersistentObject container) {
        this._container = container;
    }

    public void refreshIncarnation() {
        if (this._container != null) {
            this._container.refreshIncarnation();
            return;
        }
        ((PersistentObjectHome)this._home_base).refresh((PersistentObject)this);
    }

    public boolean checkForFlush() {
        if (this._filters_state == null) {
            return false;
        }
        if (this._mapping_filters_state == null) {
            return false;
        }
        if (this._event_types_state == null) {
            return false;
        }
        if (this._filter_operator_state == null) {
            return false;
        }
        if (this._qos_properties_state == null) {
            return false;
        }
        if (this._pull_consumers_state == null) {
            return false;
        }
        return this._push_consumers_state != null;
    }

    public void flushIncarnation() {
        if (this._container != null) {
            this._container.flushIncarnation();
            return;
        }
        if (!this.checkForFlush()) {
            return;
        }
        ((PersistentObjectHome)this._home_base).flush((PersistentObject)this);
    }
}

