/*
 * Decompiled with CFR 0.152.
 */
package memory.org.openorb.notify.persistence;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import memory.org.openorb.notify.persistence.EventChannelBase;
import memory.org.openorb.notify.persistence.EventChannelBaseRef;
import org.omg.CORBA.LocalObject;
import org.omg.CosNotification.Property;
import org.omg.CosPersistentState.CatalogBase;
import org.omg.CosPersistentState.NotFound;
import org.omg.CosPersistentState.StorageHomeBase;
import org.omg.CosPersistentState.StorageObject;
import org.omg.CosPersistentState.StorageObjectRef;
import org.omg.CosPersistentState.YieldRef;
import org.openorb.notify.persistence.ConnectionInfo;
import org.openorb.notify.persistence.EventChannel;
import org.openorb.notify.persistence.EventChannelHome;
import org.openorb.notify.persistence.EventChannelRef;
import org.openorb.notify.persistence.EventTypeInfo;
import org.openorb.pss.connector.PID;
import org.openorb.pss.connector.memory.MemoryCatalogBase;
import org.openorb.pss.connector.memory.NotFoundException;
import org.openorb.pss.connector.memory.PersistentObject;
import org.openorb.pss.connector.memory.PersistentObjectHome;

public class EventChannelHomeBase
extends LocalObject
implements EventChannelHome,
PersistentObjectHome {
    private final ArrayList _incarnations = new ArrayList();
    private CatalogBase _catalog;
    private PID _pid;

    public Object find_by_short_pid(byte[] short_pid) throws NotFound {
        ArrayList arrayList = this._incarnations;
        synchronized (arrayList) {
            Iterator it = ((AbstractList)this._incarnations).iterator();
            while (it.hasNext()) {
                PersistentObject obj = (PersistentObject)it.next();
                if (!obj.getPID().is_same_short(short_pid)) continue;
                PersistentObject persistentObject = obj;
                return persistentObject;
            }
            throw new NotFound();
        }
    }

    public CatalogBase get_catalog() {
        return this._catalog;
    }

    public EventChannelBase _create(int id, ConnectionInfo def_consumer_admin, ConnectionInfo[] consumer_admins, ConnectionInfo def_supplier_admin, ConnectionInfo[] supplier_admins, Property[] qos_properties, Property[] admin_properties, int next_consumer_admin_id, int next_supplier_admin_id, int connected_consumers, int connected_suppliers, EventTypeInfo[] published_events, EventTypeInfo[] subscribed_events) {
        EventChannelBase obj = (EventChannelBase)((MemoryCatalogBase)this._catalog).create_object((StorageHomeBase)this, "PSDL:openorb.org/notify/persistence/EventChannelBase:1.0");
        this.register_type_incarnation(obj);
        obj.id(id);
        obj.def_consumer_admin(def_consumer_admin);
        obj.consumer_admins(consumer_admins);
        obj.def_supplier_admin(def_supplier_admin);
        obj.supplier_admins(supplier_admins);
        obj.qos_properties(qos_properties);
        obj.admin_properties(admin_properties);
        obj.next_consumer_admin_id(next_consumer_admin_id);
        obj.next_supplier_admin_id(next_supplier_admin_id);
        obj.connected_consumers(connected_consumers);
        obj.connected_suppliers(connected_suppliers);
        obj.published_events(published_events);
        obj.subscribed_events(subscribed_events);
        return obj;
    }

    public EventChannelBase _create() {
        EventChannelBase obj = (EventChannelBase)((MemoryCatalogBase)this._catalog).create_object((StorageHomeBase)this, "PSDL:openorb.org/notify/persistence/EventChannelBase:1.0");
        this.register_type_incarnation(obj);
        return obj;
    }

    public EventChannelBaseRef _create(int id, ConnectionInfo def_consumer_admin, ConnectionInfo[] consumer_admins, ConnectionInfo def_supplier_admin, ConnectionInfo[] supplier_admins, Property[] qos_properties, Property[] admin_properties, int next_consumer_admin_id, int next_supplier_admin_id, int connected_consumers, int connected_suppliers, EventTypeInfo[] published_events, EventTypeInfo[] subscribed_events, YieldRef yr) {
        EventChannelBase obj = this._create(id, def_consumer_admin, consumer_admins, def_supplier_admin, supplier_admins, qos_properties, admin_properties, next_consumer_admin_id, next_supplier_admin_id, connected_consumers, connected_suppliers, published_events, subscribed_events);
        return new EventChannelBaseRef(obj.get_pid(), this._catalog);
    }

    public EventChannelBaseRef _create(YieldRef yr) {
        EventChannelBase obj = this._create();
        return new EventChannelBaseRef(obj.get_pid(), this._catalog);
    }

    public EventChannel create(int id, ConnectionInfo def_consumer_admin, ConnectionInfo[] consumer_admins, ConnectionInfo def_supplier_admin, ConnectionInfo[] supplier_admins, Property[] qos_properties, Property[] admin_properties, int next_consumer_admin_id, int next_supplier_admin_id, int connected_consumers, int connected_suppliers, EventTypeInfo[] published_events, EventTypeInfo[] subscribed_events) {
        EventChannelBase obj = (EventChannelBase)((MemoryCatalogBase)this._catalog).create_object((StorageHomeBase)this, "PSDL:openorb.org/notify/persistence/EventChannelBase:1.0");
        this.register_type_incarnation(obj);
        obj.id(id);
        obj.def_consumer_admin(def_consumer_admin);
        obj.consumer_admins(consumer_admins);
        obj.def_supplier_admin(def_supplier_admin);
        obj.supplier_admins(supplier_admins);
        obj.qos_properties(qos_properties);
        obj.admin_properties(admin_properties);
        obj.next_consumer_admin_id(next_consumer_admin_id);
        obj.next_supplier_admin_id(next_supplier_admin_id);
        obj.connected_consumers(connected_consumers);
        obj.connected_suppliers(connected_suppliers);
        obj.published_events(published_events);
        obj.subscribed_events(subscribed_events);
        return obj;
    }

    public EventChannel find_by_id(int id) throws NotFound {
        ArrayList arrayList = this._incarnations;
        synchronized (arrayList) {
            Iterator it = ((AbstractList)this._incarnations).iterator();
            while (it.hasNext()) {
                EventChannel obj = (EventChannel)it.next();
                int _tmp_id = obj.id();
                if (id != _tmp_id) continue;
                EventChannel eventChannel = obj;
                return eventChannel;
            }
        }
        throw new NotFound();
    }

    public EventChannelRef find_ref_by_id(int id) {
        ArrayList arrayList = this._incarnations;
        synchronized (arrayList) {
            Iterator it = ((AbstractList)this._incarnations).iterator();
            while (it.hasNext()) {
                EventChannel obj = (EventChannel)it.next();
                int _tmp_id = obj.id();
                if (id != _tmp_id) continue;
                EventChannelBaseRef eventChannelBaseRef = new EventChannelBaseRef(obj.get_short_pid(), this);
                return eventChannelBaseRef;
            }
        }
        return null;
    }

    public Object[] get_incarnations() {
        return this._incarnations.toArray();
    }

    public void setPersistentLinks(CatalogBase catalog, PID pid) {
        this._catalog = catalog;
        this._pid = pid;
    }

    public StorageObjectRef create_reference(byte[] pid) {
        return new EventChannelBaseRef(pid, this._catalog);
    }

    public PID getPID() {
        return this._pid;
    }

    public void remove_storage_type(PID pid) throws NotFoundException {
        this.unregister_type_incarnation(pid);
        ((MemoryCatalogBase)this._catalog).delete(this._pid, pid);
    }

    public boolean is_stored(PID pid) {
        return ((MemoryCatalogBase)this._catalog).stored(this._pid, pid);
    }

    public StorageObject deref(PID pid) {
        try {
            return (StorageObject)this.find_by_short_pid(pid.short_value());
        }
        catch (NotFound notFound) {
            return null;
        }
    }

    private void register_type_incarnation(Object type) {
        ArrayList arrayList = this._incarnations;
        synchronized (arrayList) {
            this._incarnations.add(type);
        }
    }

    private void unregister_type_incarnation(PID pid) {
        ArrayList arrayList = this._incarnations;
        synchronized (arrayList) {
            Iterator it = ((AbstractList)this._incarnations).iterator();
            while (it.hasNext()) {
                PersistentObject obj = (PersistentObject)it.next();
                if (!obj.getPID().is_same(pid)) continue;
                it.remove();
            }
            this._incarnations.trimToSize();
        }
    }
}

