/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.notify;

import org.openorb.notify.PropertiesRepository;
import org.openorb.orb.config.ORBLoader;
import org.openorb.orb.core.ORB;

public final class Configurator {
    public static final String MAX_QUEUE_LENGTH_KEY = "MaxQueueLength";
    public static final String MAX_CONSUMERS_KEY = "MaxConsumers";
    public static final String MAX_SUPPLIERS_KEY = "MaxSuppliers";
    public static final String EVENT_QUEUES_POLICY_KEY = "EventQueuesPolicy";
    public static final String SUPPLIER_PROXIES_POLICY_KEY = "SuppliersThreadPolicy";
    public static final String SUPPLIER_ADMINS_POLICY_KEY = "SupplierAdminsThreadPolicy";
    public static final String CONSUMER_PROXIES_POLICY_KEY = "ConsumersThreadPolicy";
    public static final String CONSUMER_ADMINS_POLICY_KEY = "ConsumerAdminsThreadPolicy";
    public static final String PULL_THREAD_LATENCY_KEY = "PullThreadLatency";
    public static final String EVENTS_CLEAN_PERIODICITY_KEY = "EventsCleanPeriodicity";
    public static final String CONNECTIONS_CLEAN_PERIODICITY_KEY = "ConnectionsCleanPeriodicity";
    public static final String FILTERS_CLEAN_PERIODICITY_KEY = "FiltersCleanPeriodicity";
    public static final String RESOURCES_TIMEOUT_KEY = "ResourcesTimeout";
    public static final String BIDIRECTIONAL_FLAG_KEY = "BiDirectionalFlag";
    public static final String LOG_PRIORITY_LEVEL_KEY = "LogPriorityLevel";
    public static final String LOG_EVENT_QUEUE_KEY = "LogEventQueue";
    public static final String LOG_FILTER_EVALUATION_KEY = "LogFilterEvaluation";
    public static final int MAX_PERFORMANCE_POLICY = 0;
    public static final int MAX_RESOURCE_POLICY = 1;

    private Configurator() {
    }

    public static PropertiesRepository configurePropertiesRepository(ORB orb) {
        ORBLoader cfg = orb.getLoader();
        PropertiesRepository props = new PropertiesRepository();
        if (cfg.getStringProperty("notify.eventQueuesPolicy", "MaxResource").equalsIgnoreCase("MaxPerformance")) {
            props.setProperty(EVENT_QUEUES_POLICY_KEY, new Integer(0));
        } else {
            props.setProperty(EVENT_QUEUES_POLICY_KEY, new Integer(1));
        }
        if (cfg.getStringProperty("notify.consumerAdminsThreadPolicy", "MaxPerformance").equalsIgnoreCase("MaxPerformance")) {
            props.setProperty(CONSUMER_ADMINS_POLICY_KEY, new Integer(0));
        } else {
            props.setProperty(CONSUMER_ADMINS_POLICY_KEY, new Integer(1));
        }
        if (cfg.getStringProperty("notify.supplierAdminsThreadPolicy", "MaxPerformance").equalsIgnoreCase("MaxPerformance")) {
            props.setProperty(SUPPLIER_ADMINS_POLICY_KEY, new Integer(0));
        } else {
            props.setProperty(SUPPLIER_ADMINS_POLICY_KEY, new Integer(1));
        }
        if (cfg.getStringProperty("notify.consumersThreadPolicy", "MaxResource").equalsIgnoreCase("MaxPerformance")) {
            props.setProperty("ConsumerProxiesThreadPolicy", new Integer(0));
        } else {
            props.setProperty("ConsumerProxiesThreadPolicy", new Integer(1));
        }
        if (cfg.getStringProperty("notify.suppliersThreadPolicy", "MaxResource").equalsIgnoreCase("MaxPerformance")) {
            props.setProperty("SupplierProxiesThreadPolicy", new Integer(0));
        } else {
            props.setProperty("SupplierProxiesThreadPolicy", new Integer(1));
        }
        props.setProperty(PULL_THREAD_LATENCY_KEY, new Integer(cfg.getIntProperty("notify.pullThreadLatency", 500)));
        props.setProperty(EVENTS_CLEAN_PERIODICITY_KEY, new Integer(cfg.getIntProperty("notify.eventsCleanPeriodicity", 100)));
        props.setProperty(CONNECTIONS_CLEAN_PERIODICITY_KEY, new Integer(cfg.getIntProperty("notify.connectionsCleanPeriodicity", 100)));
        props.setProperty(FILTERS_CLEAN_PERIODICITY_KEY, new Integer(cfg.getIntProperty("notify.filtersCleanPeriodicity", 100)));
        props.setProperty(RESOURCES_TIMEOUT_KEY, new Integer(cfg.getIntProperty("notify.resourcesTimeout", 1000)));
        props.setProperty(BIDIRECTIONAL_FLAG_KEY, cfg.getBooleanProperty("notify.biDirectionalFlag", false) ? Boolean.TRUE : Boolean.FALSE);
        props.setProperty(LOG_PRIORITY_LEVEL_KEY, cfg.getStringProperty("notify.logPriorityLevel", "error"));
        if (cfg.getStringProperty("notify.logEventQueue", "false").equalsIgnoreCase("true")) {
            props.setProperty(LOG_EVENT_QUEUE_KEY, Boolean.TRUE);
        } else {
            props.setProperty(LOG_EVENT_QUEUE_KEY, Boolean.FALSE);
        }
        if (cfg.getStringProperty("notify.logFilterEvaluation", "false").equalsIgnoreCase("true")) {
            props.setProperty(LOG_FILTER_EVALUATION_KEY, Boolean.TRUE);
        } else {
            props.setProperty(LOG_FILTER_EVALUATION_KEY, Boolean.FALSE);
        }
        props.setProperty("LogPriorityLevelRecovery", cfg.getStringProperty("notify.logPriorityLevelRecovery", ""));
        props.setProperty("LogPriorityLevelEventChannel", cfg.getStringProperty("notify.logPriorityLevelEventChannel", ""));
        props.setProperty("LogPriorityLevelChannel", cfg.getStringProperty("notify.logPriorityLevelChannel", ""));
        props.setProperty("LogPriorityLevelSupplierAdmin", cfg.getStringProperty("notify.logPriorityLevelSupplierAdmin", ""));
        props.setProperty("LogPriorityLevelConsumerAdmin", cfg.getStringProperty("notify.logPriorityLevelConsumerAdmin", ""));
        props.setProperty("LogPriorityLevelSupplierProxy", cfg.getStringProperty("notify.logPriorityLevelSupplierProxy", ""));
        props.setProperty("LogPriorityLevelConsumerProxy", cfg.getStringProperty("notify.logPriorityLevelConsumerProxy", ""));
        props.setProperty("LogPriorityLevelThread", cfg.getStringProperty("notify.logPriorityLevelThread", ""));
        props.setProperty("LogPriorityLevelQueue", cfg.getStringProperty("notify.logPriorityLevelQueue", ""));
        props.setProperty("LogPriorityLevelFilter", cfg.getStringProperty("notify.logPriorityLevelFilter", ""));
        return props;
    }
}

