/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.notify;

import java.util.HashMap;
import org.omg.CosPersistentState.StorageHomeBase;
import org.openorb.notify.persistence.ConsumerAdminHome;
import org.openorb.notify.persistence.EventChannelHome;
import org.openorb.notify.persistence.EventHome;
import org.openorb.notify.persistence.EventQueueHome;
import org.openorb.notify.persistence.FilterHome;
import org.openorb.notify.persistence.MappingFilterHome;
import org.openorb.notify.persistence.ProxyConsumerHome;
import org.openorb.notify.persistence.ProxySupplierHome;
import org.openorb.notify.persistence.SupplierAdminHome;

public class PersistenceRepository {
    private HashMap m_transientTbl = new HashMap();
    private HashMap m_persistentTbl = new HashMap();
    public static final String EVENT_CHANNEL = "EventChannel";
    public static final String CONSUMER_ADMIN = "ConsumerAdmin";
    public static final String SUPPLIER_ADMIN = "SupplierAdmin";
    public static final String FILTER = "Filter";
    public static final String MAPPING_FILTER = "MappingFilter";
    public static final String PROXY_CONSUMER = "ProxyConsumer";
    public static final String PROXY_SUPPLIER = "ProxySupplier";
    public static final String EVENT = "Event";
    public static final String EVENT_QUEUE = "EventQueue";
    private static PersistenceRepository s_instance;

    public static PersistenceRepository getInstance() {
        if (s_instance == null) {
            s_instance = new PersistenceRepository();
        }
        return s_instance;
    }

    public StorageHomeBase getTransientHome(String name) {
        return (StorageHomeBase)this.m_transientTbl.get(name);
    }

    public void setTransientHome(String name, StorageHomeBase home) {
        this.m_transientTbl.put(name, home);
    }

    public StorageHomeBase getPersistentHome(String name) {
        return (StorageHomeBase)this.m_persistentTbl.get(name);
    }

    public void setPersistentHome(String name, StorageHomeBase home) {
        this.m_persistentTbl.put(name, home);
    }

    public static StorageHomeBase getStorageHome(String name, boolean persistent) {
        if (persistent) {
            return PersistenceRepository.getInstance().getPersistentHome(name);
        }
        return PersistenceRepository.getInstance().getTransientHome(name);
    }

    public static void setStorageHome(String name, StorageHomeBase home, boolean persistent) {
        if (persistent) {
            PersistenceRepository.getInstance().setPersistentHome(name, home);
        } else {
            PersistenceRepository.getInstance().setTransientHome(name, home);
        }
    }

    public static EventChannelHome getEventChannelHome(boolean persistent) {
        return (EventChannelHome)PersistenceRepository.getStorageHome(EVENT_CHANNEL, persistent);
    }

    public static void setEventChannelHome(EventChannelHome home, boolean persistent) {
        PersistenceRepository.setStorageHome(EVENT_CHANNEL, home, persistent);
    }

    public static ConsumerAdminHome getConsumerAdminHome(boolean persistent) {
        return (ConsumerAdminHome)PersistenceRepository.getStorageHome(CONSUMER_ADMIN, persistent);
    }

    public static void setConsumerAdminHome(ConsumerAdminHome home, boolean persistent) {
        PersistenceRepository.setStorageHome(CONSUMER_ADMIN, home, persistent);
    }

    public static SupplierAdminHome getSupplierAdminHome(boolean persistent) {
        return (SupplierAdminHome)PersistenceRepository.getStorageHome(SUPPLIER_ADMIN, persistent);
    }

    public static void setSupplierAdminHome(SupplierAdminHome home, boolean persistent) {
        PersistenceRepository.setStorageHome(SUPPLIER_ADMIN, home, persistent);
    }

    public static FilterHome getFilterHome(boolean persistent) {
        return (FilterHome)PersistenceRepository.getStorageHome(FILTER, persistent);
    }

    public static void setFilterHome(FilterHome home, boolean persistent) {
        PersistenceRepository.setStorageHome(FILTER, home, persistent);
    }

    public static MappingFilterHome getMappingFilterHome(boolean persistent) {
        return (MappingFilterHome)PersistenceRepository.getStorageHome(MAPPING_FILTER, persistent);
    }

    public static void setMappingFilterHome(MappingFilterHome home, boolean persistent) {
        PersistenceRepository.setStorageHome(MAPPING_FILTER, home, persistent);
    }

    public static ProxyConsumerHome getProxyConsumerHome(boolean persistent) {
        return (ProxyConsumerHome)PersistenceRepository.getStorageHome(PROXY_CONSUMER, persistent);
    }

    public static void setProxyConsumerHome(ProxyConsumerHome home, boolean persistent) {
        PersistenceRepository.setStorageHome(PROXY_CONSUMER, home, persistent);
    }

    public static ProxySupplierHome getProxySupplierHome(boolean persistent) {
        return (ProxySupplierHome)PersistenceRepository.getStorageHome(PROXY_SUPPLIER, persistent);
    }

    public static void setProxySupplierHome(ProxySupplierHome home, boolean persistent) {
        PersistenceRepository.setStorageHome(PROXY_SUPPLIER, home, persistent);
    }

    public static EventHome getEventHome(boolean persistent) {
        return (EventHome)PersistenceRepository.getStorageHome(EVENT, persistent);
    }

    public static void setEventHome(EventHome home, boolean persistent) {
        PersistenceRepository.setStorageHome(EVENT, home, persistent);
    }

    public static EventQueueHome getEventQueueHome(boolean persistent) {
        return (EventQueueHome)PersistenceRepository.getStorageHome(EVENT_QUEUE, persistent);
    }

    public static void setEventQueueHome(EventQueueHome home, boolean persistent) {
        PersistenceRepository.setStorageHome(EVENT_QUEUE, home, persistent);
    }
}

