/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.notify;

import org.apache.avalon.framework.logger.LogEnabled;
import org.omg.CORBA.ORB;
import org.omg.CosPersistentState.StorageHomeBase;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.Servant;
import org.openorb.notify.Logger;
import org.openorb.notify.PersistenceManagement;
import org.openorb.notify.PersistenceRepository;
import org.openorb.notify.impl.ConsumerAdminImpl;
import org.openorb.notify.impl.EventChannelFactoryImpl;
import org.openorb.notify.impl.EventChannelImpl;
import org.openorb.notify.impl.FilterImpl;
import org.openorb.notify.impl.MappingFilterImpl;
import org.openorb.notify.impl.ProxyPullConsumerImpl;
import org.openorb.notify.impl.ProxyPullSupplierImpl;
import org.openorb.notify.impl.ProxyPushConsumerImpl;
import org.openorb.notify.impl.ProxyPushSupplierImpl;
import org.openorb.notify.impl.SequenceProxyPullConsumerImpl;
import org.openorb.notify.impl.SequenceProxyPullSupplierImpl;
import org.openorb.notify.impl.SequenceProxyPushConsumerImpl;
import org.openorb.notify.impl.SequenceProxyPushSupplierImpl;
import org.openorb.notify.impl.StructuredProxyPullConsumerImpl;
import org.openorb.notify.impl.StructuredProxyPullSupplierImpl;
import org.openorb.notify.impl.StructuredProxyPushConsumerImpl;
import org.openorb.notify.impl.StructuredProxyPushSupplierImpl;
import org.openorb.notify.impl.SupplierAdminImpl;
import org.openorb.notify.persistence.ConnectionInfo;
import org.openorb.notify.persistence.ConsumerAdmin;
import org.openorb.notify.persistence.EventChannel;
import org.openorb.notify.persistence.Filter;
import org.openorb.notify.persistence.MappingFilter;
import org.openorb.notify.persistence.ProxyConsumer;
import org.openorb.notify.persistence.ProxySupplier;
import org.openorb.notify.persistence.SupplierAdmin;
import org.openorb.pss.connector.ExtendedCatalog;
import org.openorb.pss.connector.Iterator;

public class RecoveryManager
implements LogEnabled {
    private org.apache.avalon.framework.logger.Logger m_logger;
    private Logger m_allLoggers;
    private ORB m_orb;
    private EventChannelFactoryImpl m_factory;
    private POA m_factoryPOA;

    public RecoveryManager(ORB orb, EventChannelFactoryImpl factory, POA factoryPOA, Logger allLoggers) {
        this.m_allLoggers = allLoggers;
        this.m_orb = orb;
        this.m_factory = factory;
        this.m_factoryPOA = factoryPOA;
    }

    public void enableLogging(org.apache.avalon.framework.logger.Logger logger) {
        this.m_logger = logger;
    }

    public void doRecovery() {
        this.doEventsRecovery();
        this.doConnectionsRecovery();
        this.m_factory.recoveryFinished();
    }

    private void doConnectionsRecovery() {
        this.recoverFilters();
        this.recoverMappingFilters();
        this.recoverEventChannels();
    }

    private void doEventsRecovery() {
        this.getLogger().info("Recovering events...");
        this.getLogger().info("Event recovery not supported...");
    }

    private void recoverEventChannels() {
        this.getLogger().debug("Recovering channels...");
        ExtendedCatalog catalog = (ExtendedCatalog)PersistenceRepository.getEventChannelHome(true).get_catalog();
        Iterator iter = catalog.iterator((StorageHomeBase)PersistenceRepository.getEventChannelHome(true));
        iter.reset();
        while (iter.hasMoreElements()) {
            EventChannel pssEventChannel = (EventChannel)iter.element();
            try {
                EventChannelImpl channel = new EventChannelImpl(this.m_factory, pssEventChannel, this.m_factoryPOA, this.m_allLoggers);
                this.m_factoryPOA.activate_object_with_id(channel.getPid(), (Servant)channel);
                this.m_factory.channelRecovered(pssEventChannel.id(), channel);
                this.getLogger().debug("Channel recovered with id " + pssEventChannel.id() + ".");
                this.recoverConsumerAdmins(channel, pssEventChannel);
                this.recoverSupplierAdmins(channel, pssEventChannel);
            }
            catch (Throwable ex) {
                this.getLogger().error("exception when recovering event channel", ex);
            }
            iter.next();
        }
        iter.detach();
    }

    private void recoverConsumerAdmins(EventChannelImpl channel, EventChannel pssEventChannel) {
        this.getLogger().debug("Recovering default consumer admin...");
        if (pssEventChannel.def_consumer_admin().reference != null) {
            this.recoverOneConsumerAdmin(pssEventChannel.def_consumer_admin(), channel);
        }
        this.getLogger().debug("Recovering consumer admins...");
        ConnectionInfo[] conns = pssEventChannel.consumer_admins();
        int i = 0;
        while (i < conns.length) {
            this.recoverOneConsumerAdmin(conns[i], channel);
            ++i;
        }
    }

    private void recoverOneConsumerAdmin(ConnectionInfo info, EventChannelImpl channel) {
        try {
            ConsumerAdmin pssConsumerAdmin = (ConsumerAdmin)PersistenceRepository.getConsumerAdminHome(true).get_catalog().find_by_pid(info.pid);
            ConsumerAdminImpl consumerAdmin = new ConsumerAdminImpl(channel, pssConsumerAdmin, this.m_factoryPOA, this.m_allLoggers);
            this.m_factoryPOA.activate_object_with_id(consumerAdmin.getPid(), (Servant)consumerAdmin);
            channel.consumerAdminRecovered(info.id, consumerAdmin);
            this.getLogger().debug("Consumer admin recovered with id " + pssConsumerAdmin.id() + ".");
            this.recoverProxySuppliers(consumerAdmin, pssConsumerAdmin);
        }
        catch (Throwable ex) {
            this.getLogger().debug("Consumer admin could not be recovered.");
        }
    }

    private void recoverProxySuppliers(ConsumerAdminImpl consumerAdmin, ConsumerAdmin pssConsumerAdmin) {
        this.getLogger().debug("Recovering proxy pull suppliers...");
        ConnectionInfo[] pullSuppliers = pssConsumerAdmin.pull_suppliers();
        int i = 0;
        while (i < pullSuppliers.length) {
            this.recoverOneProxySupplier(pullSuppliers[i], consumerAdmin);
            ++i;
        }
        this.getLogger().debug("Recovering proxy push suppliers...");
        ConnectionInfo[] pushSuppliers = pssConsumerAdmin.push_suppliers();
        int i2 = 0;
        while (i2 < pushSuppliers.length) {
            this.recoverOneProxySupplier(pushSuppliers[i2], consumerAdmin);
            ++i2;
        }
    }

    private void recoverOneProxySupplier(ConnectionInfo info, ConsumerAdminImpl consumerAdmin) {
        try {
            ProxySupplier pssProxySupplier = (ProxySupplier)PersistenceRepository.getProxySupplierHome(true).get_catalog().find_by_pid(info.pid);
            Servant proxySupplier = null;
            switch (pssProxySupplier.type().value()) {
                case 0: {
                    proxySupplier = new ProxyPushSupplierImpl(consumerAdmin, pssProxySupplier, this.m_allLoggers);
                    break;
                }
                case 1: {
                    proxySupplier = new ProxyPullSupplierImpl(consumerAdmin, pssProxySupplier, this.m_allLoggers);
                    break;
                }
                case 2: {
                    proxySupplier = new StructuredProxyPushSupplierImpl(consumerAdmin, pssProxySupplier, this.m_allLoggers);
                    break;
                }
                case 3: {
                    proxySupplier = new StructuredProxyPullSupplierImpl(consumerAdmin, pssProxySupplier, this.m_allLoggers);
                    break;
                }
                case 4: {
                    proxySupplier = new SequenceProxyPushSupplierImpl(consumerAdmin, pssProxySupplier, this.m_allLoggers);
                    break;
                }
                case 5: {
                    proxySupplier = new SequenceProxyPullSupplierImpl(consumerAdmin, pssProxySupplier, this.m_allLoggers);
                    break;
                }
                case 6: {
                    break;
                }
                case 7: {
                    break;
                }
                default: {
                    throw new IllegalStateException("unexpected Proxy Type " + pssProxySupplier.type().value());
                }
            }
            this.m_factoryPOA.activate_object_with_id(((PersistenceManagement)proxySupplier).getPid(), proxySupplier);
            consumerAdmin.proxySupplierRecovered(info.id, proxySupplier);
            this.getLogger().debug("Proxy supplier recovered with id " + pssProxySupplier.id() + ".");
        }
        catch (Throwable ex) {
            this.getLogger().debug("Proxy supplier could not be recovered.");
        }
    }

    private void recoverSupplierAdmins(EventChannelImpl channel, EventChannel pssEventChannel) {
        this.getLogger().debug("Recovering default supplier admin...");
        if (pssEventChannel.def_supplier_admin().reference != null) {
            this.recoverOneSupplierAdmin(pssEventChannel.def_supplier_admin(), channel);
        }
        this.getLogger().debug("Recovering supplier admins...");
        ConnectionInfo[] conns = pssEventChannel.supplier_admins();
        int i = 0;
        while (i < conns.length) {
            this.recoverOneSupplierAdmin(conns[i], channel);
            ++i;
        }
    }

    private void recoverOneSupplierAdmin(ConnectionInfo info, EventChannelImpl channel) {
        try {
            SupplierAdmin pssSupplierAdmin = (SupplierAdmin)PersistenceRepository.getSupplierAdminHome(true).get_catalog().find_by_pid(info.pid);
            SupplierAdminImpl supplierAdmin = new SupplierAdminImpl(channel, pssSupplierAdmin, this.m_factoryPOA, this.m_allLoggers);
            this.m_factoryPOA.activate_object_with_id(supplierAdmin.getPid(), (Servant)supplierAdmin);
            channel.supplierAdminRecovered(info.id, supplierAdmin);
            this.getLogger().debug("Supplier admin recovered with id " + pssSupplierAdmin.id() + ".");
            this.recoverProxyConsumers(supplierAdmin, pssSupplierAdmin);
        }
        catch (Throwable ex) {
            this.getLogger().debug("Supplier admin could not be recovered.");
        }
    }

    private void recoverProxyConsumers(SupplierAdminImpl supplierAdmin, SupplierAdmin pssSupplierAdmin) {
        this.getLogger().debug("Recovering proxy pull consumers...");
        ConnectionInfo[] pullConsumers = pssSupplierAdmin.pull_consumers();
        int i = 0;
        while (i < pullConsumers.length) {
            this.recoverOneProxyConsumer(pullConsumers[i], supplierAdmin);
            ++i;
        }
        this.getLogger().debug("Recovering proxy push consumers...");
        ConnectionInfo[] pushConsumers = pssSupplierAdmin.push_consumers();
        int i2 = 0;
        while (i2 < pushConsumers.length) {
            this.recoverOneProxyConsumer(pushConsumers[i2], supplierAdmin);
            ++i2;
        }
    }

    private void recoverOneProxyConsumer(ConnectionInfo info, SupplierAdminImpl supplierAdmin) {
        try {
            ProxyConsumer pssProxyConsumer = (ProxyConsumer)PersistenceRepository.getProxyConsumerHome(true).get_catalog().find_by_pid(info.pid);
            Servant proxyConsumer = null;
            switch (pssProxyConsumer.type().value()) {
                case 0: {
                    proxyConsumer = new ProxyPushConsumerImpl(supplierAdmin, pssProxyConsumer, this.m_allLoggers);
                    break;
                }
                case 1: {
                    proxyConsumer = new ProxyPullConsumerImpl(supplierAdmin, pssProxyConsumer, this.m_allLoggers);
                    break;
                }
                case 2: {
                    proxyConsumer = new StructuredProxyPushConsumerImpl(supplierAdmin, pssProxyConsumer, this.m_allLoggers);
                    break;
                }
                case 3: {
                    proxyConsumer = new StructuredProxyPullConsumerImpl(supplierAdmin, pssProxyConsumer, this.m_allLoggers);
                    break;
                }
                case 4: {
                    proxyConsumer = new SequenceProxyPushConsumerImpl(supplierAdmin, pssProxyConsumer, this.m_allLoggers);
                    break;
                }
                case 5: {
                    proxyConsumer = new SequenceProxyPullConsumerImpl(supplierAdmin, pssProxyConsumer, this.m_allLoggers);
                    break;
                }
                case 6: {
                    break;
                }
                case 7: {
                    break;
                }
                default: {
                    throw new IllegalStateException("unexpected Proxy Type " + pssProxyConsumer.type().value());
                }
            }
            this.m_factoryPOA.activate_object_with_id(((PersistenceManagement)proxyConsumer).getPid(), proxyConsumer);
            this.getLogger().debug("Proxy consumer recovered with id " + pssProxyConsumer.id() + ".");
        }
        catch (Throwable ex) {
            this.getLogger().debug("Proxy consumer could not be recovered.");
        }
    }

    private void recoverFilters() {
        this.getLogger().debug("Recovering filters...");
        ExtendedCatalog catalog = (ExtendedCatalog)PersistenceRepository.getFilterHome(true).get_catalog();
        Iterator iter = catalog.iterator((StorageHomeBase)PersistenceRepository.getFilterHome(true));
        iter.reset();
        while (iter.hasMoreElements()) {
            Filter pssFilter = (Filter)iter.element();
            try {
                FilterImpl filter = new FilterImpl(pssFilter, this.m_orb, this.m_factoryPOA, this.m_allLoggers.getFilterLogger());
                this.m_factoryPOA.activate_object_with_id(filter.getPid(), (Servant)filter);
                this.getLogger().debug("Filter recovered.");
            }
            catch (Throwable ex) {
                this.getLogger().error("exception when recovering filter", ex);
            }
            iter.next();
        }
        iter.detach();
    }

    private void recoverMappingFilters() {
        this.getLogger().debug("Recovering mapping filters...");
        ExtendedCatalog catalog = (ExtendedCatalog)PersistenceRepository.getMappingFilterHome(true).get_catalog();
        Iterator iter = catalog.iterator((StorageHomeBase)PersistenceRepository.getMappingFilterHome(true));
        iter.reset();
        while (iter.hasMoreElements()) {
            MappingFilter pssMappingFilter = (MappingFilter)iter.element();
            try {
                MappingFilterImpl mappingFilter = new MappingFilterImpl(pssMappingFilter, this.m_orb);
                this.m_factoryPOA.activate_object_with_id(mappingFilter.getPid(), (Servant)mappingFilter);
                this.getLogger().debug("Mapping filter recovered.");
            }
            catch (Throwable ex) {
                this.getLogger().error("exception when recovering mapping filter", ex);
            }
            iter.next();
        }
        iter.detach();
    }

    private org.apache.avalon.framework.logger.Logger getLogger() {
        return this.m_logger;
    }
}

