/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.notify;

import org.apache.avalon.framework.CascadingRuntimeException;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.omg.CORBA.Any;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CosNotifyChannelAdmin.EventChannelFactory;
import org.omg.CosPersistentState.Connector;
import org.omg.CosPersistentState.ConnectorRegistry;
import org.omg.CosPersistentState.ConnectorRegistryHelper;
import org.omg.CosPersistentState.NotFound;
import org.omg.CosPersistentState.Parameter;
import org.omg.CosPersistentState.Session;
import org.omg.CosPersistentState.StorageHomeBase;
import org.omg.PortableServer.IdAssignmentPolicyValue;
import org.omg.PortableServer.LifespanPolicyValue;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import org.omg.PortableServer.POAManagerPackage.AdapterInactive;
import org.omg.PortableServer.Servant;
import org.openorb.notify.Logger;
import org.openorb.notify.PersistenceRepository;
import org.openorb.notify.PropertiesRepository;
import org.openorb.notify.RecoveryManager;
import org.openorb.notify.impl.EventChannelFactoryImpl;
import org.openorb.orb.config.ORBLoader;
import org.openorb.orb.core.ORB;
import org.openorb.util.service.ServiceBase;

public class Service
extends ServiceBase {
    static final String EVENT_CHANNEL_FACTORY_ID = "EventChannelFactory";
    public static final String NOTIFY_PKG_PREFIX = "org.openorb.notify";
    private org.omg.CORBA.ORB m_orb;
    private POA m_parentPOA;
    private PropertiesRepository m_propertiesRepository;
    private POA m_eventChannelFactoryPOA;
    private EventChannelFactoryImpl m_eventChannelFactory;
    private Logger m_allLoggers;

    protected void contextualizeService(Context context) throws ContextException {
        this.m_allLoggers = new Logger(this.getLogger());
        this.m_orb = this.getORB();
        this.m_parentPOA = POAHelper.narrow((Object)((POA)this.createPOA()));
        this.m_propertiesRepository = (PropertiesRepository)this.getContext().get((java.lang.Object)"PROPERTIES");
        if (this.m_propertiesRepository == null) {
            throw new ContextException("null or missing PROPERTIES");
        }
    }

    public void initializeService() {
        try {
            this.initPSS();
            this.m_eventChannelFactoryPOA = this.createFactoryPOA(this.m_parentPOA);
            this.m_eventChannelFactory = new EventChannelFactoryImpl(this.m_orb, this.m_eventChannelFactoryPOA, this.m_propertiesRepository, this.m_allLoggers);
            this.m_eventChannelFactoryPOA.activate_object_with_id(EVENT_CHANNEL_FACTORY_ID.getBytes(), (Servant)this.m_eventChannelFactory);
            EventChannelFactory obj = this.m_eventChannelFactory._this(this.m_orb);
            this.registerObject(EVENT_CHANNEL_FACTORY_ID, obj);
        }
        catch (Exception ex) {
            this.getLogger().fatalError("Exception occured while initializing the service", (Throwable)ex);
            throw new CascadingRuntimeException("Problem while initializing the service", (Throwable)ex);
        }
    }

    public void startService() {
        try {
            RecoveryManager recoveryManager = new RecoveryManager(this.m_orb, this.m_eventChannelFactory, this.m_eventChannelFactory.getPOA(), this.m_allLoggers);
            recoveryManager.enableLogging(this.getLogger().getChildLogger("recovery"));
            recoveryManager.doRecovery();
            if (this.m_parentPOA != null) {
                this.m_parentPOA.the_POAManager().activate();
            }
        }
        catch (AdapterInactive ex) {
            this.getLogger().fatalError("The POAManager is inactive!", (Throwable)ex);
            throw new CascadingRuntimeException("The POAManager is inactive!", (Throwable)ex);
        }
    }

    public void stopService() {
        this.getLogger().debug("destroying POA <" + this.m_eventChannelFactoryPOA.the_name() + ">");
        this.m_eventChannelFactoryPOA.destroy(true, true);
        this.m_eventChannelFactory = null;
        this.m_eventChannelFactoryPOA = null;
        try {
            if (this.m_parentPOA != null) {
                this.m_parentPOA.the_POAManager().deactivate(false, true);
            }
        }
        catch (AdapterInactive ex) {
            this.getLogger().fatalError("The POAManager is inactive!", (Throwable)ex);
            throw new CascadingRuntimeException("The POAManager is inactive!", (Throwable)ex);
        }
    }

    private POA createFactoryPOA(POA parentPOA) {
        POA childPOA = null;
        try {
            java.lang.Object repObj = this.m_propertiesRepository.getProperty("BiDirectionalFlag");
            boolean biDirectionalFlag = repObj instanceof Boolean && (Boolean)repObj != false;
            Policy[] policies = new Policy[biDirectionalFlag ? 3 : 2];
            policies[0] = parentPOA.create_lifespan_policy(LifespanPolicyValue.PERSISTENT);
            policies[1] = parentPOA.create_id_assignment_policy(IdAssignmentPolicyValue.USER_ID);
            if (biDirectionalFlag) {
                Any any = this.m_orb.create_any();
                any.insert_ushort((short)1);
                policies[2] = this.m_orb.create_policy(37, any);
            }
            childPOA = parentPOA.create_POA("EventChannelFactoryPOA", parentPOA.the_POAManager(), policies);
        }
        catch (Exception ex) {
            this.getLogger().error("Creating the child poa failed", (Throwable)ex);
            return null;
        }
        return childPOA;
    }

    public String getEventChannelFactoryIOR() {
        if (!this.isInitialized()) {
            throw new IllegalStateException("not yet initialized");
        }
        return this.m_orb.object_to_string((Object)this.m_eventChannelFactory._this());
    }

    private void initPSS() throws ClassNotFoundException, InvalidName, NotFound {
        String transientConnectorClass = "org.openorb.pss.Memory";
        String transientConnectorPrefix = "memory.";
        String persistentConnectorClass = "org.openorb.pss.File";
        String persistentConnectorPrefix = "file.";
        if (this.m_orb instanceof ORB) {
            ORBLoader cfg = ((ORB)this.m_orb).getLoader();
            transientConnectorClass = cfg.getStringProperty("notify.transientConnector", transientConnectorClass);
            transientConnectorPrefix = cfg.getStringProperty("notify.transientConnectorPrefix", transientConnectorPrefix);
            persistentConnectorClass = cfg.getStringProperty("notify.persistentConnector", persistentConnectorClass);
            persistentConnectorPrefix = cfg.getStringProperty("notify.persistentConnectorPrefix", persistentConnectorPrefix);
        }
        Object pss = this.m_orb.resolve_initial_references("PSS");
        ConnectorRegistry registry = ConnectorRegistryHelper.narrow((Object)pss);
        Connector transientConnector = registry.find_connector(transientConnectorClass);
        Connector persistentConnector = registry.find_connector(persistentConnectorClass);
        Parameter[] parameters = new Parameter[]{};
        Session transientSession = transientConnector.create_basic_session((short)1, "", parameters);
        Session persistentSession = persistentConnector.create_basic_session((short)1, "", parameters);
        this.getStorageHomes("EventChannel", transientConnector, transientConnectorPrefix, transientSession, persistentConnector, persistentConnectorPrefix, persistentSession);
        this.getStorageHomes("ConsumerAdmin", transientConnector, transientConnectorPrefix, transientSession, persistentConnector, persistentConnectorPrefix, persistentSession);
        this.getStorageHomes("SupplierAdmin", transientConnector, transientConnectorPrefix, transientSession, persistentConnector, persistentConnectorPrefix, persistentSession);
        this.getStorageHomes("Filter", transientConnector, transientConnectorPrefix, transientSession, persistentConnector, persistentConnectorPrefix, persistentSession);
        this.getStorageHomes("MappingFilter", transientConnector, transientConnectorPrefix, transientSession, persistentConnector, persistentConnectorPrefix, persistentSession);
        this.getStorageHomes("ProxyConsumer", transientConnector, transientConnectorPrefix, transientSession, persistentConnector, persistentConnectorPrefix, persistentSession);
        this.getStorageHomes("ProxySupplier", transientConnector, transientConnectorPrefix, transientSession, persistentConnector, persistentConnectorPrefix, persistentSession);
        this.getStorageHomes("Event", transientConnector, transientConnectorPrefix, transientSession, persistentConnector, persistentConnectorPrefix, persistentSession);
        this.getStorageHomes("EventQueue", transientConnector, transientConnectorPrefix, transientSession, persistentConnector, persistentConnectorPrefix, persistentSession);
    }

    private void getStorageHomes(String name, Connector transientConnector, String transientConnectorPrefix, Session transientSession, Connector persistentConnector, String persistentConnectorPrefix, Session persistentSession) throws ClassNotFoundException, NotFound {
        StorageHomeBase transientHome = Service.getStorageHome(name, transientConnector, transientConnectorPrefix, transientSession);
        StorageHomeBase persistentHome = Service.getStorageHome(name, persistentConnector, persistentConnectorPrefix, persistentSession);
        PersistenceRepository.getInstance().setTransientHome(name, transientHome);
        PersistenceRepository.getInstance().setPersistentHome(name, persistentHome);
    }

    private static StorageHomeBase getStorageHome(String name, Connector connector, String connectorPrefix, Session session) throws ClassNotFoundException, NotFound {
        String psdlBase = "PSDL:openorb.org/notify/persistence/" + name + "Base:1.0";
        String psdlHomeBase = "PSDL:openorb.org/notify/persistence/" + name + "HomeBase:1.0";
        String baseClass = connectorPrefix + NOTIFY_PKG_PREFIX + ".persistence." + name + "Base";
        String homeBaseClass = connectorPrefix + NOTIFY_PKG_PREFIX + ".persistence." + name + "HomeBase";
        connector.register_storage_object_factory(psdlBase, Thread.currentThread().getContextClassLoader().loadClass(baseClass));
        connector.register_storage_home_factory(psdlHomeBase, Thread.currentThread().getContextClassLoader().loadClass(homeBaseClass));
        return session.find_storage_home(psdlHomeBase);
    }
}

