/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.notify.queue;

import org.apache.avalon.framework.logger.Logger;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.ORB;
import org.omg.CORBA.SystemException;
import org.omg.CosEventComm.Disconnected;
import org.openorb.notify.ConsumerAdapter;
import org.openorb.notify.ConsumerProxyManagement;
import org.openorb.notify.NotifyThread;
import org.openorb.notify.PropertiesRepository;
import org.openorb.notify.persistence.Event;
import org.openorb.notify.queue.EventQueue;
import org.openorb.orb.config.ORBLoader;

public class Pusher
extends NotifyThread {
    private static final int FOREVER = -1;
    private static final int DEFAULT_REDELIVERY_PERIOD = 1000;
    private static final int DEFAULT_DISCONNECT_ON_FAILURE_TIMEOUT = 30;
    private boolean m_isDeliveryPossible = true;
    private long m_lastDelieveryAttemptTime;
    protected final ORB m_orb;
    protected final EventQueue m_queue;
    private boolean m_isConnectionActive;
    protected final ConsumerProxyManagement m_proxy;
    private PropertiesRepository m_propertiesRepository;
    private int m_maxRedeliveryAttempts = -1;
    private int m_retryMillis = 1000;
    private long m_firstDeliveryFailureTime = 0L;
    private boolean m_hasBeenActivatedFlag = false;
    private ConsumerAdapter m_consumer = null;
    private long m_disconnectOnFailureTimeout = 30000L;

    public Pusher(String id, EventQueue queue, ConsumerProxyManagement proxy, ORB orb, Logger logger) {
        super(id, logger.getChildLogger("thread"));
        this.m_queue = queue;
        this.m_proxy = proxy;
        this.m_orb = orb;
        if (this.m_orb instanceof org.openorb.orb.core.ORB) {
            org.openorb.orb.core.ORB openorb = (org.openorb.orb.core.ORB)this.m_orb;
            ORBLoader cfg = openorb.getLoader();
            this.m_disconnectOnFailureTimeout = 1000L * (long)cfg.getIntProperty("notify.resourcesTimeout", 30);
        }
    }

    public void setConnectionActive(boolean isConnectionActive) {
        boolean oldConnectionActive;
        Object object = this.m_stateLock;
        synchronized (object) {
            oldConnectionActive = this.m_isConnectionActive;
            this.m_isConnectionActive = isConnectionActive;
        }
        if (isConnectionActive && !oldConnectionActive) {
            this.m_hasBeenActivatedFlag = true;
            this.m_firstDeliveryFailureTime = 0L;
            if (this.isRunning()) {
                EventQueue eventQueue = this.m_queue;
                synchronized (eventQueue) {
                    if (this.m_queue.isEmpty()) {
                        return;
                    }
                }
                this.notifyThread();
            }
        }
    }

    private boolean isConnectionActive() {
        Object object = this.m_stateLock;
        synchronized (object) {
            boolean bl = this.m_isConnectionActive;
            return bl;
        }
    }

    private boolean hasConsumer() {
        Object object = this.m_stateLock;
        synchronized (object) {
            boolean bl = this.m_consumer != null;
            return bl;
        }
    }

    public void pushEvent(Object event) {
        boolean eventQueued;
        EventQueue eventQueue = this.m_queue;
        synchronized (eventQueue) {
            eventQueued = this.m_queue.pushEvent(event);
        }
        if (!eventQueued) {
            this.m_proxy.reportEventDelivery(event.hashCode());
            return;
        }
        if (!this.isConnectionActive()) {
            return;
        }
        if (this.isRunning()) {
            this.notifyThread();
        } else {
            this.doDelivery();
        }
    }

    /*
     * Unable to fully structure code
     */
    protected boolean doDelivery() {
        block31: {
            block32: {
                block33: {
                    if (!this.isConnectionActive()) {
                        if (this.m_disconnectOnFailureTimeout > 0L && !this.m_hasBeenActivatedFlag) {
                            if (this.m_firstDeliveryFailureTime > 0L) {
                                failurePeriod = System.currentTimeMillis() - this.m_firstDeliveryFailureTime;
                                if (failurePeriod > this.m_disconnectOnFailureTimeout && !this.m_hasBeenActivatedFlag) {
                                    this.getLogger().error("connection not activated before timeout, disconnecting consumer " + this.m_proxy.getId());
                                    this.m_proxy.reportClientDisconnection();
                                    this.setRunning(false);
                                    return true;
                                }
                            } else {
                                this.m_firstDeliveryFailureTime = System.currentTimeMillis();
                            }
                        }
                        return false;
                    }
                    if (this.m_isDeliveryPossible) {
                        event = this.waitForEvent();
                    } else {
                        now = System.currentTimeMillis();
                        v0 = deltaTime = this.m_lastDelieveryAttemptTime < now ? now - this.m_lastDelieveryAttemptTime : 0x7FFFFFFFFFFFFFFFL - this.m_lastDelieveryAttemptTime + now;
                        if ((long)this.m_retryMillis <= deltaTime) {
                            return false;
                        }
                        event = this.waitForEvent();
                    }
                    if (event == null) {
                        return true;
                    }
                    if (!this.hasConsumer()) {
                        this.m_proxy.reportEventDelivery(event.hashCode());
                        return true;
                    }
                    try {
                        this.dispatchEvent(event);
                        this.m_isDeliveryPossible = true;
                        this.m_firstDeliveryFailureTime = 0L;
                        this.getLogger().debug("event successfully delivered to push consumer");
                        break block31;
                    }
                    catch (OBJECT_NOT_EXIST one) {
                        this.getLogger().error("push consumer does not exist, disconnecting " + this.m_proxy, (Throwable)one);
                        this.m_proxy.reportClientDisconnection();
                        this.setRunning(false);
                        break block31;
                    }
                    catch (SystemException se) {
                        proxyId = this.m_proxy.getId();
                        unavailableMsg = "push consumer " + proxyId + " temporarily unavailable during delivery of event " + event.hashCode();
                        if (this.m_firstDeliveryFailureTime == 0L) {
                            this.getLogger().warn(unavailableMsg, (Throwable)se);
                        } else {
                            this.getLogger().warn(unavailableMsg + " since " + (System.currentTimeMillis() - this.m_firstDeliveryFailureTime) + " ms: " + (Object)se);
                        }
                        if (this.m_disconnectOnFailureTimeout > 0L) {
                            if (this.m_firstDeliveryFailureTime > 0L) {
                                isProxyDisconnected = this.disconnectProxyOnFailureTimeout(proxyId);
                                if (isProxyDisconnected) {
                                    return true;
                                }
                            } else {
                                this.m_firstDeliveryFailureTime = System.currentTimeMillis();
                            }
                        }
                        if ((properties = this.getPropertiesRepository()) == null) break block31;
                        if (!properties.isConnectionReliable() || !properties.isEventReliable()) break block32;
                        if (!this.isRunning()) break block33;
                        redeliveryAttempts = 0;
                        ** while (this.m_maxRedeliveryAttempts == -1 || redeliveryAttempts < this.m_maxRedeliveryAttempts)
                    }
lbl-1000:
                    // 1 sources

                    {
                        try {
                            Thread.sleep(this.m_retryMillis);
                            if (this.getLogger().isDebugEnabled()) {
                                this.getLogger().debug("retrying event delivery to push consumer " + proxyId);
                            }
                            this.dispatchEvent(event);
                            this.m_firstDeliveryFailureTime = 0L;
                            if (this.getLogger().isDebugEnabled()) {
                                this.getLogger().debug("event delivery to push consumer " + proxyId + " finally successful");
                            }
                            return true;
                        }
                        catch (OBJECT_NOT_EXIST one) {
                            if (this.getLogger().isDebugEnabled()) {
                                this.getLogger().debug("push consumer " + proxyId + " does not exist, disconnecting it", (Throwable)one);
                            }
                            this.m_proxy.reportClientDisconnection();
                            this.setRunning(false);
                            return true;
                        }
                        catch (SystemException _se) {
                            this.getLogger().debug("push consumer still unavailable", (Throwable)_se);
                            if (this.m_firstDeliveryFailureTime > 0L) {
                                isProxyDisconnected = this.disconnectProxyOnFailureTimeout(proxyId);
                                if (isProxyDisconnected) {
                                    return true;
                                }
                            } else {
                                this.m_firstDeliveryFailureTime = System.currentTimeMillis();
                            }
                        }
                        catch (InterruptedException ie) {
                            // empty catch block
                        }
                        ++redeliveryAttempts;
                        continue;
                    }
lbl84:
                    // 1 sources

                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().warn("push consumer " + this.m_proxy.getId() + " not available after " + this.m_maxRedeliveryAttempts + " retries - giving up and dropping event");
                    }
                    break block31;
                }
                this.m_isDeliveryPossible = false;
                this.m_lastDelieveryAttemptTime = System.currentTimeMillis();
                this.getLogger().debug("pushing event back to queue");
                this.m_queue.pushEvent(event);
                return true;
            }
            this.getLogger().debug("QoS set to best effort delivery - dropping event");
        }
        return true;
    }

    private boolean disconnectProxyOnFailureTimeout(String proxyId) {
        long failurePeriod = System.currentTimeMillis() - this.m_firstDeliveryFailureTime;
        if (failurePeriod > this.m_disconnectOnFailureTimeout) {
            this.getLogger().error("event delivery has failed for " + failurePeriod + " milliseconds, disconnecting consumer " + proxyId);
            this.m_proxy.reportClientDisconnection();
            this.setRunning(false);
            return true;
        }
        return false;
    }

    public void setConsumer(ConsumerAdapter consumer) {
        Object object = this.m_stateLock;
        synchronized (object) {
            this.m_consumer = consumer;
        }
    }

    private void dispatchEvent(Event event) {
        try {
            int eventPid = event.hashCode();
            this.m_consumer.push(event);
            this.m_proxy.reportEventDelivery(eventPid);
        }
        catch (Disconnected ex) {
            try {
                try {
                    this.m_consumer.disconnect();
                }
                catch (SystemException sysex) {
                    this.getLogger().error("disconnect push consumer failed", (Throwable)sysex);
                    Object var5_5 = null;
                    this.m_proxy.reportClientDisconnection();
                    this.setRunning(false);
                }
                Object var5_4 = null;
                this.m_proxy.reportClientDisconnection();
                this.setRunning(false);
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                this.m_proxy.reportClientDisconnection();
                this.setRunning(false);
                throw throwable;
            }
        }
    }

    public void run() {
        while (!this.finishRunning()) {
            boolean queueWasChecked = this.doDelivery();
            if (queueWasChecked) continue;
            try {
                EventQueue eventQueue = this.m_queue;
                synchronized (eventQueue) {
                    this.m_queue.wait(this.m_disconnectOnFailureTimeout);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.setConsumer(null);
    }

    private void notifyThread() {
        EventQueue eventQueue = this.m_queue;
        synchronized (eventQueue) {
            this.m_queue.notifyAll();
        }
    }

    private Event waitForEvent() {
        EventQueue eventQueue = this.m_queue;
        synchronized (eventQueue) {
            if (this.m_queue.isEmpty() && this.isRunning()) {
                try {
                    this.m_queue.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            Event event = this.m_queue.isEmpty() ? null : (Event)this.m_queue.pullEvent();
            return event;
        }
    }

    private boolean finishRunning() {
        if (this.shouldFinishWork()) {
            EventQueue eventQueue = this.m_queue;
            synchronized (eventQueue) {
                if (this.m_queue.isEmpty()) {
                    boolean bl = true;
                    return bl;
                }
            }
        }
        return !this.isRunning();
    }

    public void stopThread() {
        super.stopThread();
        this.notifyThread();
    }

    public void finishWorkAndStopThread() {
        super.finishWorkAndStopThread();
        this.notifyThread();
    }

    public void setPropertiesRepository(PropertiesRepository propertiesRepository) {
        Object object = this.m_stateLock;
        synchronized (object) {
            this.m_propertiesRepository = propertiesRepository;
        }
    }

    private PropertiesRepository getPropertiesRepository() {
        Object object = this.m_stateLock;
        synchronized (object) {
            PropertiesRepository propertiesRepository = this.m_propertiesRepository;
            return propertiesRepository;
        }
    }
}

