/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.notify.queue;

import java.util.List;
import java.util.Vector;
import org.apache.avalon.framework.logger.Logger;
import org.omg.CORBA.Any;
import org.omg.CosNotification.Property;
import org.omg.CosNotification.StructuredEvent;
import org.omg.CosNotifyFilter.Filter;
import org.omg.CosNotifyFilter.UnsupportedFilterableData;
import org.omg.CosPersistentState.NotFound;
import org.openorb.notify.PersistenceRepository;
import org.openorb.notify.persistence.Event;
import org.openorb.notify.persistence.EventHome;
import org.openorb.notify.queue.DefaultEventQueue;
import org.openorb.notify.queue.FilterableEventQueue;

public class SupplierProxyQueue
extends DefaultEventQueue
implements FilterableEventQueue {
    private EventHome m_pssEventHome;
    private List m_filters = new Vector();
    private String m_id;
    private boolean m_isEventsLogged = false;
    private boolean m_isFiltersEvaluationLogged = false;
    private final Logger m_logger;
    private final Logger m_filterLogger;

    public SupplierProxyQueue(String id, int orderPolicy, boolean isPersistent, Logger logger) {
        super(orderPolicy);
        this.m_pssEventHome = PersistenceRepository.getEventHome(isPersistent);
        this.m_id = id;
        this.m_logger = logger;
        this.m_filterLogger = logger.getChildLogger("filter");
        String orderString = "FifoOrder";
        if (orderPolicy == 2) {
            orderString = "PriorityOrder";
        } else if (orderPolicy == 3) {
            orderString = "DeadlineOrder";
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug(this.m_id + " Queue created with order " + orderString + ".");
        }
    }

    public boolean pushEvent(Object event) {
        try {
            Event pssEvent = event instanceof String ? (Event)this.m_pssEventHome.find_by_short_pid(((String)event).getBytes()) : (Event)event;
            switch (pssEvent.event_type()) {
                case 0: {
                    if (this.filterAndPushEvent(pssEvent.event_data().structured_event())) {
                        super.pushEvent(pssEvent, new Short(pssEvent.priority()), new Long(pssEvent.deadline()));
                        if (this.m_isEventsLogged && this.getLogger().isDebugEnabled()) {
                            this.getLogger().debug(this.m_id + " Structured event received from consumer admin " + "(queue size=" + super.getQueueSize() + ").");
                        }
                        return true;
                    }
                    return false;
                }
                case 1: {
                    if (this.filterAndPushEvent(pssEvent.event_data().any_event())) {
                        super.pushEvent(pssEvent, new Short(pssEvent.priority()), new Long(pssEvent.deadline()));
                        if (this.m_isEventsLogged) {
                            this.getLogger().debug(this.m_id + " Any event received from consumer admin " + "(queue size=" + super.getQueueSize() + ").");
                        }
                        return true;
                    }
                    return false;
                }
            }
            if (this.filterAndPushEvent(pssEvent.event_data().typed_event())) {
                super.pushEvent(pssEvent, new Short(pssEvent.priority()), new Long(pssEvent.deadline()));
                if (this.m_isEventsLogged && this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug(this.m_id + " Typed event received from consumer admin " + "(queue size=" + super.getQueueSize() + ").");
                }
                return true;
            }
            return false;
        }
        catch (NotFound ex) {
            this.getLogger().error("The Event DataStore is not consistent.", (Throwable)ex);
            return false;
        }
    }

    public Object pullEvent() {
        Object event = super.pullEvent();
        if (this.m_isEventsLogged && this.getLogger().isDebugEnabled()) {
            this.getLogger().debug(this.m_id + " Event transmitted to consumer (queue size=" + super.getQueueSize() + ").");
        }
        return event;
    }

    public synchronized boolean filterAndPushEvent(Any event) {
        int i = 0;
        while (i < this.m_filters.size()) {
            try {
                if (((Filter)this.m_filters.get(i)).match(event)) {
                    break;
                }
            }
            catch (UnsupportedFilterableData ex) {
                this.getFilterLogger().error(this.m_id + " UnsupportedFilterableData exception.");
            }
            ++i;
        }
        if (i != this.m_filters.size() || i == 0) {
            if (this.m_isFiltersEvaluationLogged && this.getFilterLogger().isDebugEnabled()) {
                if (i == 0) {
                    this.getFilterLogger().debug(this.m_id + " No filters set. Returned TRUE.");
                } else {
                    this.getFilterLogger().debug(this.m_id + " Filter matching for event returned TRUE.");
                }
            }
            return true;
        }
        if (this.m_isFiltersEvaluationLogged && this.getFilterLogger().isDebugEnabled()) {
            this.getFilterLogger().debug(this.m_id + " Filter matching for event returned FALSE.");
        }
        return false;
    }

    public synchronized boolean filterAndPushEvent(StructuredEvent event) {
        int i = 0;
        while (i < this.m_filters.size()) {
            try {
                if (((Filter)this.m_filters.get(i)).match_structured(event)) {
                    break;
                }
            }
            catch (UnsupportedFilterableData ex) {
                this.getFilterLogger().error(this.m_id + " UnsupportedFilterableData exception.");
            }
            ++i;
        }
        if (i != this.m_filters.size() || i == 0) {
            if (this.m_isFiltersEvaluationLogged && this.getFilterLogger().isDebugEnabled()) {
                if (i == 0) {
                    this.getFilterLogger().debug(this.m_id + " No filters set. Returned TRUE.");
                } else {
                    this.getFilterLogger().debug(this.m_id + " Filter matching for event returned TRUE.");
                }
            }
            return true;
        }
        if (this.m_isFiltersEvaluationLogged && this.getFilterLogger().isDebugEnabled()) {
            this.getFilterLogger().debug(this.m_id + " Filter matching for event returned FALSE.");
        }
        return false;
    }

    public synchronized boolean filterAndPushEvent(Property[] event) {
        int i = 0;
        while (i < this.m_filters.size()) {
            try {
                if (((Filter)this.m_filters.get(i)).match_typed(event)) {
                    break;
                }
            }
            catch (UnsupportedFilterableData ex) {
                this.getFilterLogger().error(this.m_id + " UnsupportedFilterableData exception.");
            }
            ++i;
        }
        if (i != this.m_filters.size() || i == 0) {
            if (this.m_isFiltersEvaluationLogged && this.getFilterLogger().isDebugEnabled()) {
                if (i == 0) {
                    this.getFilterLogger().debug(this.m_id + " No filters set. Returned TRUE.");
                } else {
                    this.getFilterLogger().debug(this.m_id + " Filter matching for event returned TRUE.");
                }
            }
            return true;
        }
        if (this.m_isFiltersEvaluationLogged && this.getFilterLogger().isDebugEnabled()) {
            this.getFilterLogger().debug(this.m_id + " Filter matching for event returned FALSE.");
        }
        return false;
    }

    public boolean addFilter(Filter filter) {
        List list = this.m_filters;
        synchronized (list) {
            if (this.m_filters.contains(filter)) {
                boolean bl = false;
                return bl;
            }
            this.m_filters.add(filter);
            if (this.getFilterLogger().isDebugEnabled()) {
                this.getFilterLogger().debug(this.m_id + " Filter added.");
            }
            boolean bl = true;
            return bl;
        }
    }

    public boolean updateFilter(Filter filter) {
        List list = this.m_filters;
        synchronized (list) {
            if (!this.m_filters.contains(filter)) {
                boolean bl = false;
                return bl;
            }
            this.m_filters.add(filter);
            if (this.getFilterLogger().isDebugEnabled()) {
                this.getFilterLogger().debug(this.m_id + " Filter updated.");
            }
            boolean bl = true;
            return bl;
        }
    }

    public boolean removeFilter(Filter filter) {
        List list = this.m_filters;
        synchronized (list) {
            if (!this.m_filters.contains(filter)) {
                boolean bl = false;
                return bl;
            }
            this.m_filters.remove(filter);
            if (this.getFilterLogger().isDebugEnabled()) {
                this.getFilterLogger().debug(this.m_id + " Filter removed.");
            }
            boolean bl = true;
            return bl;
        }
    }

    public void removeAllFilters() {
        List list = this.m_filters;
        synchronized (list) {
            this.m_filters.clear();
            if (this.getFilterLogger().isDebugEnabled()) {
                this.getFilterLogger().debug(this.m_id + " All filters removed.");
            }
        }
    }

    private Logger getLogger() {
        return this.m_logger;
    }

    private Logger getFilterLogger() {
        return this.m_filterLogger;
    }

    void setIsEventLogged(boolean eventsLogged) {
        this.m_isEventsLogged = eventsLogged;
    }

    void setFiltersEvaluationLogged(boolean filtersEvaluationLogged) {
        this.m_isFiltersEvaluationLogged = filtersEvaluationLogged;
    }
}

