/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.notify.examples.simple;

import org.omg.CORBA.Any;
import org.omg.CORBA.BooleanHolder;
import org.omg.CORBA.ORB;
import org.omg.CosEventComm.Disconnected;
import org.omg.CosNotification.EventHeader;
import org.omg.CosNotification.EventType;
import org.omg.CosNotification.FixedEventHeader;
import org.omg.CosNotification.Property;
import org.omg.CosNotification.StructuredEvent;
import org.omg.CosNotifyComm.SequencePullSupplierPOA;
import org.omg.PortableServer.POA;
import org.openorb.notify.examples.simple.SequencePullSupplier;

class SequencePullSupplierImpl
extends SequencePullSupplierPOA {
    public static final String HDR = "[SequencePullSupplierImpl] ";
    private ORB m_orb = null;
    private POA m_poa = null;
    private int m_event_count = 0;
    private org.omg.CosNotifyComm.SequencePullSupplier m_ps = null;

    SequencePullSupplierImpl(ORB orb, POA poa) {
        this.m_orb = orb;
        this.m_poa = poa;
        System.out.println("[SequencePullSupplierImpl] Implicity conecting POA");
        this.m_ps = this._this(this.m_orb);
        System.out.println("[SequencePullSupplierImpl] Activating on POA");
        try {
            this.m_poa.the_POAManager().activate();
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
            return;
        }
    }

    public StructuredEvent[] try_pull_structured_events(int max_events, BooleanHolder has_event) throws Disconnected {
        System.out.println("[SequencePullSupplierImpl] Tried a pull");
        has_event.value = true;
        return this.pull_structured_events(max_events);
    }

    public StructuredEvent[] pull_structured_events(int max_events) throws Disconnected {
        System.out.println("[SequencePullSupplierImpl] Pulled max_events=" + max_events);
        if (this.m_event_count == SequencePullSupplier.getMaxEventCount()) {
            throw new Disconnected();
        }
        int remaining = SequencePullSupplier.getMaxEventCount() - this.m_event_count;
        int nevents = max_events < remaining ? max_events : remaining;
        System.out.println("[SequencePullSupplierImpl] Pulled - sending " + nevents);
        StructuredEvent[] events = new StructuredEvent[nevents];
        int ii = 0;
        while (ii < nevents) {
            events[ii] = SequencePullSupplierImpl.createEvent(this.m_orb, this.m_event_count++);
            ++ii;
        }
        return events;
    }

    public void disconnect_sequence_pull_supplier() {
        System.out.println("[SequencePullSupplierImpl] Disconnected...");
        System.out.println("[SequencePullSupplierImpl] POA deactivate");
        this.destroy();
        System.out.println("[SequencePullSupplierImpl] POA destroy");
        this._poa().destroy(true, false);
        System.out.println("[SequencePullSupplierImpl] ORB Shutdown: pending=" + this.m_orb.work_pending());
        this.m_orb.shutdown(false);
        System.out.println("[SequencePullSupplierImpl] Terminate application");
        System.exit(0);
    }

    public void subscription_change(EventType[] added, EventType[] removed) {
        System.out.println("[SequencePullSupplierImpl] Subscription change...");
    }

    public org.omg.CosNotifyComm.SequencePullSupplier sequencePullSupplier() {
        return this.m_ps;
    }

    public void destroy() {
        try {
            this._poa().deactivate_object(this._object_id());
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
        }
    }

    public static StructuredEvent createEvent(ORB orb, int i) {
        Property property1;
        Property property0;
        String eventName = "StructuredEvent" + i;
        EventType eventType = new EventType("OpenORB", "examples");
        FixedEventHeader fixedEventHeader = new FixedEventHeader(eventType, eventName.toString());
        Property[] variableHeader = new Property[2];
        variableHeader[0] = new Property("variable:counter", orb.create_any());
        variableHeader[0].value.insert_string("" + i);
        variableHeader[1] = new Property("variable:(counter*10)", orb.create_any());
        variableHeader[1].value.insert_string("" + i * 10);
        EventHeader eventHeader = new EventHeader(fixedEventHeader, variableHeader);
        Property[] filterableData = new Property[2];
        filterableData[0] = property0 = new Property("filter:counter", orb.create_any());
        filterableData[0].value.insert_string("" + i);
        filterableData[1] = property1 = new Property("filter:(counter*10)", orb.create_any());
        filterableData[1].value.insert_string("" + i * 10);
        Any msg = orb.create_any();
        if (i == SequencePullSupplier.getMaxEventCount() - 1) {
            msg.insert_string("done");
        } else {
            msg.insert_string("continue");
        }
        StructuredEvent event = new StructuredEvent(eventHeader, filterableData, msg);
        return event;
    }
}

