/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.notify.examples.simple;

import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.IntHolder;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CosEventChannelAdmin.AlreadyConnected;
import org.omg.CosEventChannelAdmin.TypeError;
import org.omg.CosNotification.Property;
import org.omg.CosNotification.UnsupportedAdmin;
import org.omg.CosNotification.UnsupportedQoS;
import org.omg.CosNotifyChannelAdmin.AdminLimitExceeded;
import org.omg.CosNotifyChannelAdmin.ClientType;
import org.omg.CosNotifyChannelAdmin.ConsumerAdmin;
import org.omg.CosNotifyChannelAdmin.EventChannel;
import org.omg.CosNotifyChannelAdmin.EventChannelFactory;
import org.omg.CosNotifyChannelAdmin.EventChannelFactoryHelper;
import org.omg.CosNotifyChannelAdmin.EventChannelHelper;
import org.omg.CosNotifyChannelAdmin.ProxySupplier;
import org.omg.CosNotifyChannelAdmin.SequenceProxyPushSupplier;
import org.omg.CosNotifyChannelAdmin.SequenceProxyPushSupplierHelper;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import org.openorb.notify.examples.simple.ORBObjectRef;
import org.openorb.notify.examples.simple.SequencePushConsumerImpl;

public class SequencePushConsumer {
    public static final String HDR = "[SequencePushConsumer] ";

    public static void main(String[] args) {
        try {
            System.out.println("[SequencePushConsumer] Start example");
            System.out.println("[SequencePushConsumer] Initialize the ORB");
            ORB orb = ORB.init((String[])args, null);
            System.out.println("[SequencePushConsumer] Get the event channel");
            EventChannel eventChannel = SequencePushConsumer.getEventChannel(orb);
            if (eventChannel == null) {
                System.err.println("[SequencePushConsumer] No event channel available");
                return;
            }
            System.out.println("[SequencePushConsumer] Obtain the channel's default Consumer Admin");
            ConsumerAdmin consumerAdmin = eventChannel.default_consumer_admin();
            System.out.println("[SequencePushConsumer] Obtain a supplier proxy");
            IntHolder proxyId = new IntHolder();
            ProxySupplier proxySupplier = null;
            try {
                proxySupplier = consumerAdmin.obtain_notification_push_supplier(ClientType.SEQUENCE_EVENT, proxyId);
            }
            catch (AdminLimitExceeded ex) {
                ex.printStackTrace(System.err);
                return;
            }
            System.out.println("[SequencePushConsumer] Narrow to a proxy push supplier");
            SequenceProxyPushSupplier sequenceProxyPushSupplier = null;
            try {
                sequenceProxyPushSupplier = SequenceProxyPushSupplierHelper.narrow((Object)proxySupplier);
            }
            catch (BAD_PARAM ex) {
                ex.printStackTrace(System.err);
                return;
            }
            System.out.println("[SequencePushConsumer] Initialize RootPOA");
            Object objPOA = null;
            POA rootPOA = null;
            try {
                objPOA = orb.resolve_initial_references("RootPOA");
            }
            catch (InvalidName ex) {
                ex.printStackTrace(System.err);
                return;
            }
            System.out.println("[SequencePushConsumer] Narrow the CORBA Object reference to a POA");
            try {
                rootPOA = POAHelper.narrow((Object)objPOA);
            }
            catch (BAD_PARAM ex) {
                ex.printStackTrace(System.err);
                return;
            }
            System.out.println("[SequencePushConsumer] Create the push consumer and activate on root POA");
            SequencePushConsumerImpl pushConsumer = new SequencePushConsumerImpl(orb, rootPOA);
            System.out.println("[SequencePushConsumer] Connect to the consumer proxy: push consumer");
            try {
                sequenceProxyPushSupplier.connect_sequence_push_consumer(pushConsumer.sequencePushConsumer());
            }
            catch (AlreadyConnected ex) {
                ex.printStackTrace(System.err);
                return;
            }
            catch (TypeError ex) {
                ex.printStackTrace(System.err);
                return;
            }
            System.out.println("[SequencePushConsumer] The server is ready...");
            orb.run();
        }
        catch (SystemException ex) {
            ex.printStackTrace();
            return;
        }
    }

    private static EventChannel getEventChannel(ORB orb) {
        System.out.println("[SequencePushConsumer] Resolve initial reference to the Notification Service EventChannelFactory");
        Object obj = null;
        try {
            obj = orb.resolve_initial_references("NotificationService");
        }
        catch (InvalidName ex) {
            ex.printStackTrace(System.err);
            return null;
        }
        System.out.println("[SequencePushConsumer] Narrow the CORBA Object reference to an EventChannelFactory");
        EventChannelFactory eventChannelFactory = null;
        try {
            eventChannelFactory = EventChannelFactoryHelper.narrow((Object)obj);
        }
        catch (BAD_PARAM ex) {
            ex.printStackTrace(System.err);
            return null;
        }
        System.out.println("[SequencePushConsumer] Get a reference to an EventChannel from the file");
        ORBObjectRef objRef = new ORBObjectRef(orb, "channel.ref");
        EventChannel eventChannel = null;
        try {
            Object o = objRef.get();
            eventChannel = EventChannelHelper.narrow((Object)o);
        }
        catch (BAD_PARAM ex) {
            ex.printStackTrace(System.err);
            return null;
        }
        if (eventChannel == null) {
            System.out.println("[SequencePushConsumer] Event channel does not exist, creating a new one");
            Property[] initialQoS = new Property[]{};
            Property[] initialAdmin = new Property[]{};
            IntHolder channelId = new IntHolder();
            try {
                eventChannel = eventChannelFactory.create_channel(initialQoS, initialAdmin, channelId);
            }
            catch (UnsupportedQoS ex) {
                ex.printStackTrace(System.err);
                return null;
            }
            catch (UnsupportedAdmin ex) {
                ex.printStackTrace(System.err);
                return null;
            }
            System.out.println("[SequencePushConsumer] Storing the new channel reference");
            objRef.set((Object)eventChannel);
        }
        return eventChannel;
    }
}

